/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.client;

import hec.clientapp.client.ClientApp;
import hec.watershed.model.StreamAlignmentUnits;
import hec.watershed.model.Study;
import hec.watershed.model.StudyDataList;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.rmi.RemoteException;
import java.util.TimeZone;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import rma.swing.DefaultJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDescriptionField;
import rma.swing.RmaJTextField;

public class WatershedInfoPanel
extends DefaultJPanel {
    RmaJTextField studyTitle;
    RmaJDescriptionField studyDescription;
    RmaJTextField watershedDir;
    RmaJComboBox monetaryUnits;
    JLabel systemUnits;
    JLabel timeZone;
    Study _study;
    private RmaJComboBox<StreamAlignmentUnits> _streamAlignUnitsCombo;

    public WatershedInfoPanel() {
        super((LayoutManager)new GridBagLayout());
        JLabel label = new JLabel("Title:");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        this.add(label, gbc);
        this.studyTitle = new RmaJTextField(){

            public void setEditable(boolean editable) {
            }
        };
        this.studyTitle.setEditable(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        gbc.weightx = 1.0;
        this.add((Component)this.studyTitle, gbc);
        label = new JLabel("             ");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        gbc.weightx = 1.0;
        this.add(label, gbc);
        label = new JLabel("Description:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        this.add(label, gbc);
        this.studyDescription = new RmaJDescriptionField();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        gbc.weightx = 1.0;
        this.add((Component)this.studyDescription, gbc);
        label = new JLabel("Monetary Units:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        Object[] mUnits = new String[]{"$'s", "$1,000's", "$1,000,000's"};
        this.monetaryUnits = new RmaJComboBox(mUnits);
        this.monetaryUnits.setModifiable(true);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        gbc.weightx = 1.0;
        JPanel watershedInfoPanel = new JPanel(new GridBagLayout());
        watershedInfoPanel.setBorder(BorderFactory.createTitledBorder("Watershed Information:"));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.gridwidth = 3;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        this.add(watershedInfoPanel, gbc);
        label = new JLabel("Directory Location:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        watershedInfoPanel.add((Component)label, gbc);
        this.watershedDir = new RmaJTextField(20);
        this.watershedDir.setEditable(false);
        this.watershedDir.setModifiable(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        watershedInfoPanel.add((Component)this.watershedDir, gbc);
        label = new JLabel("System Units:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        watershedInfoPanel.add((Component)label, gbc);
        this.systemUnits = new JLabel();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        watershedInfoPanel.add((Component)this.systemUnits, gbc);
        label = new JLabel("Time Zone:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        watershedInfoPanel.add((Component)label, gbc);
        this.timeZone = new JLabel();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        watershedInfoPanel.add((Component)this.timeZone, gbc);
        label = new JLabel("Stream Alignment Units:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.weighty = 0.0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        watershedInfoPanel.add((Component)label, gbc);
        this._streamAlignUnitsCombo = new RmaJComboBox((Object[])StreamAlignmentUnits.values());
        this._streamAlignUnitsCombo.setModifiable(true);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        watershedInfoPanel.add((Component)this._streamAlignUnitsCombo, gbc);
        label = new JLabel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.weighty = 1.0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        watershedInfoPanel.add((Component)label, gbc);
    }

    public void fillPanel() {
        StudyDataList dl = (StudyDataList)ClientApp.Workspace().getDataListContainer().getDataList(Study.class.getName());
        if (dl == null) {
            return;
        }
        this._study = (Study)dl.getOpenStudy();
        if (this._study == null) {
            return;
        }
        this.studyTitle.setText(this._study.getName());
        this.studyDescription.setText(this._study.getDescription());
        this.monetaryUnits.setSelectedItem((Object)this._study.getMonetaryUnits());
        ClientApp.app();
        if (ClientApp.Workspace().getUnitSystem() == 2) {
            this.systemUnits.setText("SI");
        } else {
            this.systemUnits.setText("English");
        }
        TimeZone tz = ClientApp.Workspace().getWatershedTimeZone();
        if (tz != null) {
            this.timeZone.setText(tz.getDisplayName());
        }
        this.watershedDir.setText(ClientApp.Workspace().getWorkspacePath());
        String saUnits = null;
        try {
            saUnits = ClientApp.Workspace().getData().getStreamAlignmentUnits();
            if (saUnits == null || saUnits.isEmpty()) {
                this._streamAlignUnitsCombo.setSelectedIndex(-1);
            } else {
                this._streamAlignUnitsCombo.setSelectedItem((Object)StreamAlignmentUnits.fromString(saUnits));
            }
        }
        catch (RemoteException e) {
            this._streamAlignUnitsCombo.setSelectedIndex(-1);
        }
    }

    public void refresh() {
    }

    public boolean savePanel() {
        StreamAlignmentUnits saUnits;
        if (this._study == null) {
            return true;
        }
        this._study.setName(this.studyTitle.getText());
        this._study.setDescription(this.studyDescription.getText());
        ClientApp.Workspace().setDescription(this.studyDescription.getText());
        if (this.monetaryUnits.getSelectedItem() != null) {
            this._study.setMonetaryUnits(this.monetaryUnits.getSelectedItem().toString());
        }
        if ((saUnits = (StreamAlignmentUnits)((Object)this._streamAlignUnitsCombo.getSelectedItem())) != null) {
            try {
                ClientApp.Workspace().getData().setStreamAlignmentUnits(saUnits.toString());
            }
            catch (RemoteException e) {
                Logger.getLogger(WatershedInfoPanel.class.getName()).warning("Failed to save Stream Alignment Units " + e);
            }
        }
        this._study.save();
        return true;
    }
}

