/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.importer.ccp;

import hec.map.aishape.stream.ShapeFileSelector;
import hec.map.importer.AbstractShapeImportDialog;
import hec.map.importer.ShapeSource;
import hec.map.streamAlignment.StreamAlignmentGlyph;
import hec.watershed.importer.ccp.AbstractShapeCcpTableModel;
import hec.watershed.model.ComputationPointContainer;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import rma.swing.RmaInsets;

public abstract class AbstractImportCcpsDialog
extends AbstractShapeImportDialog {
    private JLabel _rowCountLabel;
    List<ImportCCPFinshedListener> mListeners = new ArrayList<ImportCCPFinshedListener>();
    protected AbstractShapeCcpTableModel _tableModel;
    private ComputationPointContainer _ccpMgr;

    public AbstractImportCcpsDialog(Frame parent, boolean modal, List<ShapeSource> sourceList, ShapeSource selectedSource, StreamAlignmentGlyph streamGlyph, ComputationPointContainer ccpMgr, ShapeFileSelector fileSelector) {
        super(parent, modal, sourceList, selectedSource, streamGlyph, fileSelector);
        this.setCCPManager(ccpMgr);
    }

    protected void buildControls(List<ShapeSource> sourceList, ShapeSource selectedShapeSource, StreamAlignmentGlyph streamGlyph) {
        super.buildControls(sourceList, selectedShapeSource, streamGlyph);
        if (streamGlyph != null) {
            Vector reaches = streamGlyph.getStreamAlignment().getElementVector();
            this._table.setComboBoxEditor(2, reaches);
        }
        this._table.setRowHeight(this._table.getRowHeight() + 5);
        this._table.setColumnPrecision(5, 3);
        this._rowCountLabel = new JLabel("");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this._tablePanel.add((Component)this._rowCountLabel, gbc);
    }

    public void importShapes() {
        if (!this.canImport()) {
            return;
        }
        for (int r = 0; r < this._table.getRowCount(); ++r) {
            Object obj = this._table.getValueAt(r, 1);
            if (obj == null || !Boolean.parseBoolean(obj.toString()) || (obj = this._table.getValueAt(r, 2)) != null) continue;
            String msg = "The Computation Point " + this._table.getValueAt(r, 0) + " has been selected to be imported but has no stream selected";
            JOptionPane.showMessageDialog((Component)((Object)this), msg);
            return;
        }
        boolean success = this._model.importShapes();
        if (success) {
            int cnt = this._tableModel.getImportCount();
            this.closeDialog();
            this.fireImportFinished();
            Object msg = cnt == 1 ? "One Computation Point imported successfully" : String.valueOf(cnt) + " Computation Points imported successfully";
            JOptionPane.showMessageDialog((Component)((Object)this), msg);
        }
    }

    protected void setShapeSource(ShapeSource source) {
        super.setShapeSource(source);
        this.setTitle("Import Computation Points");
    }

    public final void setCCPManager(ComputationPointContainer ccpMgr) {
        this._ccpMgr = ccpMgr;
        this._tableModel.setCcpManager(this._ccpMgr);
    }

    public void streamNameChanged() {
        super.streamNameChanged();
        this._table.setCheckBoxCellEditor(3);
        this._table.setCheckBoxCellEditor(4);
        if (this._streamAlignmentGlyph != null) {
            Vector reaches = this._streamAlignmentGlyph.getStreamAlignment().getElementVector();
            this._table.setComboBoxEditor(2, reaches);
        }
        this._table.setColumnPrecision(5, 3);
        if (this._rowCountLabel != null) {
            this._rowCountLabel.setText("Computation Points:" + this._table.getRowCount());
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractImportCcpsDialog.this._table.repaint();
            }
        });
    }

    private void fireImportFinished() {
        for (int i = this.mListeners.size() - 1; i >= 0; --i) {
            this.mListeners.get(i).finished();
        }
    }

    public void addImportCCPFinishedListener(ImportCCPFinshedListener listener) {
        if (listener == null) {
            return;
        }
        this.mListeners.add(listener);
    }

    protected String getTypeString() {
        return "Computation Points";
    }

    public static interface ImportCCPFinshedListener {
        public void finished();
    }
}

