/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.importer.ccp;

import hec.clientapp.ccp.CcpShapeImport;
import hec.map.WorldPt;
import hec.map.aishape.ShapeImport;
import hec.map.aishape.ShapeImportTableModel;
import hec.map.streamAlignment.StreamAlignmentGlyph;
import hec.map.streamAlignment.StreamAlignmentIfc;
import hec.model.DataObject;
import hec.model.StreamElement;
import hec.model.StreamJunction;
import hec.watershed.model.ComputationPoint;
import hec.watershed.model.ComputationPointContainer;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.SwingWorker;
import rma.swing.RmaJTable;
import rma.util.RMAIO;

public abstract class AbstractShapeCcpTableModel
extends ShapeImportTableModel {
    public static final int STREAM_COLUMN = 2;
    public static final int ONSTREAM_COLUMN = 3;
    public static final int ATJUNCTION_COLUMN = 4;
    public static final int STREAM_STATION_COLUMN = 5;
    private static String[] _header = new String[]{"Stream", "On Stream", "At Junction", "Stream Station"};
    private ComputationPointContainer _ccpMgr;
    private StreamAlignmentGlyph _alignGlyph;
    private int _importCnt;

    public AbstractShapeCcpTableModel(final RmaJTable table) {
        super(table);
        this._table.setPopupMenuEnabled(true);
        this._table.setAddRemoveEnabled(false);
        this._table.removePopupMenuSumOptions();
        this._table.removePopuMenuFillOptions();
        this._table.removePopupMenuInsertAppendOnly();
        this._table.removePopupMenuRowEditingOptions();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                table.setCheckBoxCellEditor(3);
                table.setCheckBoxCellEditor(4);
            }
        });
    }

    public abstract boolean importShapes();

    public ShapeImport buildShapeImport(String name) {
        return new CcpShapeImport(name);
    }

    public boolean importShapes(double gapTolerance) {
        this.clearHighlights(true);
        List shapeImportNames = this.getShapeImportNames();
        this._importCnt = 0;
        for (int ii = 0; ii < shapeImportNames.size(); ++ii) {
            String ccpName = (String)shapeImportNames.get(ii);
            CcpShapeImport oss = (CcpShapeImport)this.getShapeImport(ccpName);
            if (!oss.getImportShapes()) continue;
            String userName = oss.getUserName();
            if (userName == null) {
                userName = ccpName;
            }
            StreamElement stream = oss.getStream();
            WorldPt wpt = oss.getPoint();
            ComputationPoint cp = (ComputationPoint)this._ccpMgr.newDataObject(userName, "");
            StreamElement elem = (StreamElement)this.getValueAt(ii, 2);
            boolean onStream = Boolean.parseBoolean(this.getValueAt(ii, 3).toString());
            if (elem != null) {
                double station = oss.getStation();
                cp.setStreamStation(station);
                if (oss.getJunction() != null && oss.isAtJunction() && onStream) {
                    StreamJunction junc = oss.getJunction();
                    wpt = junc.getLocation();
                    cp.setJunctionIndex(junc.getIndex());
                } else {
                    double coord = elem.getCoordByStation(station);
                    cp.setStreamCoord(coord);
                    if (onStream) {
                        WorldPt pointOnStream;
                        wpt = pointOnStream = elem.getLocationByCoord(coord);
                    }
                }
                cp.setSnapToStream(onStream);
                cp.setStreamIndex(elem.getIndex());
            }
            cp.setReferencePt(wpt);
            if (this._ccpMgr.addNewObject2((DataObject)cp) != null) {
                ++this._importCnt;
                continue;
            }
            System.out.println("importShapes:failed to import " + oss);
        }
        this.fillModel();
        return true;
    }

    public void setCcpManager(ComputationPointContainer ccpMgr) {
        this._ccpMgr = ccpMgr;
    }

    public void setStreamAlignmentGlyph(StreamAlignmentGlyph alignGlyph) {
        this._alignGlyph = alignGlyph;
        final StreamAlignmentIfc alignment = (StreamAlignmentIfc)this._alignGlyph.getMap();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Vector streams = alignment.getElementVector();
                AbstractShapeCcpTableModel.this._table.setComboBoxEditor(2, streams);
            }
        });
    }

    public void checkExistance(ShapeImport shapeImport) {
        String ccpName = shapeImport.getName();
        ComputationPoint cp = (ComputationPoint)this._ccpMgr.getObject(ccpName);
        if (cp != null) {
            shapeImport.addExistsError();
        } else {
            shapeImport.removeExistsError();
        }
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (rowIndex < 0 || rowIndex >= this._shapeImportNames.size()) {
            return false;
        }
        if (columnIndex == 4) {
            String shapeName = (String)this._shapeImportNames.get(rowIndex);
            CcpShapeImport shapeImport = (CcpShapeImport)this._shapeImportHash.get(shapeName);
            Boolean onStream = (Boolean)this.getValueAt(rowIndex, 3);
            return shapeImport.getJunction() != null && onStream != false;
        }
        if (columnIndex == 5) {
            String shapeName = (String)this._shapeImportNames.get(rowIndex);
            CcpShapeImport shapeImport = (CcpShapeImport)this._shapeImportHash.get(shapeName);
            Object stream = this.getValueAt(rowIndex, 2);
            if (stream == null) {
                return false;
            }
        } else if (columnIndex == 0) {
            // empty if block
        }
        return true;
    }

    public Class getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 3: 
            case 4: {
                return Boolean.class;
            }
            case 2: {
                return Object.class;
            }
            case 5: {
                return Double.class;
            }
        }
        return super.getColumnClass(columnIndex);
    }

    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 3: {
                return _header[1];
            }
            case 2: {
                return _header[0];
            }
            case 4: {
                return _header[2];
            }
            case 5: {
                return _header[3];
            }
        }
        return super.getColumnName(columnIndex);
    }

    public int getColumnCount() {
        return super.getColumnCount() + _header.length;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (aValue == null) {
            return;
        }
        String shapeName = (String)this._shapeImportNames.get(rowIndex);
        ShapeImport shapeImport = (ShapeImport)this._shapeImportHash.get(shapeName);
        switch (columnIndex) {
            case 0: {
                CcpShapeImport streamImport = (CcpShapeImport)shapeImport;
                if (aValue != null && aValue.toString().length() > 0) {
                    streamImport.setUserName(aValue.toString());
                    break;
                }
                streamImport.setUserName(null);
                break;
            }
            case 1: {
                CcpShapeImport streamImport = (CcpShapeImport)shapeImport;
                Boolean bool = aValue instanceof Boolean ? (Boolean)aValue : Boolean.valueOf(Boolean.parseBoolean(aValue.toString()));
                shapeImport.setImportShapes(bool.booleanValue());
                break;
            }
            case 2: {
                StreamElement elem;
                CcpShapeImport streamImport = (CcpShapeImport)shapeImport;
                if (aValue instanceof String) {
                    elem = this._alignGlyph.findReach((String)aValue);
                } else if (aValue instanceof StreamElement) {
                    elem = (StreamElement)aValue;
                } else {
                    return;
                }
                streamImport.setStream(elem);
                double station = elem.getStationByLocation(streamImport.getPoint());
                streamImport.setStation(station);
                this.fireTableCellUpdated(rowIndex, 5);
                break;
            }
            case 3: {
                CcpShapeImport streamImport = (CcpShapeImport)shapeImport;
                Boolean bool = aValue instanceof Boolean ? (Boolean)aValue : Boolean.valueOf(Boolean.parseBoolean(aValue.toString()));
                streamImport.setOnStream(bool.booleanValue());
                this.fireTableCellUpdated(rowIndex, 4);
                break;
            }
            case 4: {
                CcpShapeImport streamImport = (CcpShapeImport)shapeImport;
                Boolean bool = aValue instanceof Boolean ? (Boolean)aValue : Boolean.valueOf(Boolean.parseBoolean(aValue.toString()));
                streamImport.setIsAtJunction(bool.booleanValue());
                break;
            }
            case 5: {
                CcpShapeImport streamImport = (CcpShapeImport)shapeImport;
                double d = aValue instanceof Double ? (Double)aValue : RMAIO.parseDouble((Object)aValue);
                streamImport.setStation(d);
            }
            default: {
                super.setValueAt(aValue, rowIndex, columnIndex);
            }
        }
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        String shapeName = (String)this._shapeImportNames.get(rowIndex);
        ShapeImport shapeImport = (ShapeImport)this._shapeImportHash.get(shapeName);
        switch (columnIndex) {
            case 0: {
                CcpShapeImport streamImport = (CcpShapeImport)shapeImport;
                String name = streamImport.getUserName();
                if (name == null || name.length() == 0) {
                    return shapeName;
                }
                return name;
            }
            case 1: {
                return shapeImport.getImportShapes();
            }
            case 2: {
                CcpShapeImport streamImport = (CcpShapeImport)shapeImport;
                return streamImport.getStream();
            }
            case 3: {
                CcpShapeImport streamImport = (CcpShapeImport)shapeImport;
                return streamImport.isOnStream();
            }
            case 4: {
                CcpShapeImport streamImport = (CcpShapeImport)shapeImport;
                return streamImport.isAtJunction();
            }
            case 5: {
                CcpShapeImport streamImport = (CcpShapeImport)shapeImport;
                return streamImport.getStation();
            }
        }
        return super.getValueAt(rowIndex, columnIndex);
    }

    public void fillModel() {
        super.fillModel();
        int rows = this.getRowCount();
        for (int r = 0; r < rows; ++r) {
            String shapeName = (String)this._shapeImportNames.get(r);
            CcpShapeImport shapeImport = (CcpShapeImport)this._shapeImportHash.get(shapeName);
            StreamElement stream = this._alignGlyph.findNearestReach(shapeImport.getPoint());
            if (stream != null) {
                this.setValueAt(stream, r, 2);
                double station = stream.getStationByLocation(shapeImport.getPoint());
                this.setValueAt(station, r, 5);
                this.setValueAt(Boolean.TRUE, r, 3);
                continue;
            }
            this.setValueAt(null, r, 2);
        }
        StreamAlignmentIfc alignment = (StreamAlignmentIfc)this._alignGlyph.getMap();
        if (alignment != null) {
            final StreamAlignmentIfc fAlignment = alignment;
            SwingWorker worker = new SwingWorker(){

                public Void doInBackground() {
                    int rowCnt = AbstractShapeCcpTableModel.this.getRowCount();
                    for (int r = 0; r < rowCnt; ++r) {
                        Object streamVal;
                        CcpShapeImport ccpShape;
                        WorldPt point;
                        StreamJunction junction;
                        String shapeName = (String)AbstractShapeCcpTableModel.this._shapeImportNames.get(r);
                        ShapeImport shapeImport = (ShapeImport)AbstractShapeCcpTableModel.this._shapeImportHash.get(shapeName);
                        if (!(shapeImport instanceof CcpShapeImport) || (junction = AbstractShapeCcpTableModel.this.findNearestJunction(point = (ccpShape = (CcpShapeImport)shapeImport).getPoint(), r, fAlignment)) == null) continue;
                        Object stationVal = AbstractShapeCcpTableModel.this.getValueAt(r, 5);
                        if (RMAIO.parseDouble((Object)stationVal) < 1.0 && (streamVal = AbstractShapeCcpTableModel.this.getValueAt(r, 2)) instanceof StreamElement) {
                            StreamElement elem = (StreamElement)streamVal;
                            Vector v = new Vector();
                            junction.getOutflowingStreams(v);
                            if (v.size() == 1) {
                                elem = (StreamElement)v.get(0);
                                AbstractShapeCcpTableModel.this.setValueAt(elem, r, 2);
                            }
                        }
                        ArrayList<JunctionEntry> l = new ArrayList<JunctionEntry>(1);
                        l.add(new JunctionEntry(junction, r));
                        this.publish(l);
                    }
                    return null;
                }

                public void process(List list) {
                    if (list == null || list.size() == 0) {
                        return;
                    }
                    for (int i = 0; i < list.size(); ++i) {
                        Object object = list.get(i);
                        if (object instanceof List) {
                            List ll = (List)object;
                            for (int l = 0; l < ll.size(); ++l) {
                                object = ll.get(l);
                                if (!(object instanceof JunctionEntry)) continue;
                                JunctionEntry entry = (JunctionEntry)object;
                                AbstractShapeCcpTableModel.this.setAtJunction(entry);
                            }
                            continue;
                        }
                        if (!(object instanceof JunctionEntry)) continue;
                        JunctionEntry entry = (JunctionEntry)object;
                        AbstractShapeCcpTableModel.this.setAtJunction(entry);
                    }
                }

                @Override
                protected void done() {
                    super.done();
                    AbstractShapeCcpTableModel.this._table.repaint();
                }
            };
            worker.execute();
        }
    }

    protected void setAtJunction(JunctionEntry entry) {
        String shapeName = (String)this._shapeImportNames.get(entry.row);
        CcpShapeImport shapeImport = (CcpShapeImport)this._shapeImportHash.get(shapeName);
        shapeImport.setJunction(entry.junc);
        this.setValueAt(Boolean.TRUE, entry.row, 4);
    }

    private StreamJunction findNearestJunction(WorldPt point, int row, StreamAlignmentIfc alignment) {
        WorldPt wptBest = new WorldPt();
        StreamElement reach = (StreamElement)this.getValueAt(row, 2);
        StreamJunction junction = alignment.findStreamJunction(reach, point, 10.0);
        return junction;
    }

    public int getImportCount() {
        return this._importCnt;
    }

    public String getToolTip(int col, int row) {
        if (col == 4) {
            if (row < 0 || row >= this._shapeImportNames.size()) {
                return null;
            }
            String name = (String)this._shapeImportNames.get(row);
            CcpShapeImport shapeImport = (CcpShapeImport)this._shapeImportHash.get(name);
            if (shapeImport.isAtJunction()) {
                return "Junction:" + shapeImport.getJunction().getIndex();
            }
        } else if (col == 5) {
            if (row < 0 || row >= this._shapeImportNames.size()) {
                return null;
            }
            String name = (String)this._shapeImportNames.get(row);
            CcpShapeImport shapeImport = (CcpShapeImport)this._shapeImportHash.get(name);
            return "<html>Station:" + shapeImport.getStation() + "<br>Location:" + shapeImport.getPoint();
        }
        return super.getToolTip(col, row);
    }

    public class JunctionEntry {
        StreamJunction junc;
        int row;

        public JunctionEntry(StreamJunction junction, int r) {
            this.junc = junction;
            this.row = r;
        }
    }
}

