/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.importer.ccp;

import hec.map.WorldPt;
import hec.map.aishape.ShapeImport;
import hec.map.importer.ImportPoint;
import hec.model.StreamElement;
import hec.model.StreamJunction;
import java.util.List;

public class CcpShapeImport
extends ShapeImport {
    private String _userName;
    private WorldPt _point;
    private StreamElement _streamElement;
    private boolean _onStream;
    private String _existsError;
    private boolean _atJunction;
    private StreamJunction _junction;
    private double _station;

    public CcpShapeImport(String shapeName) {
        super(shapeName);
        String type = "Computation Point";
        this.setType(type);
        this._existsError = "Computation Point already exists";
    }

    public void removeExistsError() {
        this.removeError(this._existsError);
    }

    public void addExistsError() {
        this.addError(this._existsError);
    }

    public int getShapeGraphicType() {
        return 0;
    }

    public boolean validate() {
        this.clearErrors();
        if (this.getShapeCount() < 1) {
            String msg = "No Shape Objects for Computation Point " + this.getName();
            this.addError(msg);
            return false;
        }
        List shapes = this.getShapes();
        ImportPoint aiPoint = (ImportPoint)shapes.get(0);
        this._point = aiPoint.getWorldPt();
        return true;
    }

    public WorldPt getPoint() {
        return this._point;
    }

    public void setUserName(String name) {
        this._userName = name;
    }

    public String getUserName() {
        return this._userName;
    }

    public String toString() {
        if (this._userName != null) {
            return this._userName;
        }
        return this.getName();
    }

    public StreamElement getStream() {
        return this._streamElement;
    }

    public void setOnStream(boolean onStream) {
        this._onStream = onStream;
    }

    public boolean isOnStream() {
        return this._onStream;
    }

    public void setStream(StreamElement elem) {
        this._streamElement = elem;
    }

    public void setIsAtJunction(boolean atJunction) {
        this._atJunction = atJunction;
    }

    public boolean isAtJunction() {
        return this._atJunction;
    }

    public void setJunction(StreamJunction junction) {
        this._junction = junction;
    }

    public StreamJunction getJunction() {
        return this._junction;
    }

    public void setStation(double station) {
        this._station = station;
    }

    public double getStation() {
        return this._station;
    }
}

