/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.map;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import hec.appInterface.AppDaddy;
import hec.clientapp.client.ClientApp;
import hec.gui.NameDialog;
import hec.map.LocalPt;
import hec.map.LocalRect;
import hec.map.MapGlyph;
import hec.map.MapObjectInterface;
import hec.map.MapPanel;
import hec.map.MapScale;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.crs.CRSException;
import hec.watershed.client.StationEditorDialog;
import hec.watershed.map.StationSetMapObject;
import hec.watershed.model.Station;
import hec.watershed.model.StationSet;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import rma.swing.RmaImage;
import rma.swing.RmaJMenuLabel;

public class StationSetGlyph
extends MapGlyph {
    ImageIcon stationImage = RmaImage.getImageIcon((String)"Images/stationset/blue/wide_diamond_blue.png");
    ImageIcon metstationImage = RmaImage.getImageIcon((String)"Images/stationset/blue/wide_diamond_blue.png");
    ImageIcon observedStation = RmaImage.getImageIcon((String)"Images/stationset/purple/wide_diamond_purple.png");
    ImageIcon bothStation = RmaImage.getImageIcon((String)"Images/stationset/purple-blue/wide_diamond_purple_blue.png");

    public StationSetGlyph(MapPanel panel, StationSetMapObject stationSet) {
        super(panel, (MapObjectInterface)stationSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(Graphics graphics, MapScale scale) {
        Graphics2D g2d = (Graphics2D)graphics.create();
        try {
            StationSetMapObject map = (StationSetMapObject)this.getMap();
            StationSet ss = map.getStationSet();
            List features = ss.getFeatures();
            WorldPt wp = new WorldPt();
            Image img = null;
            for (Station station : features) {
                Geometry geometry = station.getGeometry();
                img = !station.isMetStation() && !station.isObservedStation() ? this.stationImage.getImage() : null;
                img = img == null && station.isMetStation() && !station.isObservedStation() ? this.metstationImage.getImage() : img;
                img = img == null && !station.isMetStation() && station.isObservedStation() ? this.observedStation.getImage() : img;
                img = img == null && station.isMetStation() && station.isObservedStation() ? this.bothStation.getImage() : img;
                Point centroid = geometry.getCentroid();
                wp.e = centroid.getX();
                wp.n = centroid.getY();
                try {
                    LocalPt localPt = this.transformPointToLocal(wp);
                    g2d.drawImage(img, localPt.x - this.stationImage.getIconWidth() / 2, localPt.y - this.stationImage.getIconHeight() / 2, null);
                }
                catch (CRSException e) {
                    e.printStackTrace();
                    break;
                }
            }
        }
        finally {
            g2d.dispose();
        }
    }

    private LocalRect computeLocalBoundRect(Geometry g) {
        if (g == null) {
            return new LocalRect(0, 0, 0, 0);
        }
        Envelope env = g.getEnvelopeInternal();
        WorldRect wr = new WorldRect(env.getMinX(), env.getMaxY(), env.getMaxX(), env.getMinY());
        MapScale scale = this.getMapPanel().scale((MapGlyph)this);
        LocalRect localRect = scale.wr2lr(wr);
        if (localRect.width() == 0) {
            localRect.l -= 3;
            localRect.r = localRect.l + 5;
        }
        if (localRect.height() == 0) {
            localRect.t -= 3;
            localRect.b = localRect.t + 5;
        }
        return localRect;
    }

    public Station findStation(LocalPt pt) {
        Station station = null;
        Predicate<Station> p = s -> this.computeLocalBoundRect(s.getGeometry()).contains(pt);
        StationSetMapObject mapObj = (StationSetMapObject)this.getMap();
        List<Station> findStation = mapObj.findStation(p);
        station = findStation != null && findStation.size() > 0 ? findStation.get(0) : null;
        return station;
    }

    public Station createStation(LocalPt pt) {
        if (pt == null) {
            return null;
        }
        NameDialog dlg = new NameDialog((Frame)AppDaddy.getFrame(), true);
        dlg.setName("");
        dlg.setDescription("");
        dlg.setTitle("Name New Station");
        dlg.setVisible(true);
        if (dlg.isCanceled()) {
            return null;
        }
        MapScale scale = this.getMapPanel().scale((MapGlyph)this);
        WorldPt wpt = scale.lp2wp(pt);
        StationSetMapObject mapObj = (StationSetMapObject)this.getMap();
        Station station = mapObj.createStation(wpt);
        station.setName(dlg.getName());
        station.setDescription(dlg.getDescription());
        this.getMapPanel().paintMap();
        return station;
    }

    public boolean objectDoubleClick(LocalPt pt, int modifiers) {
        Station findStation = this.findStation(pt);
        if (findStation == null) {
            return false;
        }
        this.editStation(findStation);
        return true;
    }

    public boolean objectPopupMenu(LocalPt pt, int modifiers) {
        Station findStation = this.findStation(pt);
        if (findStation == null) {
            return false;
        }
        JPopupMenu menu = new JPopupMenu();
        RmaJMenuLabel label = new RmaJMenuLabel(findStation.getName());
        menu.add((JMenuItem)label);
        menu.addSeparator();
        menu.add(new EditStationAction(findStation));
        menu.add(new DeleteStationAction(findStation));
        menu.show((Component)this.getMapPanel(), pt.x, pt.y);
        return true;
    }

    private void deleteStation(Station selectedStation) {
        StationSetMapObject mapObj = (StationSetMapObject)this.getMap();
        mapObj.deleteStation(selectedStation);
        this.getMapPanel().paintMap();
    }

    private void editStation(Station selectedStation) {
        Predicate<Station> p = s -> true;
        StationSetMapObject mapObj = (StationSetMapObject)this.getMap();
        List<Station> stations = mapObj.findStation(p);
        Window windowForComponent = SwingUtilities.windowForComponent((Component)this.getMapPanel());
        StationEditorDialog dialog = new StationEditorDialog(windowForComponent, Dialog.ModalityType.APPLICATION_MODAL);
        dialog.fillPanel(stations, selectedStation, ClientApp.Workspace().getUnitSystem());
        dialog.setTitle("Edit Station");
        dialog.pack();
        dialog.setLocationRelativeTo(windowForComponent);
        dialog.setVisible(true);
        this.getMapPanel().paintMap();
    }

    private class EditStationAction
    extends AbstractAction {
        private final Station station;

        public EditStationAction(Station station) {
            this.station = station;
            this.putValue("Name", "Edit");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    StationSetGlyph.this.editStation(EditStationAction.this.station);
                }
            };
            SwingUtilities.invokeLater(r);
        }
    }

    public class DeleteStationAction
    extends AbstractAction {
        private final Station station;

        public DeleteStationAction(Station station) {
            this.station = station;
            this.putValue("Name", "Delete");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    StationSetGlyph.this.deleteStation(DeleteStationAction.this.station);
                }
            };
            SwingUtilities.invokeLater(r);
        }
    }
}

