/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.map;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import hec.map.MapGlyphFactory;
import hec.map.MapIdentifier;
import hec.map.MapObjectInterface2;
import hec.map.MapToolSet;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.crs.CoordinateReferenceSystem;
import hec.watershed.map.StationSetGlyph;
import hec.watershed.model.Station;
import hec.watershed.model.StationSet;
import java.io.IOException;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import rma.services.annotations.ServiceProvider;

public class StationSetMapObject
implements MapObjectInterface2 {
    private MapIdentifier mapIdentifier = new MapIdentifier();
    private final StationSet _stationSet;

    public StationSetMapObject(StationSet ss) {
        this._stationSet = ss;
        this.mapIdentifier.setMapShown(true);
    }

    public List<Station> findStation(Predicate<Station> query) {
        List<Station> collect = this._stationSet.getFeatures().stream().filter(query).collect(Collectors.toList());
        return collect;
    }

    public MapToolSet getMapTools() {
        return null;
    }

    public void setMapIdentifier(MapIdentifier arg0) {
        this.mapIdentifier = arg0;
    }

    public MapIdentifier getMapIdentifier() {
        return this.mapIdentifier;
    }

    public String getName() {
        return this._stationSet.getName();
    }

    public void setExtent(WorldRect arg0) {
    }

    public WorldRect getExtent() {
        Envelope e = this._stationSet.getEnvelope();
        if (e != null) {
            return new WorldRect(e.getMinX(), e.getMaxY(), e.getMaxX(), e.getMinY());
        }
        List features = this._stationSet.getFeatures();
        for (Station station : features) {
            Geometry geometry = station.getGeometry();
            if (geometry == null) continue;
            if (e == null) {
                e = new Envelope();
            }
            e.expandToInclude(geometry.getEnvelopeInternal());
        }
        if (e == null) {
            return null;
        }
        WorldRect extent = new WorldRect(e.getMinX(), e.getMaxY(), e.getMaxX(), e.getMinY());
        if (extent.width() == 0.0) {
            extent.e += 1.0;
        }
        if (extent.height() == 0.0) {
            extent.n += 1.0;
        }
        return extent;
    }

    public void load() throws IOException {
    }

    public void unload() {
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return null;
    }

    StationSet getStationSet() {
        return this._stationSet;
    }

    public Station createStation(WorldPt wpt) {
        Point createPoint = new GeometryFactory().createPoint(new Coordinate(wpt.e, wpt.n));
        Station station = new Station();
        station.setGeometry((Geometry)createPoint);
        this._stationSet.addFeature(station);
        return station;
    }

    void deleteStation(Station selectedStation) {
        this._stationSet.removeFeature(selectedStation);
    }

    @ServiceProvider(service=MapGlyphFactory.MapGlyphMappingProvider.class)
    public static class MapLoader
    implements MapGlyphFactory.MapGlyphMappingProvider {
        public String getMapObjectInterfaceClass() {
            return StationSetMapObject.class.getName();
        }

        public String getMapGlyphClass() {
            return StationSetGlyph.class.getName();
        }
    }
}

