/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.map.impactArea;

import hec.io.Identifier;
import hec.map.MapIdentifier;
import hec.map.WorldRegion;
import hec.map.aishape.AiShapeFieldDescriptor;
import hec.map.aishape.AiShapeMap;
import hec.map.aishape.AiShapePolygon;
import hec.map.aishape.Attribute;
import hec.map.aishape.Field;
import hec.map.aishape.SelfIntersectingPolygonException;
import hec.map.streamAlignment.StreamAlignmentIfc;
import hec.model.DataList;
import hec.model.DataObject;
import hec.model.StreamElement;
import hec.watershed.model.ImpactArea;
import java.awt.Color;
import java.awt.Component;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import rma.util.RMAIO;

public class ImpactAreaToShapefile {
    public static final String IMPACT_AREA_ID_FIELD = "ID_IMPAREA";
    public static final int IMPACT_AREA_ID_FIELD_LENGTH = 32;
    public static final String STREAM_NAME_FIELD = "ID_STREAM";
    public static final int STREAM_NAME_FIELD_LENGTH = 32;
    public static final String BEGINNING_STREAM_STATION_FIELD = "BEG_STAT";
    public static final String ENDING_STREAM_STATION_FIELD = "END_STAT";
    public static final String INDEX_STREAM_STATION_FIELD = "IDX_STAT";
    public static final String DESC_FIELD = "DESC";
    public static final String COLOR_FIELD = "COLOR";
    public static final int COLOR_FIELD_LENGTH = 32;
    public static final String STREAM_BANK_FIELD = "STRM_BNK";
    public static final int STREAM_BANK_FIELD_LENGTH = 32;
    public static final int STATION_FIELD_LENGTH = 10;
    public static final int STATION_FIELD_DECIMALS = 2;
    public static final String STREAM_NAME = "Stream Name";
    public static final String BEGINNING_STREAM_STATION = "Beginning stream station";
    public static final String ENDING_STREAM_STATION = "Ending stream station";
    public static final String INDEX_STREAM_STATION = "Index stream station";
    public static final String DESCRIPTION = "Description";
    public static final String COLOR = "Color";
    public static final String STREAM_BANK = "Stream bank";
    private static final HashMap _attrFieldMap = new HashMap();

    public static Map getDefaultAttrToFieldMap() {
        return Collections.unmodifiableMap(_attrFieldMap);
    }

    public static boolean exportToShapefile(Component parent, DataList impactAreaDataList, StreamAlignmentIfc streamAlignment, Identifier shapefileId) {
        AiShapeMap map = new AiShapeMap(new MapIdentifier(shapefileId));
        DataObject[] impactAreas = impactAreaDataList.getObjects();
        Vector<AiShapePolygon> shapes = new Vector<AiShapePolygon>(impactAreas.length);
        Vector<Attribute> attributes = new Vector<Attribute>(impactAreas.length);
        AiShapeFieldDescriptor impactAreaIdDescriptor = new AiShapeFieldDescriptor(IMPACT_AREA_ID_FIELD, 'C', 32, 0);
        AiShapeFieldDescriptor descDescriptor = new AiShapeFieldDescriptor(DESC_FIELD, 'M', 0, 0);
        AiShapeFieldDescriptor colorDescriptor = new AiShapeFieldDescriptor(COLOR_FIELD, 'C', 32, 0);
        AiShapeFieldDescriptor streamNameDescriptor = new AiShapeFieldDescriptor(STREAM_NAME_FIELD, 'C', 32, 0);
        AiShapeFieldDescriptor beginningStationDescriptor = new AiShapeFieldDescriptor(BEGINNING_STREAM_STATION_FIELD, 'F', 10, 2);
        AiShapeFieldDescriptor endingStationDescriptor = new AiShapeFieldDescriptor(ENDING_STREAM_STATION_FIELD, 'F', 10, 2);
        AiShapeFieldDescriptor indexStationDescriptor = new AiShapeFieldDescriptor(INDEX_STREAM_STATION_FIELD, 'F', 10, 2);
        AiShapeFieldDescriptor streamBankDescriptor = new AiShapeFieldDescriptor(STREAM_BANK_FIELD, 'C', 32, 0);
        Vector<AiShapeFieldDescriptor> fieldDescriptors = new Vector<AiShapeFieldDescriptor>();
        fieldDescriptors.add(impactAreaIdDescriptor);
        fieldDescriptors.add(descDescriptor);
        fieldDescriptors.add(colorDescriptor);
        fieldDescriptors.add(streamNameDescriptor);
        fieldDescriptors.add(beginningStationDescriptor);
        fieldDescriptors.add(endingStationDescriptor);
        fieldDescriptors.add(indexStationDescriptor);
        fieldDescriptors.add(streamBankDescriptor);
        for (int ii = 0; ii < impactAreas.length; ++ii) {
            ImpactArea ia = (ImpactArea)impactAreas[ii];
            Field[] fields = new Field[fieldDescriptors.size()];
            fields[0] = new Field((Object)ia.getName(), impactAreaIdDescriptor, ii + 1);
            fields[1] = new Field((Object)ia.getDescription(), descDescriptor, ii + 1);
            Color c = ia.getColor();
            String s = RMAIO.color2String((Color)c);
            fields[2] = new Field((Object)s, colorDescriptor, ii + 1);
            int streamId = ia.getStreamId();
            StreamElement reach = streamAlignment.getReach(streamId);
            String streamName = "";
            if (reach != null) {
                streamName = reach.getName();
            }
            fields[3] = new Field((Object)streamName, streamNameDescriptor, ii + 1);
            Double begStation = new Double(ia.getBeginStation());
            fields[4] = new Field((Object)begStation.toString(), beginningStationDescriptor, ii + 1);
            Double endStation = new Double(ia.getEndStation());
            fields[5] = new Field((Object)endStation.toString(), endingStationDescriptor, ii + 1);
            Double indexStation = new Double(ia.getIndexStation());
            fields[6] = new Field((Object)indexStation.toString(), indexStationDescriptor, ii + 1);
            s = ImpactArea.getBankConstant(ia.getBank());
            fields[7] = new Field((Object)s, streamBankDescriptor, ii + 1);
            Attribute attr = new Attribute(ii + 1, fields);
            attributes.add(attr);
            Vector<WorldRegion> worldRegions = new Vector<WorldRegion>();
            worldRegions.add(ia.getRegion());
            try {
                AiShapePolygon poly = new AiShapePolygon(ii + 1, worldRegions);
                poly.setAttribute(attr);
                shapes.add(poly);
                continue;
            }
            catch (SelfIntersectingPolygonException e) {
                StringBuffer sb = new StringBuffer("Error exporting impact area: ");
                sb.append(ia.getName());
                sb.append(".\nError is: ");
                sb.append(e.getMessage());
                RMAIO.postError((Component)parent, (String)sb.toString());
                return false;
            }
        }
        map.writeData(5, fieldDescriptors, shapes, attributes);
        return true;
    }

    static {
        _attrFieldMap.put(STREAM_NAME, STREAM_NAME_FIELD);
        _attrFieldMap.put(BEGINNING_STREAM_STATION, BEGINNING_STREAM_STATION_FIELD);
        _attrFieldMap.put(ENDING_STREAM_STATION, ENDING_STREAM_STATION_FIELD);
        _attrFieldMap.put(INDEX_STREAM_STATION, INDEX_STREAM_STATION_FIELD);
        _attrFieldMap.put(DESCRIPTION, DESC_FIELD);
        _attrFieldMap.put(COLOR, COLOR_FIELD);
        _attrFieldMap.put(STREAM_BANK, STREAM_BANK_FIELD);
    }
}

