/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.map.impactArea;

import hec.clientapp.map.impactArea.FieldMappingDialog;
import hec.map.aishape.FieldMapModel;
import hec.map.aishape.ShapeImport;
import hec.map.aishape.ShapeImportProgressIndicator;
import hec.map.aishape.ShapeImportTableModel;
import hec.map.aishape.stream.ShapeFileSelector;
import hec.map.importer.AbstractShapeImportDialog;
import hec.map.importer.ShapeSource;
import hec.map.streamAlignment.StreamAlignmentGlyph;
import hec.model.CommonDataList;
import hec.watershed.client.StudySystemMapGlyph;
import hec.watershed.map.impactArea.ImpactAreaToShapefile;
import hec.watershed.map.impactArea.ShapeImpactAreaTableModel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTable;
import rma.util.RMAIO;

public class ShapeImpactAreaDialog
extends AbstractShapeImportDialog
implements ListSelectionListener {
    ShapeImpactAreaTableModel _tableModel;
    StudySystemMapGlyph _studySystemGlyph;
    CommonDataList _impactAreaDataList;
    RmaJCheckBox _replaceExistingCheckBox;
    JButton _mapFieldsButton;
    JButton _cancelButton;

    public ShapeImpactAreaDialog(JFrame parent, List<ShapeSource> availableShapeGlyphs, CommonDataList impactAreaDataList, ShapeSource selectedShapeSource, StudySystemMapGlyph studySystemGlyph, StreamAlignmentGlyph streamAlignmentGlyph, ShapeFileSelector fileSelector) {
        super((Frame)parent, true, availableShapeGlyphs, selectedShapeSource, streamAlignmentGlyph, fileSelector);
        this._replaceExistingCheckBox.setSelected(this._tableModel.getReplaceExisting());
        this.setImpactAreaDataList(impactAreaDataList);
        this.setStudySystemGlyph(studySystemGlyph);
        this.setStreamAlignmentGlyph(streamAlignmentGlyph);
        this._mapFieldsButton.addActionListener((ActionListener)this._listener.add((Object)this, (Object)this._mapFieldsButton, "mapFieldsAction"));
        this._replaceExistingCheckBox.addActionListener((ActionListener)this._listener.add((Object)this, (Object)this._replaceExistingCheckBox, "replaceExistingChanged"));
    }

    protected void buildControls(List<ShapeSource> sourceList, ShapeSource selectedShapeSource, StreamAlignmentGlyph streamGlyph) {
        super.buildControls(sourceList, selectedShapeSource, streamGlyph);
        this._mapFieldsButton = new JButton("Map Fields...");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this._dbFieldNamePanel.add((Component)this._mapFieldsButton, gbc);
        this._replaceExistingCheckBox = new RmaJCheckBox("Replace Existing Impact Areas");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 4;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this._optionsPanel.add((Component)this._replaceExistingCheckBox, gbc);
    }

    protected RmaJTable createTable() {
        RmaJTable table = new RmaJTable((Component)((Object)this)){

            public String getToolTipText(MouseEvent event) {
                Point p = event.getPoint();
                int column = this.columnAtPoint(p);
                int row = this.rowAtPoint(p);
                String toolTip = ShapeImpactAreaDialog.this._model.getToolTip(column, row);
                if (toolTip != null) {
                    return toolTip;
                }
                return super.getToolTipText(event);
            }

            public boolean editCellAt(int row, int column, EventObject e) {
                ShapeImport si = ShapeImpactAreaDialog.this._tableModel.getShapeImport(row);
                String errorString = null;
                if (!this.isCellEditable(row, column) && si != null && (errorString = si.getErrorString()) != null && errorString.length() > 0) {
                    JOptionPane.showMessageDialog((Component)((Object)this), errorString, "Error!", 0);
                }
                return super.editCellAt(row, column, e);
            }
        };
        table.setRowHeight(table.getRowHeight() + 5);
        return table;
    }

    public void mapFieldsAction() {
        FieldMapModel fieldMapModel = this._tableModel.getFieldMapModel();
        FieldMappingDialog dialog = new FieldMappingDialog((RmaJDialog)this, this.isModal(), this._selectedSource, fieldMapModel);
        dialog.setNameFieldIndex(this._tableModel.getNameFieldIndex());
        dialog.pack();
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.setTitle("Map Fields");
        dialog.setVisible(true);
        if (dialog.isCanceled()) {
            return;
        }
        int nameFieldIndex = dialog.getNameFieldIndex();
        this._tableModel.setNameFieldIndex(nameFieldIndex);
        this._tableModel.setFieldMapModel(dialog.getFieldMapModel());
    }

    public void replaceExistingChanged() {
        this._tableModel.setReplaceExisting(this._replaceExistingCheckBox.isSelected());
    }

    public void importShapes() {
        this._table.commitEdit(true);
        int rowCount = this._tableModel.getRowCount();
        if (rowCount == 0) {
            RMAIO.postWarning((Component)((Object)this), (String)"The Impact Area shape table is empty.\nTry mapping fields via the \"Map Fields\" button.");
            return;
        }
        final ShapeImportProgressIndicator progress = new ShapeImportProgressIndicator((RmaJDialog)this);
        progress.pack();
        progress.setSize(250, progress.getHeight());
        this.importRunning();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ShapeImpactAreaDialog.this._tableModel.importShapes(progress);
                Runnable rr = new Runnable(){

                    @Override
                    public void run() {
                        ShapeImpactAreaDialog.this.importDone();
                    }
                };
                SwingUtilities.invokeLater(rr);
            }
        };
        Thread t = new Thread(r);
        t.start();
        progress.setVisible(true);
    }

    public void importRunning() {
        this._importAllButton.setEnabled(false);
        this._tableModel.setColEnabled(false, 1);
        this._mapFieldsButton.setEnabled(false);
        this._replaceExistingCheckBox.setEnabled(false);
        for (int ii = 0; ii < this._menuBar.getMenuCount(); ++ii) {
            JMenu menu = this._menuBar.getMenu(ii);
            menu.setEnabled(false);
        }
        this._windowListener.preventClose();
    }

    public void importDone() {
        this._importAllButton.setEnabled(true);
        this._tableModel.setColEnabled(true, 1);
        this._mapFieldsButton.setEnabled(true);
        this._replaceExistingCheckBox.setEnabled(true);
        for (int ii = 0; ii < this._menuBar.getMenuCount(); ++ii) {
            JMenu menu = this._menuBar.getMenu(ii);
            menu.setEnabled(true);
        }
        this._windowListener.allowClose();
        this.setVisible(false);
        JOptionPane.showMessageDialog((Component)((Object)this), "Impact Areas imported successfully!");
    }

    public void selectAllImport() {
        this._model.setImportAll(true);
    }

    public void clearAllImport() {
        this._model.setImportAll(false);
    }

    public boolean closeDialog() {
        this._model.clearHighlights(true);
        this.setVisible(false);
        return true;
    }

    private void setImpactAreaDataList(CommonDataList impactAreaDataList) {
        this._impactAreaDataList = impactAreaDataList;
        this._tableModel.setImpactAreaDataList(impactAreaDataList);
    }

    private void setStreamAlignmentGlyph(StreamAlignmentGlyph glyph) {
        this._streamAlignmentGlyph = glyph;
        this._tableModel.setStreamAlignmentGlyph(glyph);
    }

    private void setStudySystemGlyph(StudySystemMapGlyph glyph) {
        this._studySystemGlyph = glyph;
        this._tableModel.setStudySystemGlyph(glyph);
    }

    protected void setShapeSource(ShapeSource source) {
        super.setShapeSource(source);
        if (this._tableModel == null) {
            return;
        }
        List fieldDescriptors = this._selectedSource != null ? this._selectedSource.getFieldDescriptors() : new ArrayList();
        this.setTitle("Import Impact Areas");
        Vector<String> additionalObjectAttributes = new Vector<String>();
        additionalObjectAttributes.add("Description");
        additionalObjectAttributes.add("Color");
        additionalObjectAttributes.add("Stream Name");
        additionalObjectAttributes.add("Beginning stream station");
        additionalObjectAttributes.add("Ending stream station");
        additionalObjectAttributes.add("Index stream station");
        additionalObjectAttributes.add("Stream bank");
        FieldMapModel fieldModel = new FieldMapModel(additionalObjectAttributes, fieldDescriptors, ImpactAreaToShapefile.getDefaultAttrToFieldMap(), "Impact Area");
        this._tableModel.setFieldMapModel(fieldModel);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int[] rows = this._table.getSelectedRows();
        this._model.rowSelected(rows);
    }

    public void setVisible(boolean b) {
        if (b) {
            this._model.fillModel();
        }
        super.setVisible(b);
    }

    protected ShapeImportTableModel createTableModel(RmaJTable table) {
        this._tableModel = new ShapeImpactAreaTableModel(this._table);
        return this._tableModel;
    }

    protected String getTypeString() {
        return "Impact Areas";
    }

    public static void main(String[] args) {
        ShapeImpactAreaDialog dlg = new ShapeImpactAreaDialog(null, Collections.EMPTY_LIST, null, null, null, null, null);
        dlg.setModal(true);
        dlg.setLocation(250, 250);
        dlg.setVisible(true);
    }
}

