/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.map.impactArea;

import hec.appInterface.AppDaddy;
import hec.clientapp.map.impactArea.ImpactAreaShapeImport;
import hec.map.WorldPt;
import hec.map.WorldRegion;
import hec.map.aishape.AiShapeFieldDescriptor;
import hec.map.aishape.Attribute;
import hec.map.aishape.Field;
import hec.map.aishape.FieldMapModel;
import hec.map.aishape.ShapeImport;
import hec.map.aishape.ShapeImportProgressIndicator;
import hec.map.aishape.ShapeImportTableModel;
import hec.map.appInterface.MapApplicationFrame;
import hec.map.importer.ImportObject;
import hec.map.importer.ImportShapeTableModel;
import hec.map.streamAlignment.StreamAlignmentGlyph;
import hec.map.streamAlignment.StreamAlignmentIfc;
import hec.model.CommonDataList;
import hec.model.StreamElement;
import hec.watershed.client.StudySystemMapGlyph;
import hec.watershed.model.ImpactArea;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.swing.SwingWorker;
import rma.swing.RmaJTable;
import rma.util.RMAIO;

public class ShapeImpactAreaTableModel
extends ShapeImportTableModel
implements ImportShapeTableModel {
    public static final int STREAM_COLUMN = 2;
    StudySystemMapGlyph _studySystemGlyph;
    CommonDataList _impactAreaDataList;
    HashSet _extraImportColumns = new HashSet();
    FieldMapModel _fieldMapModel;

    public ShapeImpactAreaTableModel(RmaJTable table) {
        super(table);
    }

    public boolean importShapes() {
        return this.importShapes(null);
    }

    public boolean importShapes(ShapeImportProgressIndicator progress) {
        MapApplicationFrame frame;
        this.clearHighlights(true);
        List shapeImportNames = this.getShapeImportNames();
        int size = shapeImportNames.size();
        if (this.getReplaceExisting()) {
            if (progress != null) {
                progress.setMax(size + 1);
                progress.incrementProgress("Removing current Impact Areas.");
            }
            this._impactAreaDataList.removeAll();
        } else if (progress != null) {
            progress.setMax(size);
        }
        for (int ii = 0; ii < size; ++ii) {
            StreamElement reach;
            double val;
            Color color;
            WorldRegion region;
            List shapes;
            String impactAreaName = (String)shapeImportNames.get(ii);
            ImpactAreaShapeImport shapeImport = (ImpactAreaShapeImport)this.getShapeImport(impactAreaName);
            if (!shapeImport.getImportShapes()) continue;
            if (progress != null) {
                progress.incrementProgress("Importing Impact Area: " + impactAreaName);
            }
            if ((shapes = shapeImport.getShapes()).size() < 1) continue;
            String name = shapeImport.getName();
            String description = "";
            ImportObject shape = (ImportObject)shapes.get(0);
            Attribute attr = shape.getAttribute();
            Field field = this.getField("Description", attr);
            if (field != null) {
                description = field.toString();
            }
            if ((region = shapeImport.getRegion()) == null) continue;
            ImpactArea impactArea = this._studySystemGlyph.createArea(name, description, region);
            field = this.getField("Color", attr);
            if (field != null && (color = RMAIO.parseColorString((String)field.toString())) != null) {
                impactArea.setColor(color);
            }
            if ((field = this.getField("Beginning stream station", attr)) != null && (val = RMAIO.parseDouble((String)field.toString(), (double)Double.NEGATIVE_INFINITY)) != Double.NEGATIVE_INFINITY) {
                impactArea.setAutoBeginStation(false);
                impactArea.setBeginStation(val);
            }
            if ((field = this.getField("Ending stream station", attr)) != null && (val = RMAIO.parseDouble((String)field.toString(), (double)Double.NEGATIVE_INFINITY)) != Double.NEGATIVE_INFINITY) {
                impactArea.setAutoEndStation(false);
                impactArea.setEndStation(val);
            }
            if ((field = this.getField("Index stream station", attr)) != null && (val = RMAIO.parseDouble((String)field.toString(), (double)Double.NEGATIVE_INFINITY)) != Double.NEGATIVE_INFINITY) {
                impactArea.setAutoIndexStation(false);
                impactArea.setIndexStation(val);
            }
            if ((field = this.getField("Stream bank", attr)) != null) {
                int val2 = ImpactArea.getBankConstant(field.toString());
                impactArea.setAutoBank(false);
                impactArea.setBank(val2);
            }
            field = this.getField("Stream Name", attr);
            if (shapeImport.getStreamElement() != null) {
                StreamElement elem = shapeImport.getStreamElement();
                impactArea.setStreamId(elem.getIndex());
                continue;
            }
            if (field == null) continue;
            String streamName = field.toString();
            if (this._streamAlignmentGlyph == null || (reach = this._streamAlignmentGlyph.findReach(streamName)) == null) continue;
            int streamId = reach.getIndex();
            impactArea.setAutoStream(false);
            impactArea.setStreamId(streamId);
        }
        if (progress != null) {
            progress.done();
        }
        if ((frame = (MapApplicationFrame)AppDaddy.getFrame()) != null && frame.getMapPanel() != null) {
            frame.getMapPanel().paintMap();
        }
        this.fillModel();
        return true;
    }

    private Field getField(Object key, Attribute attr) {
        AiShapeFieldDescriptor fd = this._fieldMapModel.getFieldDescriptor(key);
        if (fd == null) {
            return null;
        }
        int idx = this._shapeSource.getFieldDescriptors().indexOf(fd);
        Field field = attr.getField(idx);
        return field;
    }

    public void setFieldMapModel(FieldMapModel model) {
        this._fieldMapModel = model;
    }

    public FieldMapModel getFieldMapModel() {
        return this._fieldMapModel;
    }

    public ShapeImport buildShapeImport(String shapeName) {
        return new ImpactAreaShapeImport(shapeName);
    }

    public void checkExistance(ShapeImport shapeImport) {
        String impactAreaName = shapeImport.getName();
        ImpactArea ia = (ImpactArea)this._impactAreaDataList.getObject(impactAreaName);
        if (ia != null) {
            shapeImport.addExistsError();
        } else {
            shapeImport.removeExistsError();
        }
    }

    public void setImpactAreaDataList(CommonDataList impactAreaDataList) {
        this._impactAreaDataList = impactAreaDataList;
    }

    public void setStudySystemGlyph(StudySystemMapGlyph glyph) {
        this._studySystemGlyph = glyph;
    }

    public void setStreamAlignmentGlyph(StreamAlignmentGlyph glyph) {
        super.setStreamAlignmentGlyph(glyph);
    }

    public int getColumnCount() {
        return 3;
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex == 1) {
            return Boolean.class;
        }
        return Object.class;
    }

    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 2: {
                return "Stream Element";
            }
        }
        return super.getColumnName(columnIndex);
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 2) {
            if (aValue == null) {
                return;
            }
            String shapeName = (String)this._shapeImportNames.get(rowIndex);
            ShapeImport shapeImport = (ShapeImport)this._shapeImportHash.get(shapeName);
            if (shapeImport instanceof ImpactAreaShapeImport && aValue instanceof StreamElement) {
                StreamElement elem = (StreamElement)aValue;
                ImpactAreaShapeImport impactAreaShape = (ImpactAreaShapeImport)shapeImport;
                impactAreaShape.setStreamElement(elem);
                this.fireTableCellUpdated(rowIndex, columnIndex);
            }
            return;
        }
        super.setValueAt(aValue, rowIndex, columnIndex);
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 2) {
            String shapeName = (String)this._shapeImportNames.get(rowIndex);
            ShapeImport shapeImport = (ShapeImport)this._shapeImportHash.get(shapeName);
            if (shapeImport instanceof ImpactAreaShapeImport) {
                ImpactAreaShapeImport impactAreaShape = (ImpactAreaShapeImport)shapeImport;
                return impactAreaShape.getStreamElement();
            }
            return null;
        }
        return super.getValueAt(rowIndex, columnIndex);
    }

    public void fireTableStructureChanged() {
        super.fireTableStructureChanged();
        StreamAlignmentIfc alignment = null;
        if (this._streamAlignmentGlyph != null) {
            alignment = (StreamAlignmentIfc)this._streamAlignmentGlyph.getMap();
            Vector elements = alignment.getElementVector();
            this._table.setComboBoxEditor(2, elements);
        }
        if (alignment != null) {
            final StreamAlignmentIfc fAlignment = alignment;
            SwingWorker worker = new SwingWorker(){

                public Void doInBackground() {
                    int rowCnt = ShapeImpactAreaTableModel.this.getRowCount();
                    for (int r = 0; r < rowCnt; ++r) {
                        ImpactAreaShapeImport impactAreaShape;
                        WorldRegion region;
                        StreamElement stream;
                        String shapeName = (String)ShapeImpactAreaTableModel.this._shapeImportNames.get(r);
                        ShapeImport shapeImport = (ShapeImport)ShapeImpactAreaTableModel.this._shapeImportHash.get(shapeName);
                        if (!(shapeImport instanceof ImpactAreaShapeImport) || (stream = ShapeImpactAreaTableModel.this.findNearestReach(region = (impactAreaShape = (ImpactAreaShapeImport)shapeImport).getRegion(), fAlignment)) == null) continue;
                        ArrayList<StreamEntry> l = new ArrayList<StreamEntry>(1);
                        l.add(new StreamEntry(stream, r));
                        this.publish(l);
                    }
                    return null;
                }

                public void process(List list) {
                    if (list == null || list.size() == 0) {
                        return;
                    }
                    for (int i = 0; i < list.size(); ++i) {
                        Object object = list.get(i);
                        if (object instanceof List) {
                            List ll = (List)object;
                            for (int l = 0; l < ll.size(); ++l) {
                                object = ll.get(l);
                                if (!(object instanceof StreamEntry)) continue;
                                StreamEntry entry = (StreamEntry)object;
                                ShapeImpactAreaTableModel.this.setValueAt(entry.stream, entry.row, 2);
                            }
                            continue;
                        }
                        if (!(object instanceof StreamEntry)) continue;
                        StreamEntry entry = (StreamEntry)object;
                        ShapeImpactAreaTableModel.this.setValueAt(entry.stream, entry.row, 2);
                    }
                }
            };
            worker.execute();
        }
    }

    private StreamElement findNearestReach(WorldRegion region, StreamAlignmentIfc alignment) {
        int size = region.pts.size();
        double closest = Double.MAX_VALUE;
        double[] dist = new double[1];
        Object closestReach = null;
        WorldPt wptBest = new WorldPt();
        WorldPt center = region.getCenterPt();
        StreamElement reach = alignment.findNearestReach(center, wptBest, dist);
        return reach;
    }

    static class StreamEntry {
        StreamElement stream;
        int row;

        StreamEntry(StreamElement element, int r) {
            this.stream = element;
            this.row = r;
        }
    }
}

