/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.map.raster.dbf;

import hec.appInterface.AppDaddy;
import hec.appInterface.FileOpener;
import hec.io.HecFile;
import hec.io.Identifier;
import hec.io.dbf.DBFHeader;
import hec.map.MapObject;
import hec.map.MapObjectFactory;
import hec.watershed.map.raster.dbf.RasterDbfMap;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import mil.army.usace.hec.rmi.client.RmiFileChooserField;
import mil.army.usace.hec.rmi.client.RmiFileDialog;
import mil.army.usace.hec.rmi.io.dbf.DbfFile;
import mil.army.usace.hec.rmi.io.dbf.DbfIdentifier;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDialog;
import rma.swing.event.ReflectMultiListener;
import rma.util.RMAIO;
import rma.util.RMASort;

public class CreateRasterDbf
extends RmaJDialog
implements DocumentListener {
    String _mapFilePath;
    RmiFileChooserField _rasterFilenameTextField;
    RmaJComboBox _rasterCellSizeUnitsComboBox;
    RmiFileChooserField _dbfFilenameTextField;
    RmaJComboBox _dbfIdFieldComboBox;
    RmaJComboBox _dbfDescFieldComboBox;
    Frame _parent;
    ReflectMultiListener _listener = new ReflectMultiListener();
    RasterDbfMap _map;
    public static final String BASE_TITLE = "Raster Dbf Editor";

    public CreateRasterDbf(Frame parent, boolean modal) {
        super(parent, modal);
        this._parent = parent;
        this.setDefaultSize(600, 225);
        this.setLocation(50, 50);
        this.setTitle(BASE_TITLE);
        this.buildComponents();
        this.buildMenus();
        this._rasterFilenameTextField.setDefaultPath(AppDaddy.getWorkspace().getWorkspacePath() + "/maps");
        Vector<String> smrmpFilters = new Vector<String>(1);
        smrmpFilters.add("*.smrmp");
        smrmpFilters.add("*.asc");
        this._rasterFilenameTextField.setFilters(smrmpFilters);
        this._dbfFilenameTextField.setDefaultPath(AppDaddy.getWorkspace().getWorkspacePath() + "/maps");
        Vector<String> dbfFilters = new Vector<String>(1);
        dbfFilters.add("*.dbf");
        this._dbfFilenameTextField.setFilters(dbfFilters);
        this._dbfFilenameTextField.getDocument().addDocumentListener(this);
    }

    private void buildComponents() {
        this.getContentPane().setLayout(new GridBagLayout());
        JLabel label = new JLabel("Raster Map:");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = RmaInsets.INSETS5555;
        gbc.anchor = 17;
        this.getContentPane().add((Component)label, gbc);
        this._rasterFilenameTextField = new RmiFileChooserField();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.insets = RmaInsets.INSETS5555;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        this.getContentPane().add((Component)this._rasterFilenameTextField, gbc);
        label = new JLabel("Raster Map Cell Size Units:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = RmaInsets.INSETS5555;
        gbc.anchor = 17;
        this.getContentPane().add((Component)label, gbc);
        this._rasterCellSizeUnitsComboBox = new RmaJComboBox((Object[])RasterDbfMap.VALID_CELL_SIZE_UNITS);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.insets = RmaInsets.INSETS5555;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        this.getContentPane().add((Component)this._rasterCellSizeUnitsComboBox, gbc);
        label = new JLabel("DBF File:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.insets = RmaInsets.INSETS5555;
        gbc.anchor = 17;
        this.getContentPane().add((Component)label, gbc);
        this._dbfFilenameTextField = new RmiFileChooserField();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.insets = RmaInsets.INSETS5555;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        this.getContentPane().add((Component)this._dbfFilenameTextField, gbc);
        label = new JLabel("DBF ID Field:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.insets = RmaInsets.INSETS5555;
        gbc.anchor = 18;
        this.getContentPane().add((Component)label, gbc);
        this._dbfIdFieldComboBox = new RmaJComboBox();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.insets = RmaInsets.INSETS5555;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        this.getContentPane().add((Component)this._dbfIdFieldComboBox, gbc);
        label = new JLabel("DBF Desc Field (optional):");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.insets = RmaInsets.INSETS5555;
        gbc.anchor = 18;
        this.getContentPane().add((Component)label, gbc);
        this._dbfDescFieldComboBox = new RmaJComboBox();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 5;
        gbc.insets = RmaInsets.INSETS5555;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        this.getContentPane().add((Component)this._dbfDescFieldComboBox, gbc);
    }

    private void buildMenus() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.setMnemonic('F');
        menuBar.add(menu);
        JMenuItem menuItem = new JMenuItem("New", 78);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2, false));
        menuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)menuItem, "newMap"));
        menu.add(menuItem);
        menuItem = new JMenuItem("Open", 79);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2, false));
        menuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)menuItem, "openMap"));
        menu.add(menuItem);
        menuItem = new JMenuItem("Save", 83);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2, false));
        menuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)menuItem, "saveMap"));
        menu.add(menuItem);
        menuItem = new JMenuItem("Save As", 65);
        menuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)menuItem, "saveAsMap"));
        menu.add(menuItem);
        menuItem = new JMenuItem("Exit", 88);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(81, 2, false));
        menuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)menuItem, "exit"));
        menu.add(menuItem);
        this.setJMenuBar(menuBar);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.fillDbfFields();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.fillDbfFields();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.fillDbfFields();
    }

    protected void fillDbfFields() {
        try {
            String filepath = this._dbfFilenameTextField.getText();
            if (!filepath.endsWith(".dbf")) {
                this._dbfIdFieldComboBox.setModel(new DefaultComboBoxModel());
                this._dbfDescFieldComboBox.setModel(new DefaultComboBoxModel());
                return;
            }
            DbfIdentifier requestId = new DbfIdentifier(filepath);
            DbfIdentifier dbfId = (DbfIdentifier)AppDaddy.getWorkspace().openFile((Identifier)requestId, false);
            DbfFile dbfFile = dbfId.getDbfFile();
            DBFHeader dbfHeader = dbfFile.getHeader();
            List fieldDescriptors = dbfHeader.getFieldDescriptors();
            Vector<String> fieldNames = new Vector<String>(fieldDescriptors.size() + 1);
            for (int ii = 0; ii < fieldDescriptors.size(); ++ii) {
                fieldNames.add(fieldDescriptors.get(ii).toString());
            }
            RMASort.quickSort(fieldNames);
            if (!fieldNames.get(0).toString().trim().equals("")) {
                fieldNames.add(0, "");
            }
            this._dbfIdFieldComboBox.setModel(new DefaultComboBoxModel(fieldNames));
            this._dbfDescFieldComboBox.setModel(new DefaultComboBoxModel(fieldNames));
        }
        catch (Exception e) {
            System.out.println("Error populating DBF Fields. " + e);
        }
    }

    public void newMap() {
        this._mapFilePath = null;
        this.setTitle(BASE_TITLE);
        this._rasterFilenameTextField.setText("");
        this._rasterCellSizeUnitsComboBox.setSelectedIndex(0);
        this._dbfFilenameTextField.setText("");
        this._dbfIdFieldComboBox.setModel(new DefaultComboBoxModel());
        this._dbfDescFieldComboBox.setModel(new DefaultComboBoxModel());
    }

    public void openMap() {
        Identifier openFileId;
        String startDir = AppDaddy.getWorkspace().getWorkspacePath() + "/maps";
        Vector<String> fileMask = new Vector<String>(1);
        fileMask.add("*.rdbf");
        RmiFileDialog dialog = new RmiFileDialog((Dialog)((Object)this), true, startDir, fileMask);
        dialog.setOpenTitle();
        dialog.setVisible(true);
        if (dialog.isCanceled()) {
            return;
        }
        Identifier requestId = dialog.getIdentifier();
        if (requestId != null && (openFileId = AppDaddy.getWorkspace().openFile(requestId, false)) != null) {
            String dbfDescFieldName;
            MapObject obj = MapObjectFactory.newMapObject((FileOpener)AppDaddy.getWorkspace(), (Identifier)openFileId);
            if (!(obj instanceof RasterDbfMap)) {
                return;
            }
            RasterDbfMap map = (RasterDbfMap)obj;
            try {
                map.loadHeader();
            }
            catch (Exception e) {
                System.out.println("Exception loading map header. " + e);
                return;
            }
            this._mapFilePath = openFileId.getPath();
            this.setTitle("Raster Dbf Editor - " + this._mapFilePath);
            this._rasterFilenameTextField.setText(map.getRasterMapPath());
            this._rasterCellSizeUnitsComboBox.setSelectedItem((Object)map.getCellSizeUnits());
            this._dbfFilenameTextField.setText(map.getDbfPath());
            String dbfIdFieldName = map.getDbfIdFieldName();
            if (dbfIdFieldName != null) {
                this._dbfIdFieldComboBox.setSelectedItem((Object)dbfIdFieldName);
            }
            if ((dbfDescFieldName = map.getDbfDescFieldName()) != null) {
                this._dbfDescFieldComboBox.setSelectedItem((Object)dbfDescFieldName);
            }
        }
    }

    protected boolean isDataValid() {
        String rasterFilePath = this._rasterFilenameTextField.getText();
        if (rasterFilePath == null || rasterFilePath.trim().length() == 0) {
            RMAIO.postError((Component)((Object)this), (String)"Raster Map is not defined.");
            return false;
        }
        if (!rasterFilePath.endsWith(".smrmp") && !rasterFilePath.endsWith(".asc")) {
            RMAIO.postError((Component)((Object)this), (String)"Raster Map does not end with the extension, '.smrmp'.");
            return false;
        }
        String dbfFilePath = this._dbfFilenameTextField.getText();
        if (dbfFilePath == null || dbfFilePath.trim().length() == 0) {
            RMAIO.postError((Component)((Object)this), (String)"DBF file is not defined.");
            return false;
        }
        if (!dbfFilePath.endsWith(".dbf")) {
            RMAIO.postError((Component)((Object)this), (String)"DBF file does not end with the extension, '.dbf'.");
            return false;
        }
        Object dbfIdField = this._dbfIdFieldComboBox.getSelectedItem();
        if (dbfIdField == null || dbfIdField.toString().trim().length() == 0) {
            RMAIO.postError((Component)((Object)this), (String)"DBF ID field is not defined.");
            return false;
        }
        return true;
    }

    public boolean saveMap() {
        if (!this.isDataValid()) {
            return false;
        }
        if (this._mapFilePath == null || this._mapFilePath.trim().length() == 0) {
            return this.saveAsMap();
        }
        Identifier requestId = new Identifier(this._mapFilePath);
        Identifier openId = AppDaddy.getWorkspace().openFile(requestId, false);
        return this.saveMap(openId);
    }

    protected boolean saveMap(Identifier fileId) {
        HecFile mapFile = fileId.getFile();
        String rasterFilePath = this._rasterFilenameTextField.getText();
        String dbfFilePath = this._dbfFilenameTextField.getText();
        String dbfIdFieldName = this._dbfIdFieldComboBox.getSelectedItem().toString();
        Object dbfDescField = this._dbfDescFieldComboBox.getSelectedItem();
        String dbfDescFieldName = null;
        String cellSizeUnits = this._rasterCellSizeUnitsComboBox.getSelectedItem().toString();
        if (dbfDescField != null) {
            dbfDescFieldName = dbfDescField.toString();
        }
        try {
            RasterDbfMap.createFile((FileOpener)AppDaddy.getWorkspace(), mapFile, rasterFilePath, cellSizeUnits, dbfFilePath, dbfIdFieldName, dbfDescFieldName);
        }
        catch (Exception e) {
            System.out.println("Error saving map. " + e);
            return false;
        }
        return true;
    }

    public boolean saveAsMap() {
        Identifier fileId;
        if (!this.isDataValid()) {
            return false;
        }
        String startDir = AppDaddy.getWorkspace().getWorkspacePath() + "/maps";
        Vector<String> fileMask = new Vector<String>(1);
        fileMask.add("*.rdbf");
        RmiFileDialog dialog = new RmiFileDialog((Dialog)((Object)this), true, startDir, fileMask);
        dialog.setSaveTitle();
        dialog.setVisible(true);
        if (dialog.isCanceled()) {
            return false;
        }
        Identifier requestId = dialog.getIdentifier();
        if (!requestId.getPath().endsWith(".rdbf")) {
            requestId.setPath(requestId.getPath() + ".rdbf");
        }
        if ((fileId = AppDaddy.getWorkspace().openFile(requestId, false)) == null) {
            fileId = AppDaddy.getWorkspace().createFile(requestId);
        }
        if (this.saveMap(fileId)) {
            this._mapFilePath = fileId.getPath();
            this.setTitle("Raster Dbf Editor - " + this._mapFilePath);
            return true;
        }
        return false;
    }

    public void exit() {
        this.setVisible(false);
    }

    public static void runStaticTest() {
        Frame frame = new Frame();
        frame.setLocation(100, 100);
        CreateRasterDbf dialog = new CreateRasterDbf(frame, true);
        dialog.pack();
        dialog.setVisible(true);
    }
}

