/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.map.raster.dbf;

import hec.map.ElevationGlyph;
import hec.map.ElevationGlyphDataRecord;
import hec.map.GlyphDataRecord;
import hec.map.LocalRegion;
import hec.map.MapGlyph;
import hec.map.MapObjectInterface;
import hec.map.MapPanel;
import hec.map.MapScale;
import hec.map.WorldPt;
import hec.map.raster.RasterGlyph;
import hec.watershed.map.raster.dbf.RasterDbfGlyphDataRecord;
import hec.watershed.map.raster.dbf.RasterDbfMap;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.io.Serializable;
import java.util.Observable;
import java.util.Observer;

public class RasterDbfGlyph
extends MapGlyph
implements Serializable,
ImageObserver,
ElevationGlyph,
Observer {
    private RasterGlyph _glyph = null;
    private transient boolean _init = false;

    public RasterDbfGlyph() {
        this._glyph = new RasterGlyph();
    }

    public RasterDbfGlyph(MapPanel panel, RasterDbfMap map) {
        this._glyph = new RasterGlyph(panel, map.getRasterMap());
        this.setMapPanel(panel);
        this.setMap(map);
    }

    public void setDataRecord(GlyphDataRecord rec) {
        super.setDataRecord(rec);
        if (this._glyph != null) {
            this._glyph.setDataRecord(rec);
        }
    }

    protected void init() {
        ElevationGlyphDataRecord gdr = (ElevationGlyphDataRecord)this.getDataRecord();
        if (gdr == null) {
            gdr = (ElevationGlyphDataRecord)this.getDefaultDataRecord();
            this.setDataRecord((GlyphDataRecord)gdr);
        }
        if (!gdr.getSet()) {
            gdr.setGlyph((ElevationGlyph)this._glyph);
            this._init = true;
        }
    }

    public GlyphDataRecord getDefaultDataRecord() {
        RasterDbfGlyphDataRecord gdr = new RasterDbfGlyphDataRecord();
        return gdr;
    }

    public void fillMap(boolean load) {
        super.fillMap(load);
        if (load) {
            if (this._glyph.getMap() == null || this._glyph.getMapPanel() == null) {
                RasterDbfMap map = (RasterDbfMap)this._map;
                this._glyph.setMap((MapObjectInterface)map.getRasterMap());
                this._glyph.setMapPanel(this.getMapPanel());
                this._glyph.setDataRecord(this.getDataRecord());
            }
            this._glyph.fillMap(load);
            if (!this._init) {
                this.init();
            }
        }
    }

    public double getElevation(WorldPt pt) {
        if (this._glyph == null) {
            return Double.NEGATIVE_INFINITY;
        }
        return this._glyph.getElevation(pt);
    }

    public double getMaximumElevation() {
        if (this._glyph == null) {
            return Double.NEGATIVE_INFINITY;
        }
        return this._glyph.getMaximumElevation();
    }

    public double getMinimumElevation() {
        if (this._glyph == null) {
            return Double.NEGATIVE_INFINITY;
        }
        return this._glyph.getMinimumElevation();
    }

    @Override
    public void update(Observable o, Object arg) {
    }

    public void draw(Graphics g, MapScale scl) {
        this._glyph.draw(g, scl);
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        return false;
    }

    public double getNoDataValue() {
        return Double.NEGATIVE_INFINITY;
    }

    public float getElevationAt(int ix, int iy) {
        if (this._glyph == null) {
            return Float.NEGATIVE_INFINITY;
        }
        return this._glyph.getElevationAt(ix, iy);
    }

    public void drawElevationStats(Graphics g, LocalRegion region) {
    }
}

