/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.model;

import hec.io.AsciiSerializable;
import hec.map.WorldLine;
import hec.map.WorldLineHolder;
import hec.model.DataObject;
import hec.watershed.model.ComputationPoint;
import hec.watershed.model.ComputationPointHolder;
import hec.watershed.model.Project;
import java.awt.Color;
import java.io.Serializable;
import java.lang.reflect.Field;

public class ChannelMod
extends Project
implements Serializable,
AsciiSerializable,
ComputationPointHolder,
WorldLineHolder {
    static final long serialVersionUID = 7454408268313094748L;
    public static final String MENU_NAME = "Channel Modification";
    private int _startStreamElementIndex;
    private int _endStreamElementIndex;
    private double _startStation;
    private double _endStation;
    private long _upstreamCompPtId = -1L;
    private long _downstreamCompPtId = -1L;
    private transient ComputationPoint _upstreamCompPt;
    private transient ComputationPoint _downstreamCompPt;
    transient WorldLine _line = new WorldLine();

    public int getStartStreamElementIndex() {
        return this._startStreamElementIndex;
    }

    public int getEndStreamElementIndex() {
        return this._endStreamElementIndex;
    }

    public double getStartStation() {
        return this._startStation;
    }

    public double getEndStation() {
        return this._endStation;
    }

    public void setStartStreamElementIndex(int index) {
        this._startStreamElementIndex = index;
    }

    public void setEndStreamElementIndex(int index) {
        this._endStreamElementIndex = index;
    }

    public void setStartStation(double station) {
        this._startStation = station;
        this.setModified(true);
    }

    public void setEndStation(double station) {
        this._endStation = station;
        this.setModified(true);
    }

    public WorldLine getLine() {
        return this._line;
    }

    public void setLine(WorldLine line) {
        this._line = line;
    }

    @Override
    public String getUserDisplayedType() {
        return "Channel Mod";
    }

    @Override
    public String getLabelName() {
        return MENU_NAME;
    }

    @Override
    public void removeFromComputationPoint() {
        this.removeFromComputationPoint(true);
        this.removeFromComputationPoint(false);
    }

    public void removeFromComputationPoint(boolean upstream) {
        ComputationPoint cp = this.getComputationPoint(upstream);
        if (cp != null) {
            cp.removeProject((DataObject)this);
            if (upstream) {
                this._upstreamCompPt = null;
                this._upstreamCompPtId = -1L;
            } else {
                this._downstreamCompPt = null;
                this._downstreamCompPtId = -1L;
            }
        }
    }

    public ComputationPoint getComputationPoint(boolean upstream) {
        if (upstream) {
            if (this._upstreamCompPt == null && this._upstreamCompPtId != -1L) {
                this._upstreamCompPt = (ComputationPoint)this.getDataList().findObjectById(this._upstreamCompPtId, "hec.watershed.model.ComputationPoint");
            }
            return this._upstreamCompPt;
        }
        if (this._downstreamCompPt == null && this._downstreamCompPtId != -1L) {
            this._downstreamCompPt = (ComputationPoint)this.getDataList().findObjectById(this._downstreamCompPtId, "hec.watershed.model.ComputationPoint");
        }
        return this._downstreamCompPt;
    }

    @Override
    public void updateComputationPoint() {
    }

    public boolean loadData() {
        if (!this._loaded || this._outOfDateData) {
            Object obj = this._dataList.loadObject((DataObject)this);
            if (obj instanceof ChannelMod) {
                this.copyInto((ChannelMod)obj);
            }
            if (super.loadData()) {
                this._loaded = true;
            }
            this.setModified(false);
        }
        return this._loaded;
    }

    public void copyInto(ChannelMod cm) {
        if (cm == null) {
            return;
        }
        super.copyInto((DataObject)cm);
        this._startStreamElementIndex = cm._startStreamElementIndex;
        this._endStreamElementIndex = cm._endStreamElementIndex;
        this._startStation = cm._startStation;
        this._endStation = cm._endStation;
        this._upstreamCompPtId = cm._upstreamCompPtId;
        this._downstreamCompPtId = cm._downstreamCompPtId;
    }

    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return super.getFieldObject(fld);
        }
    }

    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return super.setFieldObject(fld, fobj);
        }
        catch (IllegalArgumentException e) {
            return super.setFieldObject(fld, fobj);
        }
    }

    public WorldLine getLine(int idx) {
        return this.getLine();
    }

    public Color getLineColor(int idx) {
        return Color.CYAN;
    }

    public int getLineCount() {
        return 1;
    }

    public String getLineDescription(int idx) {
        return this.getDescription();
    }

    public String getLineName(int idx) {
        return this.getName();
    }

    public int getStreamIndex() {
        return this.getStartStreamElementIndex();
    }

    public void setStreamIndex(int idx) {
        this.setStartStreamElementIndex(idx);
    }
}

