/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.model;

import hec.event.DataChangeEvent;
import hec.event.LockEvent;
import hec.io.AsciiSerializable;
import hec.map.WorldPt;
import hec.model.AbstractDataObject;
import hec.model.CommonDataList;
import hec.model.DataObject;
import hec.model.DataStruct;
import hec.model.StreamElement;
import hec.model.StreamReferenceHolder;
import hec.watershed.model.ComputationPointHolder;
import hec.watershed.model.ProjectRef;
import hec.watershed.model.Reservoir;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Vector;

public class ComputationPoint
extends AbstractDataObject
implements Serializable,
AsciiSerializable,
StreamReferenceHolder {
    static final long serialVersionUID = -763259830188385436L;
    public static final String MENU_NAME = "Computation Point";
    public static final String DEFAULT_NAME = "CP";
    private String _locationId;
    private boolean _snapToStream = false;
    private int _streamId = -1;
    private String _streamName;
    private double _streamStation;
    private double _streamCoord = Double.NEGATIVE_INFINITY;
    private WorldPt _refPt = new WorldPt();
    private boolean _autoGenerated = false;
    private Vector _projectRefs = new Vector();
    private transient Vector _projects = new Vector();
    private int _labelPosition = 0;
    private int _junctionId = -1;

    public void setLabelPosition(int loc) {
        this._labelPosition = loc;
    }

    public void setLocation(String locationId) {
        this._locationId = locationId;
        this.setModified(true);
    }

    public void setSnapToStream(boolean b) {
        this._snapToStream = b;
        this.setModified(true);
    }

    public void setStreamId(int id) {
        this._streamId = id;
        this.setModified(true);
    }

    public void setStreamName(String streamName) {
        this._streamName = streamName;
        this.setModified(true);
    }

    public void setAutoGenerated(boolean b) {
        this._autoGenerated = b;
        this.setModified(true);
    }

    public boolean isAutoGenerated() {
        return this._autoGenerated;
    }

    public void setStreamStation(double station) {
        this._streamStation = station;
        this.setModified(true);
    }

    public void setStreamCoord(double coord) {
        this._streamCoord = coord;
        this.setModified(true);
    }

    public double getStreamCoord() {
        return this._streamCoord;
    }

    public void setReferencePt(WorldPt pt) {
        if (pt == null) {
            this._refPt.init(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        } else {
            this._refPt.init(pt);
        }
        this.setModified(true);
    }

    public int getLabelPosition() {
        return this._labelPosition;
    }

    public String getLocation() {
        return this._locationId;
    }

    public boolean getSnapToStream() {
        return this._snapToStream;
    }

    public int getStreamId() {
        return this._streamId;
    }

    public String getStreamName() {
        return this._streamName;
    }

    public StreamElement getStream() {
        return null;
    }

    public double getStreamStation() {
        return this._streamStation;
    }

    public WorldPt getReferencePt() {
        return this._refPt;
    }

    public void updateProjects() {
        Vector projects = this.getProjects();
        if (projects.size() == 0) {
            return;
        }
        for (int i = 0; i < projects.size(); ++i) {
            DataObject dobj = (DataObject)projects.get(i);
            if (dobj == null || !(dobj instanceof ComputationPointHolder)) continue;
            ComputationPointHolder cph = (ComputationPointHolder)dobj;
            cph.computationPointMoved(this);
        }
    }

    public Vector getProjectsRefs() {
        return this._projectRefs;
    }

    public boolean hasReservoirProject() {
        Vector v = this.getProjects();
        for (int i = 0; i < v.size(); ++i) {
            if (!(v.get(i) instanceof Reservoir)) continue;
            return true;
        }
        return false;
    }

    public Vector getProjects() {
        int size = this._projectRefs.size();
        Vector<DataObject> projs = new Vector<DataObject>(size);
        if (this._projects.size() != size) {
            ProjectRef ref;
            for (int i = 0; i < size; ++i) {
                CommonDataList dl;
                ref = (ProjectRef)this._projectRefs.elementAt(i);
                if (ref == null || (dl = this.getDataList().getCommonDataListContainer().getCommonDataList(ref.getProjectType())) == null) continue;
                DataObject proj = dl.getObject(ref.getProjectId());
                if (proj == null) {
                    ref.needsRemoved = true;
                    continue;
                }
                projs.add(proj);
            }
            this._projects.addAll(projs);
            boolean needToSave = false;
            for (int i = size - 1; i >= 0; --i) {
                ref = (ProjectRef)this._projectRefs.elementAt(i);
                if (!ref.needsRemoved) continue;
                this._projectRefs.removeElementAt(i);
                needToSave = true;
            }
            if (needToSave) {
                this.setModified(true);
            }
        }
        return this._projects;
    }

    public void removeProject(DataObject dobj) {
        if (dobj == null) {
            return;
        }
        System.out.println(this.getName() + " removing object " + dobj.getName());
        int size = this._projectRefs.size();
        String type = dobj.getClass().getName();
        for (int i = 0; i < size; ++i) {
            ProjectRef ref = (ProjectRef)this._projectRefs.elementAt(i);
            if (ref == null || ref.getProjectId() != dobj.getId() || !ref.getProjectType().equals(type)) continue;
            this._projectRefs.removeElementAt(i);
            System.out.println(this.getName() + " removed projects left " + this._projectRefs.size());
            this._projects.clear();
            this.setModified(true);
            return;
        }
    }

    public int numProjects() {
        return this._projectRefs.size();
    }

    public boolean addProject(DataObject obj) {
        if (obj == null) {
            return false;
        }
        ProjectRef ref = new ProjectRef(obj, obj.getClass().getName(), "");
        if (this.findProjectRef(obj) == null) {
            this._projectRefs.add(ref);
            this._projects.clear();
            this.setModified(true);
            return true;
        }
        return false;
    }

    public ProjectRef findProjectRef(DataObject dobj) {
        if (dobj == null) {
            return null;
        }
        int size = this._projectRefs.size();
        String type = dobj.getClass().getName();
        for (int i = 0; i < size; ++i) {
            ProjectRef ref = (ProjectRef)this._projectRefs.elementAt(i);
            if (ref == null || ref.getProjectId() != dobj.getId() || !ref.getProjectType().equals(type)) continue;
            return ref;
        }
        return null;
    }

    public String toString() {
        return this.getName();
    }

    public void copyInto(DataObject dobj) {
    }

    public boolean loadData() {
        if (!this._loaded || this._outOfDateData) {
            Object obj = this._dataList.loadObject((DataObject)this);
            if (obj instanceof ComputationPoint) {
                this.copyInto((ComputationPoint)obj);
            }
            if (super.loadData()) {
                this._loaded = true;
            }
            this._projects = new Vector();
            this.setModified(false);
        }
        return this._loaded;
    }

    public void copyInto(ComputationPoint cp) {
        if (cp == null) {
            return;
        }
        super.copyInto((DataObject)cp);
        this.setName(cp.getName());
        this.setDescription(cp.getDescription());
        this._locationId = cp._locationId;
        this._snapToStream = cp._snapToStream;
        this._streamId = cp._streamId;
        this._streamName = cp._streamName;
        this._streamStation = cp._streamStation;
        if (cp._refPt != null) {
            this._refPt.init(cp._refPt);
        }
        this._autoGenerated = cp._autoGenerated;
        this._projectRefs = (Vector)cp._projectRefs.clone();
        this.setModified(false);
    }

    public void copyInto(DataStruct dstruct) {
    }

    public void DataChanged(DataChangeEvent evt) {
    }

    public void locked(LockEvent evt) {
    }

    public boolean loadId() {
        return true;
    }

    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return super.getFieldObject(fld);
        }
    }

    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return super.setFieldObject(fld, fobj);
        }
        catch (IllegalArgumentException e) {
            return super.setFieldObject(fld, fobj);
        }
    }

    public int getStreamIndex() {
        return this._streamId;
    }

    public void setStreamIndex(int idx) {
        this._streamId = idx;
    }

    public void setJunctionIndex(int index) {
        this._junctionId = index;
    }

    public int getJunctionIndex() {
        return this._junctionId;
    }
}

