/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.model;

import hec.appInterface.AppDaddy;
import hec.clientapp.model.DataListContainer;
import hec.clientapp.rmi.csinterface.RmiDataList;
import hec.map.LocalPt;
import hec.map.MapScale;
import hec.map.WorldPointHolder;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.aishape.AiShapeFieldDescriptor;
import hec.map.aishape.Field;
import hec.map.appInterface.MapApplicationFrame;
import hec.map.crs.CoordinateReferenceSystem;
import hec.map.streamAlignment.StreamAlignmentIfc;
import hec.model.DataListLoader;
import hec.model.DataObject;
import hec.model.StreamElement;
import hec.watershed.model.ComputationPoint;
import hec.watershed.model.ComputationPointContainer;
import hec.watershed.model.ComputationPointHolder;
import hec.watershed.model.WatershedDataList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

public class ComputationPointDataList
extends WatershedDataList
implements ComputationPointContainer,
WorldPointHolder {
    StreamAlignmentIfc _alignment;
    private AiShapeFieldDescriptor _nameDescriptor;
    private AiShapeFieldDescriptor _descDescriptor;
    private AiShapeFieldDescriptor _colorDescriptor;

    public ComputationPointDataList(RmiDataList rd, DataListContainer parent, String objClass) {
        super(rd, parent, objClass);
    }

    @Override
    public boolean init() {
        if (this._initd) {
            return true;
        }
        super.init();
        return true;
    }

    @Override
    public WorldPt getLocationForComputationPoint(ComputationPoint cp) {
        if (cp == null) {
            return new WorldPt();
        }
        StreamAlignmentIfc alignment = this.getAlignment();
        if (alignment == null) {
            return new WorldPt();
        }
        StreamElement elem = alignment.findReach(cp.getStreamId());
        if (elem == null) {
            return new WorldPt();
        }
        return elem.getLocationByStation(cp.getStreamStation());
    }

    public double getStationForComputationPoint(ComputationPoint cp) {
        if (cp == null) {
            return Double.NEGATIVE_INFINITY;
        }
        StreamAlignmentIfc alignment = this.getAlignment();
        if (alignment == null) {
            return Double.NEGATIVE_INFINITY;
        }
        StreamElement elem = alignment.findReach(cp.getStreamId());
        if (elem == null) {
            return Double.NEGATIVE_INFINITY;
        }
        return elem.getStationByLocation(cp.getReferencePt());
    }

    @Override
    public ComputationPoint getComputationPointAt(WorldPt wpt, double tol) {
        if (wpt == null) {
            return null;
        }
        MapApplicationFrame frame = (MapApplicationFrame)AppDaddy.getFrame();
        MapScale scale = frame.getMapPanel().scale();
        LocalPt lpt = scale.wp2lp(wpt);
        tol = scale.x2e((int)((double)lpt.x + tol)) - scale.x2e(lpt.x);
        WorldRect rc = new WorldRect(wpt.e - tol, wpt.n + tol, wpt.e + tol, wpt.n - tol);
        Enumeration e = this._objects.elements();
        ComputationPoint cp = null;
        ComputationPoint closestCp = null;
        double closestDist = Double.MAX_VALUE;
        while (e.hasMoreElements()) {
            double dist;
            WorldPt pt;
            cp = (ComputationPoint)e.nextElement();
            if (cp == null || !rc.contains(pt = cp.getReferencePt()) || !((dist = wpt.distToPoint(pt)) < closestDist)) continue;
            closestDist = dist;
            closestCp = cp;
        }
        return closestCp;
    }

    @Override
    public ComputationPoint getComputationPointAt(int streamId, double streamStation, double tol) {
        StreamAlignmentIfc alignment = this.getAlignment();
        if (alignment == null) {
            return null;
        }
        StreamElement elem = alignment.findReach(streamId);
        if (elem == null) {
            return null;
        }
        return this.getComputationPointAt(elem.getLocationByStation(streamStation), tol);
    }

    public void cleanComputationPoints() {
        Enumeration e = this._objects.elements();
        Vector<ComputationPoint> removeObjs = new Vector<ComputationPoint>();
        while (e.hasMoreElements()) {
            ComputationPoint cp = (ComputationPoint)e.nextElement();
            if (cp == null || cp.numProjects() != 0 || !cp.isAutoGenerated()) continue;
            removeObjs.add(cp);
        }
        for (int i = 0; i < removeObjs.size(); ++i) {
            this.removeObject(((ComputationPoint)removeObjs.elementAt(i)).getId());
        }
    }

    private StreamAlignmentIfc getAlignment() {
        if (this._alignment == null) {
            this._alignment = DataListLoader.getDataListLoader().getStreamAlignment();
        }
        return this._alignment;
    }

    @Override
    public boolean removeObject(long objId) {
        ComputationPoint cpt = (ComputationPoint)this.getObject(objId);
        if (cpt != null) {
            Vector projects = cpt.getProjects();
            for (int i = 0; i < projects.size(); ++i) {
                Object obj = projects.get(i);
                if (!(obj instanceof ComputationPointHolder)) continue;
                ((ComputationPointHolder)obj).computationPointDeleted(cpt);
            }
            return super.removeObject(objId);
        }
        return false;
    }

    public void projectRemoved(DataObject obj) {
        if (obj == null) {
            return;
        }
        DataObject[] cpArray = this.getObjects();
        for (int i = 0; i < cpArray.length; ++i) {
            ComputationPoint cp = (ComputationPoint)cpArray[i];
            if (!cp.getProjects().contains(obj)) continue;
            cp.removeProject(obj);
            if (cp.getProjects().size() != 0 || !cp.isAutoGenerated()) continue;
            cp.setAutoGenerated(false);
        }
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        System.out.println("getCoordinateReferenceSystem TODO implement me");
        return null;
    }

    public List<AiShapeFieldDescriptor> getFieldDescriptors() {
        ArrayList<AiShapeFieldDescriptor> fieldDesc = new ArrayList<AiShapeFieldDescriptor>();
        this._nameDescriptor = new AiShapeFieldDescriptor("ID_NAME", 'C', 32, 0);
        this._descDescriptor = new AiShapeFieldDescriptor("DESC", 'C', 50, 0);
        this._colorDescriptor = new AiShapeFieldDescriptor("COLOR", 'C', 32, 0);
        fieldDesc.add(this._nameDescriptor);
        fieldDesc.add(this._descDescriptor);
        fieldDesc.add(this._colorDescriptor);
        return fieldDesc;
    }

    public List<Field> getFields(int index) {
        ArrayList<Field> fields = new ArrayList<Field>();
        if (this._nameDescriptor == null) {
            this.getFieldDescriptors();
        }
        ComputationPoint cp = (ComputationPoint)this.getObjects()[index];
        fields.add(new Field((Object)cp.getName(), this._nameDescriptor, index + 1));
        fields.add(new Field((Object)cp.getDescription(), this._descDescriptor, index + 1));
        String s = "Black";
        fields.add(new Field((Object)s, this._colorDescriptor, index + 1));
        return fields;
    }

    public WorldPt getPointAt(int index) {
        ComputationPoint cp = (ComputationPoint)this.getObjects()[index];
        return cp.getReferencePt();
    }

    public int getPointCount() {
        return this.getObjectCount();
    }
}

