/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.model;

import hec.event.LockEvent;
import hec.gfx2d.Symbol;
import hec.model.AbstractDataObject;
import hec.model.CommonDataList;
import hec.model.DataObject;
import hec.model.DataStruct;
import hec.watershed.model.ComputationPoint;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;

public class ComputationPointLayer
extends AbstractDataObject {
    private List<Long> _compPtIds = new ArrayList<Long>();
    private List<Long> _subLayerIds = new ArrayList<Long>();
    private transient List<ComputationPoint> _compPts = new ArrayList<ComputationPoint>();
    private transient List<ComputationPointLayer> _subLayers = new ArrayList<ComputationPointLayer>();
    private Color _bgColor;
    private Color _fgColor = Color.BLACK;
    private int _symbolNum = 1;
    private int _symbolSize = 7;
    private boolean _defaultLayer;

    public ComputationPointLayer() {
        this._bgColor = Color.BLACK;
    }

    public List<ComputationPoint> getCompPts() {
        this.loadComputationPoints();
        return this._compPts;
    }

    private void loadComputationPoints() {
        CommonDataList cpdl = this.getCommonDataListContainer().getCommonDataList(ComputationPoint.class.getName());
        if (this._compPts != null) {
            this._compPts.clear();
        } else {
            this._compPts = new ArrayList<ComputationPoint>();
        }
        if (this.isDefaultLayer()) {
            DataStruct[] objs = cpdl.getObjectArray();
            for (int i = 0; i < objs.length; ++i) {
                this._compPts.add((ComputationPoint)objs[i]);
            }
            return;
        }
        Iterator<Long> iter = this._compPtIds.iterator();
        while (iter.hasNext()) {
            ComputationPoint cp = (ComputationPoint)cpdl.getObject(iter.next().longValue());
            if (cp == null) {
                iter.remove();
                continue;
            }
            this._compPts.add(cp);
        }
    }

    public void setCompPts(List<ComputationPoint> compPts) {
        if (this.isDefaultLayer()) {
            return;
        }
        this._compPts.clear();
        this._compPtIds.clear();
        if (compPts == null || compPts.size() == 0) {
            this.setModified(true);
            return;
        }
        for (int i = 0; i < compPts.size(); ++i) {
            ComputationPoint cp = compPts.get(i);
            this._compPtIds.add(cp.getId());
            this._compPts.add(cp);
        }
        this.setModified(true);
    }

    public List<ComputationPointLayer> getSubLayers() {
        this.loadSubLayers();
        return this._subLayers;
    }

    private void loadSubLayers() {
        this._subLayers.clear();
        CommonDataList cpldl = this.getDataList();
        Iterator<Long> iter = this._subLayerIds.iterator();
        while (iter.hasNext()) {
            ComputationPointLayer cpl = (ComputationPointLayer)cpldl.getObject(iter.next().longValue());
            if (cpl == null) {
                iter.remove();
                continue;
            }
            this._subLayers.add(cpl);
        }
    }

    public void setSubLayers(List<ComputationPointLayer> subLayers) {
        if (this.isDefaultLayer()) {
            return;
        }
        this._subLayers.clear();
        this._subLayerIds.clear();
        if (subLayers == null || subLayers.size() == 0) {
            this.setModified(true);
            return;
        }
        for (int i = 0; i < subLayers.size(); ++i) {
            ComputationPointLayer cpl = subLayers.get(i);
            this._subLayerIds.add(cpl.getId());
            this._subLayers.add(cpl);
        }
        this.setModified(true);
    }

    public Color getForegroundColor() {
        return this._fgColor;
    }

    public void setBackgroundColor(Color color) {
        this._bgColor = color;
    }

    public Color getBackgroundColor() {
        return this._bgColor;
    }

    public void setForegroundColor(Color color) {
        this._fgColor = color;
    }

    public int getSymbolNum() {
        return this._symbolNum;
    }

    public void setSymbolNum(int symbolNum) {
        this._symbolNum = symbolNum;
    }

    public int getSymbolSize() {
        return this._symbolSize;
    }

    public void setSymbolSize(int size) {
        this._symbolSize = size;
    }

    public void copyInto(ComputationPointLayer cpl) {
        if (cpl == null) {
            return;
        }
        super.copyInto((DataObject)cpl);
        this._defaultLayer = cpl._defaultLayer;
        this._fgColor = cpl._bgColor;
        this._bgColor = cpl._fgColor;
        this._symbolNum = cpl._symbolNum;
        this._symbolSize = cpl._symbolSize;
        this._compPtIds.clear();
        this._compPts.clear();
        this._compPtIds.addAll(cpl._compPtIds);
        this._subLayerIds.clear();
        this._subLayers.clear();
        this._subLayerIds.addAll(cpl._subLayerIds);
        this.loadComputationPoints();
        this.loadSubLayers();
        this.setModified(false);
    }

    public void locked(LockEvent le) {
    }

    public void copyInto(DataStruct dsObj) {
    }

    public void setIsDefaultLayer(boolean defaultLayer) {
        this._defaultLayer = defaultLayer;
        DataStruct[] objs = this.getDataList().getObjectArray();
        for (int i = 0; i < objs.length; ++i) {
            if (objs[i] == this) continue;
            ((ComputationPointLayer)objs[i]).setIsDefaultLayer(false);
        }
    }

    public boolean isDefaultLayer() {
        return this._defaultLayer;
    }

    public boolean contains(ComputationPoint cp) {
        if (cp == null) {
            return false;
        }
        if (this.isDefaultLayer()) {
            return true;
        }
        long id = cp.getId();
        int idx = this._compPtIds.indexOf(id);
        return idx != -1;
    }

    public void addComputationPoint(ComputationPoint cpt) {
        if (cpt == null) {
            return;
        }
        long id = cpt.getId();
        if (this._compPtIds.contains(id)) {
            return;
        }
        this._compPtIds.add(id);
        this._compPts.clear();
        this.setModified(true);
    }

    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get((Object)this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return super.getFieldObject(fld);
        }
    }

    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set((Object)this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return super.setFieldObject(fld, fobj);
        }
        catch (IllegalArgumentException e) {
            return super.setFieldObject(fld, fobj);
        }
    }

    public Icon getIcon() {
        return this.getIcon(18);
    }

    public Icon getIcon(final int height) {
        Icon icon = new Icon(){

            @Override
            public int getIconHeight() {
                return height;
            }

            @Override
            public int getIconWidth() {
                return height;
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                int size = Math.min(ComputationPointLayer.this._symbolSize, this.getIconHeight() - 1);
                int half = this.getIconHeight() / 2;
                Dimension d = c.getSize();
                int width = 15;
                int height2 = d.height / 2;
                Symbol.draw((Graphics)g, (int)9, (int)height2, (int)ComputationPointLayer.this._symbolNum, (Color)ComputationPointLayer.this._bgColor, (Color)ComputationPointLayer.this._fgColor, (float)size);
            }
        };
        return icon;
    }
}

