/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.model;

import hec.clientapp.model.DataListContainer;
import hec.clientapp.rmi.csinterface.RmiDataList;
import hec.model.DataObject;
import hec.model.DataObjectProxy;
import hec.watershed.model.ComputationPoint;
import hec.watershed.model.ComputationPointLayer;
import hec.watershed.model.ComputationPointLayerContainer;
import hec.watershed.model.DefaultDataList;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class ComputationPointLayerDataList
extends DefaultDataList
implements ComputationPointLayerContainer {
    private static final String DEFAULT_NAME = "Default";
    private boolean _initing;

    public ComputationPointLayerDataList(RmiDataList rd, DataListContainer parent, String objClass) {
        super(rd, parent, objClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean init() {
        if (this._initd || this._initing) {
            return true;
        }
        this._initing = true;
        try {
            Object[] objs;
            try {
                objs = this._rmiDataList.getObjects();
                this._shown = this._rmiDataList.isShown();
            }
            catch (RemoteException re) {
                System.out.println("ComputationPointLayerDataList.init(): remoteException getting my list of objects " + re);
                boolean bl = false;
                this._initing = false;
                return bl;
            }
            boolean haveDefaultLayer = false;
            if (objs != null) {
                long id = 0L;
                for (int ii = 0; ii < objs.length; ++ii) {
                    DataObject obj;
                    if (objs[ii] instanceof DataObjectProxy) {
                        try {
                            id = ((DataObjectProxy)objs[ii]).id;
                            obj = this._rmiDataList.getObject(id);
                            if (((ComputationPointLayer)obj).isDefaultLayer()) {
                                haveDefaultLayer = true;
                            }
                            this.addDataObject(obj);
                        }
                        catch (RemoteException re) {
                            System.out.println(this._objClass + ".init: rmi error getting id " + id);
                        }
                        continue;
                    }
                    obj = (DataObject)objs[ii];
                    if (((ComputationPointLayer)obj).isDefaultLayer()) {
                        haveDefaultLayer = true;
                    }
                    this.addDataObject((DataObject)objs[ii]);
                }
                if (!haveDefaultLayer) {
                    this.createDefaultLayer();
                }
            }
            this.register();
            this._initd = true;
            boolean bl = true;
            return bl;
        }
        finally {
            this._initing = false;
        }
    }

    private void createDefaultLayer() {
        String name = DEFAULT_NAME;
        String desc = "Default Layer";
        System.out.println("creating default layer " + name);
        ComputationPointLayer layer = (ComputationPointLayer)this.newDataObject(name, desc);
        layer.setIsDefaultLayer(true);
        this.addNewObject((DataObject)layer);
    }

    @Override
    public List<ComputationPointLayer> getLayersForComputationPoint(ComputationPoint ccp) {
        ArrayList<ComputationPointLayer> layers = new ArrayList<ComputationPointLayer>();
        if (ccp == null) {
            return layers;
        }
        DataObject[] objs = this.getObjects();
        for (int i = 0; i < objs.length; ++i) {
            if (!((ComputationPointLayer)objs[i]).contains(ccp)) continue;
            layers.add((ComputationPointLayer)objs[i]);
        }
        return layers;
    }

    @Override
    public List<ComputationPointLayer> getCompPointLayers(boolean includeDefault) {
        DataObject[] objs = this.getObjects();
        ArrayList<ComputationPointLayer> layers = new ArrayList<ComputationPointLayer>();
        ComputationPointLayer defaultLayer = null;
        for (int i = 0; i < objs.length; ++i) {
            ComputationPointLayer layer = (ComputationPointLayer)objs[i];
            if (layer.isDefaultLayer()) {
                if (!includeDefault) continue;
                defaultLayer = layer;
                continue;
            }
            layers.add(layer);
        }
        if (defaultLayer != null) {
            layers.add(0, defaultLayer);
        }
        return layers;
    }

    @Override
    public ComputationPointLayer getDefaultLayer() {
        DataObject[] objs = this.getObjects();
        for (int i = 0; i < objs.length; ++i) {
            ComputationPointLayer layer = (ComputationPointLayer)objs[i];
            if (!layer.isDefaultLayer()) continue;
            return layer;
        }
        return null;
    }
}

