/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.model;

import hec.event.DataChangeEvent;
import hec.event.LockEvent;
import hec.io.AsciiSerializable;
import hec.lang.LongContainer;
import hec.lang.ModelReference;
import hec.map.streamAlignment.StreamAlignmentIfc;
import hec.model.AbstractDataObject;
import hec.model.CommonDataList;
import hec.model.DataList;
import hec.model.DataObject;
import hec.model.DataObjectProxy;
import hec.model.DataStruct;
import hec.watershed.event.ConditionEvent;
import hec.watershed.event.ConditionListener;
import hec.watershed.model.ConditionNotesRef;
import hec.watershed.model.Project;
import hec.watershed.model.ProjectRef;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Condition
extends AbstractDataObject
implements Serializable,
AsciiSerializable {
    static final long serialVersionUID = 8949730299769260728L;
    public static final String STUDY_CONDITION_NAME = "Study";
    public static final String LAND_USE = "Land Use Layer";
    public static final String CENSUS = "Census Layer";
    public static final String TERRAIN = "Terrain Layer";
    public static final String INUNDATION = "Inundation Layer";
    private Vector _projectRefs = new Vector();
    private transient Vector _projects;
    private Vector _landUseLayers = new Vector();
    private Vector _censusLayers = new Vector();
    private Vector _terrainLayers = new Vector();
    private Vector _inundationLayers = new Vector();
    private Hashtable _conditionNotes = new Hashtable();
    private transient LongContainer _key;
    private transient Vector _conditionListenerList;
    private String _conditionDate;
    private Hashtable _modelAlts = new Hashtable();
    private transient StreamAlignmentIfc _streamAlignment;
    private String _streamAlignmentName;

    public Condition() {
        this._key = new LongContainer();
        this._conditionListenerList = new Vector();
        this._projects = new Vector();
    }

    public String getConditionNotes(long impactAreaId) {
        this._key._value = impactAreaId;
        ConditionNotesRef ref = (ConditionNotesRef)this._conditionNotes.get(this._key);
        if (ref == null) {
            return "";
        }
        return ref.getNotes();
    }

    public boolean getDisplaysSymbol(long impactAreaId) {
        this._key._value = impactAreaId;
        ConditionNotesRef ref = (ConditionNotesRef)this._conditionNotes.get(this._key);
        if (ref == null) {
            return false;
        }
        return ref.getDisplaySymbol();
    }

    public void removeConditionNotes(int impactAreaId) {
        this._key._value = impactAreaId;
        this._conditionNotes.remove(this._key);
        this.setModified(true);
    }

    public void setConditionNotes(long impactAreaId, String notes) {
        LongContainer key = new LongContainer(impactAreaId);
        ConditionNotesRef ref = (ConditionNotesRef)this._conditionNotes.get(key);
        if (ref == null) {
            ref = new ConditionNotesRef(impactAreaId, false, notes);
            this._conditionNotes.put(key, ref);
        } else {
            ref.setNotes(notes);
        }
        this.setModified(true);
    }

    public void setDisplaysSymbol(long impactAreaId, boolean displaysSymbol) {
        LongContainer key = new LongContainer(impactAreaId);
        ConditionNotesRef ref = (ConditionNotesRef)this._conditionNotes.get(key);
        if (ref == null) {
            ref = new ConditionNotesRef(impactAreaId, displaysSymbol, "");
            this._conditionNotes.put(key, ref);
        } else {
            ref.setDisplaySymbol(displaysSymbol);
        }
        this.setModified(true);
    }

    public Vector getProjects(String type) {
        ProjectRef ref;
        int size = this._projectRefs.size();
        Vector<Object> projs = new Vector<Object>(size);
        if (this.isStudyCondition()) {
            CommonDataList dl = this.getDataList().getCommonDataListContainer().getCommonDataList(type);
            if (dl == null) {
                return projs;
            }
            DataStruct[] objs = dl.getObjectArray();
            for (int o = 0; o < objs.length; ++o) {
                if (objs[o] == null) continue;
                projs.add(objs[o]);
            }
            return projs;
        }
        for (int i = 0; i < size; ++i) {
            CommonDataList dl;
            ref = (ProjectRef)this._projectRefs.elementAt(i);
            if (ref == null || !ref.getProjectType().equals(type) || (dl = this.getDataList().getCommonDataListContainer().getCommonDataList(ref.getProjectType())) == null) continue;
            Project proj = (Project)dl.getObject(ref.getProjectId());
            if (proj == null) {
                ref.needsRemoved = true;
                continue;
            }
            projs.add(proj);
        }
        boolean needToSave = false;
        for (int i = size - 1; i >= 0; --i) {
            ref = (ProjectRef)this._projectRefs.elementAt(i);
            if (!ref.needsRemoved) continue;
            this._projectRefs.removeElementAt(i);
            needToSave = true;
        }
        if (needToSave) {
            this.setModified(true);
        }
        return projs;
    }

    public Vector getProjects() {
        int size = this._projectRefs.size();
        Vector<Object> projs = new Vector<Object>(size);
        if (this.isStudyCondition()) {
            String[] projTypes = Project.KNOWN_PROJECT_TYPES;
            for (int i = 0; i < projTypes.length; ++i) {
                CommonDataList dl = this.getDataList().getCommonDataListContainer().getCommonDataList(projTypes[i]);
                if (dl == null) continue;
                DataStruct[] objs = dl.getObjectArray();
                for (int o = 0; o < objs.length; ++o) {
                    if (objs[o] == null) continue;
                    projs.add(objs[o]);
                }
            }
            return projs;
        }
        if (this._projects.size() != this._projectRefs.size()) {
            ProjectRef ref;
            for (int i = 0; i < size; ++i) {
                CommonDataList dl;
                ref = (ProjectRef)this._projectRefs.elementAt(i);
                if (ref == null || (dl = this.getDataList().getCommonDataListContainer().getCommonDataList(ref.getProjectType())) == null) continue;
                Project proj = (Project)dl.getObject(ref.getProjectId());
                if (proj == null) {
                    ref.needsRemoved = true;
                    continue;
                }
                projs.add(proj);
            }
            this._projects.addAll(projs);
            boolean needToSave = false;
            for (int i = size - 1; i >= 0; --i) {
                ref = (ProjectRef)this._projectRefs.elementAt(i);
                if (!ref.needsRemoved) continue;
                this._projectRefs.removeElementAt(i);
                needToSave = true;
            }
            if (needToSave) {
                this.setModified(true);
            }
        }
        return this._projects;
    }

    public Vector getProjectRefs() {
        if (this.isStudyCondition()) {
            Vector<ProjectRef> projs = new Vector<ProjectRef>();
            String[] projTypes = Project.KNOWN_PROJECT_TYPES;
            for (int i = 0; i < projTypes.length; ++i) {
                DataList dl = ((DataList)this.getDataList()).getDataListContainer().getDataList(projTypes[i]);
                if (dl == null) continue;
                DataObject[] objs = dl.getObjects();
                for (int o = 0; o < objs.length; ++o) {
                    if (objs[o] == null) continue;
                    projs.add(new ProjectRef((Project)objs[o], ""));
                }
            }
            return projs;
        }
        return this._projectRefs;
    }

    public void setProjects(Vector projs) {
        int size = projs.size();
        Vector<ProjectRef> v = new Vector<ProjectRef>(size);
        if (this._projects != null) {
            this._projects.clear();
        } else {
            this._projects = new Vector();
        }
        for (int i = 0; i < size; ++i) {
            Object obj = projs.elementAt(i);
            if (!(obj instanceof Project)) continue;
            Project p = (Project)obj;
            ProjectRef ref = this.findProjectRef(p);
            if (ref == null) {
                ref = new ProjectRef(p, "");
            }
            v.addElement(ref);
        }
        this._projectRefs = v;
        this.setModified(true);
    }

    public ProjectRef addProject(Project proj, String notes) {
        if (proj == null) {
            return null;
        }
        this._projects.clear();
        if (this.isStudyCondition()) {
            this.setModified(true);
            this.fireProjectAdded(proj);
            return null;
        }
        if (this.findProjectRef(proj) == null) {
            ProjectRef ref = new ProjectRef(proj, notes);
            this._projectRefs.addElement(ref);
            System.out.println(this.getName() + ".addProject: added " + proj);
            this.setModified(true);
            this.fireProjectAdded(proj);
            return ref;
        }
        return null;
    }

    public boolean removeProject(Project proj) {
        if (proj == null) {
            return false;
        }
        int size = this._projectRefs.size();
        this._projects.clear();
        if (this.isStudyCondition()) {
            this.fireProjectRemoved(proj);
            return true;
        }
        for (int i = 0; i < size; ++i) {
            ProjectRef ref = (ProjectRef)this._projectRefs.elementAt(i);
            if (ref == null || ref.getProjectId() != proj.getId() || !ref.getProjectType().equals(proj.getType())) continue;
            this._projectRefs.removeElementAt(i);
            this.fireProjectRemoved(proj);
            this.setModified(true);
            return true;
        }
        return false;
    }

    public boolean hasProject(Project proj) {
        if (proj == null) {
            return false;
        }
        if (this.isStudyCondition()) {
            return true;
        }
        return this.findProjectRef(proj) != null;
    }

    public ProjectRef findProjectRef(Project proj) {
        if (proj == null) {
            return null;
        }
        int size = this._projectRefs.size();
        for (int i = 0; i < size; ++i) {
            ProjectRef ref = (ProjectRef)this._projectRefs.elementAt(i);
            if (ref == null || ref.getProjectId() != proj.getId() || !ref.getProjectType().equals(proj.getType())) continue;
            return ref;
        }
        return null;
    }

    public String getConditionDate() {
        return this._conditionDate;
    }

    public void setConditionDate(String dt) {
        this._conditionDate = dt;
    }

    public void copyInto(DataObject dobj) {
    }

    public boolean loadData() {
        if (!this._loaded || this._outOfDateData) {
            Object obj = this._dataList.loadObject((DataObject)this);
            if (obj instanceof Condition) {
                this.copyInto((Condition)obj);
            }
            if (super.loadData()) {
                this._loaded = true;
            }
            this.setModified(false);
            this._key = new LongContainer();
            this._conditionListenerList = new Vector();
            this._projects = new Vector();
        }
        return this._loaded;
    }

    public void copyInto(Condition cond) {
        if (cond == null) {
            return;
        }
        this.setName(cond.getName());
        this.setDescription(cond.getDescription());
        this._projectRefs = (Vector)cond._projectRefs.clone();
        this._landUseLayers = (Vector)cond._landUseLayers.clone();
        this._censusLayers = (Vector)cond._censusLayers.clone();
        this._terrainLayers = (Vector)cond._terrainLayers.clone();
        this._inundationLayers = (Vector)cond._inundationLayers.clone();
        this._conditionNotes = (Hashtable)cond._conditionNotes.clone();
        this._conditionDate = cond._conditionDate;
    }

    public void copyInto(DataStruct dstruct) {
        if (dstruct instanceof DataObjectProxy) {
            System.out.println("");
        }
    }

    public void DataChanged(DataChangeEvent evt) {
    }

    public void locked(LockEvent evt) {
    }

    public boolean loadId() {
        return true;
    }

    public String toString() {
        return this.getName();
    }

    public Vector getGISLayers(String layerName) {
        if (layerName == null || layerName.length() < 1) {
            return null;
        }
        if (layerName.equalsIgnoreCase(LAND_USE)) {
            return this._landUseLayers;
        }
        if (layerName.equalsIgnoreCase(CENSUS)) {
            return this._censusLayers;
        }
        if (layerName.equalsIgnoreCase(TERRAIN)) {
            return this._terrainLayers;
        }
        if (layerName.equalsIgnoreCase(INUNDATION)) {
            return this._inundationLayers;
        }
        return null;
    }

    public void setGISLayers(String layerName, Vector layers) {
        if (layerName == null || layerName.length() < 1) {
            return;
        }
        if (layerName.equalsIgnoreCase(LAND_USE)) {
            this._landUseLayers = (Vector)layers.clone();
        } else if (layerName.equalsIgnoreCase(CENSUS)) {
            this._censusLayers = (Vector)layers.clone();
        } else if (layerName.equalsIgnoreCase(TERRAIN)) {
            this._terrainLayers = (Vector)layers.clone();
        } else if (layerName.equalsIgnoreCase(INUNDATION)) {
            this._inundationLayers = (Vector)layers.clone();
        } else {
            return;
        }
        this.setModified(true);
    }

    public boolean isStudyCondition() {
        return this.getName().equals(STUDY_CONDITION_NAME);
    }

    public void addConditionListener(ConditionListener cl) {
        if (cl == null) {
            return;
        }
        this._conditionListenerList.add(cl);
    }

    public void removeConditionListener(ConditionListener cl) {
        if (cl == null) {
            return;
        }
        this._conditionListenerList.remove(cl);
    }

    public void fireProjectAdded(Project proj) {
        this.fireProjectListChanged(proj, 0);
    }

    public void fireProjectRemoved(Project proj) {
        this.fireProjectListChanged(proj, 1);
    }

    private void fireProjectListChanged(Project proj, int eventType) {
        ConditionEvent e = null;
        int size = this._conditionListenerList.size();
        for (int i = size - 1; i >= 0; --i) {
            ConditionListener cl = (ConditionListener)this._conditionListenerList.get(i);
            if (e == null) {
                e = new ConditionEvent(this, proj, eventType);
            }
            cl.conditionChanged(e);
        }
    }

    public Object getModelAlt(int modelType, int modelAltId) {
        if (modelType == -1 || modelAltId == -1) {
            return null;
        }
        Vector v = this.getModelAlts(modelType);
        if (v == null || v.size() < 1) {
            return null;
        }
        int size = v.size();
        for (int i = 0; i < size; ++i) {
            ModelReference mr = (ModelReference)v.get(i);
            if (mr == null || mr.id != modelAltId) continue;
            return mr;
        }
        return null;
    }

    public Vector getModelAlts(int modelType) {
        if (modelType == -1) {
            return null;
        }
        Object obj = this._modelAlts.get(new Integer(modelType));
        if (obj instanceof Vector) {
            return (Vector)obj;
        }
        return null;
    }

    public void addModelAlt(int modelType, ModelReference ref) {
        if (ref == null || modelType < 0) {
            return;
        }
        Integer i = new Integer(modelType);
        Vector<ModelReference> v = (Vector<ModelReference>)this._modelAlts.get(i);
        if (v == null) {
            v = new Vector<ModelReference>(1);
        }
        if (!v.contains(ref)) {
            v.add(ref);
        }
        this._modelAlts.put(i, v);
    }

    public void setModelAlts(int modelType, Vector v) {
        if (modelType == -1) {
            return;
        }
        this._modelAlts.put(new Integer(modelType), v);
        this.setModified(true);
    }

    public Vector getModels() {
        int size = this._modelAlts.size();
        Vector v = new Vector(size);
        Enumeration e = this._modelAlts.keys();
        while (e.hasMoreElements()) {
            v.add(e.nextElement());
        }
        return v;
    }

    public String getStreamAlignmentName() {
        return this._streamAlignmentName;
    }

    public void setStreamAlignment(StreamAlignmentIfc alignment) {
        this._streamAlignment = alignment;
    }

    public StreamAlignmentIfc getStreamAlignment() {
        return this._streamAlignment;
    }

    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return super.getFieldObject(fld);
        }
    }

    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return super.setFieldObject(fld, fobj);
        }
        catch (IllegalArgumentException e) {
            return super.setFieldObject(fld, fobj);
        }
    }
}

