/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.model;

import hec.clientapp.model.DataListContainer;
import hec.clientapp.rmi.csinterface.RmiDataList;
import hec.lang.UserId;
import hec.model.DataObject;
import hec.model.DataObjectProxy;
import hec.watershed.WatershedRmiDataList;
import hec.watershed.model.Condition;
import hec.watershed.model.ConditionContainer;
import hec.watershed.model.DefaultDataList;
import hec.watershed.model.Project;
import hec.watershed.model.Study;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class ConditionDataList
extends DefaultDataList
implements ConditionContainer {
    private Condition _currentCondition;

    public ConditionDataList(RmiDataList rd, DataListContainer parent, String objClass) {
        super(rd, parent, objClass);
    }

    @Override
    public boolean init() {
        this.register();
        return true;
    }

    public boolean init(Study s) {
        Object[] objs;
        if (s == null) {
            this._objects.clear();
            this._initd = false;
            return true;
        }
        if (this._initd) {
            return true;
        }
        try {
            objs = ((WatershedRmiDataList)this._rmiDataList).getObjects(s.getId());
            this._shown = this._rmiDataList.isShown();
        }
        catch (RemoteException re) {
            System.out.println("WatershedDataList.init(" + s + "): remoteException getting my list of objects " + re);
            return false;
        }
        if (objs != null) {
            long id = 0L;
            for (int ii = 0; ii < objs.length; ++ii) {
                if (objs[ii] instanceof DataObjectProxy) {
                    try {
                        id = ((DataObjectProxy)objs[ii]).id;
                        DataObject obj = this._rmiDataList.getObject(id);
                        this.addDataObject(obj);
                    }
                    catch (RemoteException re) {
                        System.out.println(this._objClass + ".init: rmi error getting id " + id);
                    }
                    continue;
                }
                this.addDataObject((DataObject)objs[ii]);
            }
        }
        this._initd = true;
        if (this._initd) {
            if (this._objects.size() == 0 || this.getObject("Study") == null) {
                this.createStudyCondition();
            } else {
                this.setModified(false);
            }
        }
        return this._initd;
    }

    @Override
    public Condition getStudyCondition() {
        return (Condition)this.getObject("Study");
    }

    @Override
    public Condition getCurrentCondition() {
        if (this._currentCondition == null) {
            return this.getStudyCondition();
        }
        return this._currentCondition;
    }

    @Override
    public void setCurrentCondition(Condition condition) {
        this._currentCondition = condition;
    }

    private void createStudyCondition() {
        Condition c = (Condition)this.newDataObject("Study", "Study Condition");
        this.addNewObject((DataObject)c);
        this.saveAll(UserId.getUserId());
    }

    @Override
    public void deleteProject(Project proj) {
        DataObject[] objs = this.getObjects();
        for (int i = 0; i < objs.length; ++i) {
            Condition c = (Condition)objs[i];
            if (c == null) continue;
            c.removeProject(proj);
        }
    }

    @Override
    public List getConditionsForProject(Project proj) {
        ArrayList<Condition> l = new ArrayList<Condition>();
        if (proj == null) {
            return l;
        }
        DataObject[] objs = this.getObjects();
        for (int i = 0; i < objs.length; ++i) {
            Condition c = (Condition)objs[i];
            if (c == null || c.isStudyCondition() || !c.hasProject(proj)) continue;
            l.add(c);
        }
        return l;
    }

    @Override
    public boolean removeObject(long objId) {
        Condition c = (Condition)this.getObject(objId);
        if (c == null) {
            return false;
        }
        if (c.isStudyCondition()) {
            System.out.println("Can't remove the Study Condition");
            return false;
        }
        return super.removeObject(objId);
    }
}

