/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.model;

import com.google.common.flogger.FluentLogger;
import hec.clientapp.client.ClientApp;
import hec.clientapp.model.DataListContainer;
import hec.clientapp.rmi.csinterface.RmiDataList;
import hec.event.AbstractDataEvent;
import hec.event.DataChangeEvent;
import hec.event.DataListEvent;
import hec.event.DataListListener;
import hec.event.LockEvent;
import hec.lang.ClientAppCheck;
import hec.lang.DataObjectReference;
import hec.lang.LongContainer;
import hec.lang.NamedType;
import hec.model.AbstractDataObject;
import hec.model.CommonDataList;
import hec.model.CommonDataListContainer;
import hec.model.DataList;
import hec.model.DataObject;
import hec.model.DataStruct;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;
import mil.army.usace.hec.rmi.csinterface.DataCallBack;
import mil.army.usace.hec.rmi.csinterface.RmiDataCallback;
import mil.army.usace.hec.rmi.server.RemoteWrapper;
import mil.army.usace.hec.rmi.server.RmiDataCallbackImpl;

public class DefaultDataList
extends NamedType
implements DataList,
DataCallBack {
    private static final FluentLogger LOGGER = FluentLogger.forEnclosingClass();
    private static boolean DEBUG = Boolean.getBoolean("DEBUG");
    protected RmiDataList _rmiDataList;
    protected DataListContainer _dataListContainer;
    protected String _objClass = null;
    LongContainer _longContainer = new LongContainer();
    protected Hashtable _objects = new Hashtable();
    protected DataObject[] _objectsArray = null;
    protected RmiDataCallbackImpl _callback;
    RemoteWrapper _callbackWrap = null;
    protected boolean _registered = false;
    protected boolean _workspaceClosing = false;
    protected String _modelName = null;
    protected boolean _initd = false;
    protected boolean _shown = true;
    protected transient Vector _listenerList = new Vector(1);

    public DefaultDataList(RmiDataList rd, DataListContainer parent, String objClass) {
        this._rmiDataList = rd;
        this._dataListContainer = parent;
        this._objClass = objClass;
        this._workspaceClosing = false;
        try {
            this._callback = new RmiDataCallbackImpl((DataCallBack)this);
        }
        catch (RemoteException e) {
            ((FluentLogger.Api)LOGGER.atFine()).log("Exception: %s", (Object)e.getMessage());
        }
        this._callbackWrap = this._callback.getRemoteReference();
        if (ClientAppCheck.haveClientApp() && ClientApp.app().networked) {
            throw new IllegalStateException("DefaultDataList cannot be used in a networked environment");
        }
    }

    public long getLastModifiedTime() {
        try {
            return this._rmiDataList.getLastModifiedTime();
        }
        catch (RemoteException e) {
            return Long.MIN_VALUE;
        }
    }

    public int getUnitSystem() {
        return this._dataListContainer.getUnitSystem();
    }

    public int getGmtOffset() {
        return this._dataListContainer.getGmtOffset();
    }

    public boolean hasBeenInitd() {
        return this._initd;
    }

    public boolean init() {
        Object[] objs;
        if (this._initd) {
            return true;
        }
        try {
            objs = this._rmiDataList.getObjects();
            this._shown = this._rmiDataList.isShown();
        }
        catch (RemoteException re) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("DefaultDataList.init: remoteException getting my list of objects %s", (Object)re.getMessage());
            return false;
        }
        if (objs != null) {
            for (int ii = 0; ii < objs.length; ++ii) {
                if (objs[ii] instanceof DataObject) {
                    this.addDataObject((DataObject)objs[ii]);
                    continue;
                }
                if (!(objs[ii] instanceof DataStruct)) continue;
                DataObject obj = this.getDataObject((DataStruct)objs[ii]);
                this.addDataObject(obj);
            }
        }
        this.register();
        this._initd = true;
        this.setModified(false);
        return true;
    }

    public boolean unregister() {
        if (this._registered) {
            try {
                this._rmiDataList.removeListener((RmiDataCallback)this._callbackWrap.getRemote());
                this._registered = false;
            }
            catch (RemoteException re) {
                ((FluentLogger.Api)LOGGER.atInfo()).log("DefaultDataList.unregister: error unregistering my listener %s", (Object)re.getMessage());
            }
        }
        return !this._registered;
    }

    public boolean register() {
        if (!this._registered) {
            try {
                this._rmiDataList.addListener((RmiDataCallback)this._callbackWrap.getRemote());
                this._registered = true;
            }
            catch (RemoteException re) {
                ((FluentLogger.Api)LOGGER.atInfo()).log("DefaultDataList.register: error registering my listener %s", (Object)re.getMessage());
            }
        }
        return this._registered;
    }

    public DataListContainer getDataListContainer() {
        return this._dataListContainer;
    }

    public CommonDataListContainer getCommonDataListContainer() {
        return this._dataListContainer;
    }

    public DataObject findObjectById(long objId, String objClass) {
        if (objClass.equals(this._objClass)) {
            return this.getObject(objId);
        }
        return this._dataListContainer.findObjectById(objId, objClass);
    }

    public long findObjectIdByName(String name) {
        Enumeration enumeration = this._objects.elements();
        while (enumeration.hasMoreElements()) {
            DataObject dObj = (DataObject)enumeration.nextElement();
            if (!dObj.getName().equals(name)) continue;
            return dObj.getId();
        }
        return Long.MIN_VALUE;
    }

    public DataObject getObject(long objId) {
        DataObject dataObj = null;
        this._longContainer._value = objId;
        dataObj = (DataObject)this._objects.get(this._longContainer);
        if (dataObj != null) {
            dataObj.setDataList((CommonDataList)this);
            if (!dataObj.isModified() && !dataObj.isLoaded()) {
                dataObj.loadData();
            }
        } else {
            ((FluentLogger.Api)LOGGER.atWarning()).log(this._objClass + ".getObject: failed to find obj for id %d", objId);
        }
        return dataObj;
    }

    public DataObject getObject(String name) {
        Enumeration enumeration = this._objects.elements();
        while (enumeration.hasMoreElements()) {
            DataObject dObj = (DataObject)enumeration.nextElement();
            if (!dObj.getName().equals(name)) continue;
            if (!dObj.isModified() || !dObj.isLoaded()) {
                dObj.loadData();
            }
            return dObj;
        }
        return null;
    }

    public boolean saveObject(Object obj) {
        DataObject fromArray = this.getObject(((AbstractDataObject)obj).getId());
        if (fromArray != null && fromArray != obj) {
            ((AbstractDataObject)fromArray).copyInto((DataStruct)obj);
        }
        boolean success = false;
        String user = ClientApp.app().getUser();
        if (this._rmiDataList != null) {
            try {
                success = this._rmiDataList.saveObject(obj, user);
                if (obj instanceof AbstractDataObject && success) {
                    ((AbstractDataObject)obj).setModified(false);
                    DataObject[] objs = this.getObjects();
                    boolean modified = false;
                    for (int d = 0; d < objs.length; ++d) {
                        if (!objs[d].isModified()) continue;
                        modified = true;
                        break;
                    }
                    if (!modified) {
                        this.setModified(false);
                    }
                }
                if (!success && obj instanceof DataObject) {
                    ((DataObject)obj).loadData();
                }
            }
            catch (RemoteException re) {
                ((FluentLogger.Api)LOGGER.atInfo()).log("Failed to save object. Exception: %s", (Object)re.getMessage());
                return success;
            }
        }
        if (success && !this._workspaceClosing) {
            if (obj instanceof DataObject) {
                this.notifyListeners(3, ((DataObject)obj).getId());
            } else {
                this.notifyListeners(3);
            }
        }
        return success;
    }

    public boolean saveAll(String user) {
        Enumeration enumeration = this._objects.elements();
        boolean needToWrite = this.isModified();
        boolean abortWrite = false;
        if (this._dataListContainer.isReadOnly()) {
            return true;
        }
        while (enumeration.hasMoreElements()) {
            DataObject doObj = (DataObject)enumeration.nextElement();
            if (!doObj.isModified()) continue;
            if (!this.saveObject(doObj)) {
                abortWrite = true;
                continue;
            }
            needToWrite = true;
        }
        boolean success = false;
        if (!abortWrite && needToWrite) {
            try {
                success = this._rmiDataList.save(user);
                if (success) {
                    this.setModified(false);
                }
            }
            catch (RemoteException re) {
                ((FluentLogger.Api)LOGGER.atInfo()).log(((Object)((Object)this)).getClass() + ".saveAll: save failed %s", (Object)re.getMessage());
                return false;
            }
        }
        return success;
    }

    public DataObject newDataObject(String name, String description) {
        try {
            DataObject obj = (DataObject)Class.forName(this.getObjectClass()).newInstance();
            obj.setDataList((CommonDataList)this);
            obj.setName(name);
            obj.setDescription(description);
            return obj;
        }
        catch (Exception e) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("newDataObject: failed to create new object %s", (Object)e.getMessage());
            return null;
        }
    }

    public DataObject newDataObject(DataStruct dstruct) {
        try {
            DataObject obj = (DataObject)Class.forName(this.getObjectClass()).newInstance();
            obj.setDataList((CommonDataList)this);
            obj.copyInto(dstruct);
            return obj;
        }
        catch (Exception e) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("newDataObject: failed to create new object %s", (Object)e.getMessage());
            return null;
        }
    }

    public boolean addDataObject(DataObject dataObj) {
        if (dataObj == null) {
            return false;
        }
        this._objectsArray = null;
        long id = dataObj.getId();
        LongContainer lc = new LongContainer(id);
        dataObj.setDataList((CommonDataList)this);
        if (this._objects.get(lc) != null) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("addDataObject(): error duplicate id %d" + id + " object name=%s", lc._value, (Object)dataObj.getName());
            return false;
        }
        this._objects.put(lc, dataObj);
        return true;
    }

    public boolean addNewObject(DataObject dObj) {
        long id;
        if (dObj == null) {
            return false;
        }
        try {
            id = this._rmiDataList.addNewObject((Object)dObj, ClientApp.app().getUser());
            if (id < 0L) {
                return false;
            }
        }
        catch (RemoteException re) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("addNewObject(): error adding " + dObj.getName() + " error " + re);
            return false;
        }
        dObj.setId(id);
        dObj.setDataList((CommonDataList)this);
        boolean b = this.addDataObject(dObj);
        if (b) {
            this.notifyListeners(1, dObj.getId());
        }
        return b;
    }

    public DataObject addNewObject2(DataObject dObj) {
        DataObject retObj;
        if (dObj == null) {
            return null;
        }
        try {
            retObj = this._rmiDataList.addNewObject2((Object)dObj, ClientApp.app().getUser());
        }
        catch (RemoteException re) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("addNewObject2(): error adding %s error %s", (Object)dObj.getName(), (Object)re.getMessage());
            return null;
        }
        if (retObj == null) {
            return null;
        }
        retObj.setDataList((CommonDataList)this);
        boolean b = this.addDataObject(retObj);
        if (b) {
            this.notifyListeners(1, dObj.getId());
        }
        return b ? retObj : null;
    }

    public boolean addNewObjectReference(long ownerId, String newObjClass, DataObject dObj) {
        DataList dList = null;
        DataObject myObj = this.getObject(ownerId);
        if (myObj == null) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("addNewObjectReference: failed to find my object with id %d", ownerId);
            return false;
        }
        dList = this._dataListContainer.getDataList(newObjClass);
        if (dList == null) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("addNewObjectReference: failed to find datalist for class %s", (Object)newObjClass);
            return false;
        }
        if (dList.addNewObject(dObj)) {
            long newObjId = dObj.getId();
            DataObjectReference dor = new DataObjectReference(newObjId, newObjClass);
            myObj.addObjectReference(dor);
            return dor.loadObjectRef(myObj);
        }
        return false;
    }

    public boolean addNewObjectReference(long ownerId, String newObjClass, String name, String description) {
        DataList dList = null;
        DataObject dObj = null;
        DataObject myObj = this.getObject(ownerId);
        if (myObj == null) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("addNewObjectReference: failed to find my object with id %d", ownerId);
            return false;
        }
        dList = this._dataListContainer.getDataList(newObjClass);
        if (dList == null) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("addNewObjectReference: failed to find datalist for class %s", (Object)newObjClass);
            return false;
        }
        dObj = dList.newDataObject(name, description);
        if (dObj == null) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("addNewObjectReference: failed to create a new object for class %s", (Object)newObjClass);
            return false;
        }
        if (dList.addNewObject(dObj)) {
            long newObjId = dObj.getId();
            DataObjectReference dor = new DataObjectReference(newObjId, newObjClass);
            myObj.addObjectReference(dor);
            return dor.loadObjectRef(myObj);
        }
        return false;
    }

    public boolean workspaceClosing() {
        this._workspaceClosing = true;
        this.unregister();
        return this.saveAll(ClientApp.app().getUser());
    }

    public void notify(AbstractDataEvent ade) {
        if (ade.getEventGenerator().equals(ClientApp.app().getUser())) {
            return;
        }
        if (ade instanceof DataChangeEvent) {
            this.notify((DataChangeEvent)ade);
        } else if (ade instanceof LockEvent) {
            this.notify((LockEvent)ade);
        }
    }

    public void notify(DataChangeEvent dce) {
        if (dce.getChangeType() == 2 && dce.getId() == -99L) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("notify: got reload event for %s", (Object)this._objClass);
            this._objects.clear();
            this._objectsArray = null;
            this._initd = false;
            this.notifyListeners(4);
            return;
        }
        long id = dce.getId();
        DataObject dObj = this.getObject(id);
        if (dObj != null) {
            dObj.reload();
        } else {
            DataObject obj;
            try {
                obj = this._rmiDataList.getObject(id);
            }
            catch (RemoteException re) {
                ((FluentLogger.Api)LOGGER.atInfo()).log("notify(dce): failed to get object for id %d from RmiDataList %s", id, (Object)re.getMessage());
                return;
            }
            if (obj != null) {
                if (obj instanceof DataObject) {
                    this.addDataObject(obj);
                } else if (obj instanceof DataStruct) {
                    dObj = this.newDataObject((DataStruct)obj);
                    dObj.setId(id);
                    this.addDataObject(dObj);
                }
            }
        }
    }

    public void notify(LockEvent le) {
        if (le.getEventGenerator().equals(ClientApp.app().getUser())) {
            return;
        }
        long id = le.getId();
        DataObject dObj = this.getObject(id);
        if (dObj != null) {
            dObj.locked(le.isLocked(), le.getEventGenerator());
        }
    }

    public String getObjectClass() {
        return this._objClass;
    }

    public Object loadObject(DataObject dObj) {
        if (dObj == null) {
            return null;
        }
        long id = dObj.getId();
        return this.loadObject(id);
    }

    public Object loadObject(long id) {
        try {
            DataObject obj = this._rmiDataList.getObject(id);
            if (obj instanceof DataObject) {
                obj.setDataList((CommonDataList)this);
            }
            return obj;
        }
        catch (RemoteException re) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("DefaultDataList.loadObjectData: remote exception loading data for id %d", id);
            ((FluentLogger.Api)LOGGER.atInfo()).log("DefaultDataList.loadObjectData: error %s" + re.getMessage());
            return null;
        }
    }

    public boolean removeObject(long objId) {
        if (objId < 0L) {
            return false;
        }
        this._longContainer._value = objId;
        boolean success = true;
        DataObject obj = this.getObject(objId);
        if (obj != null) {
            DataObjectReference[] refs = obj.getObjectReferences();
            if (refs == null || refs.length == 0) {
                return this.removeMyObj(objId);
            }
            for (int i = 0; i < refs.length; ++i) {
                if (!refs[i].loadObjectRef(obj)) {
                    ((FluentLogger.Api)LOGGER.atInfo()).log("removeObject:Failed to load object ref");
                    return false;
                }
                DataObject dObj = (DataObject)refs[i].getObject();
                if (dObj != null) {
                    if (dObj.getDataList().removeObject(dObj.getId())) continue;
                    success = false;
                    continue;
                }
                ((FluentLogger.Api)LOGGER.atInfo()).log("removeObject:ObjRef is null");
            }
            if (success) {
                return this.removeMyObj(objId);
            }
        }
        return false;
    }

    protected boolean removeMyObj(long objId) {
        try {
            if (!this._rmiDataList.removeObject(objId, ClientApp.app().getUser())) {
                ((FluentLogger.Api)LOGGER.atInfo()).log("removeObject: failed to remove object for id %d", objId);
                return false;
            }
        }
        catch (RemoteException re) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("removeObject: Error removing object %s", (Object)re.getMessage());
            return false;
        }
        DataObject obj = (DataObject)this._objects.remove(this._longContainer);
        if (obj != null) {
            obj.delete();
        }
        this._objectsArray = null;
        if (obj != null) {
            this.notifyListeners(2, obj.getId());
        } else {
            this.notifyListeners(2);
        }
        this.setModified(true);
        return true;
    }

    public int removeAll() {
        Object[] dobjs = this._objects.values().toArray();
        for (int ii = 0; ii < dobjs.length; ++ii) {
            long objId = ((DataObject)dobjs[ii]).getId();
            DataObject obj = this.getObject(objId);
            if (obj == null) continue;
            DataObjectReference[] refs = obj.getObjectReferences();
            if (refs != null) {
                for (int i = 0; i < refs.length; ++i) {
                    DataObject dObj;
                    if (!refs[i].loadObjectRef(obj) || (dObj = (DataObject)refs[i].getObject()) == null) continue;
                    dObj.getDataList().removeObject(dObj.getId());
                }
            }
            if ((obj = (DataObject)this._objects.remove(this._longContainer)) != null) {
                obj.delete();
            }
            this._objectsArray = null;
        }
        try {
            int num = this._rmiDataList.removeAll();
            if (num > 0) {
                this.setModified(true);
            }
            return num;
        }
        catch (Exception e) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("Error removing all objects. %s", (Object)e.getMessage());
            return 0;
        }
    }

    public Object callNativeMethod(Object obj) {
        try {
            obj = this._rmiDataList.callRemoteNativeMethod(obj);
            return obj;
        }
        catch (RemoteException re) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("DefaultDataList.callNativeMethod: remote exception calling on RmiDataList %s", (Object)re.getMessage());
            return null;
        }
    }

    public void setModelName(String model) {
        this._modelName = model;
    }

    public String getModelName() {
        return this._modelName;
    }

    public int getObjectCount() {
        return this._objects.size();
    }

    public DataStruct[] getObjectArray() {
        return this.getObjects();
    }

    public Iterator iterator() {
        return new Itr();
    }

    public DataObject[] getObjects() {
        if (!this.hasBeenInitd()) {
            this.init();
        }
        if (this._objectsArray != null) {
            return this._objectsArray;
        }
        boolean modifiedState = super.isModified();
        this._objectsArray = new DataObject[this._objects.size()];
        Enumeration enumeration = this._objects.elements();
        int idx = 0;
        while (enumeration.hasMoreElements()) {
            DataObject dobj = (DataObject)enumeration.nextElement();
            dobj.setDataList((CommonDataList)this);
            if (!dobj.isModified() && !dobj.isLoaded()) {
                dobj.loadData();
            }
            this._objectsArray[idx++] = dobj;
        }
        this.setModified(modifiedState);
        return this._objectsArray;
    }

    public boolean doesExist(String name) {
        if (name == null) {
            return false;
        }
        DataObject[] objects = this.getObjects();
        for (int i = 0; i < objects.length; ++i) {
            if (!objects[i].getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    protected DataObject getDataObject(DataStruct obj) {
        try {
            Class<?> cls = Class.forName(this._objClass);
            DataObject dObj = (DataObject)cls.newInstance();
            dObj.setDataList((CommonDataList)this);
            dObj.copyInto(obj);
            return dObj;
        }
        catch (Exception e) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("DefaultDataList.getDataObject: error getting data Object for %s DataStruct=%s Error=%s", (Object)this._objClass, (Object)obj, (Object)e);
            return null;
        }
    }

    public boolean isModified() {
        if (super.isModified()) {
            return true;
        }
        Enumeration enumeration = this._objects.elements();
        while (enumeration.hasMoreElements()) {
            DataObject dobj = (DataObject)enumeration.nextElement();
            if (!dobj.isModified()) continue;
            return true;
        }
        return false;
    }

    protected void syncDataLists(String objClass, String model) {
        DataObject[] myObjs;
        if (objClass == null || objClass.length() < 1) {
            return;
        }
        DataList thierDl = this._dataListContainer.getDataList(objClass, model);
        if (thierDl == null) {
            return;
        }
        DataObject[] thierObjs = thierDl.getObjects();
        if (thierObjs.length == (myObjs = this.getObjects()).length) {
            return;
        }
        DataObjectReference[] refs = null;
        Vector<LongContainer> objIds = new Vector<LongContainer>(myObjs.length);
        for (int i = 0; i < myObjs.length; ++i) {
            refs = myObjs[i].getObjectReferences();
            if (refs == null || refs.length < 1 || !refs[0].loadObjectRef(myObjs[i])) {
                myObjs[i].removeObjectReference(0);
                ((FluentLogger.Api)LOGGER.atInfo()).log("syncDataLists: missing thier object for mine %s", (Object)myObjs[i].getName());
                DataObject newObj = thierDl.newDataObject(myObjs[i].getName(), myObjs[i].getDescription());
                newObj = thierDl.addNewObject2(newObj);
                if (newObj == null) continue;
                DataObjectReference dor = new DataObjectReference(newObj.getId(), thierDl.getObjectClass());
                myObjs[i].addObjectReference(dor);
                continue;
            }
            for (int r = 0; r < refs.length; ++r) {
                DataObject theRef = (DataObject)refs[r].getObject();
                if (theRef == null) continue;
                objIds.addElement(new LongContainer(theRef.getId()));
            }
        }
        LongContainer lc = new LongContainer();
        for (int i = 0; i < thierObjs.length; ++i) {
            lc._value = thierObjs[i].getId();
            if (objIds.contains(lc)) continue;
            ((FluentLogger.Api)LOGGER.atInfo()).log("syncDataLists: missing my object for theirs %s", (Object)thierObjs[i].getName());
            DataObject myNewObj = this.newDataObject(thierObjs[i].getName(), thierObjs[i].getDescription());
            DataObjectReference dor = new DataObjectReference(thierObjs[i].getId(), thierDl.getObjectClass());
            myNewObj.addObjectReference(dor);
            this.addNewObject(myNewObj);
        }
    }

    public Vector getNamesVector() {
        Vector<String> v = new Vector<String>(this._objects.size());
        Enumeration e = this._objects.elements();
        while (e.hasMoreElements()) {
            v.addElement(((DataObject)e.nextElement()).getName());
        }
        return v;
    }

    public void addDataListListener(DataListListener listener) {
        if (this._listenerList.contains(listener)) {
            return;
        }
        this._listenerList.addElement(listener);
    }

    public void removeDataListListener(DataListListener listener) {
        this._listenerList.removeElement(listener);
    }

    protected void notifyListeners(int notifyType) {
        DataListEvent event = new DataListEvent((CommonDataList)this, notifyType);
        for (int i = 0; i < this._listenerList.size(); ++i) {
            Object obj = this._listenerList.elementAt(i);
            if (!(obj instanceof DataListListener)) continue;
            ((DataListListener)obj).dataListChanged(event);
        }
    }

    protected void notifyListeners(int notifyType, long objId) {
        DataListEvent event = new DataListEvent((CommonDataList)this, notifyType, objId);
        for (int i = 0; i < this._listenerList.size(); ++i) {
            Object obj = this._listenerList.elementAt(i);
            if (!(obj instanceof DataListListener)) continue;
            ((DataListListener)obj).dataListChanged(event);
        }
    }

    public boolean backupObjectData(String backupDir, DataObject dObj) {
        if (dObj == null) {
            return this.backupData(backupDir);
        }
        if (backupDir == null || backupDir.length() < 1) {
            return false;
        }
        try {
            return this._rmiDataList.backupObjectData(backupDir, dObj, ClientApp.app().getUser());
        }
        catch (RemoteException re) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("backupData: failed to back up data for %s", (Object)dObj.getName());
            return false;
        }
    }

    public boolean backupData(String backupDir) {
        if (backupDir == null || backupDir.length() < 1) {
            return false;
        }
        try {
            return this._rmiDataList.backupData(backupDir, ClientApp.app().getUser());
        }
        catch (RemoteException re) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("backupData: failed to back up my data");
            return false;
        }
    }

    public boolean reload(String user) {
        try {
            if (this._rmiDataList.reload(user)) {
                this._objectsArray = null;
                this._objects.clear();
                this._initd = false;
                return true;
            }
        }
        catch (RemoteException re) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("reload: failed to reload data");
        }
        return false;
    }

    private class Itr
    implements Iterator {
        int cursor = 0;

        public Itr() {
            DefaultDataList.this.getObjectArray();
        }

        @Override
        public boolean hasNext() {
            return this.cursor != DefaultDataList.this.getObjectCount();
        }

        public Object next() {
            if (DefaultDataList.this._objectsArray == null) {
                throw new NoSuchElementException();
            }
            try {
                DataObject next = DefaultDataList.this._objectsArray[this.cursor];
                ++this.cursor;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

