/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.model;

import hec.appInterface.AppDaddy;
import hec.io.AsciiSerializable;
import hec.map.WorldLine;
import hec.map.WorldLineHolder;
import hec.map.WorldPt;
import hec.model.CommonDataList;
import hec.model.DataObject;
import hec.model.Node;
import hec.model.StreamElement;
import hec.watershed.model.ComputationPoint;
import hec.watershed.model.ComputationPointContainer;
import hec.watershed.model.ComputationPointHolder;
import hec.watershed.model.Project;
import java.awt.Color;
import java.awt.Component;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Vector;
import javax.swing.JOptionPane;
import rma.util.RMAConst;

public class Diversion
extends Project
implements Serializable,
AsciiSerializable,
ComputationPointHolder,
WorldLineHolder {
    static final long serialVersionUID = -8772712223619157277L;
    public static final String MENU_NAME = "Diversion";
    private WorldLine _line = new WorldLine();
    private int _inFlowType;
    private Vector _nodeVec = new Vector();
    private Vector _nodeDirVector = new Vector();
    private transient ComputationPoint _inflowCompPt;
    private long _inflowCompPtId = -1L;
    private transient ComputationPoint _outflowCompPt;
    private long _outflowCompPtId = -1L;
    private long _reservoirId = -1L;
    private double _reservoirOffset = -1.0;

    public void connectDownstream(Node node, ComputationPoint cp) {
        this.addNode(node, 0);
        if (cp == null) {
            this.removeFromComputationPoint(false);
            cp.setAutoGenerated(true);
            cp.setStreamId(node.getStreamIndex());
            cp.setStreamStation(node.getStreamStation());
            cp.setReferencePt(new WorldPt(node.getLocation()));
            cp.setSnapToStream(true);
            cp.addProject((DataObject)this);
            if (cp != null) {
                cp.setName(cp.getName() + cp.getId());
            }
        } else if (cp.getId() != this._outflowCompPtId) {
            this.removeFromComputationPoint(false);
            cp.addProject((DataObject)this);
        } else {
            return;
        }
        this._outflowCompPt = cp;
        this._outflowCompPtId = cp.getId();
        this.setModified(true);
    }

    public void disconnectDownstream(double eoff, double noff) {
        boolean isInflow = false;
        this.removeFromComputationPoint(isInflow);
        Node n = this.getDownstreamNode();
        if (n == null) {
            return;
        }
        WorldPt wpt = new WorldPt(n.getLocation());
        wpt.n += noff;
        wpt.e += eoff;
        this.getLine().getLastPt().init(wpt);
        this.removeNode(n);
        this.setModified(true);
    }

    public boolean loadData() {
        if (!this._loaded || this._outOfDateData) {
            Object obj = this._dataList.loadObject((DataObject)this);
            if (obj instanceof Diversion) {
                this.copyInto((DataObject)((Diversion)obj));
            }
            if (super.loadData()) {
                this._loaded = true;
            }
            this.setModified(false);
        }
        return this._loaded;
    }

    public Node getDownstreamNode() {
        if (this._nodeVec.size() < 2) {
            return null;
        }
        return (Node)this._nodeVec.elementAt(1);
    }

    public Node getUpstreamNode() {
        if (this._nodeVec.size() < 1) {
            return null;
        }
        return (Node)this._nodeVec.elementAt(0);
    }

    public int getInflowType() {
        return this._inFlowType;
    }

    @Override
    public int getStreamId() {
        return this._streamId;
    }

    public WorldLine getLine() {
        return this._line;
    }

    public long getReservoirId() {
        return this._reservoirId;
    }

    public double getReservoirOffset() {
        return this._reservoirOffset;
    }

    public void setReservoirId(long resId) {
        this._reservoirId = resId;
    }

    public void setReservoirOffset(double resOffset) {
        this._reservoirOffset = resOffset;
    }

    public void setLine(WorldLine line) {
        if (line == null) {
            return;
        }
        this._line = line;
        this.setReferencePt((WorldPt)this._line.pts.elementAt(0));
        this.setModified(true);
    }

    public void removeNode(Node node) {
        for (int i = 0; i < this._nodeVec.size(); ++i) {
            Node n = (Node)this._nodeVec.elementAt(i);
            if (n != node) continue;
            this._nodeVec.removeElementAt(i);
            this._nodeDirVector.removeElementAt(i);
            this.setModified(true);
            break;
        }
    }

    public void addNode(Node node, int idir) {
        this._nodeVec.addElement(node);
        this._nodeDirVector.addElement(new Integer(idir));
        this.setModified(true);
    }

    @Override
    public String getUserDisplayedType() {
        return MENU_NAME;
    }

    @Override
    public String getLabelName() {
        return MENU_NAME;
    }

    public void setInflowType(int inFlowType) {
        this._inFlowType = inFlowType;
    }

    @Override
    public void removeFromComputationPoint() {
        this.removeFromComputationPoint(true);
        this.removeFromComputationPoint(false);
    }

    public void removeFromComputationPoint(boolean inflow) {
        ComputationPoint cp = this.getComputationPoint(inflow);
        if (cp != null) {
            cp.removeProject((DataObject)this);
            if (cp.isAutoGenerated() && cp.getProjects().size() == 0) {
                cp.getDataList().removeObject(cp.getId());
            }
            if (inflow) {
                this._inflowCompPt = null;
                this._inflowCompPtId = -1L;
            } else {
                this._outflowCompPt = null;
                this._outflowCompPtId = -1L;
            }
        }
    }

    public ComputationPoint getComputationPoint(boolean inflow) {
        if (inflow) {
            if (this._inflowCompPt == null && this._inflowCompPtId != -1L) {
                this._inflowCompPt = (ComputationPoint)this.getDataList().findObjectById(this._inflowCompPtId, "hec.watershed.model.ComputationPoint");
            }
            return this._inflowCompPt;
        }
        if (this._outflowCompPt == null && this._outflowCompPtId != -1L) {
            this._outflowCompPt = (ComputationPoint)this.getDataList().findObjectById(this._outflowCompPtId, "hec.watershed.model.ComputationPoint");
        }
        return this._outflowCompPt;
    }

    private ComputationPoint getComputationPoint(long cptId) {
        CommonDataList dl = this.getDataList().getCommonDataListContainer().getCommonDataList("hec.watershed.model.ComputationPoint");
        return (ComputationPoint)dl.getObject(cptId);
    }

    @Override
    public void updateComputationPoint() {
        ComputationPointContainer dl = (ComputationPointContainer)this._dataList.getCommonDataListContainer().getCommonDataList("hec.watershed.model.ComputationPoint");
        if (dl == null) {
            return;
        }
        if (this._nodeVec == null || this._nodeVec.size() < 1) {
            return;
        }
        int numNodes = this._nodeVec.size();
        this.checkCompPtArrays();
        for (int i = 0; i < numNodes; ++i) {
            Node node = (Node)this._nodeVec.elementAt(i);
            if (node == null) continue;
            if (node == this.getUpstreamNode() && this._inFlowType != 1) {
                this.updateComputationPoint(node, i, dl);
                continue;
            }
            if (node != this.getDownstreamNode()) continue;
            this.updateComputationPoint(node, i, dl);
        }
        this.setModified(true);
    }

    private void checkCompPtArrays() {
        int numNodes = this._nodeVec.size();
        int numCompPtIds = this.getCompPtIdCount();
        if (numCompPtIds != numNodes) {
            this._inflowCompPtId = -1L;
            this._outflowCompPtId = -1L;
            this._inflowCompPt = null;
            this._outflowCompPt = null;
        }
    }

    private int getCompPtIdCount() {
        int idNum = 0;
        if (this._inflowCompPtId != -1L) {
            ++idNum;
        }
        if (this._outflowCompPtId != -1L) {
            ++idNum;
        }
        return idNum;
    }

    private void updateComputationPoint(Node node, int i, ComputationPointContainer dl) {
        long id;
        if (i == 0) {
            id = this._inflowCompPtId;
        } else if (i == 1) {
            id = this._outflowCompPtId;
        } else {
            System.out.println("updateComputationPoint:unknown cp number " + i);
            return;
        }
        ComputationPoint cp = null;
        if (id != -1L) {
            cp = (ComputationPoint)dl.getObject(id);
        }
        if (cp != null && cp.isAutoGenerated() && cp.getProjects().size() == 1 && cp.getProjects().get(0) == this) {
            cp.setStreamId(node.getStreamIndex());
            cp.setReferencePt(node.getLocation());
            cp.setStreamStation(node.getStreamStation());
            cp.setStreamCoord(node.getStreamCoord());
            return;
        }
        double tol = 15.0;
        cp = dl.getComputationPointAt(node.getLocation(), tol);
        Integer nodeDir = (Integer)this._nodeDirVector.get(i);
        if (cp != null && cp.getId() != id && !this.usingComputationPoint(cp, i)) {
            Object[] opts = new Object[]{"Existing computation point", "New Computation Point"};
            int opt = JOptionPane.showOptionDialog((Component)AppDaddy.getFrame(), "<html>An Existing Computation Point, <b>" + cp.getName() + "</b>, was found.<br>Connect Diversion <b>" + this.getName() + "'s</b> " + (nodeDir == 1 ? "Inflow" : "Outflow") + " Location to:</html>", "Computation Point Found", 0, 3, null, opts, opts[0]);
            if (opt == 1) {
                cp = null;
            }
        }
        if (this.usingComputationPoint(cp, i)) {
            this.removeFromComputationPoint(i);
            cp.setAutoGenerated(true);
            cp.setStreamId(node.getStreamIndex());
            cp.setStreamStation(node.getStreamStation());
            cp.setStreamCoord(node.getStreamCoord());
            cp.setReferencePt(new WorldPt(node.getLocation()));
            cp.setSnapToStream(true);
            cp.addProject((DataObject)this);
            cp = (ComputationPoint)dl.addNewObject2((DataObject)cp);
            if (cp != null) {
                cp = (ComputationPoint)dl.getObject(cp.getId());
                cp.setName(cp.getName() + cp.getId());
                if (i == 0) {
                    this._inflowCompPt = cp;
                    this._inflowCompPtId = cp.getId();
                } else {
                    this._outflowCompPt = cp;
                    this._outflowCompPtId = cp.getId();
                }
                this.setModified(true);
            }
        } else if (cp != null && cp.getId() != id) {
            StreamElement elem;
            this.removeFromComputationPoint(i);
            cp.setStreamId(node.getStreamIndex());
            cp.setStreamStation(node.getStreamStation());
            cp.setStreamCoord(node.getStreamCoord());
            cp.setSnapToStream(true);
            cp.addProject((DataObject)this);
            node.setStreamIndex(cp.getStreamId());
            node.setStreamCoord(cp.getStreamCoord());
            node.setStreamStation(cp.getStreamStation());
            if (RMAConst.isUndefinedValue((double)node.getStreamCoord()) && (elem = cp.getStream()) != null) {
                node.setStreamCoord(elem.getCoordByStation(cp.getStreamStation()));
            }
            if (i == 0) {
                this._inflowCompPt = cp;
                this._inflowCompPtId = cp.getId();
            } else {
                this._outflowCompPt = cp;
                this._outflowCompPtId = cp.getId();
            }
            this.computationPointMoved(cp);
            this.setModified(true);
        }
    }

    private boolean usingComputationPoint(ComputationPoint pt, int idx) {
        if (pt == null) {
            return false;
        }
        long cpId = pt.getId();
        return idx == 0 ? this._outflowCompPtId == cpId : this._inflowCompPtId == cpId;
    }

    protected void removeFromComputationPoint(int i) {
        long id;
        if (i == 0) {
            id = this._inflowCompPtId;
        } else if (i == 1) {
            id = this._outflowCompPtId;
        } else {
            System.out.println("removeFromComputationPoint:known cp number " + i);
            return;
        }
        ComputationPoint cp = this.getComputationPoint(id);
        if (cp != null) {
            cp.removeProject((DataObject)this);
            if (cp.isAutoGenerated() && cp.getProjects().size() == 0) {
                cp.getDataList().removeObject(cp.getId());
            }
            if (i == 0) {
                this._inflowCompPt = null;
                this._inflowCompPtId = -1L;
            } else {
                this._outflowCompPt = null;
                this._outflowCompPtId = -1L;
            }
        }
    }

    @Override
    public void computationPointMoved(ComputationPoint cpt) {
        if (cpt == null) {
            return;
        }
        if (this._inflowCompPtId == cpt.getId()) {
            Node n = this.getUpstreamNode();
            if (n == null) {
                return;
            }
            n.setStreamIndex(cpt.getStreamId());
            n.setStreamStation(cpt.getStreamStation());
            this.setModified(true);
        } else if (this._outflowCompPtId == cpt.getId()) {
            Node n = this.getDownstreamNode();
            if (n == null) {
                return;
            }
            n.setStreamIndex(cpt.getStreamId());
            n.setStreamStation(cpt.getStreamStation());
            this.setModified(true);
        }
    }

    @Override
    public boolean hasComputationPoint() {
        return this.getComputationPoint(true) != null || this.getComputationPoint(false) != null;
    }

    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return super.getFieldObject(fld);
        }
    }

    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return super.setFieldObject(fld, fobj);
        }
        catch (IllegalArgumentException e) {
            return super.setFieldObject(fld, fobj);
        }
    }

    public WorldLine getLine(int idx) {
        return this.getLine();
    }

    public Color getLineColor(int idx) {
        return Color.BLACK;
    }

    public int getLineCount() {
        return 1;
    }

    public String getLineDescription(int idx) {
        return this.getDescription();
    }

    public String getLineName(int idx) {
        return this.getName();
    }

    public int getStreamIndex() {
        Node n = this.getUpstreamNode();
        return n.getStreamIndex();
    }

    public void setStreamIndex(int idx) {
    }
}

