/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.model;

import hec.event.DataChangeEvent;
import hec.event.LockEvent;
import hec.io.AsciiSerializable;
import hec.map.WorldPt;
import hec.map.WorldRegion;
import hec.map.WorldRegionHolder;
import hec.map.streamAlignment.StreamAlignmentIfc;
import hec.model.AbstractDataObject;
import hec.model.CommonDataList;
import hec.model.DataObject;
import hec.model.DataStruct;
import hec.model.StreamElement;
import hec.model.StreamReferenceHolder;
import hec.watershed.model.ComputationPoint;
import hec.watershed.model.ComputationPointContainer;
import hec.watershed.model.ComputationPointHolder;
import hec.watershed.model.StudyContainer;
import hec.watershed.model.StudyIfc;
import hec.watershed.model.StudyRegion;
import hec.watershed.model.WatershedDefaults;
import java.awt.Color;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import rma.text.ColorFormatter;

public class ImpactArea
extends AbstractDataObject
implements Serializable,
AsciiSerializable,
StudyRegion,
ComputationPointHolder,
WorldRegionHolder,
StreamReferenceHolder {
    static final long serialVersionUID = 4962274980471828630L;
    public static final String MENU_NAME = "Impact Area";
    public static final int NO_BANKS = 0;
    public static final int LEFT_BANK = 1;
    public static final int RIGHT_BANK = 2;
    public static final int BOTH_BANKS = 3;
    public static final String NO_BANKS_STRING = "No Banks";
    public static final String LEFT_BANK_STRING = "Left";
    public static final String RIGHT_BANK_STRING = "Right";
    public static final String BOTH_BANKS_STRING = "Both";
    static final String AUTO_STREAM = "{Impact Area} Stream";
    static final String AUTO_STREAM_BANK = "{Impact Area}Impact Area Stream Bank";
    static final String AUTO_STREAM_STATION = "{Impact Area}Index Stream Station";
    static final String AUTO_BEGIN_STATION = "{Impact Area}Index Upstream Station";
    static final String AUTO_END_STATION = "{Impact Area}Index Downstream Station";
    static final String GENERATE_COMP_PT = "{Impact Area}Generate Computation Point";
    private int _streamId = Integer.MIN_VALUE;
    private String _streamName;
    private int _bank = Integer.MIN_VALUE;
    private double _indexStation = Double.NEGATIVE_INFINITY;
    private double _beginStation = Double.NEGATIVE_INFINITY;
    private double _endStation = Double.NEGATIVE_INFINITY;
    private double _northing = Double.NEGATIVE_INFINITY;
    private double _easting = Double.NEGATIVE_INFINITY;
    private WorldPt _referencePt = new WorldPt();
    private WorldPt _labelPositionPt = new WorldPt();
    private WorldRegion _region = new WorldRegion();
    private String _color = "green";
    private boolean _genCompPt = false;
    private long _compPtId = -1L;
    private transient ComputationPoint _compPt;
    private int _labelPosition = 0;
    private boolean _autoStream = true;
    private boolean _autoBank = true;
    private boolean _autoIndexStation = true;
    private boolean _autoReferencePt = true;
    private boolean _autoBeginStation = true;
    private boolean _autoEndStation = true;
    private boolean _autoLabelPosition = true;

    public static int getBankConstant(String s) {
        if (s.equalsIgnoreCase(LEFT_BANK_STRING)) {
            return 1;
        }
        if (s.equalsIgnoreCase(RIGHT_BANK_STRING)) {
            return 2;
        }
        if (s.equalsIgnoreCase(BOTH_BANKS_STRING)) {
            return 3;
        }
        return 0;
    }

    public static String getBankConstant(int i) {
        switch (i) {
            case 1: {
                return LEFT_BANK_STRING;
            }
            case 2: {
                return RIGHT_BANK_STRING;
            }
            case 3: {
                return BOTH_BANKS_STRING;
            }
        }
        return NO_BANKS_STRING;
    }

    public ImpactArea() {
        this.initDefaults();
    }

    private void initDefaults() {
        WatershedDefaults defaults = WatershedDefaults.getDefaults();
        if (defaults != null) {
            this._autoStream = (Boolean)defaults.getDefaultValue(AUTO_STREAM);
            this._autoBank = (Boolean)defaults.getDefaultValue(AUTO_STREAM_BANK);
            this._autoIndexStation = (Boolean)defaults.getDefaultValue(AUTO_STREAM_STATION);
            this._autoBeginStation = (Boolean)defaults.getDefaultValue(AUTO_BEGIN_STATION);
            this._autoEndStation = (Boolean)defaults.getDefaultValue(AUTO_END_STATION);
            this._genCompPt = (Boolean)defaults.getDefaultValue(GENERATE_COMP_PT);
        }
    }

    public static Hashtable getDefaults() {
        Hashtable<String, Boolean> table = new Hashtable<String, Boolean>();
        table.put(AUTO_STREAM_STATION, true);
        table.put(AUTO_BEGIN_STATION, true);
        table.put(AUTO_END_STATION, true);
        table.put(AUTO_STREAM, true);
        table.put(GENERATE_COMP_PT, false);
        table.put(AUTO_STREAM_BANK, true);
        return table;
    }

    private StreamElement getStreamElement() {
        StreamAlignmentIfc alignment = this.getAlignment();
        if (alignment == null) {
            return null;
        }
        Vector vec = alignment.getElementVector();
        if (vec == null) {
            return null;
        }
        StreamElement elem = null;
        for (int i = 0; i < vec.size(); ++i) {
            elem = (StreamElement)vec.elementAt(i);
            if (elem == null || elem.getIndex() != this._streamId) continue;
            return elem;
        }
        return null;
    }

    private double[] getStations() {
        double[] _stations = new double[3];
        Arrays.fill(_stations, Double.NEGATIVE_INFINITY);
        StreamElement elem = this.getStreamElement();
        if (elem == null) {
            return _stations;
        }
        _stations[0] = elem.getStationByLocation(this.getReferencePt());
        double begin = Double.POSITIVE_INFINITY;
        double end = Double.NEGATIVE_INFINITY;
        WorldRegion reg = this.getRegion();
        for (int i = 0; i < reg.pts.size(); ++i) {
            WorldPt pt = (WorldPt)reg.pts.elementAt(i);
            double station = elem.getStationByLocation(pt);
            if (station < begin) {
                begin = station;
            }
            if (!(station > end)) continue;
            end = station;
        }
        _stations[1] = begin;
        _stations[2] = end;
        return _stations;
    }

    public boolean save() {
        this.updateWorldRegionDependentFields();
        super.save();
        return true;
    }

    public void setModified(boolean tf) {
        if (this.getIgnoreModifiedEvents()) {
            return;
        }
        if (tf) {
            if (this._region != null) {
                this._region.invalidate();
            }
            this.updateWorldRegionDependentFields();
        }
        super.setModified(tf);
    }

    private void updateEditors() {
        this.notifyObservers();
    }

    private void updateReferencePt() {
        if (!this._autoReferencePt) {
            return;
        }
        for (int i = 0; i < this._region.pts.size(); ++i) {
            WorldPt pt = (WorldPt)this._region.pts.elementAt(i);
            if (pt == null) continue;
            if (i == 0) {
                this._referencePt.init(pt);
                continue;
            }
            this._referencePt.e += pt.e;
            this._referencePt.n += pt.n;
        }
        double xnum = this._region.pts.size();
        if (xnum > 1.0) {
            this._referencePt.e /= xnum;
            this._referencePt.n /= xnum;
        }
    }

    private void updateStationing() {
        double tempStation;
        if (!(this._autoIndexStation || this._autoBeginStation || this._autoEndStation)) {
            return;
        }
        double[] stations = this.getStations();
        if (this._autoIndexStation) {
            tempStation = this._indexStation;
            this._indexStation = stations[0];
            this._propertyChangeSupport.firePropertyChange("indexStation", tempStation, this._indexStation);
        }
        if (this._autoBeginStation) {
            tempStation = this._beginStation;
            this._beginStation = stations[1];
            this._propertyChangeSupport.firePropertyChange("beginStation", tempStation, this._beginStation);
        }
        if (this._autoEndStation) {
            tempStation = this._endStation;
            this._endStation = stations[2];
            this._propertyChangeSupport.firePropertyChange("endStation", tempStation, this._endStation);
        }
    }

    private void updateLabelPosition() {
        if (!this._autoLabelPosition) {
            return;
        }
        this._labelPositionPt.init(this._referencePt);
    }

    private void updateComputationPointPosition() {
        this.updateComputationPoint();
        if (this._compPtId == -1L) {
            return;
        }
        this._compPt.setStreamStation(this._indexStation);
    }

    private void updateBank() {
        if (!this._autoBank) {
            return;
        }
        StreamElement elem = this.getStreamElement();
        if (elem == null) {
            return;
        }
        this._bank = elem.getLine().getNearestLocationSigned(this.getReferencePt(), new WorldPt()) > 0.0 ? 1 : 2;
    }

    private StreamAlignmentIfc getAlignment() {
        if (this._dataList == null) {
            return null;
        }
        StudyContainer studydl = (StudyContainer)this._dataList.getCommonDataListContainer().getCommonDataList("hec.watershed.model.Study");
        if (studydl != null) {
            StudyIfc study = studydl.getOpenStudy();
            return study.getAlignment();
        }
        return null;
    }

    private void updateStream() {
        if (!this._autoStream) {
            return;
        }
        StreamAlignmentIfc alignment = this.getAlignment();
        if (alignment == null) {
            return;
        }
        StreamElement elem = alignment.findNearestReach(this.getReferencePt(), new WorldPt());
        if (elem != null) {
            this._streamId = elem.getIndex();
        }
    }

    public void updateWorldRegionDependentFields() {
        this.updateReferencePt();
        this.updateReferencePtDependentFields();
    }

    private void updateReferencePtDependentFields() {
        this.updateStream();
        this.updateBank();
        this.updateLabelPosition();
        this.updateStationing();
    }

    public boolean setStreamId(int streamId) {
        if (this._autoStream) {
            return false;
        }
        this._streamId = streamId;
        return true;
    }

    public boolean setBank(int bank) {
        if (this._autoBank || bank != 1 && bank != 2 && bank != 3) {
            return false;
        }
        this._bank = bank;
        return true;
    }

    public boolean setBankString(String bank) {
        if (this._autoBank) {
            return false;
        }
        if (bank.equalsIgnoreCase("left")) {
            this._bank = 1;
            return true;
        }
        if (bank.equalsIgnoreCase("right")) {
            this._bank = 2;
            return true;
        }
        if (bank.equalsIgnoreCase("both")) {
            this._bank = 3;
            return true;
        }
        return false;
    }

    @Override
    public void removeFromComputationPoint() {
        ComputationPoint cp = this.getComputationPoint();
        if (cp != null) {
            cp.removeProject((DataObject)this);
            this._compPt = null;
            this._compPtId = -1L;
        }
    }

    public ComputationPoint getComputationPoint() {
        if (this._compPt == null && this._compPtId != -1L) {
            ComputationPoint cp;
            this._compPt = cp = (ComputationPoint)this.getDataList().findObjectById(this._compPtId, "hec.watershed.model.ComputationPoint");
        }
        return this._compPt;
    }

    @Override
    public void updateComputationPoint() {
        ComputationPointContainer dl = (ComputationPointContainer)this._dataList.getCommonDataListContainer().getCommonDataList("hec.watershed.model.ComputationPoint");
        if (dl == null) {
            return;
        }
        if (!this._genCompPt) {
            this.removeFromComputationPoint();
            return;
        }
        ComputationPoint cp = dl.getComputationPointAt(this._streamId, this._indexStation, 5.0);
        if (cp == null) {
            this.removeFromComputationPoint();
            cp = (ComputationPoint)dl.newDataObject("CP", "Computation Point for Impact Area " + this.getName());
            cp.setAutoGenerated(true);
            cp.setStreamId(this._streamId);
            cp.setStreamStation(this._indexStation);
            cp.setReferencePt(new WorldPt(dl.getLocationForComputationPoint(cp)));
            cp.setSnapToStream(true);
            ((CommonDataList)dl).addNewObject((DataObject)cp);
            cp.addProject((DataObject)this);
            cp.setName(cp.getName() + cp.getId());
        } else if (cp.getId() != this._compPtId) {
            this.removeFromComputationPoint();
            cp.addProject((DataObject)this);
        } else {
            return;
        }
        cp.setStreamStation(this._indexStation);
        cp.save();
        this._compPt = cp;
        this._compPtId = cp.getId();
    }

    public WorldPt getLabelPositionPoint() {
        if (!this._labelPositionPt.isValid()) {
            this.updateLabelPosition();
        }
        return this._labelPositionPt;
    }

    public void setLabelPosition(int pos) {
        this._labelPosition = pos;
    }

    @Override
    public int getLabelPosition() {
        return this._labelPosition;
    }

    public void setNorthing(double northing) {
        this._northing = northing;
    }

    public void setEasting(double easting) {
        this._easting = easting;
    }

    public double getNorthing() {
        return this._northing;
    }

    public double getEasting() {
        return this._easting;
    }

    public void setColor(Color color) {
        this._color = ColorFormatter.nameForColor((Color)color);
    }

    public Color getColor() {
        return ColorFormatter.colorForName((String)this._color);
    }

    public boolean setIndexStation(double loc) {
        if (this._autoIndexStation) {
            return false;
        }
        double tempStation = this._indexStation;
        this._indexStation = loc;
        this._propertyChangeSupport.firePropertyChange("indexStation", tempStation, this._indexStation);
        return true;
    }

    public boolean setBeginStation(double station) {
        if (this._autoBeginStation) {
            return false;
        }
        double tempStation = this._beginStation;
        this._beginStation = station;
        this._propertyChangeSupport.firePropertyChange("beginStation", tempStation, this._beginStation);
        return true;
    }

    public boolean setEndStation(double station) {
        if (this._autoEndStation) {
            return false;
        }
        double tempStation = this._endStation;
        this._endStation = station;
        this._propertyChangeSupport.firePropertyChange("endStation", tempStation, this._endStation);
        return true;
    }

    public int getStreamId() {
        return this._streamId;
    }

    public String getBankString() {
        switch (this._bank) {
            case 1: {
                return LEFT_BANK_STRING;
            }
            case 2: {
                return RIGHT_BANK_STRING;
            }
            case 3: {
                return BOTH_BANKS_STRING;
            }
        }
        return "";
    }

    public int getBank() {
        return this._bank;
    }

    public double getIndexStation() {
        return this._indexStation;
    }

    public double getBeginStation() {
        return this._beginStation;
    }

    public double getEndStation() {
        return this._endStation;
    }

    @Override
    public WorldRegion getRegion() {
        return this._region;
    }

    public void setRegion(WorldRegion region) {
        WorldRegion oldRegion = this._region;
        if (region != null) {
            this._region = (WorldRegion)region.clone();
            if (!this.getIgnoreModifiedEvents()) {
                this.updateWorldRegionDependentFields();
            }
        } else {
            this._region = new WorldRegion();
        }
        this._propertyChangeSupport.firePropertyChange("Region", oldRegion, this._region);
    }

    public boolean setReferencePt(WorldPt pt) {
        if (this._autoReferencePt) {
            return false;
        }
        this._referencePt = pt;
        this.updateReferencePtDependentFields();
        return true;
    }

    @Override
    public WorldPt getReferencePt() {
        if (this._referencePt.isValid()) {
            return this._referencePt;
        }
        if (this._region.pts.size() > 0) {
            this._referencePt = (WorldPt)this._region.pts.elementAt(0);
        }
        return this._referencePt;
    }

    public boolean getAutoReferencePt() {
        return this._autoReferencePt;
    }

    public void setAutoReferencePt(boolean tf) {
        this._autoReferencePt = tf;
    }

    public boolean getAutoStream() {
        return this._autoStream;
    }

    public void setAutoStream(boolean tf) {
        this._autoStream = tf;
    }

    public boolean getAutoLabelPosition() {
        return this._autoLabelPosition;
    }

    public void setAutoLabelPosition(boolean b) {
        this._autoLabelPosition = b;
    }

    public boolean getAutoIndexStation() {
        return this._autoIndexStation;
    }

    public boolean getGenerateCompPt() {
        return this._genCompPt;
    }

    public boolean getAutoBeginStation() {
        return this._autoBeginStation;
    }

    public boolean getAutoEndStation() {
        return this._autoEndStation;
    }

    public void setAutoIndexStation(boolean b) {
        this._autoIndexStation = b;
    }

    public void setGenerateCompPt(boolean b) {
        this._genCompPt = b;
    }

    public void setAutoBeginStation(boolean b) {
        this._autoBeginStation = b;
    }

    public void setAutoEndStation(boolean b) {
        this._autoEndStation = b;
    }

    public void setAutoBank(boolean tf) {
        this._autoBank = tf;
    }

    public boolean getAutoBank() {
        return this._autoBank;
    }

    public void copyInto(DataObject dobj) {
        if (dobj instanceof ImpactArea) {
            this.copyInto((ImpactArea)dobj);
        }
    }

    public boolean loadData() {
        this.setIgnoreModifiedEvents(true);
        if (!this._loaded || this._outOfDateData) {
            Object obj = this._dataList.loadObject((DataObject)this);
            if (obj instanceof ImpactArea) {
                this.copyInto((ImpactArea)obj);
            }
            if (super.loadData()) {
                this._loaded = true;
            }
            this.setModified(false);
        }
        this.setIgnoreModifiedEvents(false);
        return this._loaded;
    }

    public void copyInto(ImpactArea area) {
        if (area == null) {
            return;
        }
        super.copyInto((DataObject)area);
        this.setName(area.getName());
        this.setDescription(area.getDescription());
        this._streamId = area._streamId;
        this._bank = area._bank;
        this._indexStation = area._indexStation;
        this._beginStation = area._beginStation;
        this._endStation = area._endStation;
        this._northing = area._northing;
        this._easting = area._easting;
        this._referencePt = (WorldPt)area._referencePt.clone();
        this._labelPositionPt = (WorldPt)area._labelPositionPt.clone();
        this._region = (WorldRegion)area._region.clone();
        this._color = area._color;
        this._genCompPt = area._genCompPt;
        this._compPtId = area._compPtId;
        this._labelPosition = area._labelPosition;
        this._autoStream = area._autoStream;
        this._autoBank = area._autoBank;
        this._autoIndexStation = area._autoIndexStation;
        this._autoReferencePt = area._autoReferencePt;
        this._autoBeginStation = area._autoBeginStation;
        this._autoEndStation = area._autoEndStation;
        this._autoLabelPosition = area._autoLabelPosition;
    }

    public void copyInto(DataStruct dstruct) {
    }

    public void DataChanged(DataChangeEvent evt) {
    }

    public void locked(LockEvent evt) {
    }

    public boolean loadId() {
        return true;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public void computationPointMoved(ComputationPoint cpt) {
        if (cpt == null) {
            return;
        }
        if (cpt.getId() == this._compPtId) {
            this._streamId = cpt.getStreamId();
            this._indexStation = cpt.getStreamStation();
            this.setModified(true);
        }
    }

    @Override
    public void computationPointDeleted(ComputationPoint cpt) {
        if (cpt == null) {
            return;
        }
        if (cpt.getId() == this._compPtId) {
            this._compPtId = -1L;
            this._compPt = null;
        }
    }

    @Override
    public boolean hasComputationPoint() {
        return this._genCompPt && this._compPtId != -1L;
    }

    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return super.getFieldObject(fld);
        }
    }

    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return super.setFieldObject(fld, fobj);
        }
        catch (IllegalArgumentException e) {
            return super.setFieldObject(fld, fobj);
        }
    }

    public WorldRegion getRegion(int idx) {
        return this.getRegion();
    }

    public Color getRegionColor(int idx) {
        return this.getColor();
    }

    public int getRegionCount() {
        return 1;
    }

    public String getRegionDescription(int idx) {
        return this.getDescription();
    }

    public String getRegionName(int idx) {
        return this.getName();
    }

    public int getStreamIndex() {
        return this._streamId;
    }

    public String getStreamName() {
        return this._streamName;
    }

    public void setStreamIndex(int idx) {
        this._streamId = idx;
    }

    public void setStreamName(String name) {
        this._streamName = name;
    }
}

