/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.model;

import hec.io.AsciiSerializable;
import hec.map.WorldLine;
import hec.map.WorldLineHolder;
import hec.map.WorldPt;
import hec.model.DataObject;
import hec.model.StreamSegmentIdentifier;
import hec.watershed.model.ComputationPoint;
import hec.watershed.model.ComputationPointHolder;
import hec.watershed.model.Project;
import java.awt.Color;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class Levee
extends Project
implements Serializable,
AsciiSerializable,
ComputationPointHolder,
WorldLineHolder {
    static final long serialVersionUID = 208192224784671850L;
    public static final String MENU_NAME = "Levee";
    public static final int LEFT_BANK = -1;
    public static final int RIGHT_BANK = 1;
    public static final int BOTH_BANKS = 0;
    private int _bank = 0;
    private List<StreamSegmentIdentifier> _ssiList = new ArrayList<StreamSegmentIdentifier>();
    private int _avgOffset;
    private boolean _followsStream;
    private WorldLine _line = null;
    private long _startCompPtId = -1L;
    private long _endCompPtId = -1L;
    private transient ComputationPoint _startCompPt;
    private transient ComputationPoint _endCompPt;
    private double _breachElevation = Double.NEGATIVE_INFINITY;

    public double getBreachElevation() {
        return this._breachElevation;
    }

    public void setBreachElevation(double breachElevation) {
        this._breachElevation = breachElevation;
    }

    public void setBank(int bank) {
        if (bank != -1 && bank != 1 && bank != 0) {
            return;
        }
        this._bank = bank;
        this.setModified(true);
    }

    public void setStreamSegmentList(List<StreamSegmentIdentifier> ssiList) {
        this._ssiList.clear();
        if (ssiList == null) {
            return;
        }
        int size = ssiList.size();
        for (int i = --size; i >= 0; --i) {
            StreamSegmentIdentifier obj = ssiList.get(i);
            if (!(obj instanceof StreamSegmentIdentifier)) {
                ssiList.remove(i);
            }
            if (obj.isValid()) continue;
            ssiList.remove(i);
        }
        this._ssiList.addAll(ssiList);
    }

    public List<StreamSegmentIdentifier> getStreamSegmentList() {
        return this._ssiList;
    }

    public void setAveOffset(int avgoffset) {
        this._avgOffset = avgoffset;
        this.setModified(true);
    }

    public void setFollowsStream(boolean b) {
        this._followsStream = b;
        this.setModified(true);
    }

    public void setLine(WorldLine line) {
        this._line = line;
        if (this._line != null && this._line.pts.size() > 0) {
            this.setReferencePt((WorldPt)this._line.pts.elementAt(0));
        }
        this.setModified(true);
    }

    public int getBank() {
        return this._bank;
    }

    public int getAveOffset() {
        return this._avgOffset;
    }

    public boolean getFollowsStream() {
        return this._followsStream;
    }

    public WorldLine getLine() {
        return this._line;
    }

    @Override
    public String getUserDisplayedType() {
        return MENU_NAME;
    }

    @Override
    public String getLabelName() {
        return MENU_NAME;
    }

    @Override
    public void removeFromComputationPoint() {
        this.removeFromComputationPoint(true);
        this.removeFromComputationPoint(false);
    }

    protected void removeFromComputationPoint(boolean start) {
        ComputationPoint cp = this.getComputationPoint(start);
        if (cp != null) {
            cp.removeProject((DataObject)this);
            if (start) {
                this._startCompPt = null;
                this._startCompPtId = -1L;
            } else {
                this._endCompPt = null;
                this._endCompPtId = -1L;
            }
        }
    }

    public ComputationPoint getComputationPoint(boolean start) {
        if (start) {
            if (this._startCompPt == null && this._startCompPtId != -1L) {
                this._startCompPt = (ComputationPoint)this.getDataList().findObjectById(this._startCompPtId, "hec.watershed.model.ComputationPoint");
            }
            return this._startCompPt;
        }
        if (this._endCompPt == null && this._endCompPtId != -1L) {
            this._endCompPt = (ComputationPoint)this.getDataList().findObjectById(this._endCompPtId, "hec.watershed.model.ComputationPoint");
        }
        return this._endCompPt;
    }

    @Override
    public void updateComputationPoint() {
    }

    public boolean loadData() {
        if (!this._loaded || this._outOfDateData) {
            Object obj = this._dataList.loadObject((DataObject)this);
            if (obj instanceof Levee) {
                this.copyInto((Levee)obj);
            }
            if (super.loadData()) {
                this._loaded = true;
            }
            this.setModified(false);
        }
        return this._loaded;
    }

    @Override
    public void copyInto(DataObject dObj) {
        if (dObj instanceof Levee) {
            this.copyInto((Levee)dObj);
        }
    }

    public void copyInto(Levee levee) {
        if (levee == null || levee == this) {
            return;
        }
        super.copyInto((DataObject)levee);
        this._bank = levee._bank;
        this._ssiList.clear();
        if (levee._ssiList != null) {
            this._ssiList.addAll(levee._ssiList);
        }
        this._avgOffset = levee._avgOffset;
        this._followsStream = levee._followsStream;
        this._startCompPtId = levee._startCompPtId;
        this._endCompPtId = levee._endCompPtId;
        this._line = !this._followsStream ? levee._line : null;
        this.setModified(false);
    }

    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return super.getFieldObject(fld);
        }
    }

    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return super.setFieldObject(fld, fobj);
        }
        catch (IllegalArgumentException e) {
            return super.setFieldObject(fld, fobj);
        }
    }

    public WorldLine getLine(int idx) {
        return this._line;
    }

    public Color getLineColor(int idx) {
        return Color.black;
    }

    public int getLineCount() {
        return 1;
    }

    public String getLineDescription(int idx) {
        return this.getDescription();
    }

    public String getLineName(int idx) {
        return this.getName();
    }

    public int getStreamIndex() {
        if (this._ssiList.size() == 0) {
            return -1;
        }
        StreamSegmentIdentifier ss = this._ssiList.get(0);
        return ss.streamId;
    }

    @Override
    public String getStreamName() {
        if (this._ssiList.size() == 0) {
            return null;
        }
        StreamSegmentIdentifier ss = this._ssiList.get(0);
        return ss.streamName;
    }

    public void setStreamIndex(int idx) {
    }

    @Override
    public void setStreamName(String name) {
        if (this._ssiList.size() == 0) {
            return;
        }
        StreamSegmentIdentifier ss = this._ssiList.get(0);
        ss.streamName = name;
    }
}

