/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.model;

import hec.io.AsciiSerializable;
import hec.map.WorldPt;
import hec.model.DataObject;
import hec.watershed.model.ComputationPoint;
import hec.watershed.model.ComputationPointContainer;
import hec.watershed.model.ComputationPointHolder;
import hec.watershed.model.Project;
import java.io.Serializable;
import java.lang.reflect.Field;

public class OtherProject
extends Project
implements Serializable,
AsciiSerializable,
ComputationPointHolder {
    static final long serialVersionUID = -6638996006648756295L;
    public static final String MENU_NAME = "Other Project";
    private long _compPtId = -1L;
    private transient ComputationPoint _compPt;
    private boolean _genCompPt = true;
    private boolean _connectToStream = false;
    private int _iconPosition = 0;
    private double _streamStation = 0.0;

    public void setStreamStation(double station) {
        this._streamStation = station;
        this.setModified(true);
    }

    public double getStreamStation() {
        return this._streamStation;
    }

    public void setIconPosition(int pos) {
        this._iconPosition = pos;
        this.setModified(true);
    }

    public int getIconPosition() {
        return this._iconPosition;
    }

    public boolean isConnectedToStream() {
        return this._connectToStream;
    }

    public void setConnectedtoStream(boolean b) {
        this._connectToStream = b;
        this.setModified(true);
    }

    @Override
    public String getUserDisplayedType() {
        return "Other";
    }

    @Override
    public String getLabelName() {
        return MENU_NAME;
    }

    public boolean getGenerateCompPt() {
        return this._genCompPt;
    }

    public void setGenerateCompPt(boolean gen) {
        this._genCompPt = gen;
        this.setModified(true);
    }

    @Override
    public void updateComputationPoint() {
        ComputationPointContainer dl = (ComputationPointContainer)this._dataList.getCommonDataListContainer().getCommonDataList("hec.watershed.model.ComputationPoint");
        if (dl == null) {
            return;
        }
        if (!this._genCompPt) {
            this.removeFromComputationPoint();
            return;
        }
        if (this._compPt == null) {
            this._compPt = (ComputationPoint)dl.getObject(this._compPtId);
        }
        if (this._compPt != null && this._compPt.isAutoGenerated() && this._compPt.getProjects().size() == 1) {
            this._compPt.setStreamId(this._streamId);
            this._compPt.setReferencePt((WorldPt)this._referencePt.clone());
            return;
        }
        ComputationPoint cp = dl.getComputationPointAt(this._referencePt, 15.0);
        if (cp == null) {
            this.removeFromComputationPoint();
            cp = (ComputationPoint)dl.newDataObject("CP", "Computation Point for Other Project " + this.getName());
            cp.setAutoGenerated(true);
            cp.setStreamId(this._streamId);
            cp.setReferencePt((WorldPt)this._referencePt.clone());
            cp.setSnapToStream(false);
            cp.addProject((DataObject)this);
            cp = (ComputationPoint)dl.addNewObject2((DataObject)cp);
            if (cp != null) {
                cp = (ComputationPoint)dl.getObject(cp.getId());
                cp.setName(cp.getName() + cp.getId());
            }
        } else if (cp.getId() != this._compPtId) {
            this.removeFromComputationPoint();
            cp.addProject((DataObject)this);
        } else {
            return;
        }
        this._compPt = cp;
        this._compPtId = cp.getId();
        this.setModified(true);
    }

    public ComputationPoint getComputationPoint() {
        if (this._compPt == null && this._compPtId != -1L) {
            ComputationPoint cp;
            this._compPt = cp = (ComputationPoint)this.getDataList().findObjectById(this._compPtId, "hec.watershed.model.ComputationPoint");
        }
        return this._compPt;
    }

    @Override
    public void removeFromComputationPoint() {
        ComputationPoint cp = this.getComputationPoint();
        if (cp != null) {
            cp.removeProject((DataObject)this);
            if (cp.isAutoGenerated() && cp.getProjects().size() == 0) {
                cp.getDataList().removeObject(cp.getId());
            }
            this._compPt = null;
            this._compPtId = -1L;
        }
    }

    public boolean loadData() {
        if (!this._loaded || this._outOfDateData) {
            Object obj = this._dataList.loadObject((DataObject)this);
            if (obj instanceof OtherProject) {
                this.copyInto((OtherProject)obj);
            }
            if (super.loadData()) {
                this._loaded = true;
            }
            this.setModified(false);
        }
        return this._loaded;
    }

    public void copyInto(OtherProject op) {
        if (op == null) {
            return;
        }
        super.copyInto((DataObject)op);
        this._compPtId = op._compPtId;
    }

    @Override
    public void computationPointMoved(ComputationPoint cpt) {
        if (cpt == null) {
            return;
        }
        if (cpt.getId() == this._compPtId) {
            this._referencePt.init(cpt.getReferencePt());
            this.setModified(true);
        }
    }

    @Override
    public boolean hasComputationPoint() {
        return this.getComputationPoint() != null;
    }

    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return super.getFieldObject(fld);
        }
    }

    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return super.setFieldObject(fld, fobj);
        }
        catch (IllegalArgumentException e) {
            return super.setFieldObject(fld, fobj);
        }
    }

    public int getStreamIndex() {
        return -1;
    }

    public void setStreamIndex(int idx) {
    }
}

