/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.model;

import hec.event.DataChangeEvent;
import hec.event.LockEvent;
import hec.map.MapLabelItem;
import hec.map.WorldPt;
import hec.map.streamAlignment.StreamAlignmentIfc;
import hec.model.AbstractDataObject;
import hec.model.DataObject;
import hec.model.DataStruct;
import hec.model.StreamReferenceHolder;
import hec.watershed.model.ComputationPoint;
import java.io.Serializable;

public abstract class Project
extends AbstractDataObject
implements Serializable,
StreamReferenceHolder {
    static final long serialVersionUID = 344583493323138333L;
    public static final String[] KNOWN_PROJECT_TYPES = new String[]{"hec.watershed.model.Reservoir", "hec.watershed.model.Levee", "hec.watershed.model.ChannelMod", "hec.watershed.model.Diversion", "hec.watershed.model.StoragePool", "hec.watershed.model.OtherProject"};
    protected boolean _isExisting = false;
    protected int _streamId = -1;
    protected WorldPt _referencePt = new WorldPt();
    protected boolean _isCorpsProject = false;
    protected short _yearInService = (short)1900;
    protected int _labelPosition = 2;
    protected String _streamName;
    private String _alignmentName;
    private transient StreamAlignmentIfc _alignment;

    public void setIsExisting(boolean isExisting) {
        this._isExisting = isExisting;
        this.setModified(true);
    }

    public void setIsCorpsProject(boolean corpsProject) {
        this._isCorpsProject = corpsProject;
        this.setModified(true);
    }

    public boolean isCorpsProject() {
        return this._isCorpsProject;
    }

    public boolean isExisting() {
        return this._isExisting;
    }

    public void setStreamId(int streamId) {
        this._streamId = streamId;
        this.setModified(true);
    }

    public int getStreamId() {
        return this._streamId;
    }

    public void setStreamName(String streamName) {
        this._streamName = streamName;
    }

    public String getStreamName() {
        return this._streamName;
    }

    public void setStreamAlignment(StreamAlignmentIfc alignment) {
        if (alignment != null) {
            this._alignmentName = alignment.getName();
            this._alignment = alignment;
        } else {
            this._alignment = null;
            this._alignmentName = null;
        }
    }

    public String getStreamAlignmentName() {
        return this._alignmentName;
    }

    public StreamAlignmentIfc getStreamAlignment() {
        return this._alignment;
    }

    public short getYearInService() {
        return this._yearInService;
    }

    public void setYearInService(short yis) {
        this._yearInService = yis;
        this.setModified(true);
    }

    public void copyInto(DataObject dobj) {
        if (dobj instanceof Project) {
            Project p = (Project)dobj;
            this.setIgnoreModifiedEvents(true);
            try {
                this.setName(dobj.getName());
                this.setDescription(dobj.getDescription());
                this._isExisting = p._isExisting;
                this._isCorpsProject = p._isCorpsProject;
                this._streamId = p._streamId;
                this._referencePt.init(p._referencePt);
                this._yearInService = p._yearInService;
            }
            finally {
                this.setIgnoreModifiedEvents(false);
            }
        }
    }

    public void setLabelPosition(int position) {
        if (position < 0 || position >= MapLabelItem.POSITION_STRINGS.length) {
            return;
        }
        this._labelPosition = position;
        this.setModified(true);
    }

    public int getLabelPosition() {
        return this._labelPosition;
    }

    public void copyInto(DataStruct dstruct) {
    }

    public void DataChanged(DataChangeEvent evt) {
    }

    public void locked(LockEvent evt) {
    }

    public boolean loadId() {
        return true;
    }

    public String getType() {
        return this.getClass().getName();
    }

    public abstract String getUserDisplayedType();

    public abstract String getLabelName();

    public String toString() {
        return this.getName();
    }

    public void setReferencePt(WorldPt pt) {
        if (pt == null) {
            this._referencePt.init(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        } else {
            this._referencePt.init(pt);
        }
        this.setModified(true);
    }

    public WorldPt getReferencePt() {
        return this._referencePt;
    }

    public void computationPointMoved(ComputationPoint cpt) {
    }

    public void computationPointDeleted(ComputationPoint cpt) {
    }

    public boolean hasComputationPoint() {
        return false;
    }
}

