/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.model;

import hec.io.AsciiSerializable;
import hec.model.DataObject;
import hec.watershed.model.Project;
import java.io.Serializable;
import java.lang.reflect.Field;

public class ProjectRef
implements Serializable,
AsciiSerializable {
    static final long serialVersionUID = 5583053550794403219L;
    private long _id;
    private String _type;
    private String _notes;
    public transient boolean needsRemoved = false;

    public ProjectRef() {
    }

    public ProjectRef(long id, String type, String notes) {
        if (type == null) {
            throw new IllegalArgumentException("Object type can not be null");
        }
        this._id = id;
        this._type = type;
        this._notes = notes;
    }

    public ProjectRef(DataObject dobj, String type, String notes) {
        if (dobj == null) {
            throw new IllegalArgumentException("Data Object can not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Object type can not be null");
        }
        this._id = dobj.getId();
        this._type = type;
        this._notes = notes;
    }

    public ProjectRef(Project proj, String notes) {
        if (proj == null) {
            throw new IllegalArgumentException("Project can not be null");
        }
        this._id = proj.getId();
        this._type = proj.getType();
        this._notes = notes;
    }

    public long getProjectId() {
        return this._id;
    }

    public String getProjectType() {
        return this._type;
    }

    public String getNotes() {
        return this._notes;
    }

    public void setNotes(String notes) {
        this._notes = notes;
    }

    public String toString() {
        int idx = this._type.lastIndexOf(46);
        return this._type.substring(idx + 1) + " " + this._id;
    }

    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

