/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.model;

import hec.appInterface.AppDaddy;
import hec.io.AsciiSerializable;
import hec.map.WorldLine;
import hec.map.WorldLineHolder;
import hec.map.WorldPt;
import hec.map.WorldRegion;
import hec.map.WorldRegionHolder;
import hec.map.streamAlignment.StreamAlignmentIfc;
import hec.model.CommonDataList;
import hec.model.DataObject;
import hec.model.DataStruct;
import hec.model.Node;
import hec.model.StreamElement;
import hec.model.StreamPolyLine;
import hec.model.StreamSegment;
import hec.watershed.model.ComputationPoint;
import hec.watershed.model.ComputationPointContainer;
import hec.watershed.model.ComputationPointHolder;
import hec.watershed.model.Diversion;
import hec.watershed.model.Project;
import hec.watershed.model.StudyContainer;
import hec.watershed.model.StudyIfc;
import hec.watershed.model.StudyRegion;
import java.awt.Color;
import java.awt.Component;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Vector;
import javax.swing.JOptionPane;
import rma.util.RMAConst;

public class Reservoir
extends Project
implements Serializable,
AsciiSerializable,
StudyRegion,
ComputationPointHolder,
WorldRegionHolder,
WorldLineHolder {
    protected static int maxPtArraySz = 10000;
    protected static int[] xarray = new int[maxPtArraySz];
    protected static int[] yarray = new int[maxPtArraySz];
    static final long serialVersionUID = -195919453472069769L;
    public static final int OUTFLOW = 0;
    public static final int INFLOW = 1;
    public static final String MENU_NAME = "Reservoir";
    private WorldRegion _region = new WorldRegion();
    private Vector<Node> _nodeVec = new Vector();
    private Vector<Integer> _nodeDirVector = new Vector();
    private Vector<StreamSegment> _streamSegmentVector;
    private long[] _compPtIdArray;
    private transient ComputationPoint[] _compPtArray;
    private transient ComputationPoint _upstreamCompPt;
    private long _upstreamCompPtId = -1L;
    private transient ComputationPoint _downstreamCompPt;
    private long _downstreamCompPtId = -1L;

    public Vector<StreamSegment> getStreamSegmentVector() {
        return this._streamSegmentVector;
    }

    public StreamSegment getStreamSegment(int streamId) {
        Vector<StreamSegment> v = this.getStreamSegmentVector();
        if (v == null) {
            return null;
        }
        for (int i = 0; i < v.size(); ++i) {
            StreamSegment ss = v.get(i);
            if (ss == null || ss.streamIndex != streamId) continue;
            return ss;
        }
        return null;
    }

    public StreamSegment getStreamSegment(String streamName) {
        Vector<StreamSegment> v = this.getStreamSegmentVector();
        if (v == null) {
            return null;
        }
        for (int i = 0; i < v.size(); ++i) {
            StreamSegment ss = v.get(i);
            if (ss == null || ss.streamName == null || !ss.streamName.equals(streamName)) continue;
            return ss;
        }
        return null;
    }

    public void setStreamSegmentVector(Vector<StreamSegment> segvec) {
        this._streamSegmentVector = segvec;
    }

    @Override
    public WorldRegion getRegion() {
        return this._region;
    }

    public void setRegion(WorldRegion reg) {
        if (reg == null) {
            return;
        }
        this._region = (WorldRegion)reg.clone();
        if (this._region.pts.size() > 1) {
            this.setReferencePt((WorldPt)this._region.pts.elementAt(1));
        }
    }

    private void updateReferencePt() {
        for (int i = 0; i < this._region.pts.size(); ++i) {
            WorldPt pt = (WorldPt)this._region.pts.elementAt(i);
            if (pt == null) continue;
            if (i == 0) {
                this._referencePt.init(pt);
                continue;
            }
            this._referencePt.e += pt.e;
            this._referencePt.n += pt.n;
        }
        double xnum = this._region.pts.size();
        if (xnum > 1.0) {
            this._referencePt.e /= xnum;
            this._referencePt.n /= xnum;
        }
    }

    public void addNode(Node node, int idir) {
        this._nodeVec.addElement(node);
        this._nodeDirVector.addElement(new Integer(idir));
    }

    public Vector<Node> getNodeVector() {
        return this._nodeVec;
    }

    public Vector<Integer> getNodeDirVector() {
        return this._nodeDirVector;
    }

    public Node getDownstreamNode() {
        for (int i = 0; i < this._nodeVec.size(); ++i) {
            Node node = this._nodeVec.elementAt(i);
            Integer ndir = this._nodeDirVector.elementAt(i);
            if (ndir != 0) continue;
            return node;
        }
        return null;
    }

    public Node getUpstreamNode() {
        for (int i = 0; i < this._nodeVec.size(); ++i) {
            Node node = this._nodeVec.elementAt(i);
            Integer ndir = this._nodeDirVector.elementAt(i);
            if (ndir != 1) continue;
            return node;
        }
        return null;
    }

    @Override
    public String getUserDisplayedType() {
        return MENU_NAME;
    }

    @Override
    public String getLabelName() {
        return MENU_NAME;
    }

    @Override
    public void removeFromComputationPoint() {
        if (this._compPtIdArray == null) {
            return;
        }
        for (int i = 0; i < this._compPtIdArray.length; ++i) {
            this.removeFromComputationPoint(i);
        }
        this._compPtArray = null;
    }

    public ComputationPoint getComputationPointAt(int i) {
        if (this._compPtIdArray == null || i < 0 || i >= this._compPtIdArray.length) {
            return null;
        }
        return this.getComputationPoint(this._compPtIdArray[i]);
    }

    ComputationPoint getComputationPoint(long cptId) {
        CommonDataList dl = this.getDataList().getCommonDataListContainer().getCommonDataList("hec.watershed.model.ComputationPoint");
        return (ComputationPoint)dl.getObject(cptId);
    }

    protected void removeFromComputationPoint(int i) {
        if (this._compPtIdArray == null) {
            return;
        }
        if (i < 0 || i > this._compPtIdArray.length) {
            return;
        }
        ComputationPoint cp = this.getComputationPoint(this._compPtIdArray[i]);
        if (cp != null) {
            cp.removeProject((DataObject)this);
            if (cp.isAutoGenerated() && cp.getProjects().size() == 0) {
                cp.getDataList().removeObject(cp.getId());
            }
            this._compPtIdArray[i] = -1L;
            if (this._compPtArray != null) {
                this._compPtArray[i] = null;
            }
        }
    }

    @Deprecated
    public ComputationPoint getComputationPoint_old(boolean upstream) {
        if (upstream) {
            if (this._upstreamCompPt == null && this._upstreamCompPtId != -1L) {
                this._upstreamCompPt = (ComputationPoint)this.getDataList().findObjectById(this._upstreamCompPtId, "hec.watershed.model.ComputationPoint");
            }
            return this._upstreamCompPt;
        }
        if (this._downstreamCompPt == null && this._downstreamCompPtId != -1L) {
            this._downstreamCompPt = (ComputationPoint)this.getDataList().findObjectById(this._downstreamCompPtId, "hec.watershed.model.ComputationPoint");
        }
        return this._downstreamCompPt;
    }

    @Override
    public void updateComputationPoint() {
        ComputationPointContainer dl = (ComputationPointContainer)this._dataList.getCommonDataListContainer().getCommonDataList("hec.watershed.model.ComputationPoint");
        if (dl == null) {
            return;
        }
        if (this._nodeVec == null || this._nodeVec.size() < 1) {
            return;
        }
        int numNodes = this._nodeVec.size();
        this.checkCompPtArrays();
        for (int i = 0; i < numNodes; ++i) {
            Node node = this._nodeVec.elementAt(i);
            if (node == null) continue;
            this.updateComputationPoint(node, i, dl);
        }
        this.setModified(true);
    }

    private void checkCompPtArrays() {
        int numNodes = this._nodeVec.size();
        if (this._compPtIdArray == null || this._compPtIdArray.length != numNodes) {
            this._compPtIdArray = new long[numNodes];
            this._compPtArray = new ComputationPoint[numNodes];
            for (int i = 0; i < this._compPtIdArray.length; ++i) {
                this._compPtIdArray[i] = -1L;
            }
        }
    }

    private boolean usingComputationPoint(ComputationPoint pt, int idx) {
        if (pt == null) {
            return false;
        }
        long cpId = pt.getId();
        for (int i = 0; i < this._compPtIdArray.length; ++i) {
            if (i == idx || this._compPtIdArray[i] != cpId) continue;
            return true;
        }
        return false;
    }

    public void updateComputationPoint(Node node) {
        if (node == null) {
            return;
        }
        for (int i = 0; i < this._nodeVec.size(); ++i) {
            if (node != this._nodeVec.get(i)) continue;
            ComputationPointContainer dl = (ComputationPointContainer)this._dataList.getCommonDataListContainer().getCommonDataList("hec.watershed.model.ComputationPoint");
            this.updateComputationPoint(node, i, dl);
        }
    }

    private void updateComputationPoint(Node node, int i, ComputationPointContainer dl) {
        ComputationPoint cp = (ComputationPoint)dl.getObject(this._compPtIdArray[i]);
        if (cp != null && cp.isAutoGenerated() && cp.getProjects().size() == 1) {
            cp.setStreamId(node.getStreamIndex());
            cp.setReferencePt(node.getLocation());
            cp.setStreamStation(node.getStreamStation());
            cp.setStreamCoord(node.getStreamCoord());
            return;
        }
        cp = dl.getComputationPointAt(node.getLocation(), 15.0);
        Integer nodeDir = this._nodeDirVector.get(i);
        if (cp != null && cp.getId() != this._compPtIdArray[i] && !this.usingComputationPoint(cp, i)) {
            Object[] opts = new Object[]{"Existing computation point", "New Computation Point"};
            int opt = JOptionPane.showOptionDialog((Component)AppDaddy.getFrame(), "An Existing Computation Point, " + cp.getName() + ", was found.\nConnect " + this.getName() + "'s " + (nodeDir == 1 ? "Inflow" : "Outflow") + " Location to:", "Computation Point Found", 0, 3, null, opts, opts[0]);
            if (opt == 1) {
                cp = null;
            }
        }
        if (cp == null || this.usingComputationPoint(cp, i)) {
            this.removeFromComputationPoint(i);
            cp = (ComputationPoint)dl.newDataObject("CP", (nodeDir == 1 ? "Inflow" : "Outflow") + " for Reservoir " + this.getName());
            cp.setAutoGenerated(true);
            cp.setStreamId(node.getStreamIndex());
            cp.setStreamStation(node.getStreamStation());
            cp.setStreamCoord(node.getStreamCoord());
            cp.setReferencePt(new WorldPt(node.getLocation()));
            cp.setSnapToStream(true);
            cp.addProject((DataObject)this);
            cp = (ComputationPoint)dl.addNewObject2((DataObject)cp);
            if (cp != null) {
                cp = (ComputationPoint)dl.getObject(cp.getId());
                cp.setName(cp.getName() + cp.getId());
                if (this._compPtArray != null) {
                    this._compPtArray[i] = cp;
                }
                this._compPtIdArray[i] = cp.getId();
                this.setModified(true);
            }
        } else if (cp.getId() != this._compPtIdArray[i]) {
            StreamElement elem;
            this.removeFromComputationPoint(i);
            cp.setStreamId(node.getStreamIndex());
            cp.setStreamStation(node.getStreamStation());
            cp.setStreamCoord(node.getStreamCoord());
            cp.setSnapToStream(true);
            cp.addProject((DataObject)this);
            node.setStreamIndex(cp.getStreamId());
            node.setStreamCoord(cp.getStreamCoord());
            node.setStreamStation(cp.getStreamStation());
            if (RMAConst.isUndefinedValue((double)node.getStreamCoord()) && (elem = cp.getStream()) != null) {
                node.setStreamCoord(elem.getCoordByStation(cp.getStreamStation()));
            }
            if (this._compPtArray != null) {
                this._compPtArray[i] = cp;
            }
            this._compPtIdArray[i] = cp.getId();
            this.computationPointMoved(cp);
            this.setModified(true);
        }
    }

    public boolean loadData() {
        if (!this._loaded || this._outOfDateData) {
            Object obj = this._dataList.loadObject((DataObject)this);
            if (obj instanceof Reservoir) {
                this.copyInto((Reservoir)obj);
            }
            if (super.loadData()) {
                this._loaded = true;
            }
            this.setModified(false);
        }
        return this._loaded;
    }

    public void copyInto(Reservoir res) {
        if (res == null || res == this) {
            if (this._compPtArray == null && this._compPtIdArray != null && this._compPtArray.length != this._compPtIdArray.length) {
                this._compPtArray = new ComputationPoint[this._compPtIdArray.length];
            }
            return;
        }
        super.copyInto((DataObject)res);
        this._region = (WorldRegion)res._region.clone();
        this._nodeVec = (Vector)res._nodeVec.clone();
        this._nodeDirVector = (Vector)res._nodeDirVector.clone();
        if (res._compPtIdArray != null) {
            this._compPtIdArray = new long[res._compPtIdArray.length];
            System.arraycopy(res._compPtIdArray, 0, this._compPtIdArray, 0, this._compPtIdArray.length);
        }
        this._upstreamCompPtId = res._upstreamCompPtId;
        this._downstreamCompPtId = res._downstreamCompPtId;
    }

    @Override
    public void computationPointMoved(ComputationPoint cpt) {
        if (cpt == null) {
            return;
        }
        StudyContainer studydl = (StudyContainer)this._dataList.getCommonDataListContainer().getCommonDataList("hec.watershed.model.Study");
        StreamAlignmentIfc alignment = null;
        if (studydl != null) {
            StudyIfc study = studydl.getOpenStudy();
            alignment = study.getAlignment();
        }
        for (int i = 0; i < this._compPtIdArray.length; ++i) {
            if (this._compPtIdArray[i] != cpt.getId()) continue;
            if (i >= this._nodeVec.size()) {
                return;
            }
            Node n = this._nodeVec.get(i);
            if (n == null) {
                return;
            }
            n.setStreamIndex(cpt.getStreamId());
            n.setStreamStation(cpt.getStreamStation());
            n.setStreamCoord(cpt.getStreamCoord());
            n.setLocation(cpt.getReferencePt());
            if (alignment != null) {
                Vector ndirVec = new Vector();
                Vector<StreamSegment> segVec = new Vector<StreamSegment>();
                String errstr = null;
                errstr = alignment.getStreamSegmentsByNodes(this.getNodeVector(), ndirVec, segVec);
                if (errstr != null) {
                    System.out.println("Cannot change reservoir node location");
                    return;
                }
                this.getNodeDirVector().removeAllElements();
                this.getNodeDirVector().addAll(ndirVec);
                this.setStreamSegmentVector(segVec);
                this.setModified(true);
            }
            this.setModified(true);
            return;
        }
    }

    @Override
    public void computationPointDeleted(ComputationPoint cpt) {
        if (cpt == null) {
            return;
        }
        long cptId = cpt.getId();
        if (this._compPtIdArray == null) {
            return;
        }
        for (int i = 0; i < this._compPtIdArray.length; ++i) {
            if (this._compPtIdArray[i] != cptId) continue;
            Node node = this._nodeVec.get(i);
            node.setStreamIndex(cpt.getStreamId());
            node.setStreamCoord(cpt.getStreamCoord());
            node.setStreamStation(cpt.getStreamStation());
            this.removeFromComputationPoint(i);
            this.updateComputationPoint(this._nodeVec.get(i), i, (ComputationPointContainer)cpt.getDataList());
        }
    }

    public void delete() {
        CommonDataList divdl = this.getDataList().getCommonDataListContainer().getCommonDataList("hec.watershed.model.Diversion");
        DataStruct[] objs = divdl.getObjectArray();
        this.getStreamSegmentVector();
        for (int i = 0; i < objs.length; ++i) {
            Diversion div = (Diversion)objs[i];
            if (div.getReservoirId() != this.getId()) continue;
            div.getDataList().removeObject(div.getId());
        }
    }

    @Override
    public int getStreamId() {
        for (int i = this._nodeDirVector.size() - 1; i >= 0; --i) {
            Integer ndir = this._nodeDirVector.get(i);
            if (ndir != 0) continue;
            Node node = this._nodeVec.get(i);
            return node.getStreamIndex();
        }
        return super.getStreamId();
    }

    @Override
    public boolean hasComputationPoint() {
        return true;
    }

    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return super.getFieldObject(fld);
        }
    }

    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return super.setFieldObject(fld, fobj);
        }
        catch (IllegalArgumentException e) {
            return super.setFieldObject(fld, fobj);
        }
    }

    public WorldRegion getRegion(int idx) {
        if (idx == 0) {
            return this.getRegion();
        }
        Vector<StreamSegment> streamSegments = this.getStreamSegmentVector();
        if (streamSegments != null && --idx < streamSegments.size()) {
            StreamSegment ss = streamSegments.get(idx);
            return this.getRegionForSegment(ss);
        }
        return null;
    }

    public Color getRegionColor(int idx) {
        return Color.BLUE;
    }

    public int getRegionCount() {
        return 1;
    }

    public String getRegionDescription(int idx) {
        return this.getDescription();
    }

    public String getRegionName(int idx) {
        if (idx == 0) {
            return this.getName() + " Pool";
        }
        Vector<StreamSegment> streamSegments = this.getStreamSegmentVector();
        if (streamSegments != null && --idx < streamSegments.size()) {
            StreamSegment ss = streamSegments.get(idx);
            return this.getName() + "Reach:" + ss.getStreamName();
        }
        return "";
    }

    public int getStreamIndex() {
        Node n = this.getDownstreamNode();
        if (n != null) {
            return n.getStreamIndex();
        }
        return Integer.MIN_VALUE;
    }

    public void setStreamIndex(int idx) {
    }

    public WorldRegion getRegionForSegment(StreamSegment ss) {
        if (ss == null) {
            return null;
        }
        WorldLine line = this.getLineForSegment(ss);
        if (line != null) {
            int li = line.getLocalRegionArrays(null, xarray, yarray, 3.0);
            WorldRegion region = new WorldRegion();
            for (int i = 0; i < li; ++i) {
                region.pts.add(new WorldPt((double)xarray[i], (double)yarray[i]));
            }
            return region;
        }
        return null;
    }

    public WorldLine getLineForSegment(StreamSegment ss) {
        double c1;
        StreamElement strm;
        StreamAlignmentIfc align = this.getStreamAlignment();
        if (align == null) {
            return null;
        }
        if (ss == null) {
            return null;
        }
        String streamName = ss.streamName;
        if (streamName != null) {
            strm = align.findReach(ss.streamIndex);
        } else {
            strm = align.findReach(ss.streamIndex);
            if (strm != null) {
                ss.streamName = strm.getName();
            }
        }
        if (strm == null) {
            return null;
        }
        double c0 = ss.downstreamStation != Double.NEGATIVE_INFINITY ? strm.getCoordByStation(ss.downstreamStation) : ss.downstreamCoord;
        if (c0 == (c1 = ss.upstreamStation != Double.NEGATIVE_INFINITY ? strm.getCoordByStation(ss.upstreamStation) : ss.upstreamCoord)) {
            return null;
        }
        StreamPolyLine line = strm.getLineSegment(c0, c1);
        return line;
    }

    public WorldLine getLine(int idx) {
        Vector<StreamSegment> streamSegments = this.getStreamSegmentVector();
        if (streamSegments != null) {
            StreamSegment segment = streamSegments.get(idx);
            WorldLine line = this.getLineForSegment(segment);
            return line;
        }
        return null;
    }

    public Color getLineColor(int idx) {
        return Color.BLUE;
    }

    public int getLineCount() {
        int cnt = 0;
        Vector<StreamSegment> streamSegments = this.getStreamSegmentVector();
        if (streamSegments != null) {
            cnt = streamSegments.size();
        }
        return cnt;
    }

    public String getLineDescription(int idx) {
        return "";
    }

    public String getLineName(int idx) {
        boolean cnt = false;
        Vector<StreamSegment> streamSegments = this.getStreamSegmentVector();
        if (streamSegments != null) {
            StreamSegment segment = streamSegments.get(idx);
            String name = segment.getStreamName();
            if (name == null || name.isEmpty()) {
                StreamElement stream;
                StreamAlignmentIfc align = this.getStreamAlignment();
                if (align != null && (stream = align.findReach(segment.streamIndex)) != null) {
                    return stream.getName();
                }
            } else {
                return name;
            }
        }
        return "";
    }
}

