/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.rma.geojson.Feature;
import com.rma.geojson.Id;
import hec.map.WorldPt;
import hec.watershed.client.ObsStationSnapPoint;

@JsonTypeInfo(property="type", use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY)
@JsonSubTypes(value={@JsonSubTypes.Type(value=Station.class, name="Feature")})
public class Station
extends Feature {
    private static final Id<String> NAME = new Id("name");
    private static final Id<String> DESCRIPTION = new Id("description");
    private static final Id<String> STREAM_NAME = new Id("streamName");
    private static final Id<Double> STREAM_STATION = new Id("streamStation");
    private static final Id<Double> ELEVATION = new Id("elevation");
    private static final Id<Double> LATITUDE = new Id("latitude");
    private static final Id<Double> LONGITUDE = new Id("longitude");
    private static final Id<Integer> NEAREST_MERIDIAN = new Id("nearestMeridian");
    private static final Id<String> LOCATION_ID = new Id("locationId");
    private static final Id<Boolean> OBSERVED_STATION = new Id("isObservedStation");
    private static final Id<Boolean> MET_STATION = new Id("isMetStation");
    private static final Id<Boolean> SNAP_TO_STREAM_ELEMENT = new Id("snapToStreamElement");
    private static final Id<String> LABEL_POSITION = new Id("labelposition");
    private static final Id<Integer> COMPUTATION_PT_ID = new Id("computationPointId");
    private static final Id<Double> STATION_ICON_LONG = new Id("stationIconLongitude");
    private static final Id<Double> STATION_ICON_LAT = new Id("stationIconLatitude");
    private static final Id<Boolean> PROFILE_STATION = new Id("isProfileStation");
    @JsonIgnore
    private ObsStationSnapPoint _snapPoint;
    @JsonIgnore
    private WorldPt _stationIconLocation;

    public Station() {
        super.setProperty(LABEL_POSITION, (Object)"EAST");
        super.setProperty(MET_STATION, (Object)true);
    }

    @JsonIgnore
    public int getComputationPointId() {
        Integer value = (Integer)super.getProperty(COMPUTATION_PT_ID);
        return value != null ? value : -1;
    }

    public void setComputationPointId(int computationPointId) {
        super.setProperty(COMPUTATION_PT_ID, (Object)computationPointId);
    }

    @JsonIgnore
    public boolean isProfileStation() {
        Boolean value = (Boolean)super.getProperty(PROFILE_STATION);
        return value != null && value != false;
    }

    public void setIsProfileStation(boolean isProfileStation) {
        super.setProperty(PROFILE_STATION, (Object)isProfileStation);
    }

    @JsonIgnore
    public String getName() {
        return (String)super.getProperty(NAME);
    }

    public void setName(String name) {
        super.setProperty(NAME, (Object)name);
    }

    @JsonIgnore
    public String getDescription() {
        return (String)super.getProperty(DESCRIPTION);
    }

    public void setDescription(String description) {
        super.setProperty(DESCRIPTION, (Object)description);
    }

    @JsonIgnore
    public String getStreamName() {
        return (String)super.getProperty(STREAM_NAME);
    }

    public void setStreamName(String streamName) {
        this.setProperty(STREAM_NAME, streamName);
    }

    @JsonIgnore
    public double getStreamStation() {
        Double value = (Double)super.getProperty(STREAM_STATION);
        return value != null ? value : 0.0;
    }

    public void setStreamStation(double streamStation) {
        this.setProperty(STREAM_STATION, streamStation);
    }

    @JsonIgnore
    public double getElevation() {
        Double value = (Double)super.getProperty(ELEVATION);
        return value != null ? value : 0.0;
    }

    public void setElevation(double elevation) {
        this.setProperty(ELEVATION, elevation);
    }

    @JsonIgnore
    public int getNearestMeridian() {
        Integer value = (Integer)super.getProperty(NEAREST_MERIDIAN);
        return value != null ? value : 0;
    }

    public void setNearestMeridian(int nearestMeridian) {
        this.setProperty(NEAREST_MERIDIAN, nearestMeridian);
    }

    @JsonIgnore
    public Double getStationIconLongitude() {
        return (Double)super.getProperty(STATION_ICON_LONG);
    }

    public void setStationIconLongitude(Double stationIconLongitude) {
        this.setProperty(STATION_ICON_LONG, stationIconLongitude);
    }

    @JsonIgnore
    public Double getStationIconLatitude() {
        return (Double)super.getProperty(STATION_ICON_LAT);
    }

    public void setStationIconLatitude(Double stationIconLatitude) {
        this.setProperty(STATION_ICON_LAT, stationIconLatitude);
    }

    @JsonIgnore
    public String getLocationId() {
        return (String)super.getProperty(LOCATION_ID);
    }

    public void setLocationId(String locationId) {
        this.setProperty(LOCATION_ID, locationId);
    }

    @JsonIgnore
    public boolean isObservedStation() {
        Boolean value = (Boolean)super.getProperty(OBSERVED_STATION);
        return value != null ? value : false;
    }

    public void setIsObservedStation(boolean isObservedStation) {
        super.setProperty(OBSERVED_STATION, (Object)isObservedStation);
    }

    @JsonIgnore
    public boolean isMetStation() {
        Boolean value = (Boolean)super.getProperty(MET_STATION);
        return value != null ? value : false;
    }

    public void setIsMetStation(boolean isMetStation) {
        super.setProperty(MET_STATION, (Object)isMetStation);
    }

    public double getLongitude() {
        Double value = (Double)super.getProperty(LONGITUDE);
        return value != null ? value : 0.0;
    }

    public void setLongitude(double value) {
        super.setProperty(LONGITUDE, (Object)value);
    }

    public double getLatitude() {
        Double value = (Double)super.getProperty(LATITUDE);
        return value != null ? value : 0.0;
    }

    public void setLatitude(double value) {
        super.setProperty(LATITUDE, (Object)value);
    }

    public String getLabelPosition() {
        return (String)this.getProperty(LABEL_POSITION);
    }

    public void setLabelPosition(String position) {
        this.setProperty(LABEL_POSITION, position);
    }

    public String toString() {
        return this.getName();
    }

    @JsonIgnore
    public void setSnapPoint(ObsStationSnapPoint snapPoint) {
        this._snapPoint = snapPoint;
    }

    @JsonIgnore
    public ObsStationSnapPoint getSnapPoint() {
        return this._snapPoint;
    }

    @JsonIgnore
    public void setStationIconLocation(WorldPt stationIconDragPt) {
        this._stationIconLocation = stationIconDragPt;
        this.setProperty(STATION_ICON_LONG, stationIconDragPt.e);
        this.setProperty(STATION_ICON_LAT, stationIconDragPt.n);
    }

    @JsonIgnore
    public WorldPt getStationIconLocation() {
        if (this.getStationIconLongitude() != null && this.getStationIconLatitude() != null) {
            this._stationIconLocation = new WorldPt(this.getStationIconLongitude().doubleValue(), this.getStationIconLatitude().doubleValue());
        }
        return this._stationIconLocation;
    }
}

