/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.model;

import hec.io.AsciiSerializable;
import hec.map.WorldPt;
import hec.map.WorldRegion;
import hec.map.WorldRegionHolder;
import hec.model.DataObject;
import hec.watershed.model.Project;
import hec.watershed.model.StudyRegion;
import java.awt.Color;
import java.io.Serializable;
import java.lang.reflect.Field;

public class StoragePool
extends Project
implements Serializable,
AsciiSerializable,
StudyRegion,
WorldRegionHolder {
    static final long serialVersionUID = -831239624550836867L;
    public static final String MENU_NAME = "Off Channel Storage Area";
    private WorldRegion _region = new WorldRegion();

    public void setRegion(WorldRegion region) {
        this._region = region;
        this.updateReferencePt();
    }

    @Override
    public WorldRegion getRegion() {
        return this._region;
    }

    @Override
    public String getUserDisplayedType() {
        return "OffChannel Storage";
    }

    @Override
    public String getLabelName() {
        return MENU_NAME;
    }

    @Override
    public WorldPt getReferencePt() {
        if (this._referencePt.isValid()) {
            return this._referencePt;
        }
        this._referencePt = (WorldPt)this._region.pts.elementAt(0);
        return this._referencePt;
    }

    private void updateReferencePt() {
        for (int i = 0; i < this._region.pts.size(); ++i) {
            WorldPt pt = (WorldPt)this._region.pts.elementAt(i);
            if (pt == null) continue;
            if (i == 0) {
                this._referencePt.init(pt);
                continue;
            }
            this._referencePt.e += pt.e;
            this._referencePt.n += pt.n;
        }
        double xnum = this._region.pts.size();
        if (xnum > 1.0) {
            this._referencePt.e /= xnum;
            this._referencePt.n /= xnum;
        }
    }

    public boolean loadData() {
        if (!this._loaded || this._outOfDateData) {
            Object obj = this._dataList.loadObject((DataObject)this);
            if (obj instanceof StoragePool) {
                this.copyInto((StoragePool)obj);
            }
            if (super.loadData()) {
                this._loaded = true;
            }
            this.setModified(false);
        }
        return this._loaded;
    }

    public void copyInto(StoragePool sp) {
        if (sp == null) {
            return;
        }
        super.copyInto((DataObject)sp);
        this._region = (WorldRegion)sp._region.clone();
    }

    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return super.getFieldObject(fld);
        }
    }

    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return super.setFieldObject(fld, fobj);
        }
        catch (IllegalArgumentException e) {
            return super.setFieldObject(fld, fobj);
        }
    }

    public WorldRegion getRegion(int idx) {
        return this.getRegion();
    }

    public Color getRegionColor(int idx) {
        return Color.CYAN;
    }

    public int getRegionCount() {
        return 1;
    }

    public String getRegionDescription(int idx) {
        return this.getDescription();
    }

    public String getRegionName(int idx) {
        return this.getName();
    }

    public int getStreamIndex() {
        return -1;
    }

    public void setStreamIndex(int idx) {
    }
}

