/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.model;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import hec.clientapp.client.ClientApp;
import hec.event.DataChangeEvent;
import hec.event.LockEvent;
import hec.io.AsciiSerializable;
import hec.io.Identifier;
import hec.map.MapIdentifier;
import hec.map.MapObjectInterface;
import hec.map.MapScale;
import hec.map.WorldLine;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.WorldRegion;
import hec.map.crs.CoordinateReferenceSystem;
import hec.map.streamAlignment.StreamAlignmentIfc;
import hec.model.AbstractDataObject;
import hec.model.CommonDataList;
import hec.model.DataList;
import hec.model.DataObject;
import hec.model.DataStruct;
import hec.model.Node;
import hec.model.StreamElement;
import hec.model.StreamJunction;
import hec.model.StreamNode;
import hec.model.StreamSegment;
import hec.model.StreamSegmentIdentifier;
import hec.watershed.client.StudySystemGlyph;
import hec.watershed.model.ChannelMod;
import hec.watershed.model.ComputationPoint;
import hec.watershed.model.Condition;
import hec.watershed.model.ConditionContainer;
import hec.watershed.model.Diversion;
import hec.watershed.model.ImpactArea;
import hec.watershed.model.Levee;
import hec.watershed.model.OtherProject;
import hec.watershed.model.Project;
import hec.watershed.model.Reservoir;
import hec.watershed.model.Station;
import hec.watershed.model.StationSet;
import hec.watershed.model.StationSetDataList;
import hec.watershed.model.StoragePool;
import hec.watershed.model.StudyContainer;
import hec.watershed.model.StudyIfc;
import hec.watershed.model.StudyRegion;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Stack;
import java.util.Vector;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import rma.util.RMAIO;

public class Study
extends AbstractDataObject
implements Serializable,
MapObjectInterface,
AsciiSerializable,
StudyIfc {
    static final long serialVersionUID = -2326577699438042243L;
    private String _notes;
    private String _monetaryUnits;
    private String _systemUnits;
    private transient MapIdentifier _mapId;
    private transient StreamAlignmentIfc _alignment;
    private Vector _nodeVector = new Vector();
    private int _nextNodeIndex = 0;
    private transient Identifier _lockId;

    @Override
    public Condition getCondition() {
        return null;
    }

    public void setStreamAlignment(StreamAlignmentIfc alignment) {
        this._alignment = alignment;
    }

    @Override
    public StreamAlignmentIfc getAlignment() {
        return this.getStreamAlignment();
    }

    public StreamAlignmentIfc getStreamAlignment() {
        if (this._alignment == null) {
            this._alignment = ((StudyContainer)this.getDataList()).getAlignment();
        }
        return this._alignment;
    }

    public void setNotes(String notes) {
        this._notes = notes;
    }

    public void setMonetaryUnits(String units) {
        this._monetaryUnits = units;
    }

    public void setSystemUnits(String units) {
        this._systemUnits = units;
    }

    public String getNotes() {
        return this._notes;
    }

    public String getMonetaryUnits() {
        return this._monetaryUnits;
    }

    public String getSystemUnits() {
        return this._systemUnits;
    }

    public boolean deleteImpactArea(String name) {
        CommonDataList dl = this._dataList.getCommonDataListContainer().getCommonDataList("hec.watershed.model.ImpactArea");
        if (dl == null) {
            return false;
        }
        DataObject iarea = dl.getObject(name);
        if (iarea == null) {
            return false;
        }
        return dl.removeObject(iarea.getId());
    }

    @Override
    public Reservoir findReservoir(WorldPt wpt) {
        return (Reservoir)this.findRegion(wpt, 5.0, "hec.watershed.model.Reservoir");
    }

    @Override
    public Reservoir findReservoir(int streamIndex, double coord) {
        if (streamIndex < 0 || coord == Double.NEGATIVE_INFINITY) {
            return null;
        }
        Reservoir reservoir = null;
        CommonDataList dl = this._dataList.getCommonDataListContainer().getCommonDataList("hec.watershed.model.Reservoir");
        if (dl == null) {
            return null;
        }
        DataStruct[] resList = dl.getObjectArray();
        for (int ii = 0; ii < resList.length; ++ii) {
            int i;
            int size;
            DataStruct elem = resList[ii];
            if (elem == null || !(elem instanceof Reservoir)) continue;
            reservoir = (Reservoir)elem;
            Vector<StreamSegment> segvec = reservoir.getStreamSegmentVector();
            if (segvec != null) {
                size = segvec.size();
                for (i = 0; i < size; ++i) {
                    StreamSegment ss = segvec.elementAt(i);
                    if (ss == null || streamIndex != ss.streamIndex || !(ss.downstreamCoord <= coord) || !(ss.upstreamCoord >= coord)) continue;
                    return reservoir;
                }
                continue;
            }
            Vector<Node> nvec = reservoir.getNodeVector();
            size = nvec.size();
            for (i = 0; i < size; ++i) {
                StreamElement stream;
                Node node = nvec.elementAt(i);
                if (node == null || node.getStreamIndex() != streamIndex || (stream = this.getStreamAlignment().findReach(node.getStreamIndex())) == null) continue;
                double c0 = node.getStreamCoord();
                double c1 = Double.NEGATIVE_INFINITY;
                for (int j = 0; j < size; ++j) {
                    Node node1;
                    if (i == j || (node1 = nvec.elementAt(j)) == null || node1.getStreamIndex() != node.getStreamIndex()) continue;
                    c1 = node1.getStreamCoord();
                    break;
                }
                if (c1 == Double.NEGATIVE_INFINITY) {
                    c1 = 0.0;
                }
                if (c1 >= c0 || !(c0 >= coord) || !(c1 <= coord)) continue;
                return reservoir;
            }
        }
        return null;
    }

    @Override
    public Node createNode(WorldPt pt) {
        Node node = this.newNode();
        node.setLocation(pt);
        return node;
    }

    public Node newNode() {
        Node node = new Node(null, this.nextNodeIndex());
        this._nodeVector.addElement(node);
        node.setName("Node " + Integer.toString(node.getIndex()));
        node.setDescription("");
        this.setModified(true);
        return node;
    }

    private int nextNodeIndex() {
        int i = this._nextNodeIndex++;
        return i;
    }

    public Station findStation(WorldPt wpt, double tol) {
        StationSetDataList dl = (StationSetDataList)this._dataList.getCommonDataListContainer().getCommonDataList("hec.watershed.model.StationSet");
        if (dl == null) {
            return null;
        }
        StationSet ss = (StationSet)dl.getObjects()[0];
        GeometryFactory gf = new GeometryFactory();
        Envelope e = new Envelope(wpt.e - tol, wpt.e + tol, wpt.n + tol, wpt.n - tol);
        Geometry boundingBox = gf.toGeometry(e);
        Predicate<Station> p = station -> {
            if (station.getStationIconLocation() != null) {
                return boundingBox.contains((Geometry)new GeometryFactory().createPoint(new Coordinate(station.getStationIconLocation().e, station.getStationIconLocation().n)));
            }
            return boundingBox.contains(station.getGeometry());
        };
        List collect = ss.getFeatures().stream().filter(p).collect(Collectors.toList());
        return collect.isEmpty() ? null : (Station)((Object)collect.get(0));
    }

    @Override
    public StudyRegion findRegion(WorldPt wpt, double tol, String type) {
        CommonDataList dl = this._dataList.getCommonDataListContainer().getCommonDataList(type);
        if (dl == null) {
            return null;
        }
        DataStruct[] projs = dl.getObjectArray();
        for (int i = 0; i < projs.length; ++i) {
            WorldRegion region = ((StudyRegion)projs[i]).getRegion();
            if (region == null || !region.contains(wpt)) continue;
            return (StudyRegion)projs[i];
        }
        return null;
    }

    public OtherProject findOtherProject(WorldPt wpt, double tol) {
        return this.findOtherProject(wpt, tol, false);
    }

    @Override
    public OtherProject findOtherProject(WorldPt wpt, double tol, boolean useIconPosition) {
        if (wpt == null) {
            return null;
        }
        CommonDataList dl = this._dataList.getCommonDataListContainer().getCommonDataList("hec.watershed.model.OtherProject");
        if (dl == null) {
            return null;
        }
        DataStruct[] cpts = dl.getObjectArray();
        WorldRect rc = new WorldRect(wpt.e - tol, wpt.n + tol, wpt.e + tol, wpt.n - tol);
        WorldPt pt = new WorldPt();
        int[] xy = null;
        MapScale scale = null;
        if (useIconPosition) {
            xy = new int[2];
            scale = ClientApp.frame().getMapPanel().scale();
        }
        for (int i = 0; i < cpts.length; ++i) {
            OtherProject op = (OtherProject)cpts[i];
            if (op == null) continue;
            pt.init(op.getReferencePt());
            if (useIconPosition) {
                xy[0] = scale.e2x(pt.e);
                xy[1] = scale.n2y(pt.n);
                StudySystemGlyph.getOtherProjectIconPosition(op.getIconPosition(), xy);
                pt.init(scale.x2e(xy[0]), scale.y2n(xy[1]));
            }
            if (!rc.contains(pt)) continue;
            return op;
        }
        return null;
    }

    @Override
    public ComputationPoint findCompPt(int streamIndex, double upstreamCoord, double downstreamCoord) {
        CommonDataList dl = this._dataList.getCommonDataListContainer().getCommonDataList("hec.watershed.model.ComputationPoint");
        if (dl == null) {
            return null;
        }
        DataStruct[] cpts = dl.getObjectArray();
        for (int i = 0; i < cpts.length; ++i) {
            ComputationPoint cpt = (ComputationPoint)cpts[i];
            if (cpt == null || !cpt.getSnapToStream() || cpt.getStreamId() != streamIndex || !(cpt.getStreamCoord() <= upstreamCoord) || !(cpt.getStreamCoord() >= downstreamCoord)) continue;
            return cpt;
        }
        return null;
    }

    @Override
    public ComputationPoint findCompPt(WorldPt wpt, double tol) {
        if (wpt == null) {
            return null;
        }
        CommonDataList dl = this._dataList.getCommonDataListContainer().getCommonDataList("hec.watershed.model.ComputationPoint");
        if (dl == null) {
            return null;
        }
        DataStruct[] cpts = dl.getObjectArray();
        ComputationPoint cpt = null;
        WorldRect rc = new WorldRect(wpt.e - tol, wpt.n + tol, wpt.e + tol, wpt.n - tol);
        ArrayList<ComputationPoint> cpsFound = new ArrayList<ComputationPoint>();
        for (int i = 0; i < cpts.length; ++i) {
            StreamElement elem;
            cpt = (ComputationPoint)cpts[i];
            if (cpt == null) continue;
            WorldPt pt = cpt.getSnapToStream() ? ((elem = this.getStreamAlignment().findReach(cpt.getStreamId())) != null ? elem.getLocationByStation(cpt.getStreamStation()) : cpt.getReferencePt()) : cpt.getReferencePt();
            if (!rc.contains(pt)) continue;
            cpsFound.add(cpt);
        }
        int size = cpsFound.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return (ComputationPoint)cpsFound.get(0);
        }
        cpt = (ComputationPoint)cpsFound.get(0);
        double minDist = cpt.getReferencePt().distToPoint(wpt);
        ComputationPoint closestCp = cpt;
        for (int i = 1; i < size; ++i) {
            cpt = (ComputationPoint)cpsFound.get(i);
            double dist = cpt.getReferencePt().distToPoint(wpt);
            if (!(dist < minDist)) continue;
            minDist = dist;
            closestCp = cpt;
        }
        return closestCp;
    }

    @Override
    public Diversion findDiversion(WorldPt wpt, double tol) {
        if (wpt == null) {
            return null;
        }
        CommonDataList dl = this._dataList.getCommonDataListContainer().getCommonDataList("hec.watershed.model.Diversion");
        if (dl == null) {
            return null;
        }
        DataStruct[] divList = dl.getObjectArray();
        if (divList == null || divList.length == 0) {
            return null;
        }
        WorldRect rc = new WorldRect(wpt, tol);
        for (int i = 0; i < divList.length; ++i) {
            WorldPt pt;
            Diversion diversion = (Diversion)divList[i];
            if (diversion == null) continue;
            if (diversion.getLine().nearPt(wpt, tol)) {
                return diversion;
            }
            Node n = diversion.getUpstreamNode();
            if (n != null && rc.contains(pt = n.getLocation())) {
                return diversion;
            }
            n = diversion.getDownstreamNode();
            if (n == null || !rc.contains(pt = n.getLocation())) continue;
            return diversion;
        }
        return null;
    }

    @Override
    public ImpactArea findImpactArea(WorldPt wpt, double tol) {
        return (ImpactArea)this.findRegion(wpt, tol, "hec.watershed.model.ImpactArea");
    }

    public OtherProject addOtherProject(WorldPt wpt) {
        return this.addOtherProject(wpt, null, null);
    }

    @Override
    public OtherProject addOtherProject(WorldPt wpt, String name, String description) {
        CommonDataList dl = this._dataList.getCommonDataListContainer().getCommonDataList("hec.watershed.model.OtherProject");
        if (dl == null) {
            return null;
        }
        OtherProject op = name != null ? (OtherProject)dl.newDataObject(name, description) : (OtherProject)dl.newDataObject("OtherProject", "");
        if (op == null) {
            return op;
        }
        op.setReferencePt(wpt);
        if (this.getStreamAlignment() != null) {
            StreamElement elem = this._alignment.findNearestReach(wpt, new WorldPt());
            if (elem != null) {
                op.setStreamId(elem.getIndex());
            } else {
                System.out.println("addOtherProject:Failed to find StreamElement");
            }
        } else {
            System.out.println("addOtherProject: failed to find StreamAlignment");
        }
        dl.addNewObject((DataObject)op);
        if (name == null) {
            op.setName(op.getName() + op.getId());
        }
        op.updateComputationPoint();
        op.setModified(true);
        this.addProjectToCondition(op);
        return op;
    }

    public ComputationPoint addCompPt(WorldPt wpt, boolean autoGenerated) {
        return this.addCompPt(wpt, autoGenerated, null, null);
    }

    public Station addStation(WorldPt wpt, String name, String description) {
        Objects.requireNonNull(name, "Null Name value in addStation()");
        Objects.requireNonNull(wpt, "Null world point value in addStation()");
        StationSetDataList dl = (StationSetDataList)this._dataList.getCommonDataListContainer().getCommonDataList("hec.watershed.model.StationSet");
        if (dl == null) {
            return null;
        }
        StationSet ss = (StationSet)dl.getObjects()[0];
        Station station = new Station();
        station.setName(name);
        station.setDescription(description);
        ss.addFeature(station);
        return station;
    }

    @Override
    public ComputationPoint addCompPt(WorldPt wpt, boolean autoGenerated, String name, String description) {
        CommonDataList dl = this._dataList.getCommonDataListContainer().getCommonDataList("hec.watershed.model.ComputationPoint");
        if (dl == null) {
            return null;
        }
        ComputationPoint cpt = name != null ? (ComputationPoint)dl.newDataObject(name, description) : (ComputationPoint)dl.newDataObject("CP", "");
        if (cpt == null) {
            return cpt;
        }
        cpt.setReferencePt(wpt);
        cpt.setAutoGenerated(autoGenerated);
        if (this.getStreamAlignment() != null) {
            // empty if block
        }
        dl.addNewObject((DataObject)cpt);
        if (cpt != null) {
            cpt = (ComputationPoint)dl.getObject(cpt.getId());
            if (name == null) {
                cpt.setName(cpt.getName() + cpt.getId());
            }
            cpt.setModified(true);
        }
        return cpt;
    }

    public StoragePool addStoragePool(WorldRegion reg) {
        return this.addStoragePool(reg, null, null);
    }

    @Override
    public StoragePool addStoragePool(WorldRegion reg, String name, String description) {
        StreamElement elem;
        CommonDataList dl = this._dataList.getCommonDataListContainer().getCommonDataList("hec.watershed.model.StoragePool");
        if (dl == null) {
            return null;
        }
        StoragePool sp = name != null ? (StoragePool)dl.newDataObject(name, description) : (StoragePool)dl.newDataObject("OffChannel Storage", "");
        if (sp == null) {
            return sp;
        }
        sp.setRegion(reg);
        dl.addNewObject((DataObject)sp);
        if (name == null) {
            sp.setName(sp.getName() + sp.getId());
        }
        if (this.getStreamAlignment() != null && (elem = this._alignment.findNearestReach((WorldPt)reg.pts.elementAt(0), new WorldPt())) != null) {
            sp.setStreamId(elem.getIndex());
        }
        sp.setModified(true);
        this.addProjectToCondition(sp);
        return sp;
    }

    public Diversion createDiversion(Node node0, Node node1, List<WorldPt> ptVec, double tol, int inflowType) {
        return this.createDiversion(node0, node1, ptVec, tol, inflowType, null, null);
    }

    @Override
    public Diversion createDiversion(Node node0, Node node1, List<WorldPt> ptVec, double tol, int inflowType, String name, String description) {
        Vector<StreamSegment> v;
        Reservoir res;
        if (node0 == null) {
            return null;
        }
        CommonDataList dl = this._dataList.getCommonDataListContainer().getCommonDataList("hec.watershed.model.Diversion");
        if (dl == null) {
            return null;
        }
        Diversion div = name != null ? (Diversion)dl.newDataObject(name, description) : (Diversion)dl.newDataObject("Diversion", "");
        if (div == null) {
            return null;
        }
        div.addNode(node0, 1);
        if (node1 != null) {
            div.addNode(node1, 0);
        }
        WorldLine wl = new WorldLine();
        wl.pts.addAll(ptVec);
        div.setLine(wl);
        div.setStreamName(node0.getStreamName());
        div.setStreamId(node0.getStreamIndex());
        dl.addNewObject((DataObject)div);
        if (name == null) {
            div.setName(div.getName() + div.getId());
        }
        if (inflowType == 1 && (res = this.findReservoir(node0.getStreamIndex(), node0.getStreamCoord())) != null && (v = res.getStreamSegmentVector()) != null) {
            for (int i = 0; i < v.size(); ++i) {
                StreamSegment seg = v.get(i);
                if (seg.streamIndex != node0.getStreamIndex() || !(node0.getStreamCoord() < seg.upstreamCoord) || !(node0.getStreamCoord() > seg.downstreamCoord)) continue;
                double offset = node0.getStreamCoord() / (seg.upstreamCoord - seg.downstreamCoord);
                div.setReservoirId(res.getId());
                div.setReservoirOffset(offset);
                break;
            }
        }
        div.setInflowType(inflowType);
        div.updateComputationPoint();
        div.loadData();
        div.setModified(true);
        this.addProjectToCondition(div);
        return div;
    }

    public Reservoir createReservoir(WorldRegion reg, List nodeVec, List ndirVec, double tol, String rname, String rdescrip) {
        CommonDataList dl = this._dataList.getCommonDataListContainer().getCommonDataList("hec.watershed.model.Reservoir");
        if (dl == null) {
            return null;
        }
        Reservoir res = (Reservoir)dl.newDataObject(rname, rdescrip);
        if (res == null) {
            return null;
        }
        res.setRegion(reg);
        int numnodes = nodeVec.size();
        if (numnodes > 0) {
            res.setStreamId(((Node)nodeVec.get(0)).getStreamIndex());
        }
        for (int ii = 0; ii < numnodes; ++ii) {
            res.addNode((Node)nodeVec.get(ii), (Integer)ndirVec.get(ii));
        }
        dl.addNewObject((DataObject)res);
        res.setModified(true);
        this.addProjectToCondition(res);
        return res;
    }

    public Reservoir createReservoir(WorldRegion reg, List nodeVec, double tol, String rname, String rdescrip) {
        int ii;
        CommonDataList dl = this._dataList.getCommonDataListContainer().getCommonDataList("hec.watershed.model.Reservoir");
        if (dl == null) {
            return null;
        }
        Reservoir res = (Reservoir)dl.newDataObject(rname, rdescrip);
        if (res == null) {
            return null;
        }
        if (nodeVec == null || nodeVec.size() == 0) {
            return null;
        }
        res.setRegion(reg);
        Vector<StreamElement> streamVec = new Vector<StreamElement>();
        Stack<Object> streamStack = new Stack<Object>();
        Vector svec = new Vector();
        int numnodes = nodeVec.size();
        int[] ndirArray = new int[numnodes];
        res.setStreamId(((Node)nodeVec.get(0)).getStreamIndex());
        block0: for (ii = 0; ii < numnodes; ++ii) {
            Node nj;
            Node node = (Node)nodeVec.get(ii);
            if (this.getStreamAlignment() != null) {
                ndirArray[ii] = 0;
                streamVec.removeAllElements();
                streamStack.removeAllElements();
                StreamElement strmelem = this._alignment.getReach(node.getStreamIndex());
                if (strmelem != null) {
                    streamStack.push(strmelem);
                }
                while (!streamStack.isEmpty()) {
                    StreamElement s = (StreamElement)streamStack.pop();
                    streamVec.addElement(s);
                    StreamNode strmnode = s.getDownstreamNode();
                    StreamJunction strmjunc = strmnode.getJunction();
                    if (strmjunc == null) continue;
                    svec.removeAllElements();
                    strmjunc.getOutflowingStreams(svec);
                    for (int j = 0; j < svec.size(); ++j) {
                        streamStack.push(svec.elementAt(j));
                    }
                }
                boolean ifound = false;
                for (int jj = 0; jj < nodeVec.size(); ++jj) {
                    nj = (Node)nodeVec.get(jj);
                    if (nj == null || nj == node) continue;
                    for (int k = 0; k < streamVec.size(); ++k) {
                        StreamElement ss = (StreamElement)streamVec.elementAt(k);
                        if (nj.getStreamIndex() != ss.getIndex() || nj.getStreamIndex() == node.getStreamIndex() && !(nj.getStreamCoord() < node.getStreamCoord())) continue;
                        ndirArray[ii] = 1;
                        ifound = true;
                        break;
                    }
                    if (ifound) continue block0;
                }
                continue;
            }
            ndirArray[ii] = 1;
            for (int jj = 0; jj < nodeVec.size(); ++jj) {
                nj = (Node)nodeVec.get(jj);
                if (nj == null || nj == node || nj.getStreamIndex() != node.getStreamIndex() || !(nj.getStreamCoord() > node.getStreamCoord())) continue;
                ndirArray[ii] = 0;
            }
        }
        for (ii = 0; ii < numnodes; ++ii) {
            res.addNode((Node)nodeVec.get(ii), ndirArray[ii]);
        }
        dl.addNewObject((DataObject)res);
        res.setModified(true);
        this.addProjectToCondition(res);
        return res;
    }

    public Levee addLevee(List<StreamSegmentIdentifier> ssiList, int bank, int offset) {
        return this.addLevee(ssiList, bank, offset);
    }

    @Override
    public Levee addLevee(List<StreamSegmentIdentifier> ssiList, int bank, int offset, String name, String description) {
        DataList dl = ((DataList)this._dataList).getDataListContainer().getDataList("hec.watershed.model.Levee");
        if (dl == null) {
            return null;
        }
        Levee levee = name != null ? (Levee)dl.newDataObject(name, description) : (Levee)dl.newDataObject("Levee", "");
        levee.setFollowsStream(true);
        levee.setStreamSegmentList(ssiList);
        levee.setAveOffset(offset);
        levee.setBank(bank);
        dl.addNewObject((DataObject)levee);
        if (name == null) {
            levee.setName(levee.getName() + levee.getId());
        }
        levee.updateComputationPoint();
        levee.setModified(true);
        this.addProjectToCondition(levee);
        return levee;
    }

    @Override
    public ImpactArea addImpactArea(WorldRegion reg) {
        return this.addImpactArea(reg, null, null);
    }

    @Override
    public ImpactArea addImpactArea(WorldRegion reg, String name, String description) {
        CommonDataList dl = this._dataList.getCommonDataListContainer().getCommonDataList("hec.watershed.model.ImpactArea");
        if (dl == null) {
            return null;
        }
        ImpactArea ia = name != null ? (ImpactArea)dl.newDataObject(name, description) : (ImpactArea)dl.newDataObject("ImpactArea", "");
        if (ia == null) {
            return ia;
        }
        ia.setIgnoreModifiedEvents(true);
        ia.setRegion(reg);
        if (this.getStreamAlignment() != null) {
            StreamElement elem = this._alignment.findNearestReach(ia.getReferencePt(), new WorldPt());
            if (elem != null) {
                ia.setStreamId(elem.getIndex());
                WorldPt worldPt = new WorldPt();
                if (elem.getLine().getNearestLocationSigned(ia.getReferencePt(), worldPt) > 0.0) {
                    ia.setBank(1);
                } else {
                    ia.setBank(2);
                }
                double[] stations = Study.getStations(elem, ia);
                ia.setIndexStation(stations[0]);
                ia.setBeginStation(stations[1]);
                ia.setEndStation(stations[2]);
            } else {
                System.out.println("addImpactArea:Failed to find StreamElement");
            }
        } else {
            System.out.println("addImpactArea: failed to find StreamAlignment");
        }
        dl.addNewObject((DataObject)ia);
        if (name == null) {
            ia.setName(ia.getName() + ia.getId());
        }
        if (description != null) {
            ia.setDescription(description);
        }
        ia.updateComputationPoint();
        ia.loadData();
        ia.setIgnoreModifiedEvents(false);
        ia.setModified(true);
        return ia;
    }

    public ChannelMod addChannelMod(String streamName, int streamStartIndex, int streamEndIndex, double start, double end) {
        return this.addChannelMod(streamName, streamStartIndex, streamEndIndex, start, end, null, null);
    }

    @Override
    public ChannelMod addChannelMod(String streamName, int streamStartIndex, int streamEndIndex, double start, double end, String name, String description) {
        CommonDataList dl = this._dataList.getCommonDataListContainer().getCommonDataList("hec.watershed.model.ChannelMod");
        if (dl == null) {
            return null;
        }
        ChannelMod cm = name != null ? (ChannelMod)dl.newDataObject(name, description) : (ChannelMod)dl.newDataObject("ChannelMod", "");
        if (cm == null) {
            return null;
        }
        cm.setStartStreamElementIndex(streamStartIndex);
        cm.setStreamId(streamStartIndex);
        cm.setEndStreamElementIndex(streamEndIndex);
        cm.setStartStation(start);
        cm.setEndStation(end);
        cm.setStreamName(streamName);
        dl.addNewObject((DataObject)cm);
        if (name == null) {
            cm.setName(cm.getName() + cm.getId());
        }
        cm.updateComputationPoint();
        cm.setModified(true);
        this.addProjectToCondition(cm);
        return cm;
    }

    public void addProjectToCondition(Project proj) {
        if (proj == null) {
            return;
        }
        ConditionContainer dl = (ConditionContainer)this._dataList.getCommonDataListContainer().getCommonDataList("hec.watershed.model.Condition");
        if (dl == null) {
            return;
        }
        Condition c = dl.getCurrentCondition();
        if (c == null) {
            return;
        }
        if (c.isStudyCondition()) {
            proj.setIsExisting(true);
            c.addProject(proj, "");
            return;
        }
        c.addProject(proj, "");
    }

    @Override
    public Object[] getImpactAreaList() {
        CommonDataList dl = this._dataList.getCommonDataListContainer().getCommonDataList("hec.watershed.model.ImpactArea");
        if (dl == null) {
            return new Object[0];
        }
        return dl.getObjectArray();
    }

    public Object[] getComputationPointList() {
        CommonDataList dl = this._dataList.getCommonDataListContainer().getCommonDataList("hec.watershed.model.ComputationPoint");
        if (dl == null) {
            return new Object[0];
        }
        return dl.getObjectArray();
    }

    @Override
    public Object[] getReservoirList() {
        CommonDataList dl = this._dataList.getCommonDataListContainer().getCommonDataList("hec.watershed.model.Reservoir");
        if (dl == null) {
            return new Object[0];
        }
        return dl.getObjectArray();
    }

    public void copyInto(DataObject dobj) {
        if (dobj instanceof Study) {
            this.copyInto((Study)dobj);
        }
    }

    public void copyInto(Study study) {
        if (study == null) {
            return;
        }
        super.copyInto((DataObject)study);
        this._notes = study._notes;
        this._monetaryUnits = study._monetaryUnits;
        this._systemUnits = study._systemUnits;
        this._nodeVector = (Vector)study._nodeVector.clone();
        this._nextNodeIndex = study._nextNodeIndex;
        this.setModified(false);
    }

    public void copyInto(DataStruct dstruct) {
    }

    public void DataChanged(DataChangeEvent evt) {
    }

    public void locked(LockEvent evt) {
    }

    public boolean loadId() {
        return true;
    }

    public WorldRect getExtent() {
        return new WorldRect();
    }

    public void load() {
    }

    public boolean loadData() {
        if (!this._loaded || this._outOfDateData) {
            Object obj = this._dataList.loadObject((DataObject)this);
            if (obj instanceof Study) {
                this.copyInto((Study)obj);
            }
            if (super.loadData()) {
                this._loaded = true;
            }
            this.setModified(false);
        }
        return this._loaded;
    }

    public void setExtent(WorldRect rect) {
    }

    public MapIdentifier getMapIdentifier() {
        if (this._mapId == null) {
            this._mapId = new MapIdentifier("study/" + this.getName() + "/" + this.getName());
            this._mapId.setName("Study");
        }
        return this._mapId;
    }

    public void unload() {
    }

    public void setMapIdentifier(MapIdentifier id) {
    }

    public static double[] getStations(StreamElement elem, ImpactArea ia) {
        double[] stations = new double[3];
        if (elem == null || ia == null) {
            return stations;
        }
        stations[0] = elem.getStationByLocation(ia.getReferencePt());
        double begin = Double.POSITIVE_INFINITY;
        double end = Double.NEGATIVE_INFINITY;
        WorldRegion reg = ia.getRegion();
        for (int i = 0; i < reg.pts.size(); ++i) {
            WorldPt pt = (WorldPt)reg.pts.elementAt(i);
            double station = elem.getStationByLocation(pt);
            if (station < begin) {
                begin = station;
            }
            if (!(station > end)) continue;
            end = station;
        }
        stations[1] = begin;
        stations[2] = end;
        return stations;
    }

    public Identifier getLockIdentifier() {
        if (this._lockId == null) {
            if (ClientApp.Workspace() == null) {
                return null;
            }
            String wkspPath = ClientApp.Workspace().getWorkspacePath();
            String fileName = RMAIO.userNameToFileName((String)(this.getName() + ".lck"));
            Identifier id = new Identifier(wkspPath + "/study/" + fileName);
            this._lockId = ClientApp.Workspace().openRemoteFileID(id);
            if (this._lockId == null) {
                this._lockId = ClientApp.Workspace().newRemoteFileID(id);
            }
        }
        return this._lockId;
    }

    @Override
    public List getObjectNamesList(String className) {
        CommonDataList dl = this._dataList.getCommonDataListContainer().getCommonDataList(className);
        if (dl == null) {
            return null;
        }
        DataStruct[] dobjs = dl.getObjectArray();
        if (dobjs != null && dobjs.length > 0) {
            Vector<String> v = new Vector<String>(dobjs.length);
            for (int i = 0; i < dobjs.length; ++i) {
                DataObject dObj = (DataObject)dobjs[i];
                if (dObj == null) continue;
                v.add(dObj.getName());
            }
            return v;
        }
        return null;
    }

    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return super.getFieldObject(fld);
        }
    }

    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return super.setFieldObject(fld, fobj);
        }
        catch (IllegalArgumentException e) {
            return super.setFieldObject(fld, fobj);
        }
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return null;
    }
}

