/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.model;

import hec.appInterface.AppDaddy;
import hec.clientapp.client.ClientApp;
import hec.clientapp.model.DataListContainer;
import hec.clientapp.model.StreamAlignment;
import hec.clientapp.rmi.csinterface.RmiDataList;
import hec.map.streamAlignment.StreamAlignmentIfc;
import hec.model.DataObject;
import hec.model.DataObjectProxy;
import hec.watershed.model.ConditionDataList;
import hec.watershed.model.DefaultDataList;
import hec.watershed.model.Study;
import hec.watershed.model.StudyContainer;
import hec.watershed.model.StudyIfc;
import hec.watershed.model.WatershedDataList;
import java.rmi.RemoteException;

public class StudyDataList
extends DefaultDataList
implements StudyContainer {
    Study _currentStudy = null;
    StreamAlignmentIfc _alignment;

    public StudyDataList(RmiDataList rd, DataListContainer parent, String objClass) {
        super(rd, parent, objClass);
    }

    @Override
    public boolean init() {
        Object[] objs;
        try {
            objs = this._rmiDataList.getObjects();
            this._shown = this._rmiDataList.isShown();
        }
        catch (RemoteException re) {
            System.out.println("StudyDataList.init(): remoteException getting my list of objects " + re);
            return false;
        }
        if (objs != null) {
            long id = 0L;
            for (int ii = 0; ii < objs.length; ++ii) {
                if (objs[ii] instanceof DataObjectProxy) {
                    try {
                        id = ((DataObjectProxy)objs[ii]).id;
                        DataObject obj = this._rmiDataList.getObject(id);
                        this.addDataObject(obj);
                    }
                    catch (RemoteException re) {
                        System.out.println(this._objClass + ".init: rmi error getting id " + id);
                    }
                    continue;
                }
                this.addDataObject((DataObject)objs[ii]);
            }
            String name = ClientApp.Workspace().getTitleName();
            if (this.getObject(name) == null) {
                this.createDefaultStudy();
            } else {
                this.setModified(false);
            }
        }
        this.register();
        this._initd = true;
        return true;
    }

    private void init(Study s) {
        ConditionDataList cdl;
        DataListContainer dlc = this.getDataListContainer();
        WatershedDataList wsdl = (WatershedDataList)dlc.getDataList("hec.watershed.model.Reservoir");
        if (wsdl != null) {
            wsdl.init(s);
        }
        if ((wsdl = (WatershedDataList)dlc.getDataList("hec.watershed.model.Levee")) != null) {
            wsdl.init(s);
        }
        if ((wsdl = (WatershedDataList)dlc.getDataList("hec.watershed.model.ChannelMod")) != null) {
            wsdl.init(s);
        }
        if ((wsdl = (WatershedDataList)dlc.getDataList("hec.watershed.model.OtherProject")) != null) {
            wsdl.init(s);
        }
        if ((wsdl = (WatershedDataList)dlc.getDataList("hec.watershed.model.StoragePool")) != null) {
            wsdl.init(s);
        }
        if ((wsdl = (WatershedDataList)dlc.getDataList("hec.watershed.model.ImpactArea")) != null) {
            wsdl.init(s);
        }
        if ((wsdl = (WatershedDataList)dlc.getDataList("hec.watershed.model.ComputationPoint")) != null) {
            wsdl.init(s);
        }
        if ((wsdl = (WatershedDataList)dlc.getDataList("hec.watershed.model.Diversion")) != null) {
            wsdl.init(s);
        }
        if ((cdl = (ConditionDataList)dlc.getDataList("hec.watershed.model.Condition")) != null) {
            cdl.init(s);
        }
        this._currentStudy = s;
    }

    @Override
    public DataObject getObject(long id) {
        Study s = (Study)super.getObject(id);
        if (s != this._currentStudy) {
            this.init(s);
        }
        return s;
    }

    @Override
    public DataObject getObject(String name) {
        Study s = (Study)super.getObject(name);
        if (s != this._currentStudy) {
            this.init(s);
        }
        return s;
    }

    @Override
    public StudyIfc getOpenStudy() {
        if (this._currentStudy == null) {
            return (StudyIfc)this.getObject(AppDaddy.getWorkspace().getTitleName());
        }
        return this._currentStudy;
    }

    private void createDefaultStudy() {
        String name = AppDaddy.getWorkspace().getTitleName();
        String desc = ClientApp.Workspace().getDescription();
        System.out.println("creating default study " + name);
        Study s = (Study)this.newDataObject(name, desc);
        this.addNewObject((DataObject)s);
    }

    @Override
    public StreamAlignmentIfc getAlignment() {
        if (this._alignment == null) {
            this._alignment = (StreamAlignment)ClientApp.Workspace().openManager("stream.align");
        }
        return this._alignment;
    }
}

