/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.model;

import hec.appInterface.AppDaddy;
import hec.clientapp.model.DataListContainer;
import hec.clientapp.rmi.csinterface.RmiDataList;
import hec.map.appInterface.MapApplicationFrame;
import hec.model.DataObject;
import hec.model.DataObjectProxy;
import hec.watershed.WatershedRmiDataList;
import hec.watershed.model.ComputationPoint;
import hec.watershed.model.ComputationPointDataList;
import hec.watershed.model.ComputationPointHolder;
import hec.watershed.model.DefaultDataList;
import hec.watershed.model.Study;
import hec.watershed.model.StudyContainer;
import hec.watershed.model.StudyIfc;
import java.awt.Component;
import java.rmi.RemoteException;
import javax.swing.JOptionPane;

public class WatershedDataList
extends DefaultDataList {
    public WatershedDataList(RmiDataList rd, DataListContainer parent, String objClass) {
        super(rd, parent, objClass);
    }

    @Override
    public boolean init() {
        if (this._initd) {
            return true;
        }
        this.register();
        return true;
    }

    public boolean init(Study s) {
        Object[] objs;
        if (s == null) {
            this._objects.clear();
            this._initd = false;
            return true;
        }
        if (this._rmiDataList == null) {
            return false;
        }
        try {
            objs = ((WatershedRmiDataList)this._rmiDataList).getObjects(s.getId());
            this._shown = this._rmiDataList.isShown();
        }
        catch (RemoteException re) {
            System.out.println("WatershedDataList.init(" + s + "): remoteException getting my list of objects " + re);
            return false;
        }
        if (objs != null) {
            long id = 0L;
            for (int ii = 0; ii < objs.length; ++ii) {
                if (objs[ii] instanceof DataObjectProxy) {
                    try {
                        id = ((DataObjectProxy)objs[ii]).id;
                        DataObject obj = this._rmiDataList.getObject(id);
                        this.addDataObject(obj);
                    }
                    catch (RemoteException re) {
                        System.out.println(this._objClass + ".init: rmi error getting id " + id);
                    }
                    continue;
                }
                this.addDataObject((DataObject)objs[ii]);
            }
        }
        this._initd = true;
        return true;
    }

    @Override
    public boolean removeObject(long objId) {
        DataObject obj = this.getObject(objId);
        if (obj != null) {
            StudyContainer sdl;
            StudyIfc study;
            ComputationPointHolder cph;
            if (obj instanceof ComputationPointHolder && (cph = (ComputationPointHolder)obj).hasComputationPoint()) {
                MapApplicationFrame frame = (MapApplicationFrame)AppDaddy.getFrame();
                int opt = JOptionPane.showConfirmDialog((Component)frame.getMapPanel(), "<html>Remove Project <b>" + obj + "</b>'s Computation Points?</html>", "Confirm Removal", 0);
                if (opt == 0) {
                    cph.removeFromComputationPoint();
                } else {
                    ComputationPointDataList cpdl = (ComputationPointDataList)this.getDataListContainer().getDataList(ComputationPoint.class.getName());
                    if (cpdl != null) {
                        cpdl.projectRemoved(obj);
                    }
                }
            }
            if ((study = (sdl = (StudyContainer)this.getDataListContainer().getDataList(Study.class.getName())).getOpenStudy()) != null) {
                study.setModified(true);
            }
            return super.removeObject(objId);
        }
        return false;
    }

    @Override
    public int removeAll() {
        StudyContainer sdl = (StudyContainer)this.getDataListContainer().getDataList(Study.class.getName());
        StudyIfc study = sdl.getOpenStudy();
        int num = super.removeAll();
        if (study != null && num > 0) {
            study.setModified(true);
        }
        return num;
    }
}

