/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.model;

import hec.appInterface.AppDaddy;
import hec.clientapp.client.ClientApp;
import hec.clientapp.model.Manager;
import hec.io.Identifier;
import hec.lang.ClientAppCheck;
import hec.watershed.model.WatershedModeDefaults;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.lang.reflect.Field;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import mil.army.usace.hec.rmi.io.HecAsciiDeserializer;
import mil.army.usace.hec.rmi.io.HecAsciiSerializer;
import mil.army.usace.hec.rmi.msgsystem.Msg;

public class WatershedDefaults
extends Manager {
    static WatershedDefaults DEFAULTS = null;
    private Map m_defaults;
    private static String m_workspacePath = null;

    public WatershedDefaults() {
        this.init();
    }

    public static WatershedDefaults getDefaults() {
        if (!ClientAppCheck.haveClientApp()) {
            m_workspacePath = null;
            return null;
        }
        if (AppDaddy.getWorkspace() == null) {
            m_workspacePath = null;
            return null;
        }
        if (m_workspacePath != null && !AppDaddy.getWorkspace().getWorkspacePath().equals(m_workspacePath)) {
            DEFAULTS = null;
        }
        if (DEFAULTS != null) {
            return DEFAULTS;
        }
        m_workspacePath = AppDaddy.getWorkspace().getWorkspacePath();
        ClientApp.app();
        Vector idlist = ClientApp.Workspace().getManagerIDList("main", "hec.watershed.model.WatershedDefaults");
        if (idlist == null || idlist.size() == 0) {
            ClientApp.app();
            Identifier id = ClientApp.Workspace().getManagerIdentifier("study", "hec.watershed.model.WatershedDefaults", "WatershedDefaults", "def");
            id.setDescription("Watershed Defaults");
            ClientApp.app();
            DEFAULTS = (WatershedDefaults)ClientApp.Workspace().newManager("main", "hec.watershed.model.WatershedDefaults");
            ClientApp.app();
            boolean success = ClientApp.Workspace().saveManagerAs("main", (Manager)DEFAULTS, id);
            if (!success) {
                ClientApp.app().errMsgBox(new Msg("Unable to create Watershed Defaults", 1));
                DEFAULTS = null;
            }
        } else {
            ClientApp.app();
            DEFAULTS = (WatershedDefaults)ClientApp.Workspace().openManager("main", (Identifier)idlist.elementAt(0));
        }
        return DEFAULTS;
    }

    public synchronized void init() {
        this.m_defaults = new Hashtable();
        this.m_defaults.put("ressim.hec.watershed.client.WatershedConfigMode", new WatershedModeDefaults().getDefaults());
        if (!ClientAppCheck.haveClientApp()) {
            return;
        }
        Map appDefaults = ClientApp.app().getWatershedDefaultsMap();
        if (appDefaults == null) {
            return;
        }
        this.m_defaults.putAll(appDefaults);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean writeFile(Identifier id) {
        try {
            this.setReloadOk(false);
            BufferedWriter writer = id.getFile().getBufferedWriter();
            HecAsciiSerializer serializer = new HecAsciiSerializer(writer);
            boolean value = serializer.serializeObject((Object)this);
            writer.flush();
            writer.close();
            boolean bl = value;
            return bl;
        }
        catch (Exception exception) {
        }
        finally {
            this.setReloadOk(true);
        }
        return false;
    }

    public synchronized boolean readFile(Identifier id) {
        Map tempTable = this.m_defaults;
        this.m_defaults = null;
        super.readFile(id);
        BufferedReader reader = id.getFile().getBufferedReader();
        HecAsciiDeserializer deserializer = new HecAsciiDeserializer(reader);
        boolean returnValue = deserializer.deserializeObject((Object)this);
        if (!returnValue) {
            return false;
        }
        this.updateTables(this.m_defaults, tempTable);
        return true;
    }

    private void updateTables(Map baseTable, Map inputTable) {
        if (baseTable.equals(inputTable)) {
            return;
        }
        Iterator baseKeys = baseTable.keySet().iterator();
        for (Object key : inputTable.keySet()) {
            Object value = baseTable.get(key);
            if (value == null) {
                baseTable.put(key, inputTable.get(key));
                continue;
            }
            if (!(value instanceof Map)) continue;
            this.updateTables((Map)baseTable.get(key), (Map)inputTable.get(key));
        }
    }

    public synchronized Object getDefaultValue(String key) {
        return this.getDefaultValue(key, this.m_defaults);
    }

    private Object getDefaultValue(String key, Map defaults) {
        Object value = defaults.get(key);
        if (value != null) {
            return value;
        }
        Object defaultValue = null;
        for (String k : defaults.keySet()) {
            value = defaults.get(k);
            if (!(value instanceof Map) || (defaultValue = this.getDefaultValue(key, (Map)value)) == null) continue;
            return defaultValue;
        }
        return defaultValue;
    }

    public synchronized Map getDefaults(String key) {
        return (Map)this.m_defaults.get(key);
    }

    public synchronized void setDefaults(String key, Map defaults) {
        this.m_defaults.put(key, defaults);
    }

    public synchronized Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get((Object)this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return super.getFieldObject(fld);
        }
    }

    public synchronized boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set((Object)this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return super.setFieldObject(fld, fobj);
        }
        catch (IllegalArgumentException e) {
            return super.setFieldObject(fld, fobj);
        }
    }

    public static void runTest() {
        ClientApp.app();
        Vector v = ClientApp.Workspace().getManagerIDList("hec.watershed.model.DefaultStateManager");
        WatershedDefaults manager = null;
        if (v == null || v.size() == 0) {
            ClientApp.app();
            Identifier id = ClientApp.Workspace().getManagerIdentifier("study", "hec.watershed.model.WatershedDefaults", "StateManager", "dat");
            String path = id.getPath();
            ClientApp.app();
            manager = (WatershedDefaults)ClientApp.Workspace().newManager("main", "hec.watershed.model.WatershedDefaults");
            if (manager == null) {
                return;
            }
            manager.getIdentifier().copy(id);
            manager.setName("WatershedDefaults");
            manager.saveManager();
        } else {
            ClientApp.app();
            manager = (WatershedDefaults)ClientApp.Workspace().openManager("main", (Identifier)v.elementAt(0));
            manager.saveManager();
        }
    }
}

