/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.res.model;

import hec.map.WorldLine;
import hec.map.WorldPt;
import hec.watershed.res.model.Element;
import hec.watershed.res.model.ResNetwork;
import hec.watershed.res.model.ResNode;
import java.awt.Color;
import java.lang.reflect.Field;
import java.util.Enumeration;

public class DiversionElement
extends Element {
    ResNode _cntrlNode = null;
    int _inFlowType = 0;
    WorldPt _referencePt = new WorldPt();
    WorldLine _line = new WorldLine();
    long _diversionProjectId = Long.MIN_VALUE;

    public DiversionElement() {
    }

    public DiversionElement(ResNetwork network, int idx) {
        super(network, idx);
    }

    @Override
    public void setupForSerialization() {
        super.setupForSerialization();
    }

    @Override
    public synchronized Object clone() {
        DiversionElement div = (DiversionElement)super.clone();
        return div;
    }

    @Override
    public void setActive(boolean active) {
        Enumeration e = this._elemVector.elements();
        while (e.hasMoreElements()) {
            Element elem = (Element)e.nextElement();
            elem.setActive(active);
        }
        super.setActive(active);
    }

    @Override
    public void removeNode(ResNode node) {
        if (node == this.getDownstreamNode() && this.hasReach()) {
            Element rch = (Element)this._elemVector.elementAt(1);
            rch.dispose();
            this._elemVector.removeElementAt(1);
        }
        super.removeNode(node);
    }

    public boolean hasReach() {
        return this._elemVector.size() > 1;
    }

    public Element getReachElement() {
        if (!this.hasReach()) {
            return null;
        }
        return (Element)this._elemVector.elementAt(1);
    }

    public Element getSourceElement() {
        ResNode upnode = this.getUpstreamNode();
        if (upnode == null) {
            return null;
        }
        return upnode.getDownstreamElement();
    }

    public WorldLine getLine() {
        return this._line;
    }

    @Override
    public WorldPt getReferencePt() {
        return this._referencePt;
    }

    public void setReferencePt(WorldPt pt) {
        this._referencePt = pt;
    }

    public void setLine(WorldLine reg) {
        if (reg == null) {
            return;
        }
        this._line = reg;
        this._referencePt = (WorldPt)this._line.pts.elementAt(0);
    }

    public ResNode getUpstreamNode() {
        if (this._nodeVector.size() < 1) {
            return null;
        }
        return (ResNode)((Object)this._nodeVector.elementAt(0));
    }

    @Override
    public ResNode getDownstreamNode() {
        if (this._nodeVector.size() < 2) {
            return null;
        }
        return (ResNode)((Object)this._nodeVector.elementAt(1));
    }

    void createDefaultElements() {
        this.removeAllChildElements();
    }

    @Override
    public void addNode(ResNode n, int idir) {
        if (idir == 1) {
            super.addNode(n, 1, false);
        } else {
            super.addNode(n, 0, false);
        }
    }

    public Color getLineColor() {
        return Color.black;
    }

    public int getInflowType() {
        return this._inFlowType;
    }

    public void setInflowType(int inFlowType) {
        this._inFlowType = inFlowType;
    }

    public long getDiversionProjectId() {
        return this._diversionProjectId;
    }

    public void setDiversionProjectId(long id) {
        this._diversionProjectId = id;
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return super.getFieldObject(fld);
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return super.setFieldObject(fld, fobj);
        }
        catch (IllegalArgumentException e) {
            return super.setFieldObject(fld, fobj);
        }
    }
}

