/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.res.model;

import hec.clientapp.model.TSDataSet;
import hec.clientapp.model.TSRecordProxy;
import hec.lang.NamedType;
import hec.map.WorldPt;
import hec.model.ModelVariable;
import hec.model.TSLocation;
import hec.watershed.res.model.DiversionElement;
import hec.watershed.res.model.JunctionElement;
import hec.watershed.res.model.PlotVariableConstants;
import hec.watershed.res.model.PlottableObject;
import hec.watershed.res.model.ReachElement;
import hec.watershed.res.model.ResAlt;
import hec.watershed.res.model.ResNetwork;
import hec.watershed.res.model.ResNode;
import hec.watershed.res.model.ReservoirElement;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class Element
extends NamedType
implements PlottableObject,
PlotVariableConstants,
TSLocation {
    public static final String PLOT_TYPES_JAR = "resprm.jar";
    public static final int RESERVIOR_ELEMENT_ID = 1;
    public static final int REACH_ELEMENT_ID = 2;
    public static final int JUNCTION_ELEMENT_ID = 4;
    public static final int DIVERSION_ELEMENT_ID = 8;
    public static final int DIVERTEDOUTLET_ELEMENT_ID = 16;
    public static final int OUTFLOW = 0;
    public static final int INFLOW = 1;
    ResNetwork _network;
    Vector _nodeVector = new Vector();
    Vector _nodeDirVector = new Vector();
    Vector _elemVector = new Vector();
    Vector _obsDataVector = new Vector();
    Element _parentElement = null;
    transient boolean _active = true;

    public Element() {
    }

    public Element(ResNetwork network, int idx) {
        this._network = network;
        this._index = idx;
    }

    public static int getObjectTypeId(ModelVariable mv) {
        if (mv == null || mv.getObjectType() == null) {
            return 0;
        }
        String objectType = mv.getObjectType();
        if ("reservoir".equalsIgnoreCase(objectType)) {
            return 1;
        }
        if ("reach".equalsIgnoreCase(objectType)) {
            return 2;
        }
        if ("diversion".equalsIgnoreCase(objectType)) {
            return 8;
        }
        if ("diverted outlet".equalsIgnoreCase(objectType)) {
            return 16;
        }
        if ("junction".equalsIgnoreCase(objectType)) {
            return 4;
        }
        return 0;
    }

    public String toString() {
        return this._network.getNameForKeyString(this.getName());
    }

    public void setupForSerialization() {
        if (this._elemVector == null) {
            return;
        }
        for (int i = 0; i < this._elemVector.size(); ++i) {
            Element elem = (Element)this._elemVector.get(i);
            elem.setupForSerialization();
        }
    }

    public String getDisplayName() {
        String name = this.getName();
        if (this._network.isKeyString(name)) {
            return name;
        }
        if (this._parentElement != null) {
            return this.getTopParent().getDisplayName() + "-" + this.getName();
        }
        return this.getName();
    }

    public String getFullName() {
        if (this._parentElement != null) {
            return this._parentElement.getFullName() + "-" + this.getName();
        }
        return this.getName();
    }

    public String getTopParentName() {
        if (this._parentElement != null) {
            return this._parentElement.getTopParentName();
        }
        return this.getName();
    }

    public int getChildElementCount() {
        return this._elemVector.size();
    }

    public Enumeration children() {
        return this._elemVector.elements();
    }

    public int getUnitSystem() {
        return this._network.getUnitSystem();
    }

    public synchronized Object clone() {
        try {
            Element re = (Element)super.clone();
            re._nodeVector = (Vector)this._nodeVector.clone();
            re._nodeDirVector = (Vector)this._nodeDirVector.clone();
            re._elemVector = new Vector();
            for (int i = 0; i < this._elemVector.size(); ++i) {
                Element elem = (Element)this._elemVector.elementAt(i);
                if (elem == null) continue;
                Element ec = (Element)elem.clone();
                ec.setParentElement(re);
                re._elemVector.addElement(ec);
            }
            if (this._obsDataVector != null) {
                re._obsDataVector = (Vector)this._obsDataVector.clone();
            }
            return re;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public void copyInto(Element re) {
        this._name = re._name;
        this._description = re._description;
        this._index = re._index;
        this.setValid(re.isValid());
        this._network = re._network;
        this._parentElement = re._parentElement;
        this._active = re._active;
        this._nodeVector = (Vector)re._nodeVector.clone();
        this._nodeDirVector = (Vector)re._nodeDirVector.clone();
        this._elemVector = new Vector();
        for (int i = 0; i < re._elemVector.size(); ++i) {
            Element elem = (Element)re._elemVector.elementAt(i);
            if (elem == null) continue;
            Element ec = (Element)elem.clone();
            ec.setParentElement(this);
            this._elemVector.addElement(ec);
        }
        this._obsDataVector = re._obsDataVector != null ? (Vector)re._obsDataVector.clone() : null;
        this.setModified(true);
    }

    public boolean downStreamFrom(Element element) {
        if (element == null) {
            return false;
        }
        if (this._network == null) {
            return false;
        }
        Vector downstreamVec = this._network.getDownstreamElements(element);
        if (downstreamVec == null || downstreamVec.size() == 0) {
            return false;
        }
        for (int i = 0; i < downstreamVec.size(); ++i) {
            Element elem = (Element)downstreamVec.elementAt(i);
            if (elem != this) continue;
            return true;
        }
        return false;
    }

    public void resetParentElement() {
        Enumeration e = this._elemVector.elements();
        while (e.hasMoreElements()) {
            Element child = (Element)e.nextElement();
            child.setParentElement(this);
            child.resetParentElement();
        }
    }

    public boolean isActive() {
        return this._active;
    }

    public void setActive(boolean active) {
        this.setActive(active, false);
    }

    public void setActive(boolean active, boolean recurse) {
        this._active = active;
    }

    public boolean isActive(ResAlt alt) {
        return this._active;
    }

    public String getKeyStringForObject(Object obj) {
        return this._network.getKeyStringForObject(obj);
    }

    public Object getObjectForKeyString(String keystr) {
        return this._network.getObjectForKeyString(keystr);
    }

    public Element getTopParent() {
        if (this._parentElement != null) {
            return this._parentElement.getTopParent();
        }
        return this;
    }

    public Element getParent() {
        return this._parentElement;
    }

    public void setParentElement(Element e) {
        this._parentElement = e;
    }

    public void addChildElement(Element child) {
        if (child == null) {
            return;
        }
        this._elemVector.addElement(child);
        child.setParentElement(this);
    }

    public void addChildElementAt(Element child, int idx) {
        if (child == null) {
            return;
        }
        if (this._elemVector.size() <= idx) {
            this._elemVector.setSize(idx + 1);
        }
        this._elemVector.setElementAt(child, idx);
        child.setParentElement(this);
    }

    public void removeChild(Element child) {
        if (this._elemVector.contains(child)) {
            child.setParentElement(null);
            this._elemVector.removeElement(child);
        }
    }

    public void removeAllChildElements() {
        Enumeration e = this._elemVector.elements();
        while (e.hasMoreElements()) {
            Element child = (Element)e.nextElement();
            child.setParentElement(null);
        }
        this._elemVector.removeAllElements();
    }

    public boolean initialize() {
        for (int i = 0; i < this._elemVector.size(); ++i) {
            Element elem = (Element)this._elemVector.elementAt(i);
            elem.setParentElement(this);
            if (elem == null || !elem.isActive() || elem.initialize()) continue;
            return false;
        }
        return true;
    }

    public ResNetwork getNetwork() {
        return this._network;
    }

    public Vector getElementVector() {
        return this._elemVector;
    }

    public Vector getElementsByClass(Class eclass, Vector vec) {
        if (vec == null) {
            vec = new Vector();
        }
        Element e = null;
        Object echild = null;
        int imax = this._elemVector.size();
        for (int i = 0; i < imax; ++i) {
            e = (Element)this._elemVector.elementAt(i);
            if (e == null) continue;
            if (eclass.isInstance(e)) {
                vec.add(e);
            }
            vec = e.getElementsByClass(eclass, vec);
        }
        return vec;
    }

    public Element getElementByName(String name) {
        Element e = null;
        Element echild = null;
        for (int i = 0; i < this._elemVector.size(); ++i) {
            e = (Element)this._elemVector.elementAt(i);
            if (e == null) continue;
            if (e.getName().equals(name)) {
                return e;
            }
            echild = e.getElementByName(name);
            if (echild == null) continue;
            return echild;
        }
        return null;
    }

    public Element getElement(int idx) {
        Element e = null;
        Element echild = null;
        for (int i = 0; i < this._elemVector.size(); ++i) {
            e = (Element)this._elemVector.elementAt(i);
            if (e == null) continue;
            if (e.getIndex() == idx) {
                return e;
            }
            echild = e.getElement(idx);
            if (echild == null) continue;
            return echild;
        }
        return null;
    }

    public void dispose() {
        int i;
        int imax = this._elemVector.size();
        for (i = 1; i <= imax; ++i) {
            Element e = (Element)this._elemVector.elementAt(imax - i);
            if (e == null) continue;
            e.dispose();
        }
        this._elemVector.removeAllElements();
        imax = this._nodeVector.size();
        for (i = 1; i <= imax; ++i) {
            Integer idir;
            ResNode n = (ResNode)((Object)this._nodeVector.elementAt(imax - i));
            if (n != null) {
                n.removeElement(this);
            }
            if ((idir = (Integer)this._nodeDirVector.elementAt(imax - i)) != 0) continue;
            n.dispose();
        }
        this._nodeVector.removeAllElements();
        this._nodeDirVector.removeAllElements();
    }

    public void cleanVectors() {
        int i;
        int imax = this._nodeVector.size();
        for (i = imax - 1; i >= 0; --i) {
            ResNode n = (ResNode)((Object)this._nodeVector.elementAt(i));
            if (n != null && !n.isDisposed()) continue;
            System.out.println("Clean Element: remove node " + n.getName());
            this._nodeVector.remove(i);
            this._nodeDirVector.remove(i);
        }
        imax = this._elemVector.size();
        for (i = imax - 1; i >= 0; --i) {
            Element e = (Element)this._elemVector.elementAt(i);
            e.cleanVectors();
            if (!e.isDisposed()) continue;
            System.out.println("Clean Element: remove element " + e.getFullName());
            this._elemVector.remove(i);
        }
    }

    public boolean isDisposed() {
        if (this._nodeVector.isEmpty()) {
            return true;
        }
        int imax = this._nodeVector.size();
        for (int i = imax - 1; i >= 0; --i) {
            Object n = this._nodeVector.elementAt(i);
            if (n == null) continue;
            return false;
        }
        return true;
    }

    public Vector getNodeVector() {
        return this._nodeVector;
    }

    public Vector getNodeDirVector() {
        return this._nodeDirVector;
    }

    public ResNode getDownstreamNode() {
        for (int i = 0; i < this._nodeVector.size(); ++i) {
            ResNode node = (ResNode)((Object)this._nodeVector.elementAt(i));
            Integer ndir = (Integer)this._nodeDirVector.elementAt(i);
            if (ndir != 0) continue;
            return node;
        }
        return null;
    }

    public Vector getDownstreamNodes(Vector vec) {
        if (vec == null) {
            vec = new Vector<ResNode>();
        }
        for (int i = 0; i < this._nodeVector.size(); ++i) {
            ResNode node = (ResNode)((Object)this._nodeVector.elementAt(i));
            Integer ndir = (Integer)this._nodeDirVector.elementAt(i);
            if (ndir != 0) continue;
            vec.add(node);
        }
        return vec;
    }

    public Vector getUpstreamNodes(Vector vec) {
        if (vec == null) {
            vec = new Vector<ResNode>();
        }
        for (int i = 0; i < this._nodeVector.size(); ++i) {
            ResNode node = (ResNode)((Object)this._nodeVector.elementAt(i));
            Integer ndir = (Integer)this._nodeDirVector.elementAt(i);
            if (ndir != 1) continue;
            vec.add(node);
        }
        return vec;
    }

    public void addNode(ResNode node, int idir, boolean makeTS) {
        if (this._nodeVector.contains((Object)node)) {
            return;
        }
        this._nodeVector.addElement(node);
        this._nodeDirVector.addElement(new Integer(idir));
        if (idir == 0) {
            node.setName(this._network.getKeyStringForObject(this));
        }
        if (idir == 0) {
            node.setUpstreamElement(this);
        } else {
            node.setDownstreamElement(this);
        }
    }

    public void addNode(ResNode node, int idir) {
        if (node == null || this._nodeVector.contains((Object)node)) {
            return;
        }
        this._nodeVector.addElement(node);
        this._nodeDirVector.addElement(new Integer(idir));
        if (idir == 0) {
            node.setName(this._network.getKeyStringForObject(this));
        }
        if (idir == 0) {
            node.setUpstreamElement(this);
        } else {
            node.setDownstreamElement(this);
        }
    }

    public void removeNode(ResNode node) {
        for (int i = 0; i < this._nodeVector.size(); ++i) {
            ResNode n = (ResNode)((Object)this._nodeVector.elementAt(i));
            if (n != node) continue;
            this._nodeVector.removeElementAt(i);
            this._nodeDirVector.removeElementAt(i);
            break;
        }
        node.removeElement(this);
    }

    public WorldPt getReferencePt() {
        if (this._nodeVector.size() > 0) {
            ResNode node = (ResNode)((Object)this._nodeVector.elementAt(0));
            return node.getLocation();
        }
        return null;
    }

    public Element findElement(String name) {
        String elemName = name;
        int idx = name.indexOf(";");
        if (idx >= 0) {
            elemName = name.substring(0, idx);
        }
        for (int i = 0; i < this._elemVector.size(); ++i) {
            Element elem = (Element)this._elemVector.elementAt(i);
            if (elem == null || elemName.compareTo(elem.getName()) != 0) continue;
            if (idx < 0) {
                return elem;
            }
            return elem.findElement(name.substring(idx + 1));
        }
        return null;
    }

    public TSDataSet getTSDataSet(boolean isInput) {
        if (isInput) {
            return this._network.getInputTSDataSet();
        }
        return this._network.getOutputTSDataSet();
    }

    public int getNodeCount() {
        return this._nodeVector.size();
    }

    public ResNode getNode(int idx) {
        if (idx < 0 || idx >= this._nodeVector.size()) {
            return null;
        }
        return (ResNode)((Object)this._nodeVector.elementAt(idx));
    }

    public int getNodeDir(int idx) {
        if (idx < 0 || idx >= this._nodeDirVector.size()) {
            return -1;
        }
        Integer ndir = (Integer)this._nodeDirVector.elementAt(idx);
        return ndir;
    }

    public void setName(String name) {
        String newname;
        int idx;
        int i;
        String curname = this.getName();
        if (this._elemVector != null) {
            for (i = 0; i < this._elemVector.size(); ++i) {
                String elemname;
                Element e = (Element)this._elemVector.elementAt(i);
                if (e == null || (idx = (elemname = e.getName()).indexOf(curname)) < 0) continue;
                newname = name + elemname.substring(idx + curname.length());
                e.setName(newname);
            }
        }
        if (this._nodeVector != null) {
            for (i = 0; i < this._nodeVector.size(); ++i) {
                String nodename;
                ResNode n = (ResNode)((Object)this._nodeVector.elementAt(i));
                if (n == null || (idx = (nodename = n.getName()).indexOf(curname)) < 0) continue;
                newname = name + nodename.substring(idx + curname.length());
                n.setName(newname);
            }
        }
        super.setName(name);
    }

    @Override
    public Vector getModelVariables(Vector variableList) {
        return variableList;
    }

    @Override
    public Vector getDefaultModelVariables() {
        return new Vector(0);
    }

    @Override
    public Vector getPlotTypes() {
        return null;
    }

    public BufferedReader getPlotTypeFile(String name) {
        String origName = name;
        if (!name.endsWith(".plotType")) {
            name = origName.concat(".plotType");
        }
        String path = this.getPlotTypeDirectory();
        String plotTypeName = path.concat("/").concat(name);
        URL url = this.getClass().getClassLoader().getResource(plotTypeName);
        if (url == null) {
            System.out.println("getPlotTypeName: failed to find URL for " + plotTypeName);
            return null;
        }
        File f = new File(url.getFile());
        try {
            if (f.exists()) {
                return new BufferedReader(new FileReader(f));
            }
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(plotTypeName);
            if (is != null) {
                return new BufferedReader(new InputStreamReader(is));
            }
        }
        catch (FileNotFoundException fne) {
            System.out.println("getPlotTypeName: file not found " + fne);
        }
        System.out.println("getPlotTypeName: failed to find file for " + url.getFile());
        return null;
    }

    public String getPlotTypeDirectory() {
        return "hec/resprm/client/plottypes/" + this.getElementType();
    }

    public Vector getPlotTypeNames() {
        Vector<String> v = null;
        String path = this.getPlotTypeDirectory();
        URL url = this.getClass().getClassLoader().getResource(path);
        if (url == null || url.getFile().indexOf("resprm.jar!/" + path) > 0) {
            v = this.getPlotTypeNamesFromJar(path);
        } else {
            String[] list;
            v = new Vector<String>();
            File f = new File(url.getFile());
            if (f.exists() && f.isDirectory() && (list = f.list()) != null) {
                v.ensureCapacity(list.length);
                for (int i = 0; i < list.length; ++i) {
                    String name = list[i];
                    name = name.endsWith(".plotType") ? list[i].substring(0, name.indexOf(".plotType")) : list[i];
                    v.add(name);
                }
            }
        }
        if (v.size() > 0) {
            Collections.sort(v);
            if (v.remove("default")) {
                v.add(0, "default");
            }
            return v;
        }
        System.out.println(this.getElementType() + ".getPlotTypeNames: Failed to find file " + (url == null ? path : url.getFile()));
        return v;
    }

    private Vector getPlotTypeNamesFromJar(String path) {
        Vector<String> v = new Vector<String>();
        String classPath = System.getProperty("java.class.path");
        if (classPath == null) {
            System.out.println("getPlotTypeNamesFromJar: got null classpath");
            return v;
        }
        StringTokenizer tokenizer = new StringTokenizer(classPath, File.pathSeparator);
        String token = null;
        boolean found = false;
        while (tokenizer.hasMoreTokens()) {
            token = tokenizer.nextToken();
            if (token.indexOf(PLOT_TYPES_JAR) <= -1) continue;
            found = true;
            break;
        }
        if (!found) {
            System.out.println("getPlotTypeNamesFromJar: failed to find Images.jar in " + classPath);
            return v;
        }
        try {
            JarFile rssJar = new JarFile(token);
            Enumeration<JarEntry> e = rssJar.entries();
            v.ensureCapacity(rssJar.size());
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                if (!entry.getName().startsWith(path) || entry.isDirectory()) continue;
                String name = entry.getName();
                int idx = name.lastIndexOf("/");
                idx = idx == -1 ? 0 : ++idx;
                if (name.endsWith(".plotType")) {
                    name = name.substring(idx, name.indexOf(".plotType"));
                }
                v.add(name);
            }
        }
        catch (IOException ioe) {
            System.out.println("getPlotTypeNamesFromJar: error reading jarfile " + token + " error " + ioe);
            return v;
        }
        v.trimToSize();
        return v;
    }

    public String getElementType() {
        if (this instanceof ReservoirElement) {
            return "reservoir";
        }
        if (this instanceof ReachElement) {
            return "reach";
        }
        if (this instanceof JunctionElement) {
            return "junction";
        }
        if (this instanceof DiversionElement) {
            return "diversion";
        }
        return "";
    }

    public int getElementTypeId() {
        if (this instanceof ReservoirElement) {
            return 1;
        }
        if (this instanceof ReachElement) {
            return 2;
        }
        if (this instanceof JunctionElement) {
            return 4;
        }
        if (this instanceof DiversionElement) {
            return 8;
        }
        return 0;
    }

    public Vector getTSRecords(ModelVariable modelVariable, Vector vec) {
        return vec;
    }

    @Override
    public Vector getTSRecords(ModelVariable modelVariable, Vector vec, Vector runs) {
        return this.getTSRecords(modelVariable, vec);
    }

    public void clearTSProxyList() {
        for (int j = 0; j < this._elemVector.size(); ++j) {
            Element elem = (Element)this._elemVector.elementAt(j);
            if (elem == null) continue;
            elem.clearTSProxyList();
        }
    }

    public void updateTSProxyList() {
        for (int j = 0; j < this._elemVector.size(); ++j) {
            Element elem = (Element)this._elemVector.elementAt(j);
            if (elem == null) continue;
            elem.updateTSProxyList();
        }
    }

    public Vector getActiveTSProxies(Vector vec, int iotype) {
        if (vec == null) {
            vec = new Vector();
        }
        for (int j = 0; j < this._elemVector.size(); ++j) {
            Element elem = (Element)this._elemVector.elementAt(j);
            if (elem == null || !elem.isActive()) continue;
            elem.getActiveTSProxies(vec, iotype);
        }
        return vec;
    }

    public TSRecordProxy getTSRecordProxy(int varId) {
        return null;
    }

    public void setObsDataVector(Vector obsDataList) {
        this.setModified(true);
        if (obsDataList == null) {
            this._obsDataVector = null;
            return;
        }
        this._obsDataVector = (Vector)obsDataList.clone();
    }

    public Vector getObsDataVector() {
        return this._obsDataVector;
    }

    public Vector getComputedTSRecordProxies() {
        Vector v = new Vector();
        if (this._elemVector.size() <= 0) {
            return v;
        }
        for (int i = 0; i < this._elemVector.size(); ++i) {
            Element child = (Element)this._elemVector.elementAt(i);
            if (child == null) continue;
            Vector cv = child.getComputedTSRecordProxies();
            for (int j = 0; j < cv.size(); ++j) {
                v.addElement(cv.elementAt(j));
            }
        }
        return v;
    }

    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return super.getFieldObject(fld);
        }
    }

    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return super.setFieldObject(fld, fobj);
        }
        catch (IllegalArgumentException e) {
            return super.setFieldObject(fld, fobj);
        }
    }
}

