/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.res.model;

import hec.clientapp.model.StreamAlignment;
import hec.map.WorldPt;
import hec.model.StreamElement;
import hec.model.StreamNode;
import hec.watershed.model.ComputationPoint;
import hec.watershed.res.model.DiversionElement;
import hec.watershed.res.model.Element;
import hec.watershed.res.model.ResNetwork;
import hec.watershed.res.model.ResNode;
import java.lang.reflect.Field;
import java.util.Observer;
import java.util.Vector;

public class JunctionElement
extends Element {
    protected boolean _hasKnownOutflow = false;
    protected int _cpIndex = 0;
    Vector _localFlowVec = new Vector();
    int _labelPosition = 0;
    long _computationPointId = Long.MIN_VALUE;
    transient ComputationPoint _computationPoint;
    transient double _station = Double.NEGATIVE_INFINITY;
    transient StreamElement _stream = null;

    public JunctionElement() {
    }

    public JunctionElement(ResNetwork network, int idx) {
        super(network, idx);
    }

    public void setLabelPosition(int p) {
        this._labelPosition = p;
    }

    public int getLabelPosition() {
        return this._labelPosition;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public void finalize() throws Throwable {
        if (this._stream != null) {
            this._stream.deleteObserver((Observer)((Object)this));
        }
        super.finalize();
    }

    public Vector getDiversions(Vector divVec) {
        if (divVec == null) {
            divVec = new Vector<Element>();
        }
        int imax = this._nodeVector.size();
        for (int i = 0; i < imax; ++i) {
            ResNode n = (ResNode)((Object)this._nodeVector.elementAt(i));
            if (n == null) continue;
            int idir = (Integer)this._nodeDirVector.elementAt(i);
            Element e = null;
            if (idir == 1) {
                e = n.getDownstreamElement();
            }
            if (e == null) continue;
            while (e.getParent() != null) {
                e = e.getParent();
            }
            if (!(e instanceof DiversionElement) || ((DiversionElement)e).getUpstreamNode() != n) continue;
            divVec.addElement(e);
        }
        return divVec;
    }

    public Vector getDownstreamDiversions(Vector divVec) {
        if (divVec == null) {
            divVec = new Vector<Element>();
        }
        int imax = this._nodeVector.size();
        for (int i = 0; i < imax; ++i) {
            ResNode n = (ResNode)((Object)this._nodeVector.elementAt(i));
            if (n == null) continue;
            int idir = (Integer)this._nodeDirVector.elementAt(i);
            Element e = null;
            if (idir == 0) {
                e = n.getDownstreamElement();
            }
            if (e == null) continue;
            while (e.getParent() != null) {
                e = e.getParent();
            }
            if (!(e instanceof DiversionElement) || ((DiversionElement)e).getUpstreamNode() != n) continue;
            divVec.addElement(e);
        }
        return divVec;
    }

    public Vector getConnectedElements() {
        Vector<Element> evec = new Vector<Element>();
        int imax = this._nodeVector.size();
        for (int i = 0; i < imax; ++i) {
            ResNode node = (ResNode)((Object)this._nodeVector.elementAt(i));
            int idir = (Integer)this._nodeDirVector.elementAt(i);
            Element e = null;
            e = idir == 1 ? node.getUpstreamElement() : node.getDownstreamElement();
            if (e == null) continue;
            while (e.getParent() != null) {
                e = e.getParent();
            }
            evec.addElement(e);
        }
        return evec;
    }

    public long getComputationPointId() {
        return this._computationPointId;
    }

    public void setComputationPoint(ComputationPoint cp) {
        this._computationPoint = cp;
        if (cp == null) {
            this._computationPointId = Long.MIN_VALUE;
            return;
        }
        this._computationPointId = cp.getId();
        this.setName(cp.getName());
    }

    public double getStreamStation() {
        if (this._station == Double.NEGATIVE_INFINITY) {
            for (int i = 0; i < this._nodeVector.size(); ++i) {
                ResNode node = (ResNode)((Object)this._nodeVector.elementAt(i));
                Integer ndir = (Integer)this._nodeDirVector.elementAt(i);
                if (ndir != 0) continue;
                this._station = node.getStreamStation();
            }
        }
        return this._station;
    }

    public boolean setStreamStation(StreamElement stream, double station) {
        ResNode node;
        int i;
        if (stream != null) {
            for (i = 0; i < this._nodeVector.size(); ++i) {
                node = (ResNode)((Object)this._nodeVector.elementAt(i));
                if (node.getStream() == null || node.getStream() == this.getStream()) continue;
                StreamAlignment align = this._network.getAlignment();
                if (align == null) {
                    return false;
                }
                WorldPt wpt = stream.getLocationByStation(station);
                for (int j = 0; j < this._nodeVector.size(); ++j) {
                    ResNode n = (ResNode)((Object)this._nodeVector.elementAt(j));
                    StreamNode snode = align.findNearestStreamNode(n.getStream(), wpt);
                    n.setStreamStation(snode.getStation());
                }
                return false;
            }
            if (this.getStream() != stream) {
                if (this._stream != null) {
                    this._network.printMessage("JunctionElement.setStreamStation: Warning - attempted to set station of junction " + this.getName() + " currently on stream " + this._stream.getName() + " to a station on stream " + stream.getName());
                }
                return false;
            }
        }
        for (i = 0; i < this._nodeVector.size(); ++i) {
            node = (ResNode)((Object)this._nodeVector.elementAt(i));
            node.setStreamStation(station);
        }
        this._station = station;
        return true;
    }

    public void resetStream() {
        if (this._stream != null) {
            this._stream.deleteObserver((Observer)((Object)this));
        }
        this._stream = null;
        this.getStream();
    }

    public StreamElement getStream() {
        if (this._stream == null) {
            for (int i = 0; i < this._nodeVector.size(); ++i) {
                ResNode node = (ResNode)((Object)this._nodeVector.elementAt(i));
                Integer ndir = (Integer)this._nodeDirVector.elementAt(i);
                if (node == null || ndir != 0) continue;
                this._stream = node.getStream();
                if (this._stream != null) {
                    this._stream.addObserver((Observer)((Object)this));
                    continue;
                }
                System.out.println(this.getName() + ".getStream: can't find stream for node " + node.getName());
            }
        }
        return this._stream;
    }

    public String[] getTribNameArray() {
        this.getStream();
        if (this._stream == null) {
            return null;
        }
        Vector<String> vec = new Vector<String>();
        for (int i = 0; i < this._nodeVector.size(); ++i) {
            ResNode node = (ResNode)((Object)this._nodeVector.elementAt(i));
            if (node.getStream() == null || node.getStream() == this._stream) continue;
            String sname = node.getStream().getName();
            boolean found = false;
            for (int j = 0; j < vec.size(); ++j) {
                if (!sname.equals((String)vec.elementAt(j))) continue;
                found = true;
                break;
            }
            if (found) continue;
            vec.addElement(sname);
        }
        if (vec.size() > 0) {
            String[] sa = new String[vec.size()];
            for (int i = 0; i < vec.size(); ++i) {
                sa[i] = (String)vec.elementAt(i);
            }
            return sa;
        }
        return null;
    }

    public Vector getLocalFlowVector() {
        Vector vec = new Vector();
        return vec;
    }

    public void setLocalFlowVector(Vector vect) {
    }

    public void setCPIndex(int cpIndex) {
        this._cpIndex = cpIndex;
    }

    public int getCPIndex() {
        return this._cpIndex;
    }

    public void setHasKnownOutflow(boolean hasKnownOutflow) {
        this._hasKnownOutflow = hasKnownOutflow;
    }

    public boolean getHasKnownOutflow() {
        return this._hasKnownOutflow;
    }

    public void addJunction(JunctionElement j) {
        ResNode dn = this.getDownstreamNode();
        ResNode dnj = j.getDownstreamNode();
        boolean hasDownstreamElem = false;
        if (dn.getDownstreamElement() != null) {
            hasDownstreamElem = true;
        }
        int imax = j._nodeVector.size();
        for (int i = 1; i <= imax; ++i) {
            ResNode n = (ResNode)((Object)j._nodeVector.elementAt(imax - i));
            if (n == null) continue;
            Integer ndir = (Integer)j._nodeDirVector.elementAt(imax - i);
            if (ndir == 1) {
                this.addNode(n, ndir);
                j.removeNode(n);
                continue;
            }
            if (n.getDownstreamElement() != null) {
                this.addNode(n, ndir);
                j.removeNode(n);
                if (hasDownstreamElem) continue;
                this.removeNode(dn);
                continue;
            }
            if (!(dn.getStreamCoord() < 0.01)) continue;
            this.addNode(n, ndir);
            j.removeNode(n);
            if (hasDownstreamElem) continue;
            this.removeNode(dn);
        }
        j.dispose();
        this._network.cleanVectors();
    }

    public boolean hasConnectedElements() {
        for (int i = 0; i < this._nodeVector.size(); ++i) {
            Integer idir;
            ResNode n = (ResNode)((Object)this._nodeVector.elementAt(i));
            if (n == null || !((idir = (Integer)this._nodeDirVector.elementAt(i)) == 1 ? n.getUpstreamElement() != null : n.getDownstreamElement() != null)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return super.getFieldObject(fld);
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return super.setFieldObject(fld, fobj);
        }
        catch (IllegalArgumentException e) {
            return super.setFieldObject(fld, fobj);
        }
    }
}

