/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.res.model;

import hec.clientapp.model.Manager;
import hec.clientapp.model.TSDataSet;
import hec.io.Identifier;
import hec.watershed.res.model.ResNetwork;
import java.rmi.RemoteException;
import java.util.Vector;

public abstract class ResAlt
extends Manager {
    protected transient ResNetwork _network = null;
    protected transient TSDataSet _inputTSData = null;
    protected transient TSDataSet _outputTSData = null;
    protected transient TSDataSet _observedTSData = null;
    protected String _networkPath = "";
    protected int _networkId = -1;
    protected String _inputTSDataPath = "";
    protected String _outputTSDataPath = "";
    protected String _observedTSDataPath = "";
    protected Vector _runList = new Vector();

    public ResAlt() {
    }

    public ResAlt(String name) {
        super(name);
    }

    public abstract String getNetworkClassName();

    public ResNetwork getNetwork() {
        if (this._network == null) {
            if (this._networkId == -1) {
                Identifier id = new Identifier(this._networkPath);
                try {
                    this._network = (ResNetwork)this._proxyList.loadManager(this.getNetworkClassName(), id);
                }
                catch (RemoteException re) {
                    this.printErrorMessage("PrmAlt.getNetwork - RemoteException" + re);
                    this.printMessage("Failed to load ResNetwork " + this._networkPath);
                }
                if (this._network != null) {
                    this._networkId = this._network.getIndex();
                    this.setModified(true);
                }
            } else {
                this._network = (ResNetwork)this._proxyList.openManager(this.getNetworkClassName(), this._networkId);
                if (this._network == null) {
                    Identifier id = new Identifier(this._networkPath);
                    try {
                        this._network = (ResNetwork)this._proxyList.loadManager(this.getNetworkClassName(), id);
                    }
                    catch (RemoteException re) {
                        this.printErrorMessage("PrmAlt.getNetwork - RemoteException" + re);
                        this.printMessage("Failed to load ResNetwork " + this._networkPath);
                    }
                    if (this._network != null) {
                        this._networkId = this._network.getIndex();
                        this.setModified(true);
                    }
                }
            }
        }
        return this._network;
    }

    public TSDataSet getInputTSDataSet() {
        if (this._inputTSData != null) {
            return this._inputTSData;
        }
        Identifier id = new Identifier(this._inputTSDataPath);
        try {
            this._inputTSData = (TSDataSet)this._proxyList.loadManager("hec.clientapp.model.TSDataSet", id);
        }
        catch (RemoteException re) {
            this.printErrorMessage("ResAlt.getInputTSData - RemoteException" + re);
            this.printMessage("Failed to load Input TSDataSet" + this._inputTSDataPath);
        }
        return this._inputTSData;
    }

    public String getNetworkName() {
        if (this._network != null) {
            return this._network.getName();
        }
        return this._networkPath;
    }

    public String getObservedTSDataName() {
        if (this._observedTSData != null) {
            return this._observedTSData.getName();
        }
        return this._observedTSDataPath;
    }

    public String getObservedTSDataPath() {
        return this._observedTSDataPath;
    }

    public TSDataSet getObservedTSDataSet() {
        if (this._observedTSData != null) {
            return this._observedTSData;
        }
        if (this._observedTSDataPath == null) {
            return null;
        }
        Identifier id = new Identifier(this._observedTSDataPath);
        try {
            this._observedTSData = (TSDataSet)this._proxyList.loadManager("hec.clientapp.model.TSDataSet", id);
        }
        catch (RemoteException re) {
            this.printErrorMessage("ResAlt.getObservedTSData - RemoteException" + re);
            this.printMessage("Failed to load Observed TSDataSet" + this._observedTSDataPath);
        }
        return this._observedTSData;
    }

    public String getInputTSDataName() {
        if (this._inputTSData != null) {
            return this._inputTSData.getName();
        }
        return this._inputTSDataPath;
    }

    public String getInputTSDataPath() {
        return this._inputTSDataPath;
    }

    public String getOutputTSDataName() {
        if (this._outputTSData != null) {
            return this._outputTSData.getName();
        }
        return this._outputTSDataPath;
    }

    public void setNetworkId(int id) {
        if (this._network != null) {
            this._proxyList.unloadManager(this._network.getIdentifier());
            this._network = null;
        }
        this._networkId = id;
        this.setModified(true);
    }

    public void setNetworkPath(String path) {
        if (this._network != null) {
            this._proxyList.unloadManager(this._network.getIdentifier());
            this._network = null;
        }
        this._networkPath = path;
        this.setModified(true);
    }

    public int getNetworkId() {
        return this._networkId;
    }

    public String getNetworkPath() {
        return this._networkPath;
    }

    public boolean reLoadFile(Identifier id) {
        if (this._reloadOk) {
            this._runList.removeAllElements();
            return this.readFile(id);
        }
        return false;
    }

    public void addRun(String run) {
        if (run == null || this._runList.contains(run)) {
            return;
        }
        this._runList.addElement(run);
        this.setModified(true);
    }

    public Vector getRunList() {
        return (Vector)this._runList.clone();
    }

    public void deleteRun(String run) {
        if (run == null) {
            return;
        }
        this._runList.removeElement(run);
        this.setModified(true);
    }

    public void renameRun(String old, String newr) {
        if (old == null || newr == null) {
            return;
        }
        this._runList.removeElement(old);
        this._runList.addElement(newr);
        this.setModified(true);
    }

    public void unloading() {
        this.unloadManagers();
    }

    protected void unloadManagers() {
        if (this._network != null) {
            this._proxyList.unloadManager(this._network.getIdentifier());
            this._network = null;
        }
        if (this._inputTSData != null) {
            this._proxyList.unloadManager(this._inputTSData.getIdentifier());
            this._inputTSData = null;
        }
        if (this._observedTSData != null) {
            this._proxyList.unloadManager(this._observedTSData.getIdentifier());
            this._observedTSData = null;
        }
    }
}

