/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.res.model;

import hec.clientapp.model.Manager;
import hec.clientapp.model.StreamAlignment;
import hec.clientapp.model.TSDataSet;
import hec.clientapp.model.TSRecordProxy;
import hec.clientapp.rmi.csinterface.RmiWorkspace;
import hec.io.AsciiSerializable;
import hec.io.HecFile;
import hec.io.Identifier;
import hec.lang.NamedType;
import hec.lang.UserId;
import hec.map.MapIdentifier;
import hec.map.MapObjectInterface;
import hec.map.WorldLine;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.WorldRegion;
import hec.map.crs.CoordinateReferenceSystem;
import hec.model.CommonDataList;
import hec.model.Node;
import hec.model.StreamElement;
import hec.model.StreamSegment;
import hec.model.TSLocation;
import hec.model.TSManager;
import hec.watershed.model.ComputationPoint;
import hec.watershed.model.Condition;
import hec.watershed.model.ConditionDataList;
import hec.watershed.model.Diversion;
import hec.watershed.model.Reservoir;
import hec.watershed.model.Study;
import hec.watershed.res.model.DiversionElement;
import hec.watershed.res.model.Element;
import hec.watershed.res.model.JunctionElement;
import hec.watershed.res.model.ReachElement;
import hec.watershed.res.model.ResNode;
import hec.watershed.res.model.ReservoirElement;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Observer;
import java.util.StringTokenizer;
import java.util.Vector;
import mil.army.usace.hec.rmi.csinterface.BaseDSSManager;
import mil.army.usace.hec.rmi.io.HecAsciiDeserializer;
import mil.army.usace.hec.rmi.io.HecAsciiSerializer;
import rma.util.RMAIO;

public class ResNetwork
extends Manager
implements MapObjectInterface,
TSManager,
AsciiSerializable {
    public static final int REACH = 0;
    public static final int RESERVOIR = 1;
    public static final int JUNCTION = 2;
    public static final int DIVERSION = 3;
    public static final int SPILLWAY = 4;
    public static final String KEYMARK = "~";
    public static final String KEYDELIM = ":";
    public static final int VERSION = 1012;
    int _version = -1;
    int _nextElementIndex = 0;
    int _nextNodeIndex = 0;
    protected Vector _nodeVector = new Vector();
    protected Vector _elementVector = new Vector();
    Vector _inputTSDataNameVector = new Vector();
    long _configurationID = Long.MIN_VALUE;
    transient TSDataSet _inputTSDataSet = null;
    transient TSDataSet _outputTSDataSet = null;
    transient StreamAlignment _align = null;
    transient Condition _configuration;
    transient int[] _elementOrder = null;
    transient Vector _activeElemVec = null;
    transient Vector _iterationBlockVec = null;
    transient CommonDataList _reservoirOpDataList;
    transient CommonDataList _reservoirSysOpDataList;
    transient String _baseDirectory = null;
    transient String _pairedDataDssFileName = null;

    public void finalize() throws Throwable {
        if (this._align != null) {
            this._align.deleteObserver((Observer)((Object)this));
        }
        super.finalize();
    }

    public boolean isKeyString(String str) {
        return str != null && str.length() > 2 && str.indexOf(KEYMARK) >= 0;
    }

    public String getNameForKeyString(String key) {
        if (!this.isKeyString(key)) {
            return key;
        }
        int idx0 = key.indexOf(KEYMARK);
        String prefix = idx0 > 0 ? key.substring(0, idx0) : "";
        NamedType obj = this.getObjectForKeyString(key);
        if (obj == null) {
            return key;
        }
        Object name = obj.getDisplayName();
        if (this.isKeyString((String)name)) {
            name = this.getNameForKeyString((String)name);
        }
        name = prefix + (String)name;
        int idx = key.lastIndexOf(KEYMARK);
        if (idx > 0 && idx < key.length() - 1) {
            name = (String)name + " " + key.substring(idx + 1);
        }
        return name;
    }

    public String getKeyStringForObject(Object obj) {
        if (obj == null) {
            return null;
        }
        String keystr = null;
        if (obj instanceof Element) {
            keystr = "~E" + Integer.toString(((Element)obj).getIndex());
        }
        return keystr;
    }

    public NamedType getObjectForKeyString(String keystr) {
        if (keystr == null) {
            return null;
        }
        Element pobj = null;
        TSLocation obj = null;
        String key = null;
        int idx0 = keystr.indexOf(KEYMARK);
        int idx1 = keystr.lastIndexOf(KEYMARK);
        if (idx0 >= 0) {
            keystr = idx0 != idx1 ? keystr.substring(idx0 + 1, idx1) : keystr.substring(idx0 + 1);
        }
        StringTokenizer tok = new StringTokenizer(keystr, KEYDELIM);
        while (tok.hasMoreElements()) {
            pobj = obj;
            key = tok.nextToken();
            if (key.substring(0, 1).equals("E")) {
                obj = this.getElement(Integer.parseInt(key.substring(1)));
                continue;
            }
            if (!key.substring(0, 1).equals("N")) continue;
            obj = this.getNode(Integer.parseInt(key.substring(1)));
        }
        return obj;
    }

    public void setupForSerialization() {
        int imax = this._elementVector.size();
        for (int i = 0; i < imax; ++i) {
            Element e = (Element)this._elementVector.get(i);
            e.setupForSerialization();
        }
    }

    public void cleanupFromDeSerialization() {
        System.out.println("RES SYSTEMS CLEANUP");
    }

    public String getBaseDirectory() {
        if (this._baseDirectory != null) {
            return this._baseDirectory;
        }
        return RMAIO.getDirectoryFromPath((String)this.getIdentifier().getPath());
    }

    public String getDssPairedDataFilePath() {
        String fileName = RMAIO.getFileFromPath((String)this.getIdentifier().getPath());
        if (this._pairedDataDssFileName == null) {
            return this.getBaseDirectory() + "/" + RMAIO.removeFileExtension((String)fileName) + ".dss";
        }
        return this.getBaseDirectory() + "/" + this._pairedDataDssFileName;
    }

    public void setConfiguration(Study study, Condition config) {
        int i;
        this._configuration = config;
        if (this._configuration == null) {
            this._configurationID = Long.MIN_VALUE;
            return;
        }
        this._configurationID = this._configuration.getId();
        if (study == null) {
            return;
        }
        Object[] compPtArray = study.getComputationPointList();
        if (compPtArray != null) {
            for (i = 0; i < compPtArray.length; ++i) {
                ComputationPoint cp = (ComputationPoint)compPtArray[i];
                if (cp == null || !cp.getSnapToStream() || cp.getStreamId() < 0) continue;
                ResNode onode = this.createNode(cp);
                JunctionElement junc = this.newJunctionElement(cp);
                junc.addNode(onode, 0);
            }
        }
        Vector resvec = this._configuration.getProjects("hec.watershed.model.Reservoir");
        int imax = resvec.size();
        for (i = 0; i < imax; ++i) {
            Reservoir resproj = (Reservoir)resvec.elementAt(i);
            if (resproj == null) continue;
            this.createReservoir(resproj);
        }
        Vector divvec = this._configuration.getProjects("hec.watershed.model.Diversion");
        imax = divvec.size();
        for (i = 0; i < imax; ++i) {
            Diversion divproj = (Diversion)divvec.elementAt(i);
            if (divproj == null) continue;
            Reservoir resproj = null;
            long resid = divproj.getReservoirId();
            if (resid >= 0L) {
                int jmax = resvec.size();
                for (int j = 0; j < jmax; ++j) {
                    Reservoir res = (Reservoir)resvec.elementAt(j);
                    if (res == null || res.getId() != divproj.getReservoirId()) continue;
                    resproj = res;
                    break;
                }
            }
            this.createDiversion(divproj, resproj);
        }
        this.setModified(true);
    }

    public Condition getConfiguration() {
        if (this._configuration == null && this._configurationID != Long.MIN_VALUE) {
            ConditionDataList conditionList = (ConditionDataList)this.getCommonDataList("hec.watershed.model.Condition", "");
            this._configuration = (Condition)conditionList.getObject(this._configurationID);
        }
        return this._configuration;
    }

    public void updateConfiguration() {
        Condition conf = this.getConfiguration();
        if (conf == null) {
            return;
        }
        this.cleanVectors();
        this.setModified(true);
        System.out.println("\n\nFinished updating configuration\n\n");
    }

    public boolean modifiyForSaveAs() {
        this._inputTSDataNameVector.clear();
        this._inputTSDataSet = null;
        this.setModified(true);
        return true;
    }

    public void addInputTSData(String name) {
        if (name == null || this._inputTSDataNameVector.contains(name)) {
            return;
        }
        this._inputTSDataNameVector.addElement(name);
        this.setModified(true);
    }

    public Vector getInputTSDataList() {
        return (Vector)this._inputTSDataNameVector.clone();
    }

    public void deleteInputTSData(String name) {
        if (name == null) {
            return;
        }
        this._inputTSDataNameVector.removeElement(name);
        this.setModified(true);
    }

    public void renameInputTSData(String old, String newr) {
        if (old == null || newr == null) {
            return;
        }
        this._inputTSDataNameVector.removeElement(old);
        this._inputTSDataNameVector.addElement(newr);
        this.setModified(true);
    }

    public Vector getDownstreamElements(Element startingElem) {
        Vector elemVec = new Vector();
        return elemVec;
    }

    public Vector getDownstreamNodes(Element startingElem) {
        Vector nodeVec = new Vector();
        return nodeVec;
    }

    public void init() {
    }

    public StreamAlignment getAlignment() {
        if (this._align == null) {
            this._align = (StreamAlignment)this._proxyList.openManager("main", "stream.align");
            if (this._align != null) {
                this.addObserver((Observer)((Object)this));
            }
        }
        return this._align;
    }

    public int getElementCount(String classname) {
        Class<?> c;
        try {
            c = Class.forName(classname);
        }
        catch (Exception e) {
            System.out.println(e.toString());
            return 0;
        }
        int icnt = 0;
        for (int i = 0; i < this._elementVector.size(); ++i) {
            Object obj = this._elementVector.elementAt(i);
            if (!c.isInstance(obj)) continue;
            ++icnt;
        }
        return icnt;
    }

    public Vector getElementNameVector(String classname) {
        Class<?> c;
        try {
            c = Class.forName(classname);
        }
        catch (Exception e) {
            System.out.println(e.toString());
            return null;
        }
        Vector<String> vec = new Vector<String>();
        for (int i = 0; i < this._elementVector.size(); ++i) {
            Object obj = this._elementVector.elementAt(i);
            if (!c.isInstance(obj)) continue;
            vec.addElement(((Element)obj).getName());
        }
        return vec;
    }

    public Element newElement(boolean addtolist) {
        Element elem = new Element(this, this.nextElementIndex());
        if (addtolist) {
            this._elementVector.addElement(elem);
        }
        elem.setName("Elem " + elem.getIndex());
        return elem;
    }

    public ReachElement newReachElement() {
        String name = this.getNextDefaultName(0);
        return this.newReachElement(name);
    }

    public ReachElement newReachElement(String name) {
        ReachElement reach = this.newReachElement(this, this.nextElementIndex());
        reach.setName(name);
        this._elementVector.addElement(reach);
        return reach;
    }

    protected ReachElement newReachElement(ResNetwork network, int index) {
        return new ReachElement(network, index);
    }

    public DiversionElement newDiversionElement() {
        String name = this.getNextDefaultName(3);
        return this.newDiversionElement(name);
    }

    public DiversionElement newDiversionElement(String name) {
        DiversionElement div = this.newDiversionElement(this, this.nextElementIndex());
        div.setName(name);
        this._elementVector.addElement(div);
        div.createDefaultElements();
        this.setModified(true);
        return div;
    }

    protected DiversionElement newDiversionElement(ResNetwork network, int index) {
        return new DiversionElement(network, index);
    }

    public JunctionElement newJunctionElement() {
        String name = this.getNextDefaultName(2);
        return this.newJunctionElement(name);
    }

    public JunctionElement newJunctionElement(String name) {
        JunctionElement junc = this.newJunctionElement(this, this.nextElementIndex());
        junc.setName(name);
        this._elementVector.addElement(junc);
        return junc;
    }

    public JunctionElement newJunctionElement(ComputationPoint cp) {
        JunctionElement junc = this.newJunctionElement(this, this.nextElementIndex());
        junc.setComputationPoint(cp);
        junc.setLabelPosition(cp.getLabelPosition());
        this._elementVector.addElement(junc);
        return junc;
    }

    protected JunctionElement newJunctionElement(ResNetwork network, int index) {
        return new JunctionElement(network, index);
    }

    public DiversionElement findDiversion(WorldPt wpt, double tol) {
        WorldRect rc = new WorldRect(wpt, tol);
        int imax = this._elementVector.size();
        for (int i = 1; i <= imax; ++i) {
            WorldPt pt;
            Element elem = (Element)this._elementVector.elementAt(imax - i);
            if (elem == null || !(elem instanceof DiversionElement)) continue;
            DiversionElement diversion = (DiversionElement)elem;
            if (diversion.getLine().nearPt(wpt, tol)) {
                return diversion;
            }
            ResNode n = diversion.getUpstreamNode();
            if (n != null && rc.contains(pt = n.getLocation())) {
                return diversion;
            }
            n = diversion.getDownstreamNode();
            if (n == null || !rc.contains(pt = n.getLocation())) continue;
            return diversion;
        }
        return null;
    }

    public DiversionElement findDiversion(String name) {
        int imax = this._elementVector.size();
        for (int i = 1; i <= imax; ++i) {
            Element elem = (Element)this._elementVector.elementAt(imax - i);
            if (elem == null || !(elem instanceof DiversionElement) || !elem.getName().equals(name)) continue;
            return (DiversionElement)elem;
        }
        return null;
    }

    public boolean deleteDiversion(String name) {
        int imax = this._elementVector.size();
        for (int i = 1; i <= imax; ++i) {
            DiversionElement div;
            Element elem = (Element)this._elementVector.elementAt(imax - i);
            if (elem == null || !(elem instanceof DiversionElement) || !(div = (DiversionElement)elem).getName().equals(name)) continue;
            div.dispose();
            this._elementVector.removeElementAt(imax - i);
            this.cleanVectors();
            this.setModified(true);
            return true;
        }
        return false;
    }

    public JunctionElement createJunction(ResNode node0, ResNode node1, double tol, String name, String descrip) {
        if (node0 == null && node1 == null) {
            return null;
        }
        JunctionElement junc = this.newJunctionElement();
        junc.addNode(node0, 1);
        if (node1 == null) {
            node1 = this.createNode(node0);
        }
        junc.addNode(node1, 0);
        if (name == null || name.length() == 0) {
            name = this.getNextDefaultName(2);
            junc.setName(name);
        } else {
            junc.setName(name);
            junc.setDescription(descrip);
        }
        this.setModified(true);
        return junc;
    }

    public ReachElement findReach(WorldPt wpt, double tol) {
        int imax = this._elementVector.size();
        for (int i = 0; i < imax; ++i) {
            Object elem = this._elementVector.elementAt(i);
            if (elem == null || !(elem instanceof ReachElement)) continue;
            ReachElement rch = (ReachElement)elem;
            WorldLine line = null;
            ResNode n0 = rch.getUpstreamNode();
            ResNode n1 = rch.getDownstreamNode();
            StreamElement stream = this.getAlignment().findReach(n0.getStreamIndex());
            if (stream != null) {
                double c0 = n0.getStreamCoord();
                double c1 = n1.getStreamCoord();
                line = stream.getLineSegment(c1, c0);
            } else {
                line = new WorldLine();
                line.pts.addElement(n0.getLocation());
                line.pts.addElement(n1.getLocation());
            }
            if (!line.nearPt(wpt, tol)) continue;
            return rch;
        }
        return null;
    }

    public ReachElement findReach(String name) {
        int imax = this._elementVector.size();
        for (int i = 1; i <= imax; ++i) {
            ReachElement reach;
            Element elem = (Element)this._elementVector.elementAt(imax - i);
            if (elem == null || !(elem instanceof ReachElement) || !(reach = (ReachElement)elem).getName().equals(name)) continue;
            return reach;
        }
        return null;
    }

    public void breakReach(ReachElement rch, WorldPt wpt) {
    }

    public boolean deleteReach(String name) {
        int imax = this._elementVector.size();
        for (int i = 1; i <= imax; ++i) {
            ReachElement reach;
            Element elem = (Element)this._elementVector.elementAt(imax - i);
            if (elem == null || !(elem instanceof ReachElement) || !(reach = (ReachElement)elem).getName().equals(name)) continue;
            reach.dispose();
            this._elementVector.removeElementAt(imax - i);
            this.cleanVectors();
            this.setModified(true);
            return true;
        }
        return false;
    }

    public JunctionElement findJunction(WorldPt wpt, double tol) {
        WorldRect rc = new WorldRect(wpt, tol);
        int imax = this._elementVector.size();
        for (int i = 1; i <= imax; ++i) {
            Element elem = (Element)this._elementVector.elementAt(imax - i);
            if (elem == null || !(elem instanceof JunctionElement) || !rc.contains(elem.getReferencePt())) continue;
            return (JunctionElement)elem;
        }
        return null;
    }

    public JunctionElement findJunction(String name) {
        int imax = this._elementVector.size();
        for (int i = 1; i <= imax; ++i) {
            Element elem = (Element)this._elementVector.elementAt(imax - i);
            if (elem == null || !(elem instanceof JunctionElement) || !elem.getName().equals(name)) continue;
            return (JunctionElement)elem;
        }
        return null;
    }

    public JunctionElement findJunction(ComputationPoint cp) {
        if (cp == null) {
            return null;
        }
        long cid = cp.getId();
        int imax = this._elementVector.size();
        for (int i = 1; i <= imax; ++i) {
            JunctionElement j;
            Element elem = (Element)this._elementVector.elementAt(imax - i);
            if (elem == null || !(elem instanceof JunctionElement) || (j = (JunctionElement)elem).getComputationPointId() != cid) continue;
            return j;
        }
        return null;
    }

    public boolean deleteJunction(String name) {
        int imax = this._elementVector.size();
        for (int i = 1; i <= imax; ++i) {
            Element elem = (Element)this._elementVector.elementAt(imax - i);
            if (elem == null || !(elem instanceof JunctionElement) || !elem.getName().equals(name)) continue;
            elem.dispose();
            this._elementVector.removeElementAt(imax - i);
            this.cleanVectors();
            this.setModified(true);
            return true;
        }
        return false;
    }

    public void cleanVectors() {
        int i;
        int imax = this._elementVector.size();
        for (i = 1; i <= imax; ++i) {
            Element elem = (Element)this._elementVector.elementAt(imax - i);
            if (elem == null) continue;
            elem.cleanVectors();
            if (!elem.isDisposed()) continue;
            System.out.println("Clean Vectors: removing element " + elem.getFullName());
            this._elementVector.removeElementAt(imax - i);
        }
        imax = this._nodeVector.size();
        for (i = 1; i <= imax; ++i) {
            ResNode node = (ResNode)((Object)this._nodeVector.elementAt(imax - i));
            if (node == null || !node.isDisposed()) continue;
            System.out.println("Clean Vectors: removing node " + node.getName());
            this._nodeVector.removeElementAt(imax - i);
        }
    }

    public ReservoirElement findReservoir(WorldPt wpt) {
        int imax = this._elementVector.size();
        for (int i = 1; i <= imax; ++i) {
            ReservoirElement res;
            Element elem = (Element)this._elementVector.elementAt(imax - i);
            if (elem == null || !(elem instanceof ReservoirElement) || !(res = (ReservoirElement)elem).getRegion().contains(wpt)) continue;
            return res;
        }
        return null;
    }

    public ReservoirElement findReservoir(int id) {
        int imax = this._elementVector.size();
        for (int i = 1; i <= imax; ++i) {
            ReservoirElement res;
            Element elem = (Element)this._elementVector.elementAt(imax - i);
            if (elem == null || !(elem instanceof ReservoirElement) || (res = (ReservoirElement)elem).getIndex() != id) continue;
            return res;
        }
        return null;
    }

    public ReservoirElement findReservoir(String name) {
        int imax = this._elementVector.size();
        for (int i = 1; i <= imax; ++i) {
            ReservoirElement res;
            Element elem = (Element)this._elementVector.elementAt(imax - i);
            if (elem == null || !(elem instanceof ReservoirElement) || !(res = (ReservoirElement)elem).getName().equals(name)) continue;
            return res;
        }
        return null;
    }

    public ReservoirElement findReservoir(int streamIndex, double coord) {
        if (streamIndex < 0 || coord == Double.NEGATIVE_INFINITY) {
            return null;
        }
        ReservoirElement reservoir = null;
        for (int ii = 0; ii < this._elementVector.size(); ++ii) {
            Object elem = this._elementVector.elementAt(ii);
            if (elem == null || !(elem instanceof ReservoirElement)) continue;
            reservoir = (ReservoirElement)elem;
            Vector segvec = reservoir.getStreamSegmentVector();
            if (segvec != null) {
                int size = segvec.size();
                for (int i = 0; i < size; ++i) {
                    StreamSegment ss = (StreamSegment)segvec.elementAt(i);
                    if (ss == null || streamIndex != ss.streamIndex || !(ss.downstreamCoord <= coord) || !(ss.upstreamCoord >= coord)) continue;
                    return reservoir;
                }
                continue;
            }
            Vector nvec = reservoir.getNodeVector();
            for (int i = 0; i < nvec.size(); ++i) {
                StreamElement stream;
                ResNode node = (ResNode)((Object)nvec.elementAt(i));
                if (node == null || node.getStreamIndex() != streamIndex || (stream = node.getStream()) == null) continue;
                double c0 = node.getStreamCoord();
                double c1 = Double.NEGATIVE_INFINITY;
                for (int j = 0; j < nvec.size(); ++j) {
                    ResNode node1;
                    if (i == j || (node1 = (ResNode)((Object)nvec.elementAt(j))) == null || node1.getStreamIndex() != node.getStreamIndex()) continue;
                    c1 = node1.getStreamCoord();
                    break;
                }
                if (c1 == Double.NEGATIVE_INFINITY) {
                    c1 = 0.0;
                }
                if (c1 >= c0 || !(c0 >= coord) || !(c1 <= coord)) continue;
                return reservoir;
            }
        }
        return null;
    }

    public void addReservoir(ReservoirElement resElem) {
        if (resElem == null) {
            return;
        }
        this._elementVector.addElement(resElem);
    }

    public boolean deleteReservoir(String name) {
        int imax = this._elementVector.size();
        for (int i = 1; i <= imax; ++i) {
            Element elem = (Element)this._elementVector.elementAt(imax - i);
            if (elem == null || !(elem instanceof ReservoirElement) || !elem.getName().equals(name)) continue;
            elem.dispose();
            this._elementVector.removeElementAt(imax - i);
            this.cleanVectors();
            this.setModified(true);
            return true;
        }
        return false;
    }

    public ReservoirElement createReservoir(WorldRegion reg) {
        if (reg == null) {
            return null;
        }
        ReservoirElement reservoir = this.newReservoirElement(this, this.nextElementIndex());
        reservoir.createDefaultElements();
        reservoir.setRegion(reg);
        this._elementVector.addElement(reservoir);
        int ir = this.getElementCount(reservoir.getClass().getName());
        reservoir.setName("Reservoir Element " + Integer.toString(ir));
        this.setModified(true);
        return reservoir;
    }

    public ReservoirElement createReservoir(WorldRegion reg, Vector nodeVec, Vector ndirVec, double tol, String name, String descrip) {
        if (reg == null) {
            return null;
        }
        ReservoirElement reservoir = this.newReservoirElement(this, this.nextElementIndex());
        reservoir.setRegion(reg);
        this._elementVector.addElement(reservoir);
        if (name == null || name.length() == 0) {
            name = this.getNextDefaultName(1);
            reservoir.setName(name);
        } else {
            reservoir.setName(name);
            reservoir.setDescription(descrip);
        }
        reservoir.createDefaultElements();
        this.setModified(true);
        WorldRect rc = new WorldRect();
        for (int ii = 0; ii < nodeVec.size(); ++ii) {
            int ndir;
            ResNode node = (ResNode)((Object)nodeVec.elementAt(ii));
            if (!this._nodeVector.contains((Object)node)) {
                node.setNetwork(this);
                node.setIndex(this.nextNodeIndex());
                this._nodeVector.addElement(node);
            }
            int jdir = (ndir = ((Integer)ndirVec.elementAt(ii)).intValue()) == 1 ? 0 : 1;
            rc.init(node.getLocation(), tol);
            JunctionElement junc = null;
            for (int i = 0; i < this._elementVector.size(); ++i) {
                Element e = (Element)this._elementVector.elementAt(i);
                if (e == null || !(e instanceof JunctionElement)) continue;
                JunctionElement j = (JunctionElement)e;
                if (junc == null && rc.contains(j.getReferencePt())) {
                    junc = j;
                    ResNode onode = junc.getDownstreamNode();
                    if (onode != null && onode.getDownstreamElement() == null) {
                        onode.dispose();
                    }
                    junc.addNode(node, jdir);
                }
                if (junc != null) break;
            }
            if (junc == null) {
                junc = this.newJunctionElement();
                junc.addNode(node, jdir);
                if (jdir == 1) {
                    ResNode onode = this.createNode(node.getLocation());
                    onode.setStreamIndex(node.getStreamIndex());
                    onode.setStreamCoord(node.getStreamCoord());
                    onode.setStreamStation(node.getStreamStation());
                    junc.addNode(onode, 0);
                }
            }
            reservoir.addNode(node, ndir);
        }
        return reservoir;
    }

    protected ReservoirElement newReservoirElement(ResNetwork network, int index) {
        return new ReservoirElement(network, index);
    }

    public ReservoirElement createReservoir(Reservoir resProject) {
        if (resProject == null) {
            return null;
        }
        ReservoirElement reservoir = this.newReservoirElement(this, this.nextElementIndex());
        reservoir.setRegion((WorldRegion)resProject.getRegion().clone());
        this._elementVector.addElement(reservoir);
        reservoir.setName(resProject.getName());
        reservoir.setDescription(resProject.getDescription());
        reservoir.createDefaultElements();
        reservoir.setReservoirProjectId(resProject.getId());
        this.setModified(true);
        Vector<Node> nodeVec = resProject.getNodeVector();
        Vector<Integer> nodeDirVec = resProject.getNodeDirVector();
        for (int ii = 0; ii < nodeVec.size(); ++ii) {
            Node rnode = nodeVec.elementAt(ii);
            Integer indir = nodeDirVec.elementAt(ii);
            ResNode node = this.createNode(rnode);
            int ndir = indir;
            int jdir = 1;
            if (ndir == 1) {
                jdir = 0;
            }
            JunctionElement junc = null;
            ComputationPoint cp = resProject.getComputationPointAt(ii);
            if (cp != null) {
                for (int i = 0; i < this._elementVector.size(); ++i) {
                    Element e = (Element)this._elementVector.elementAt(i);
                    if (e == null || !(e instanceof JunctionElement)) continue;
                    JunctionElement j = (JunctionElement)e;
                    if (j.getComputationPointId() == cp.getId()) {
                        junc = j;
                        ResNode onode = junc.getDownstreamNode();
                        if (onode != null && jdir == 0) {
                            onode.dispose();
                        }
                        junc.addNode(node, jdir);
                    }
                    if (junc != null) break;
                }
            }
            if (junc == null) {
                junc = this.newJunctionElement();
                junc.addNode(node, jdir);
                if (jdir == 1) {
                    ResNode onode = this.createNode(node.getLocation());
                    onode.setStreamIndex(node.getStreamIndex());
                    onode.setStreamCoord(node.getStreamCoord());
                    onode.setStreamStation(node.getStreamStation());
                    junc.addNode(onode, 0);
                }
            }
            reservoir.addNode(node, ndir);
        }
        reservoir.updateSegments();
        return reservoir;
    }

    public ResNode getConnectionNode(WorldPt pt, double tol, int idir) {
        int i;
        if (pt == null) {
            return null;
        }
        ResNode node = null;
        int imax = this._elementVector.size();
        WorldRect rc = new WorldRect(pt.e - tol, pt.n + tol, pt.e + tol, pt.n - tol);
        for (i = 0; i < imax; ++i) {
            WorldPt ptj;
            Element elem = (Element)this._elementVector.elementAt(i);
            if (elem == null || !(elem instanceof JunctionElement) || (ptj = elem.getReferencePt()) == null || !rc.contains(ptj)) continue;
            node = this.createNode(ptj);
            elem.addNode(node, idir);
            return node;
        }
        for (i = 0; i < imax; ++i) {
            ReachElement reach;
            ResNode rchNode;
            Element elem = (Element)this._elementVector.elementAt(i);
            if (elem != null && elem instanceof ReachElement && !rc.contains((rchNode = (reach = (ReachElement)elem).getUpstreamNode()).getLocation())) continue;
        }
        return null;
    }

    public ReachElement createReach(JunctionElement junc0, JunctionElement junc1, ResNode node0, ResNode node1, String reachName) {
        if (!junc0.getNodeVector().contains((Object)node0)) {
            junc0.addNode(node0, 1);
        }
        if (!junc1.getNodeVector().contains((Object)node1)) {
            junc0.addNode(node1, 0);
        }
        ReachElement reach = this.newReachElement(reachName);
        reach.addNode(node0, 1);
        reach.addNode(node1, 0);
        this.setModified(true);
        return reach;
    }

    public ReachElement createReach(ResNode node0, ResNode node1, double tol, String name, String descrip) {
        if (node0 == null || node1 == null) {
            return null;
        }
        WorldRect rc0 = new WorldRect(node0.getLocation(), tol);
        WorldRect rc1 = new WorldRect(node1.getLocation(), tol);
        JunctionElement junc0 = null;
        JunctionElement junc1 = null;
        for (int i = 0; i < this._elementVector.size(); ++i) {
            ResNode onode;
            Element e = (Element)this._elementVector.elementAt(i);
            if (e == null || !(e instanceof JunctionElement)) continue;
            JunctionElement j = (JunctionElement)e;
            if (junc0 == null && j != junc1 && rc0.contains(j.getReferencePt())) {
                junc0 = j;
                onode = junc0.getDownstreamNode();
                if (onode != null && onode.getDownstreamElement() == null) {
                    onode.dispose();
                }
                junc0.addNode(node0, 0);
            } else if (junc1 == null && j != junc0 && rc1.contains(j.getReferencePt())) {
                junc1 = j;
                junc1.addNode(node1, 1);
                onode = junc1.getDownstreamNode();
                if (onode != null && onode.getStreamIndex() != node1.getStreamIndex() && onode.getStreamCoord() < 0.01) {
                    onode.setStream(node1.getStream());
                    onode.setStreamIndex(node1.getStreamIndex());
                    onode.setStreamStation(node1.getStreamStation());
                    onode.setStreamCoord(node1.getStreamCoord());
                }
            }
            if (junc0 != null && junc1 != null) break;
        }
        if (junc0 == null) {
            junc0 = this.newJunctionElement();
            junc0.addNode(node0, 0);
        }
        if (junc1 == null) {
            junc1 = this.newJunctionElement();
            junc1.addNode(node1, 1);
            ResNode onode = this.createNode(node1.getLocation());
            onode.setStreamIndex(node1.getStreamIndex());
            onode.setStreamCoord(node1.getStreamCoord());
            onode.setStreamStation(node1.getStreamStation());
            junc1.addNode(onode, 0);
        }
        ReachElement reach = this.newReachElement();
        reach.addNode(node0, 1);
        reach.addNode(node1, 0);
        if (name == null || name.length() == 0) {
            name = this.getNextDefaultName(0);
            reach.setName(name);
        } else {
            reach.setName(name);
            reach.setDescription(descrip);
        }
        this.setModified(true);
        return reach;
    }

    public DiversionElement createDiversion(ResNode node0, ResNode node1, Vector ptVec, double tol, String name, String descrip) {
        if (node0 == null) {
            return null;
        }
        DiversionElement div = this.newDiversionElement();
        div.addNode(node0, 1);
        if (node1 != null) {
            div.addNode(node1, 0);
        }
        WorldLine wl = new WorldLine();
        for (int i = 0; i < ptVec.size(); ++i) {
            wl.pts.addElement(ptVec.elementAt(i));
        }
        div.setLine(wl);
        if (name == null || name.length() == 0) {
            name = this.getNextDefaultName(3);
            div.setName(name);
        } else {
            div.setName(name);
            div.setDescription(descrip);
        }
        this.setModified(true);
        return div;
    }

    public Element createDiversion(Diversion divproj, Reservoir resproj) {
        DiversionElement div;
        if (divproj == null) {
            return null;
        }
        long rid = divproj.getReservoirId();
        if (rid < 0L) {
            boolean bUpstream = true;
            JunctionElement jup = null;
            JunctionElement jdown = null;
            ComputationPoint cpUp = divproj.getComputationPoint(bUpstream);
            if (cpUp == null) {
                return null;
            }
            jup = this.findJunction(cpUp);
            if (jup == null) {
                jup = this.findJunction(cpUp.getName());
            }
            if (jup == null) {
                return null;
            }
            bUpstream = false;
            ComputationPoint cpDown = divproj.getComputationPoint(bUpstream);
            if (cpDown != null && (jdown = this.findJunction(cpDown)) == null) {
                jdown = this.findJunction(cpDown.getName());
            }
            ResNode node0 = this.createNode(cpUp);
            jup.addNode(node0, 1);
            ResNode node1 = null;
            if (cpDown != null && jdown != null) {
                node1 = this.createNode(cpDown);
                jdown.addNode(node1, 1);
            }
            div = this.newDiversionElement();
            div.setDiversionProjectId(divproj.getId());
            div.setName(divproj.getName());
            div.setDescription(divproj.getDescription());
            div.addNode(node0, 1);
            if (node1 != null) {
                div.addNode(node1, 0);
            }
        } else {
            ReservoirElement res = null;
            int iemax = this._elementVector.size();
            for (int ie = 0; ie < iemax; ++ie) {
                ReservoirElement restmp;
                Element elem = (Element)this._elementVector.elementAt(ie);
                if (elem == null || !(elem instanceof ReservoirElement) || (restmp = (ReservoirElement)elem).getReservoirProjectId() != resproj.getId()) continue;
                res = restmp;
                break;
            }
            if (res == null) {
                return null;
            }
            long divprojid = divproj.getId();
            Vector dvec = res.getDownstreamDiversions(null);
            int imax = dvec.size();
            for (int i = 0; i < imax; ++i) {
                DiversionElement divout = (DiversionElement)dvec.elementAt(i);
                if (divout == null || divout.getDiversionProjectId() != divprojid) continue;
                return null;
            }
            JunctionElement jdown = null;
            boolean bUpstream = false;
            ComputationPoint cpDown = divproj.getComputationPoint(bUpstream);
            if (cpDown != null && (jdown = this.findJunction(cpDown)) == null) {
                jdown = this.findJunction(cpDown.getName());
            }
            Node upnode = divproj.getUpstreamNode();
            ResNode node0 = this.newNode();
            node0.setName(upnode.getName());
            node0.setStreamIndex(upnode.getStreamIndex());
            node0.setStreamName(upnode.getStreamName());
            node0.setStreamStation(upnode.getStreamStation());
            ResNode node1 = null;
            if (cpDown != null && jdown != null) {
                node1 = this.createNode(cpDown);
                jdown.addNode(node1, 1);
            }
            WorldLine wl = (WorldLine)divproj.getLine().clone();
            DiversionElement div2 = this.createDiversion(node0, node1, wl.pts, 0.0, divproj.getName(), divproj.getDescription());
            div2.setInflowType(1);
            this.setModified(true);
            return div2;
        }
        WorldLine wl = (WorldLine)divproj.getLine().clone();
        div.setLine(wl);
        this.setModified(true);
        return null;
    }

    public ReachElement findReach(int streamIndex, double coord) {
        if (streamIndex < 0 || coord == Double.NEGATIVE_INFINITY) {
            return null;
        }
        ReachElement rch = null;
        for (int i = 0; i < this._elementVector.size(); ++i) {
            Object elem = this._elementVector.elementAt(i);
            if (elem == null || !(elem instanceof ReachElement)) continue;
            rch = (ReachElement)elem;
            ResNode n0 = rch.getUpstreamNode();
            ResNode n1 = rch.getDownstreamNode();
            if (n0 == null || n1 == null || streamIndex != n0.getStreamIndex() || !(n0.getStreamCoord() >= coord) || !(n1.getStreamCoord() <= coord)) continue;
            return rch;
        }
        return null;
    }

    public Vector getElementVector() {
        return this._elementVector;
    }

    public Vector getNodeVector() {
        return this._nodeVector;
    }

    public Vector getElementVectorByClass(String classname) {
        Class<?> c;
        try {
            c = Class.forName(classname);
        }
        catch (Exception e) {
            System.out.println(e.toString());
            return null;
        }
        return this.getElementVectorByClass(c);
    }

    public Vector getElementVectorByClass(Class c) {
        Vector vec = new Vector();
        Enumeration e = this._elementVector.elements();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            if (!c.isInstance(obj)) continue;
            vec.addElement(obj);
        }
        return vec;
    }

    public int[] getElementOrder() {
        return this._elementOrder;
    }

    public Element getElement(int idx) {
        Element e = null;
        Element echild = null;
        for (int i = 0; i < this._elementVector.size(); ++i) {
            e = (Element)this._elementVector.elementAt(i);
            if (e == null) continue;
            if (e.getIndex() == idx) {
                return e;
            }
            echild = e.getElement(idx);
            if (echild == null) continue;
            return echild;
        }
        return null;
    }

    public Element findElement(int idx) {
        Element e = null;
        for (int i = 0; i < this._elementVector.size(); ++i) {
            e = (Element)this._elementVector.elementAt(i);
            if (e == null || e.getIndex() != idx) continue;
            return e;
        }
        return null;
    }

    public Element findElement(String name) {
        String elemName = name;
        int idx = name.indexOf(";");
        if (idx >= 0) {
            elemName = name.substring(0, idx);
        }
        for (int i = 0; i < this._elementVector.size(); ++i) {
            Element elem = (Element)this._elementVector.elementAt(i);
            if (elem == null || elemName.compareTo(elem.getName()) != 0) continue;
            if (idx < 0) {
                return elem;
            }
            return elem.findElement(name.substring(idx + 1));
        }
        return null;
    }

    public Vector checkForDuplicateNames() {
        Vector vec = new Vector();
        if (this._elementVector == null || this._elementVector.size() < 2) {
            return vec;
        }
        HashMap<String, Element> hashMap = new HashMap<String, Element>(this._elementVector.size());
        int nsize = this._elementVector.size();
        for (int i = 0; i < nsize; ++i) {
            Element elem = (Element)this._elementVector.get(i);
            Object obj = hashMap.get(elem.getName());
            if (obj != null) {
                Vector<Element> v = new Vector<Element>();
                v.add(elem);
                v.add((Element)obj);
                vec.add(v);
                continue;
            }
            hashMap.put(elem.getName(), elem);
        }
        return vec;
    }

    public String[] getNodeNames(String type) {
        Vector<String> v = new Vector<String>();
        ResNode n = null;
        for (int i = 0; i < this._nodeVector.size(); ++i) {
            TSRecordProxy proxy;
            n = (ResNode)((Object)this._nodeVector.elementAt(i));
            if (n == null || (proxy = (TSRecordProxy)n.getTSRecordProxy(type)) == null) continue;
            v.addElement(n.getName());
        }
        if (v.size() <= 0) {
            return null;
        }
        String[] names = new String[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            names[i] = (String)v.elementAt(i);
        }
        return names;
    }

    public double[] findTSArray(String locType, String locName, String param) {
        block3: {
            block2: {
                if (locType.compareTo("Node") != 0) break block2;
                for (int i = 0; i < this._nodeVector.size(); ++i) {
                    ResNode node = (ResNode)((Object)this._nodeVector.elementAt(i));
                    if (node == null || locName.compareTo(node.getName()) != 0) continue;
                    return node.getTSArray(param);
                }
                break block3;
            }
            if (locType.compareTo("Element") != 0) break block3;
            for (int i = 0; i < this._elementVector.size(); ++i) {
                Element elem = (Element)this._elementVector.elementAt(i);
                if (elem == null || locName.compareTo(elem.getName()) != 0) continue;
                return null;
            }
        }
        return null;
    }

    public boolean initialize(TSDataSet inputTS, TSDataSet outputTS) {
        int i;
        this._inputTSDataSet = inputTS;
        this._outputTSDataSet = outputTS;
        int imax = this._nodeVector.size();
        for (i = imax - 1; i >= 0; --i) {
            ResNode node = (ResNode)((Object)this._nodeVector.elementAt(i));
            if (node == null || !node.isValid()) {
                this._nodeVector.remove(i);
            }
            if (!node.isActive()) continue;
            node.initialize();
        }
        imax = this._elementVector.size();
        for (i = 0; i < imax; ++i) {
            Element elem = (Element)this._elementVector.elementAt(i);
            if (elem == null || !elem.isActive() || elem.initialize()) continue;
            return false;
        }
        return true;
    }

    public void setInputTSDataSet(TSDataSet tsData) {
        this._inputTSDataSet = tsData;
    }

    public TSDataSet getInputTSDataSet() {
        return this._inputTSDataSet;
    }

    public void setOutputTSDataSet(TSDataSet tsData) {
        this._outputTSDataSet = tsData;
    }

    public TSDataSet getOutputTSDataSet() {
        return this._outputTSDataSet;
    }

    public ResNode findNode(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        ResNode n = null;
        for (int i = 0; i < this._nodeVector.size(); ++i) {
            n = (ResNode)((Object)this._nodeVector.elementAt(i));
            if (n == null || !name.equals(n.getName())) continue;
            return n;
        }
        return null;
    }

    public ResNode getNode(int idx) {
        ResNode n = null;
        for (int i = 0; i < this._nodeVector.size(); ++i) {
            n = (ResNode)((Object)this._nodeVector.elementAt(i));
            if (n == null || n.getIndex() != idx) continue;
            return n;
        }
        return null;
    }

    public void setMapIdentifier(MapIdentifier id) {
    }

    public MapIdentifier getMapIdentifier() {
        MapIdentifier id = new MapIdentifier(this.getIdentifier());
        id.setIsManager(true);
        return id;
    }

    public void setExtent(WorldRect rc) {
    }

    public WorldRect getExtent() {
        WorldRect rc = new WorldRect();
        return rc;
    }

    public void load() throws IOException {
        if (this._identifier != null) {
            this.readFile(this._identifier);
        }
    }

    public void unload() {
    }

    public void clearTSProxyList() {
        int i;
        int imax = this._nodeVector.size();
        for (i = 0; i < imax; ++i) {
            ResNode node = (ResNode)((Object)this._nodeVector.elementAt(i));
            if (node == null) continue;
            node.clearTSProxyList();
        }
        imax = this._elementVector.size();
        for (i = 0; i < imax; ++i) {
            Element elem = (Element)this._elementVector.elementAt(i);
            if (elem == null) continue;
            elem.clearTSProxyList();
        }
    }

    public void updateTSProxyList() {
        this.clearTSProxyList();
        int imax = this._elementVector.size();
        for (int i = 0; i < imax; ++i) {
            Element elem = (Element)this._elementVector.elementAt(i);
            if (elem == null) continue;
            elem.updateTSProxyList();
        }
    }

    public Vector getObservedDataTSProxies(Vector vec) {
        int imax = this._elementVector.size();
        for (int i = 0; i < imax; ++i) {
            Vector v;
            Element elem = (Element)this._elementVector.elementAt(i);
            if (elem == null || !elem.isActive() || (v = elem.getObsDataVector()) == null) continue;
            vec.addAll(v);
        }
        return vec;
    }

    public Vector getTSRecordProxies() {
        return new Vector();
    }

    public Vector getTSRecordProxies(boolean isInput) {
        return new Vector();
    }

    public String getNextDefaultName(int type) {
        String prefix;
        String classname;
        switch (type) {
            case 0: {
                classname = "hec.watershed.res.model.ReachElement";
                prefix = "Reach";
                break;
            }
            case 1: {
                classname = "hec.watershed.res.model.ReservoirElement";
                prefix = "Res";
                break;
            }
            case 2: {
                classname = "hec.watershed.res.model.JunctionElement";
                prefix = "Jct";
                break;
            }
            case 3: {
                classname = "hec.watershed.res.model.DiversionElement";
                prefix = "Div";
                break;
            }
            default: {
                return "Untitled";
            }
        }
        int icnt = this.getElementCount(classname);
        String[] names = this.getElementNames(classname);
        String name = prefix + " " + Integer.toString(icnt);
        if (names == null) {
            return name;
        }
        boolean notdone = true;
        while (notdone) {
            notdone = false;
            for (int i = 0; i < names.length; ++i) {
                if (!names[i].equalsIgnoreCase(name)) continue;
                notdone = true;
                name = prefix + " " + Integer.toString(++icnt);
            }
        }
        return name;
    }

    public String[] getElementNames(String classname) {
        int i;
        Class<?> c = null;
        try {
            c = Class.forName(classname);
        }
        catch (ClassNotFoundException e) {
            System.out.println(e.toString());
            return null;
        }
        Vector<String> tempNames = new Vector<String>();
        for (i = 0; i < this._elementVector.size(); ++i) {
            Element elem = (Element)this._elementVector.elementAt(i);
            if (elem == null || !c.isInstance(elem)) continue;
            tempNames.addElement(elem.getName());
        }
        if (tempNames.size() <= 0) {
            return null;
        }
        String[] names = new String[tempNames.size()];
        for (i = 0; i < tempNames.size(); ++i) {
            names[i] = (String)tempNames.elementAt(i);
        }
        return names;
    }

    public String[] getReservoirNames() {
        return this.getElementNames("hec.watershed.res.model.ReservoirElement");
    }

    public String[] getReachNames() {
        return this.getElementNames("hec.watershed.res.model.ReachElement");
    }

    public String[] getJunctionNames() {
        return this.getElementNames("hec.watershed.res.model.JunctionElement");
    }

    public String[] getDiversionNames() {
        return this.getElementNames("hec.watershed.res.model.DiversionElement");
    }

    public ResNode newNode() {
        ResNode node = new ResNode(this, this.nextNodeIndex());
        this._nodeVector.addElement(node);
        node.setName("Node " + Integer.toString(node.getIndex()));
        node.setDescription("");
        this.setModified(true);
        return node;
    }

    public ResNode createNode(WorldPt pt) {
        if (pt == null) {
            return null;
        }
        ResNode node = this.newNode();
        node.setLocation(pt);
        return node;
    }

    public ResNode createNode(ComputationPoint cp) {
        if (cp == null) {
            return null;
        }
        ResNode node = this.newNode();
        node.setComputationPoint(cp);
        return node;
    }

    public ResNode createNode(Node n) {
        if (n == null) {
            return null;
        }
        ResNode node = this.newNode();
        node.setLocation(n.getLocation());
        node.setStreamIndex(n.getStreamIndex());
        node.setStreamCoord(n.getStreamCoord());
        node.setStreamStation(n.getStreamStation());
        return node;
    }

    public void deleteNode(ResNode node) {
        if (this._nodeVector.contains((Object)node)) {
            this._nodeVector.remove((Object)node);
            node.dispose();
            this.setModified(true);
        }
    }

    public ResNode findDownstreamNode(int streamIndex, double coord) {
        ResNode dnode = null;
        ResNode node = null;
        double tol = 1.0E-9;
        for (int i = 0; i < this._nodeVector.size(); ++i) {
            node = (ResNode)((Object)this._nodeVector.elementAt(i));
            if (node == null || streamIndex != node.getStreamIndex()) continue;
            double diff = coord - node.getStreamCoord();
            if (!(node.getStreamCoord() < coord) || Math.abs(diff) < tol || dnode != null && !(dnode.getStreamCoord() < node.getStreamCoord())) continue;
            dnode = node;
        }
        return dnode;
    }

    public ResNode findUpstreamNode(int streamIndex, double coord) {
        ResNode dnode = null;
        ResNode node = null;
        for (int i = 0; i < this._nodeVector.size(); ++i) {
            node = (ResNode)((Object)this._nodeVector.elementAt(i));
            if (node == null || streamIndex != node.getStreamIndex() || !(node.getStreamCoord() > coord) || dnode != null && !(dnode.getStreamCoord() > node.getStreamCoord())) continue;
            dnode = node;
        }
        return dnode;
    }

    private Vector getDownstreamElementsWithDiv(Element firstElem, Element lastElem) {
        Element elem;
        int i;
        Vector evec = this.getDownstreamElements(firstElem);
        int imax = evec.size();
        for (i = imax - 1; i >= 0 && (elem = (Element)evec.elementAt(i)) != lastElem; --i) {
            evec.removeElementAt(i);
        }
        imax = evec.size();
        if (imax < 1) {
            return evec;
        }
        boolean gotdiv = false;
        Vector divVec = new Vector();
        for (i = 0; i < imax; ++i) {
            elem = (Element)evec.elementAt(i);
            if (elem == null) continue;
            if (elem instanceof JunctionElement) {
                divVec.clear();
                divVec = ((JunctionElement)elem).getDiversions(divVec);
                int jmax = divVec.size();
                for (int j = 0; j < jmax; ++j) {
                    Element delem;
                    int l;
                    System.out.println("\nElem " + elem.getName() + " has " + jmax + " diversions");
                    DiversionElement div = (DiversionElement)divVec.elementAt(j);
                    if (div == null) continue;
                    evec.insertElementAt(div, i);
                    ++i;
                    ResNode dn = div.getDownstreamNode();
                    if (dn == null) continue;
                    int k = i + 1;
                    Element felem = dn.getDownstreamElement();
                    Vector devec = this.getDownstreamElements(felem);
                    devec.insertElementAt(felem, 0);
                    if (!devec.contains(lastElem)) continue;
                    System.out.println("Div " + div.getName() + " does connect back at " + lastElem.getName());
                    int lmax = devec.size();
                    for (l = 0; l < lmax; ++l) {
                        Element te = (Element)devec.elementAt(l);
                        System.out.println("devec elem " + te.getName());
                        if (te == lastElem) break;
                    }
                    gotdiv = true;
                    for (l = 0; l < lmax && !evec.contains(delem = (Element)devec.elementAt(l)); ++l) {
                        evec.insertElementAt(delem, k);
                        ++k;
                    }
                }
            }
            imax = evec.size();
        }
        if (gotdiv) {
            for (i = 0; i < evec.size(); ++i) {
                Element te = (Element)evec.elementAt(i);
                System.out.println("evec elem " + te.getName());
                if (te == lastElem) break;
            }
        }
        return evec;
    }

    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get((Object)this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return super.getFieldObject(fld);
        }
    }

    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set((Object)this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return super.setFieldObject(fld, fobj);
        }
        catch (IllegalArgumentException e) {
            return super.setFieldObject(fld, fobj);
        }
    }

    public int nextElementIndex() {
        int i = this._nextElementIndex++;
        return i;
    }

    private int nextNodeIndex() {
        int i = this._nextNodeIndex++;
        return i;
    }

    public boolean refreshData(Manager otherMgr) {
        if (!(otherMgr instanceof ResNetwork)) {
            return false;
        }
        ResNetwork otherSys = (ResNetwork)otherMgr;
        String name = this.getName();
        String description = this.getDescription();
        int index = this.getIndex();
        this.readFile(otherSys.getIdentifier());
        this.getIdentifier().setName(name);
        this.setName(name);
        this.setDescription(description);
        this.setIndex(index);
        this._proxyList.saveManager(UserId.getUserId(), (Manager)this);
        return true;
    }

    public void deleting() {
    }

    public void renamed(Identifier id) {
        super.renamed(id);
    }

    public boolean readFile(Identifier id) {
        int maxNode = -1;
        int maxElem = -1;
        boolean success = true;
        String strout = new String();
        HecFile file = id.getFile();
        System.out.println("opening " + file.getPath());
        try {
            BufferedReader input = file.getBufferedReader();
            HecAsciiDeserializer deser = new HecAsciiDeserializer(input);
            this._baseDirectory = RMAIO.getDirectoryFromPath((String)id.getPath());
            deser.setDssFileManager((BaseDSSManager)this.getDSSFileManager());
            RmiWorkspace workspace = (RmiWorkspace)this.getWorkspace().getRemote();
            deser.setWorkspacePath(this._baseDirectory);
            success = deser.deserializeObject((Object)this);
            this._baseDirectory = null;
            this._pairedDataDssFileName = null;
            input.close();
        }
        catch (IOException e) {
            this.printErrorMessage("Failed to open file " + id.getPath());
            return false;
        }
        this.setModified(false);
        if (!success) {
            this.printErrorMessage("Failed to correctly read file " + id.getPath());
        }
        this.cleanVectors();
        this.updateTSProxyList();
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeFile(Identifier id) {
        BufferedWriter out;
        if (this.getReadOnly()) {
            System.out.println("File " + id.getFile().getPath() + " is marked readonly");
            return false;
        }
        this._version = 1012;
        super.writeFile(id);
        String strout = new String();
        HecFile file = id.getFile();
        System.out.println("writing " + file.getPath());
        this.setReloadOk(false);
        try {
            out = file.getBufferedWriter();
            if (out == null) {
                return false;
            }
            out.write("System Name=" + this.getName());
            out.newLine();
            out.newLine();
            HecAsciiSerializer ser = new HecAsciiSerializer(out);
            RmiWorkspace workspace = (RmiWorkspace)this.getWorkspace().getRemote();
            this._baseDirectory = RMAIO.getDirectoryFromPath((String)id.getPath());
            ser.setWorkspacePath(this._baseDirectory);
            ser.setDssFileManager((BaseDSSManager)this.getDSSFileManager());
            ser.setFileManager(this.getFileManager());
            ser.serializeObject((Object)this);
            this._baseDirectory = null;
            this._pairedDataDssFileName = null;
        }
        catch (IOException e) {
            this.printMessage("Failed to open file " + id.getPath());
            return false;
        }
        try {
            out.flush();
            out.close();
        }
        catch (Exception e) {
            System.out.println("An error occured trying flush/close the output stream");
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        finally {
            this.setModified(false);
            this.setReloadOk(true);
        }
        return true;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return null;
    }
}

