/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.res.model;

import hec.clientapp.model.StreamAlignment;
import hec.clientapp.model.TSDataSet;
import hec.lang.ObjectReference;
import hec.map.WorldPt;
import hec.model.Node;
import hec.model.StreamElement;
import hec.model.TSLocation;
import hec.model.TsRecordContainer;
import hec.watershed.model.ComputationPoint;
import hec.watershed.res.model.Element;
import hec.watershed.res.model.ResNetwork;
import java.lang.reflect.Field;
import java.util.Observer;

public class ResNode
extends Node
implements TSLocation {
    ResNetwork _network;
    ObjectReference _upstreamElement = new ObjectReference();
    ObjectReference _downstreamElement = new ObjectReference();
    long _computationPointId = Long.MIN_VALUE;
    transient ComputationPoint _computationPoint;
    transient boolean _active = true;

    public ResNode() {
    }

    public ResNode(ResNetwork network, int idx) {
        super((TsRecordContainer)network, idx);
        this._network = network;
    }

    public void finalize() throws Throwable {
        if (this._stream != null) {
            this._stream.deleteObserver((Observer)((Object)this));
        }
        super.finalize();
    }

    public void setComputationPoint(ComputationPoint cp) {
        this._computationPoint = cp;
        if (cp == null) {
            this._computationPointId = Long.MIN_VALUE;
            return;
        }
        this._computationPointId = cp.getId();
        this.setName(cp.getName());
        this.setStreamIndex(cp.getStreamId());
        this.setStreamStation(cp.getStreamStation());
    }

    public String toString() {
        return this._network.getNameForKeyString(this.getName());
    }

    public boolean isActive() {
        return this._active;
    }

    public void setActive(boolean active) {
        this._active = active;
    }

    public void setNetwork(ResNetwork network) {
        this._network = network;
        this.setManager((TsRecordContainer)network);
    }

    public Element getUpstreamElement() {
        Element elem = (Element)this._upstreamElement.getObject();
        if (elem != null) {
            return elem;
        }
        if (this._upstreamElement.id != Integer.MIN_VALUE) {
            elem = this._network.getElement(this._upstreamElement.id);
            this._upstreamElement.setObject((Object)elem);
        }
        return elem;
    }

    public void setUpstreamElement(Element elem) {
        this._upstreamElement.id = elem.getIndex();
        this._upstreamElement.setObject((Object)elem);
    }

    public Element getDownstreamElement() {
        Element elem = (Element)this._downstreamElement.getObject();
        if (elem != null) {
            return elem;
        }
        if (this._downstreamElement.id != Integer.MIN_VALUE) {
            elem = this._network.getElement(this._downstreamElement.id);
            this._downstreamElement.setObject((Object)elem);
        }
        return elem;
    }

    public void setDownstreamElement(Element elem) {
        this._downstreamElement.id = elem.getIndex();
        this._downstreamElement.setObject((Object)elem);
    }

    public void removeElement(Element e) {
        if (e == this.getDownstreamElement()) {
            this._downstreamElement.clear();
        } else if (e == this.getUpstreamElement()) {
            this._upstreamElement.clear();
        }
    }

    public void setStreamStation(double stat) {
        this._station = stat;
        StreamElement stream = this.getStream();
        if (stream != null) {
            this._streamCoord = stream.getCoordByStation(this._station);
        }
    }

    public double getStreamCoord() {
        StreamElement stream = this.getStream();
        if (stream != null) {
            this._streamCoord = stream.getCoordByStation(this._station);
        }
        return this._streamCoord;
    }

    public WorldPt getLocation() {
        StreamElement stream = this.getStream();
        if (stream != null) {
            this._location = stream.getLocationByStation(this._station);
        }
        return this._location;
    }

    public StreamElement getStream() {
        StreamAlignment align;
        if (this._stream == null && (align = this._network.getAlignment()) != null && this._streamIndex >= 0) {
            this._stream = align.findReach(this._streamIndex);
            if (this._stream != null) {
                this._stream.addObserver((Observer)((Object)this));
            }
        }
        return this._stream;
    }

    public void dispose() {
        if (this.getDownstreamElement() != null) {
            this.getDownstreamElement().removeNode(this);
            this._downstreamElement.clear();
        }
        if (this.getUpstreamElement() != null) {
            this.getUpstreamElement().removeNode(this);
            this._upstreamElement.clear();
        }
    }

    public boolean isDisposed() {
        if (this.getDownstreamElement() == null && this.getUpstreamElement() == null) {
            return true;
        }
        if (this._upstreamElement.id != Integer.MIN_VALUE && this._network.getElement(this._upstreamElement.id) == null) {
            return true;
        }
        return this._downstreamElement.id != Integer.MIN_VALUE && this._network.getElement(this._downstreamElement.id) == null;
    }

    public TSDataSet getTSDataSet(boolean isInput) {
        if (isInput) {
            return this._network.getInputTSDataSet();
        }
        return this._network.getOutputTSDataSet();
    }

    public void clearTSProxyList() {
    }

    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get((Object)this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return super.getFieldObject(fld);
        }
    }

    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set((Object)this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return super.setFieldObject(fld, fobj);
        }
        catch (IllegalArgumentException e) {
            return super.setFieldObject(fld, fobj);
        }
    }
}

