/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.res.model;

import hec.clientapp.model.StreamAlignment;
import hec.map.WorldPt;
import hec.map.WorldRegion;
import hec.watershed.res.model.DiversionElement;
import hec.watershed.res.model.Element;
import hec.watershed.res.model.ResNetwork;
import hec.watershed.res.model.ResNode;
import java.lang.reflect.Field;
import java.util.Vector;

public class ReservoirElement
extends Element
implements Cloneable {
    public static final int STORAGE_ID = 0;
    public static final int DNSTRM_ID = 1;
    public static final int DAM_ID = 0;
    public static final int OUTLET_ID = 1;
    public static final int SPILL_ID = 2;
    public static final int TAILWATER_ID = 3;
    WorldPt _referencePt = new WorldPt();
    WorldRegion _region = new WorldRegion();
    private Vector _streamSegmentVector;
    long _reservoirProjectId = Long.MIN_VALUE;

    public ReservoirElement() {
    }

    public ReservoirElement(ResNetwork network, int idx) {
        super(network, idx);
    }

    @Override
    public void setupForSerialization() {
        super.setupForSerialization();
    }

    public void updateSegments() {
        StreamAlignment align = this._network.getAlignment();
        if (align == null) {
            return;
        }
        Vector ndirvec = new Vector();
        Vector segvec = new Vector();
        String errstr = align.getStreamSegmentsByNodes(this._nodeVector, ndirvec, segvec);
        if (errstr == null) {
            this.setStreamSegmentVector(segvec);
        }
    }

    public Vector getStreamSegmentVector() {
        return this._streamSegmentVector;
    }

    public void setStreamSegmentVector(Vector segvec) {
        this._streamSegmentVector = segvec;
    }

    public String getNextChildName(String classname, String basename) {
        Class<?> elemclass = null;
        try {
            elemclass = Class.forName(classname);
        }
        catch (ClassNotFoundException e) {
            System.out.println(e);
            return basename;
        }
        Vector childvec = this.getElementsByClass(elemclass, new Vector());
        int icnt = 0;
        boolean done = false;
        Object name = basename;
        int imax = childvec.size();
        while (!done) {
            done = true;
            for (int i = 0; i < imax; ++i) {
                Element e = (Element)childvec.elementAt(i);
                if (!e.getName().equalsIgnoreCase((String)name)) continue;
                name = basename + " " + Integer.toString(++icnt);
                done = false;
                break;
            }
            if (icnt <= 10000) continue;
            name = "Element " + Integer.toString(imax);
            break;
        }
        return name;
    }

    public Vector getDownstreamDiversions(Vector divVec) {
        if (divVec == null) {
            divVec = new Vector<Element>();
        }
        int imax = this._nodeVector.size();
        for (int i = 0; i < imax; ++i) {
            ResNode n = (ResNode)((Object)this._nodeVector.elementAt(i));
            if (n == null) continue;
            int idir = (Integer)this._nodeDirVector.elementAt(i);
            Element e = null;
            if (idir == 0) {
                e = n.getDownstreamElement();
            }
            if (e == null) continue;
            while (e.getParent() != null) {
                e = e.getParent();
            }
            if (!(e instanceof DiversionElement) || ((DiversionElement)e).getUpstreamNode() != n) continue;
            divVec.addElement(e);
        }
        return divVec;
    }

    @Override
    public synchronized Object clone() {
        ReservoirElement re = (ReservoirElement)super.clone();
        re._referencePt = (WorldPt)this._referencePt.clone();
        re._region = (WorldRegion)this._region.clone();
        return re;
    }

    public void copyInto(ReservoirElement re) {
        super.copyInto(re);
        this._referencePt = (WorldPt)re._referencePt.clone();
        this._region = (WorldRegion)re._region.clone();
        this.setModified(true);
    }

    @Override
    public boolean initialize() {
        return super.initialize();
    }

    public void setName() {
    }

    public void createDefaultElements() {
    }

    public void setReservoirProjectId(long id) {
        this._reservoirProjectId = id;
    }

    public long getReservoirProjectId() {
        return this._reservoirProjectId;
    }

    @Override
    public void addNode(ResNode n, int idir) {
        if (this._nodeVector.contains((Object)n)) {
            return;
        }
        super.addNode(n, idir);
    }

    public WorldRegion getRegion() {
        return this._region;
    }

    @Override
    public WorldPt getReferencePt() {
        return this._referencePt;
    }

    public void setRegion(WorldRegion reg) {
        if (reg == null) {
            return;
        }
        this._region = reg;
        if (this._region.pts.size() > 1) {
            this._referencePt = (WorldPt)this._region.pts.elementAt(1);
        }
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return super.getFieldObject(fld);
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return super.setFieldObject(fld, fobj);
        }
        catch (IllegalArgumentException e) {
            return super.setFieldObject(fld, fobj);
        }
    }

    @Override
    public String toString() {
        String name = this.getName();
        if (name != null) {
            return name;
        }
        return super.toString();
    }
}

