/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.server;

import hec.clientapp.rmi.csinterface.RmiDataList;
import hec.clientapp.rmi.csinterface.RmiDataListContainer;
import hec.clientapp.rmi.csinterface.RmiWorkspace;
import hec.data.Units;
import hec.event.AbstractDataEvent;
import hec.event.DataChangeEvent;
import hec.event.DataListListener;
import hec.event.LockEvent;
import hec.io.DataStorage;
import hec.model.CommonDataList;
import hec.model.CommonDataListContainer;
import hec.model.DataObject;
import hec.model.DataStruct;
import hec.model.ModifiedTime;
import hec.server.ServerDataList;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import mil.army.usace.hec.rmi.csinterface.RmiDataCallback;
import mil.army.usace.hec.rmi.server.PortableRmiObject;

public abstract class AbstractRmiDataList
extends PortableRmiObject
implements RmiDataList,
CommonDataList,
ServerDataList {
    SoftReference<RmiDataListContainer> _rdlc;
    Vector<SoftReference<RmiDataCallback>> _listeners;
    String _objClass;
    EventNotifyThread _eventThread;
    Vector _eventList = new Vector();
    boolean _modified = false;
    boolean _isShown = true;
    public static final int LOCK_EVENT = 0;
    public static final int CHANGE_EVENT = 1;
    public static final int RELOAD_EVENT = 2;
    private int _unitSystem = Integer.MIN_VALUE;
    private int _gmtOffset = Integer.MIN_VALUE;
    private Serializable _dataNotifierHandle;
    private List<Serializable> _callbackHandles = new ArrayList<Serializable>();

    public AbstractRmiDataList(RmiDataListContainer rdlc) throws RemoteException {
        if (rdlc == null) {
            throw new IllegalArgumentException("RmiDataListContainer can not be null");
        }
        this._rdlc = new SoftReference<RmiDataListContainer>(rdlc);
    }

    public boolean addListener(RmiDataCallback callBack) {
        this.startEventNotifyThread();
        if (this._listeners == null) {
            this._listeners = new Vector();
        }
        if (!this._listeners.contains(callBack)) {
            this._listeners.addElement(new SoftReference<RmiDataCallback>(callBack));
        }
        return true;
    }

    public int getUnitSystem() {
        return this._unitSystem;
    }

    public void setUnitSystem(int unitSystem) {
        if (!Units.isValidUnitsSystem((int)unitSystem)) {
            throw new IllegalArgumentException("ERROR: <RmiWorkspaceImpl.setUnitSystem()> Invalid Unit System ID" + unitSystem);
        }
        if (this._unitSystem != Integer.MIN_VALUE) {
            System.out.println("WARNING: <" + ((Object)((Object)this)).getClass().getName() + ".setUnitSystem()> Trying to set an already Defined Unit System!");
            return;
        }
        this._unitSystem = unitSystem;
    }

    public int getGmtOffset() {
        if (this._gmtOffset == Integer.MIN_VALUE) {
            RmiDataListContainer rdlc = this._rdlc.get();
            if (rdlc == null) {
                return this._gmtOffset;
            }
            try {
                this._gmtOffset = rdlc.getGmtOffset();
            }
            catch (Exception ex) {
                System.out.println("ERROR: <" + ((Object)((Object)this)).getClass().getName() + ".getGmtOffset()> Remote Exception occurred when getting the GMT Offset");
                System.out.println(ex.getMessage());
            }
        }
        return this._gmtOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeListener(RmiDataCallback callBack) throws RemoteException {
        if (callBack == null) {
            return true;
        }
        if (this._listeners != null) {
            Vector<SoftReference<RmiDataCallback>> vector = this._listeners;
            synchronized (vector) {
                int size = this._listeners.size();
                Iterator<SoftReference<RmiDataCallback>> iter = this._listeners.iterator();
                while (iter.hasNext()) {
                    SoftReference<RmiDataCallback> ref = iter.next();
                    if (ref == null) {
                        iter.remove();
                        continue;
                    }
                    if (!callBack.equals(ref.get())) continue;
                    iter.remove();
                    return true;
                }
            }
        }
        return false;
    }

    public void fileRmiChangeEvent(long id, String generator) {
        this.fireChangeEvent(id, generator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireChangeEvent(long id, String generator) {
        if ((this._listeners == null || this._listeners.isEmpty()) && (this._callbackHandles == null || this._callbackHandles.isEmpty())) {
            return;
        }
        this._eventList.addElement(new EventItem(id, generator));
        EventNotifyThread eventNotifyThread = this._eventThread;
        synchronized (eventNotifyThread) {
            this._eventThread.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireReloadEvent(String generator) {
        if (this._listeners == null || this._listeners.size() < 1) {
            return;
        }
        this._eventList.add(new EventItem(generator));
        EventNotifyThread eventNotifyThread = this._eventThread;
        synchronized (eventNotifyThread) {
            this._eventThread.notifyAll();
        }
    }

    public void fireRmiLockEvent(int id, boolean locked, String generator) {
        this.fireLockEvent(id, locked, generator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireLockEvent(int id, boolean locked, String generator) {
        if (this._listeners == null || this._listeners.size() < 1) {
            return;
        }
        this._eventList.addElement(new EventItem(id, generator, locked));
        EventNotifyThread eventNotifyThread = this._eventThread;
        synchronized (eventNotifyThread) {
            ((Object)((Object)this)).notifyAll();
        }
    }

    public String getObjectClass() {
        return this._objClass;
    }

    public void setObjectClass(String objClass) {
        this._objClass = objClass;
    }

    public String getDataListType() {
        return this.getObjectClass();
    }

    public CommonDataListContainer getCommonDataListContainer() {
        CommonDataListContainer rdlc = (CommonDataListContainer)this._rdlc.get();
        return rdlc;
    }

    public DataObject getObject(String objName) {
        Object obj;
        DataStorage ds = this.getDataStorage();
        if (ds != null && (obj = ds.loadObject(objName, this.getObjectClass())) != null && obj instanceof DataObject) {
            ((DataObject)obj).setDataList((CommonDataList)this);
            return (DataObject)obj;
        }
        return null;
    }

    public DataObject getObject(long objId) {
        try {
            DataStorage ds = this.getDataStorage();
            if (ds != null) {
                Object obj = ds.loadObject(objId, this.getObjectClass());
                if (obj != null && obj instanceof DataObject) {
                    ((DataObject)obj).setDataList((CommonDataList)this);
                }
                return (DataObject)obj;
            }
        }
        catch (Exception e) {
            System.out.println("getObject: Exception " + e);
            e.printStackTrace();
        }
        return null;
    }

    public boolean saveObject(Object obj) {
        boolean success = false;
        if (!(obj instanceof DataObject) && obj instanceof DataStruct) {
            return success;
        }
        DataObject dObj = (DataObject)obj;
        DataStorage ds = this.getDataStorage();
        if (ds != null && (success = ds.storeObject((Object)dObj))) {
            this.updateModifiedTime();
            this.fireChangeEvent(dObj.getId(), "");
        }
        return success;
    }

    public boolean saveObject(Object obj, String user) {
        boolean success = false;
        if (!(obj instanceof DataObject) && obj instanceof DataStruct) {
            return success;
        }
        DataObject dObj = (DataObject)obj;
        DataStorage ds = this.getDataStorage();
        if (ds != null && (success = ds.storeObject((Object)dObj))) {
            this.updateModifiedTime();
            this.fireChangeEvent(dObj.getId(), user);
        }
        return success;
    }

    public Object callNativeMethod(Object obj) {
        DataStorage ds = this.getDataStorage();
        if (ds != null) {
            return ds.callNativeMethod(obj);
        }
        return null;
    }

    public Object callRemoteNativeMethod(Object obj) {
        DataStorage ds = this.getDataStorage();
        if (ds != null) {
            return ds.callNativeMethod(obj);
        }
        return null;
    }

    protected abstract DataStorage getDataStorage();

    public Object[] getObjects() {
        DataStorage ds = this.getDataStorage();
        if (ds != null) {
            return ds.getDataObjectIdList(this.getDataListType());
        }
        return null;
    }

    public DataStruct[] getObjectArray() {
        DataStorage ds = this.getDataStorage();
        DataStruct[] list = ds.getObjectList(this.getDataListType());
        if (list == null) {
            return null;
        }
        DataStruct[] newList = new DataStruct[list.length];
        System.arraycopy(list, 0, newList, 0, list.length);
        for (int i = 0; i < newList.length; ++i) {
            if (!(newList[i] instanceof DataObject)) continue;
            ((DataObject)newList[i]).setDataList((CommonDataList)this);
            ((DataObject)newList[i]).loadData();
        }
        return newList;
    }

    public boolean addNewObject(DataObject dObj) {
        if (dObj == null) {
            return false;
        }
        long id = -1L;
        DataStorage ds = this.getDataStorage();
        if (ds != null) {
            id = ds.addNewObject((Object)dObj);
        }
        if (id > -1L) {
            this.fireChangeEvent(id, "");
        }
        return id > -1L;
    }

    public long addNewObject(Object dObj, String user) {
        if (dObj == null) {
            return -1L;
        }
        long id = -1L;
        DataStorage ds = this.getDataStorage();
        if (ds != null) {
            id = ds.addNewObject(dObj);
        }
        if (id > -1L) {
            this.fireChangeEvent(id, user);
        }
        return id;
    }

    public DataObject addNewObject2(Object dObj, String user) {
        if (dObj == null) {
            return null;
        }
        DataObject obj = null;
        DataStorage ds = this.getDataStorage();
        if (ds != null) {
            obj = ds.addNewObject2(dObj);
        }
        if (obj != null) {
            this.fireChangeEvent(obj.getId(), user);
        }
        return obj;
    }

    public int removeAll() {
        DataStorage ds = this.getDataStorage();
        if (ds == null) {
            return 0;
        }
        DataStruct[] dsArray = ds.getObjectList(this.getObjectClass());
        for (int ii = 0; ii < dsArray.length; ++ii) {
            if (dsArray[ii] == null) continue;
            long objId = dsArray[ii].getId();
            String objectClass = this.getObjectClass();
            ds.removeObject(objId, objectClass);
        }
        return dsArray.length;
    }

    public boolean removeObject(long objId) {
        if (objId < 0L) {
            return false;
        }
        DataStorage ds = this.getDataStorage();
        if (ds != null) {
            boolean success = ds.removeObject(objId, this.getObjectClass());
            if (success) {
                this.updateModifiedTime();
            }
            return success;
        }
        return false;
    }

    public boolean removeObject(long objId, String user) {
        if (objId < 0L) {
            return false;
        }
        DataStorage ds = this.getDataStorage();
        if (ds != null) {
            boolean success = ds.removeObject(objId, this.getObjectClass());
            if (success) {
                this.updateModifiedTime();
            }
            return success;
        }
        return false;
    }

    public boolean removeObject(long objId, String objClass, String user) {
        if (objId < 0L) {
            return false;
        }
        DataStorage ds = this.getDataStorage();
        if (ds != null) {
            boolean success = ds.removeObject(objId, this.getObjectClass());
            if (success) {
                this.updateModifiedTime();
            }
            return success;
        }
        return false;
    }

    public boolean isShown() {
        return this._isShown;
    }

    public void setIsShown(boolean isShown) {
        this._isShown = isShown;
    }

    public RmiWorkspace getWorkspace() {
        RmiDataListContainer rdlc = this._rdlc.get();
        if (rdlc == null) {
            return null;
        }
        try {
            return rdlc.getWorkspace();
        }
        catch (RemoteException re) {
            System.out.println(((Object)((Object)this)).getClass() + ".getWorkspace: error getting Workspace " + re);
            return null;
        }
    }

    public boolean save(String user) throws RemoteException {
        DataStorage ds = this.getDataStorage();
        if (ds != null) {
            boolean success = ds.save();
            if (success) {
                this.updateModifiedTime();
            }
            return success;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void workspaceClosing() throws RemoteException {
        DataStorage ds = this.getDataStorage();
        if (ds != null) {
            ds.workspaceClosing();
            if (this._eventThread != null) {
                this._eventThread.stopThread();
                EventNotifyThread eventNotifyThread = this._eventThread;
                synchronized (eventNotifyThread) {
                    this._eventThread.notify();
                }
            }
        }
    }

    public DataObject newDataObject(String name, String description) {
        try {
            DataObject obj = (DataObject)Class.forName(this.getObjectClass()).newInstance();
            obj.setDataList((CommonDataList)this);
            obj.setName(name);
            obj.setDescription(description);
            return obj;
        }
        catch (Exception e) {
            System.out.println("newDataObject: failed to create new object " + e);
            return null;
        }
    }

    public DataObject findObjectById(long objId, String objClass) {
        if (objClass.equals(this._objClass)) {
            return this.getObject(objId);
        }
        return ((CommonDataListContainer)this._rdlc).findObjectById(objId, objClass);
    }

    public Object loadObject(DataObject dObj) {
        if (dObj == null) {
            return null;
        }
        long id = dObj.getId();
        return this.loadObject(id);
    }

    public Object loadObject(long id) {
        DataObject obj = this.getObject(id);
        return obj;
    }

    public boolean backupObjectData(String backupDir, DataObject dObj, String user) {
        return this.backupObjectData(backupDir, dObj);
    }

    public boolean backupData(String backupDir, String user) {
        return this.backupData(backupDir);
    }

    public boolean backupObjectData(String backupDir, DataObject dObj) {
        DataStorage ds = this.getDataStorage();
        if (ds != null) {
            return ds.backupData(backupDir, dObj);
        }
        return false;
    }

    public boolean backupData(String backupDir) {
        DataStorage ds = this.getDataStorage();
        if (ds != null) {
            return ds.backupData(backupDir, null);
        }
        return false;
    }

    public void setModified(boolean b) {
        this._modified = b;
    }

    public boolean isModified() {
        return this._modified;
    }

    public synchronized boolean reload(String user) {
        DataStorage ds = this.getDataStorage();
        if (ds != null) {
            if (ds.reload()) {
                this.fireReloadEvent(user);
            }
            return true;
        }
        return false;
    }

    protected void updateModifiedTime() {
        CommonDataListContainer container = this.getCommonDataListContainer();
        if (container == null) {
            return;
        }
        CommonDataList dataList = container.getCommonDataList(ModifiedTime.class.getName(), "");
        if (dataList == null) {
            return;
        }
        DataObject dataObj = dataList.getObject(this.getObjectClass());
        if (dataObj == null) {
            dataObj = new ModifiedTime();
            dataObj.setName(this.getObjectClass());
            dataList.addNewObject(dataObj);
            dataObj.setDataList(dataList);
        }
        ((ModifiedTime)dataObj).setModifiedTime(System.currentTimeMillis());
        dataObj.save();
    }

    public long getLastModifiedTime() {
        CommonDataList dataList = this.getCommonDataListContainer().getProxyListContainer().getCommonDataList("hec.model.ModifiedTime", "");
        if (dataList == null) {
            return Long.MIN_VALUE;
        }
        DataObject dataObj = dataList.getObject(this.getObjectClass());
        if (dataObj == null) {
            return Long.MIN_VALUE;
        }
        return ((ModifiedTime)dataObj).getModifiedTime();
    }

    public int getObjectCount() {
        Object[] objects = this.getObjects();
        return objects != null ? objects.length : 0;
    }

    public boolean doesExist(String name) {
        if (name == null) {
            return false;
        }
        Object[] objects = this.getObjects();
        for (int i = 0; i < objects.length; ++i) {
            if (!(objects[i] instanceof DataObject) || !((DataObject)objects[i]).getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public void addDataListListener(DataListListener listener) {
    }

    public void removeDataListListener(DataListListener listener) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(Serializable callbackHandle) {
        List<Serializable> list = this._callbackHandles;
        synchronized (list) {
            this._callbackHandles.remove(callbackHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Serializable callbackHandle) {
        if (callbackHandle == null) {
            return;
        }
        this.startEventNotifyThread();
        List<Serializable> list = this._callbackHandles;
        synchronized (list) {
            if (this._callbackHandles.contains(callbackHandle)) {
                return;
            }
            this._callbackHandles.add(callbackHandle);
        }
    }

    private void startEventNotifyThread() {
        if (this._eventThread == null) {
            this._eventThread = new EventNotifyThread(this.getDataListType());
            this._eventThread.start();
        }
    }

    public class EventItem {
        public long _id;
        public String _user;
        public boolean _locked;
        public int _type;

        public EventItem(long id, String user) {
            this._id = id;
            this._user = user;
            this._type = 1;
        }

        public EventItem(long id, String user, boolean locked) {
            this._id = id;
            this._user = user;
            this._locked = locked;
            this._type = 0;
        }

        public EventItem(String user) {
            this._id = -1L;
            this._user = user;
            this._type = 2;
        }
    }

    public class EventNotifyThread
    extends Thread {
        boolean _run;

        public EventNotifyThread(String type) {
            super("RmiDataList.EventNotifyThread " + type);
            this._run = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void run() {
            EventItem ei = null;
            while (this._run) {
                Vector vector = AbstractRmiDataList.this._eventList;
                synchronized (vector) {
                    if (AbstractRmiDataList.this._eventList.size() > 0 && (ei = (EventItem)AbstractRmiDataList.this._eventList.elementAt(0)) != null) {
                        AbstractRmiDataList.this._eventList.removeElementAt(0);
                    }
                }
                if (ei != null) {
                    switch (ei._type) {
                        case 1: {
                            this.fireChangeEvent(ei._id, ei._user);
                            break;
                        }
                        case 0: {
                            this.fireLockEvent(ei._id, ei._user, ei._locked);
                            break;
                        }
                        case 2: {
                            this.fireReloadEvent(ei._user);
                        }
                    }
                }
                if (AbstractRmiDataList.this._eventList.size() >= 1) continue;
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public void stopThread() {
            this._run = false;
        }

        private void notify(AbstractDataEvent event) {
            System.out.println("notify:" + event);
            if (AbstractRmiDataList.this.getNetworked()) {
                throw new IllegalStateException("Networked mode not supported!");
            }
            System.out.println("notify: have" + AbstractRmiDataList.this._listeners.size() + " to notify");
            for (int i = 0; i < AbstractRmiDataList.this._listeners.size(); ++i) {
                SoftReference<RmiDataCallback> ref = AbstractRmiDataList.this._listeners.get(i);
                RmiDataCallback callback = ref.get();
                if (callback != null) {
                    try {
                        callback.notify(event);
                    }
                    catch (RemoteException re) {
                        System.out.println("AbstractRmiDataList.fireChangeEvent:Error with rmi data call back  " + re);
                        re.printStackTrace();
                        AbstractRmiDataList.this._listeners.remove(i);
                        --i;
                    }
                    continue;
                }
                AbstractRmiDataList.this._listeners.remove(i);
                --i;
            }
        }

        private void fireChangeEvent(long id, String generator) {
            DataChangeEvent event = new DataChangeEvent(1, id, generator, AbstractRmiDataList.this.getObjectClass());
            this.notify((AbstractDataEvent)event);
        }

        private void fireLockEvent(long id, String generator, boolean locked) {
            LockEvent event = new LockEvent(id, generator, AbstractRmiDataList.this.getObjectClass(), locked);
            this.notify((AbstractDataEvent)event);
        }

        private void fireReloadEvent(String generator) {
            DataChangeEvent event = new DataChangeEvent(2, -99L, generator, AbstractRmiDataList.this.getObjectClass());
            this.notify((AbstractDataEvent)event);
        }
    }
}

