/*
 * Decompiled with CFR 0.152.
 */
package hec.watershed.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import hec.clientapp.rmi.csinterface.RmiDataList;
import hec.clientapp.rmi.csinterface.RmiDataListContainer;
import hec.io.AbstractDataStorage;
import hec.io.DataStorage;
import hec.model.DataStruct;
import hec.watershed.model.StationSet;
import hec.watershed.model.StationSetDataObject;
import hec.watershed.server.AbstractRmiDataList;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import rma.util.RMAConst;

public class StationSetRmiDataListImpl
extends AbstractRmiDataList {
    transient DataStorage _datastorage;

    public StationSetRmiDataListImpl(RmiDataListContainer container, String stringClass) throws RemoteException {
        super(container);
        this.setObjectClass(stringClass);
        this._datastorage = new GeoJSonDataStorage(this);
        this._datastorage.init();
        if (this._datastorage.getObjectCount() == 0) {
            StationSet ss = new StationSet();
            ss.setName("StationSet");
            StationSetDataObject ssdobj = new StationSetDataObject();
            ssdobj.setStationSet(ss);
            ssdobj.setName(ss.getName());
            this._datastorage.addNewObject((Object)ssdobj);
        }
    }

    @Override
    public void workspaceClosing() throws RemoteException {
        super.workspaceClosing();
        this._datastorage.workspaceClosing();
    }

    @Override
    public DataStorage getDataStorage() {
        return this._datastorage;
    }

    public Object[] getObjects(long studyId) throws RemoteException {
        return this._datastorage.getObjectList(this.getObjectClass());
    }

    private class GeoJSonDataStorage
    extends AbstractDataStorage {
        public static final String EXT = "stationset";
        String workspacePath;
        Map<File, StationSetDataObject> fileMap;
        Map<Long, File> stationSetDataObjectMap;
        long nextId = -1L;

        public GeoJSonDataStorage(RmiDataList parent) {
            try {
                this.fileMap = new HashMap<File, StationSetDataObject>();
                this.stationSetDataObjectMap = new HashMap<Long, File>();
                this.workspacePath = parent.getWorkspace().getWorkspacePath();
                File studyPath = new File(this.workspacePath, "study");
                this.workspacePath = studyPath.getAbsolutePath();
            }
            catch (RemoteException re) {
                System.out.println("AsciiSplitDataStorage.<init>:failed to get workspace path " + re);
            }
        }

        public boolean init() {
            File wkspPathF = new File(this.workspacePath);
            File[] listFiles = wkspPathF.listFiles(pathname -> pathname.getAbsolutePath().endsWith(EXT));
            if (listFiles != null) {
                for (File listFile : listFiles) {
                    StationSet stationset = this.readStationSet(listFile);
                    if (stationset == null) continue;
                    if (stationset.getId() == -1L) {
                        stationset.setId(++this.nextId);
                    }
                    this.nextId = Math.max(this.nextId, stationset.getId());
                    StationSetDataObject ssDataObject = new StationSetDataObject();
                    ssDataObject.setId(stationset.getId());
                    ssDataObject.setStationSet(stationset);
                    ssDataObject.setName(stationset.getName());
                    ssDataObject.setDescription(stationset.getDescription());
                    this.fileMap.put(listFile, ssDataObject);
                    this.stationSetDataObjectMap.put(stationset.getId(), listFile);
                }
            }
            return true;
        }

        public void workspaceClosing() {
            this.fileMap.clear();
            this.stationSetDataObjectMap.clear();
        }

        public boolean reload() {
            this.fileMap.clear();
            return true;
        }

        public boolean removeObject(long[] objId, String objClass) {
            for (long l : objId) {
                this.removeObject(l, objClass);
            }
            return true;
        }

        public boolean removeObject(long objId, String objClass) {
            File objectFile = this.stationSetDataObjectMap.remove(objId);
            if (objectFile != null) {
                StationSetDataObject remove = this.fileMap.remove(objectFile);
                objectFile.delete();
            }
            return true;
        }

        public boolean save() {
            Set<Map.Entry<File, StationSetDataObject>> entrySet = this.fileMap.entrySet();
            for (Map.Entry<File, StationSetDataObject> entry : entrySet) {
                this.storeObject((Object)entry.getValue());
            }
            return true;
        }

        public long addNewObject(Object obj) {
            if (!(obj instanceof StationSetDataObject)) {
                return -1L;
            }
            if (!this.storeObject(obj)) {
                return -1L;
            }
            return ((StationSetDataObject)((Object)obj)).getId();
        }

        public int getObjectCount() {
            return this.fileMap.size();
        }

        public String getFilename() {
            return "";
        }

        public Object loadObject(long id, String objClass) {
            File f = this.stationSetDataObjectMap.get(id);
            if (f == null) {
                return null;
            }
            StationSetDataObject ssDataObject = this.fileMap.get(f);
            if (ssDataObject == null) {
                ssDataObject = new StationSetDataObject();
                ssDataObject.setId(id);
                StationSet stationSet = this.readStationSet(f);
                ssDataObject.setStationSet(stationSet);
                ssDataObject.setName(stationSet.getName());
                ssDataObject.setDescription(stationSet.getDescription());
                this.fileMap.put(f, ssDataObject);
            }
            return ssDataObject;
        }

        public boolean storeObject(Object obj) {
            return this.writeObjectToDisk(obj);
        }

        private boolean writeObjectToDisk(Object obj) {
            File outputFile;
            if (!(obj instanceof StationSetDataObject)) {
                return false;
            }
            Logger.getLogger(GeoJSonDataStorage.class.getName()).log(Level.INFO, "message");
            StationSetDataObject ssDataObject = (StationSetDataObject)((Object)obj);
            if (ssDataObject.getId() == -1L || RMAConst.isUndefinedValue((long)ssDataObject.getId())) {
                ssDataObject.setId(++this.nextId);
            }
            if ((outputFile = this.stationSetDataObjectMap.get(ssDataObject.getId())) == null) {
                outputFile = new File(this.workspacePath);
                outputFile = new File(outputFile, ssDataObject.getName() + ".stationset");
                this.stationSetDataObjectMap.put(ssDataObject.getId(), outputFile);
            }
            this.fileMap.put(outputFile, ssDataObject);
            ObjectMapper mapper = new ObjectMapper();
            mapper.enable(SerializationFeature.INDENT_OUTPUT);
            List findModules = ObjectMapper.findModules();
            mapper.registerModules((Iterable)findModules);
            ObjectWriter writerFor = mapper.writerFor(StationSet.class);
            StationSet stationSet = ssDataObject.getStationSet();
            stationSet.setId(ssDataObject.getId());
            File parent = outputFile.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            try (FileOutputStream byteArrayInputStream = new FileOutputStream(outputFile);){
                writerFor.writeValue((OutputStream)byteArrayInputStream, (Object)stationSet);
            }
            catch (Exception e) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, "Error Writing stations set", e);
                return false;
            }
            return true;
        }

        public Object[] getDataObjectIdList(String objClass) {
            try {
                Class<?> cls = Class.forName(objClass);
            }
            catch (ClassNotFoundException cfe) {
                System.out.println("AsciiDataStorage.getDataObjectIdList: can't find class " + objClass + " " + cfe);
                return null;
            }
            return this.getObjectList(objClass);
        }

        public DataStruct[] getObjectList(String objClass) {
            DataStruct[] dsArray = new DataStruct[this.stationSetDataObjectMap.size()];
            ArrayList<StationSetDataObject> dsList = new ArrayList<StationSetDataObject>();
            Set<Map.Entry<Long, File>> entrySet = this.stationSetDataObjectMap.entrySet();
            for (Map.Entry<Long, File> entry : entrySet) {
                Long key = entry.getKey();
                File f = entry.getValue();
                if (f == null) continue;
                StationSetDataObject ssDataObject = this.fileMap.get(f);
                if (ssDataObject != null) {
                    dsList.add(ssDataObject);
                    continue;
                }
                StationSet stationset = this.readStationSet(f);
                if (stationset == null) continue;
                ssDataObject = new StationSetDataObject();
                ssDataObject.setId(key);
                ssDataObject.setStationSet(stationset);
                ssDataObject.setName(stationset.getName());
                ssDataObject.setDescription(stationset.getDescription());
                this.fileMap.put(f, ssDataObject);
                dsList.add(ssDataObject);
            }
            dsArray = new DataStruct[dsList.size()];
            dsArray = dsList.toArray(dsArray);
            return dsArray;
        }

        private StationSet readStationSet(File f) {
            StationSet stationSet;
            ObjectMapper mapper = new ObjectMapper();
            List findModules = ObjectMapper.findModules();
            mapper.registerModules((Iterable)findModules);
            ObjectReader readerFor = mapper.readerFor(StationSet.class);
            try (FileInputStream byteArrayInputStream = new FileInputStream(f);){
                stationSet = (StationSet)((Object)readerFor.readValue((InputStream)byteArrayInputStream));
            }
            catch (Exception e) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, "Error Reading stations set", e);
                return null;
            }
            return stationSet;
        }
    }
}

