/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.dataentry;

import hec.dataTable.HecDataTable;
import hec.dataui.dataentry.PairedDataPathnameEditor;
import hec.heclib.dss.DSSPathname;
import hec.io.DataContainer;
import hec.io.PairedDataContainer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJRadioButton;

public class PairedDataEntryPanel
extends JPanel {
    private static final long serialVersionUID = -7252178712784888338L;
    protected PairedDataPathnameEditor pathnamePanel;
    protected JPanel specsPanel;
    protected JPanel XtypePanel;
    protected JPanel YtypePanel;
    protected JPanel ratingPanel;
    protected JLabel labelNumberCurves;
    protected JComboBox numberCurvesComboBox;
    protected RmaJRadioButton _xHorizontalAxisRadio;
    protected RmaJRadioButton _yHorizontalAxisRadio;
    protected JLabel XlabelUnits;
    protected JTextField XunitsTextField;
    protected JLabel XlabelType;
    protected JComboBox XtypeComboBox;
    protected JLabel YlabelUnits;
    protected JTextField YunitsTextField;
    protected JLabel YlabelType;
    protected JComboBox YtypeComboBox;
    protected JCheckBox _addRatingInfo;
    protected RmaJDecimalField _datum;
    protected RmaJDecimalField _shift;
    protected RmaJDecimalField _offset;
    protected JComboBox _transformComboBox;
    protected JPanel tablePanel;
    protected HecDataTable _table;
    protected JScrollPane _tableScrollPane;
    protected JButton pasteButton;
    protected JPanel buttonPanel;
    protected PairedDataContainer _pairedDataContainer = null;
    protected DSSPathname _path;
    protected String[] types = new String[]{"Linear", "Log", "Probability", "Percent"};
    protected String _sdate = "";
    protected String _stime = "";
    protected boolean fComponentsAdjusted = false;

    public PairedDataEntryPanel() {
        super(new GridBagLayout());
        this._path = new DSSPathname();
        this._pairedDataContainer = new PairedDataContainer();
        this._pairedDataContainer.numberCurves = 1;
        this.setup();
    }

    public void setup() {
        this.build();
    }

    protected void build() {
        this.buildPathnamePanel();
        this.buildNumberCurvesPanel();
        this.buildSpecsPanel();
        this.buildPasteButton();
        this.buildRatingPanel();
        this.buildTable();
        this.registerListeners();
    }

    protected String getType(String originalType) {
        for (int i = 0; i < this.types.length; ++i) {
            if (!originalType.equalsIgnoreCase(this.types[i])) continue;
            return this.types[i];
        }
        String lcType = originalType.toLowerCase();
        for (int i = 0; i < this.types.length; ++i) {
            String type = this.types[i].toLowerCase();
            if (!type.startsWith(lcType)) continue;
            return this.types[i];
        }
        if (lcType.startsWith("log")) {
            return this.types[1];
        }
        if (lcType.startsWith("li")) {
            return this.types[0];
        }
        if (lcType.startsWith("per")) {
            return this.types[3];
        }
        if (lcType.startsWith("pro")) {
            return this.types[2];
        }
        return this.types[0];
    }

    public void setPathname(String pathname) {
        this._path.setPathname(pathname);
        this.pathnamePanel.setPathname(this._path);
    }

    protected void buildPathnamePanel() {
        this.pathnamePanel = new PairedDataPathnameEditor(this._path);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.insets = new Insets(10, 24, 0, 24);
        gbc.weightx = 1.0;
        gbc.anchor = 11;
        gbc.fill = 2;
        this.add((Component)this.pathnamePanel, gbc);
    }

    protected void buildNumberCurvesPanel() {
        JPanel numberCurvesPanel = new JPanel();
        numberCurvesPanel.setLayout(new GridLayout(1, 2));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.insets = new Insets(16, 24, 0, 24);
        gbc.weightx = 1.0;
        gbc.anchor = 11;
        gbc.fill = 2;
        this.add((Component)numberCurvesPanel, gbc);
        JPanel nc = new JPanel();
        this.labelNumberCurves = new JLabel("Number of Curves:  ");
        this.labelNumberCurves.setForeground(new Color(0));
        nc.add(this.labelNumberCurves);
        String[] numbers = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "50"};
        this.numberCurvesComboBox = new JComboBox<String>(numbers);
        this.numberCurvesComboBox.setSelectedItem("1");
        this.numberCurvesComboBox.setToolTipText("Date of the first data value");
        this.numberCurvesComboBox.setForeground(new Color(0));
        this.numberCurvesComboBox.setBackground(Color.white);
        nc.add(this.numberCurvesComboBox);
        numberCurvesPanel.add(nc);
        this._xHorizontalAxisRadio = new RmaJRadioButton("X");
        this._yHorizontalAxisRadio = new RmaJRadioButton("Y");
        JLabel label = new JLabel("Horizontal Axis:");
        JPanel ha = new JPanel();
        ha.add(label);
        ha.add((Component)this._xHorizontalAxisRadio);
        ha.add((Component)this._yHorizontalAxisRadio);
        numberCurvesPanel.add(ha);
        ButtonGroup bg = new ButtonGroup();
        bg.add((AbstractButton)this._xHorizontalAxisRadio);
        bg.add((AbstractButton)this._yHorizontalAxisRadio);
        this._xHorizontalAxisRadio.setSelected(true);
    }

    protected void buildSpecsPanel() {
        this.specsPanel = new JPanel();
        this.specsPanel.setLayout(new GridLayout(1, 2));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.insets = new Insets(20, 24, 0, 24);
        gbc.weightx = 1.0;
        gbc.anchor = 11;
        gbc.fill = 2;
        this.add((Component)this.specsPanel, gbc);
        this.XtypePanel = new JPanel();
        this.XtypePanel.setLayout(new GridBagLayout());
        this.specsPanel.add(this.XtypePanel);
        this.XlabelUnits = new JLabel("X Units:");
        this.XlabelUnits.setForeground(new Color(0));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.fill = 0;
        this.XtypePanel.add((Component)this.XlabelUnits, gbc);
        this.XunitsTextField = new JTextField();
        this.XunitsTextField.setToolTipText("Date of the first data value");
        this.XunitsTextField.setForeground(new Color(0));
        this.XunitsTextField.setMargin(new Insets(0, 2, 0, 0));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 5, 0, 15);
        gbc.ipady = 0;
        this.XtypePanel.add((Component)this.XunitsTextField, gbc);
        this.XlabelType = new JLabel("X Type:");
        this.XlabelType.setForeground(new Color(0));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 0;
        gbc.insets = new Insets(10, 0, 0, 0);
        this.XtypePanel.add((Component)this.XlabelType, gbc);
        this.XtypeComboBox = new JComboBox<String>(this.types);
        this.XtypeComboBox.setSelectedItem("Linear");
        this.XtypeComboBox.setForeground(new Color(0));
        this.XtypeComboBox.setBackground(Color.white);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 5, 0, 15);
        gbc.ipadx = 0;
        gbc.ipady = 0;
        ((GridBagLayout)this.XtypePanel.getLayout()).setConstraints(this.XtypeComboBox, gbc);
        this.XtypePanel.add(this.XtypeComboBox);
        this.XtypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PairedDataEntryPanel.this._table.setValueAt(PairedDataEntryPanel.this.XtypeComboBox.getSelectedItem(), 2, 1);
                PairedDataEntryPanel.this._table.revalidate();
                PairedDataEntryPanel.this._table.repaint();
            }
        });
        this.YtypePanel = new JPanel();
        this.YtypePanel.setLayout(new GridBagLayout());
        this.specsPanel.add(this.YtypePanel);
        this.YlabelUnits = new JLabel("Y Units:");
        this.YlabelUnits.setForeground(new Color(0));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.YtypePanel.add((Component)this.YlabelUnits, gbc);
        this.YunitsTextField = new JTextField();
        this.YunitsTextField.setToolTipText("Data units (e.g., FEET)");
        this.YunitsTextField.setForeground(new Color(0));
        this.YunitsTextField.setMargin(new Insets(0, 2, 0, 0));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 5, 0, 0);
        gbc.ipady = 0;
        this.YtypePanel.add((Component)this.YunitsTextField, gbc);
        this.YlabelType = new JLabel("Y Type:");
        this.YlabelType.setForeground(new Color(0));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 0;
        gbc.insets = new Insets(10, 0, 0, 0);
        this.YtypePanel.add((Component)this.YlabelType, gbc);
        this.YtypeComboBox = new JComboBox<String>(this.types);
        this.YtypeComboBox.setSelectedItem("Unitary");
        this.YtypeComboBox.setForeground(new Color(0));
        this.YtypeComboBox.setBackground(Color.white);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 5, 0, 0);
        gbc.ipadx = 0;
        gbc.ipady = 0;
        this.YtypePanel.add((Component)this.YtypeComboBox, gbc);
        this.YtypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PairedDataEntryPanel.this._table.setValueAt(PairedDataEntryPanel.this.YtypeComboBox.getSelectedItem(), 2, 2);
                PairedDataEntryPanel.this._table.revalidate();
                PairedDataEntryPanel.this._table.repaint();
            }
        });
    }

    protected void buildPasteButton() {
        this.pasteButton = new JButton("Paste");
        this.pasteButton.setEnabled(true);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 0.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(20, 24, 0, 0);
        this.add((Component)this.pasteButton, gbc);
        this._addRatingInfo = new JCheckBox("Add Rating Table Data");
        this._addRatingInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PairedDataEntryPanel.this._addRatingInfo.isSelected()) {
                    PairedDataEntryPanel.this.ratingPanel.setVisible(true);
                } else {
                    PairedDataEntryPanel.this.ratingPanel.setVisible(false);
                }
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.insets = new Insets(20, 24, 0, 24);
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        this.add((Component)this._addRatingInfo, gbc);
    }

    protected void plotData() {
        this.updateContainers();
        if (this._pairedDataContainer == null || this._pairedDataContainer.xOrdinates.length == 0 || this._pairedDataContainer.numberCurves == 0) {
            JOptionPane.showMessageDialog(null, "There are no values in the table", "", 2);
            return;
        }
        Window windowAncestor = SwingUtilities.getWindowAncestor(this);
        if (windowAncestor instanceof JFrame) {
            this._table.plot((JFrame)windowAncestor);
        }
    }

    protected void buildRatingPanel() {
        this.ratingPanel = new JPanel();
        this.ratingPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.insets = new Insets(20, 24, 0, 24);
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        this.add((Component)this.ratingPanel, gbc);
        this.ratingPanel.setVisible(false);
        JLabel label = new JLabel("Datum:");
        label.setForeground(new Color(0));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.fill = 0;
        this.ratingPanel.add((Component)label, gbc);
        this._datum = new RmaJDecimalField();
        this._datum.setToolTipText("Datum of river");
        this._datum.setForeground(new Color(0));
        this._datum.setMargin(new Insets(0, 2, 0, 0));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 5, 0, 15);
        gbc.ipady = 0;
        this.ratingPanel.add((Component)this._datum, gbc);
        label = new JLabel("    Shift:");
        label.setForeground(new Color(0));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = new Insets(3, 0, 0, 0);
        gbc.fill = 0;
        this.ratingPanel.add((Component)label, gbc);
        this._shift = new RmaJDecimalField();
        this._shift.setForeground(new Color(0));
        this._shift.setMargin(new Insets(0, 2, 0, 0));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 0, 15);
        gbc.ipady = 0;
        this.ratingPanel.add((Component)this._shift, gbc);
        label = new JLabel("       Offset:");
        label.setForeground(new Color(0));
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 20, 0, 0);
        gbc.fill = 0;
        this.ratingPanel.add((Component)label, gbc);
        this._offset = new RmaJDecimalField();
        this._offset.setForeground(new Color(0));
        this._offset.setMargin(new Insets(0, 2, 0, 0));
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 5, 0, 0);
        gbc.ipady = 0;
        this.ratingPanel.add((Component)this._offset, gbc);
        label = new JLabel("Transform:");
        label.setForeground(new Color(0));
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.insets = new Insets(3, 20, 0, 0);
        gbc.fill = 0;
        this.ratingPanel.add((Component)label, gbc);
        String[] transformTypes = new String[]{"Linear", "Log"};
        this._transformComboBox = new JComboBox<String>(transformTypes);
        this._transformComboBox.setSelectedItem("Linear");
        this._transformComboBox.setForeground(new Color(0));
        this._transformComboBox.setBackground(Color.white);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 0, 0);
        gbc.ipadx = 0;
        gbc.ipady = 0;
        this.ratingPanel.add((Component)this._transformComboBox, gbc);
    }

    protected void buildTable() {
        this.tablePanel = new JPanel();
        this.tablePanel.setLayout(new BorderLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 11;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(20, 24, 0, 24);
        this.add((Component)this.tablePanel, gbc);
        this._table = new HecDataTable((Component)this);
        this._table.allowSort(false);
        this._tableScrollPane = new JScrollPane((Component)this._table);
        this._tableScrollPane.setVerticalScrollBarPolicy(22);
        this.tablePanel.add((Component)this._tableScrollPane, "Center");
        this._table.setData((DataContainer)this._pairedDataContainer, false, 0);
        this._table.setNumberHeaderRows(3);
        this._table.setEditable(true);
        this._table.setExtendable(true, 2);
    }

    protected void registerListeners() {
        SymAction lSymAction = new SymAction();
        this.pasteButton.addActionListener(lSymAction);
        this.numberCurvesComboBox.addActionListener(lSymAction);
        this.XunitsTextField.addActionListener(lSymAction);
        this.YunitsTextField.addActionListener(lSymAction);
    }

    protected void numberOfCurvesChanged() {
        int numberY = this.numberCurvesComboBox.getSelectedIndex() + 1;
        this._table.numberOfPairedCurvesChanged(numberY);
    }

    public PairedDataContainer getData() {
        this.updateContainers();
        return this._pairedDataContainer;
    }

    public void setData(PairedDataContainer pairedDataContainer) {
        this._pairedDataContainer = pairedDataContainer;
        this._path.setPathname(this._pairedDataContainer.fullName);
        this.pathnamePanel.setPathname(this._path);
        this.numberCurvesComboBox.setSelectedIndex(this._pairedDataContainer.numberCurves - 1);
        this._yHorizontalAxisRadio.setSelected(this._pairedDataContainer.switchXyAxis);
        this.XunitsTextField.setText(this._pairedDataContainer.xunits);
        this.YunitsTextField.setText(this._pairedDataContainer.yunits);
        this.XtypeComboBox.setSelectedItem(this.getType(this._pairedDataContainer.xtype));
        this.YtypeComboBox.setSelectedItem(this.getType(this._pairedDataContainer.ytype));
        if (this._pairedDataContainer.transformType != Integer.MIN_VALUE) {
            this._addRatingInfo.setSelected(true);
            this._datum.setValue(this._pairedDataContainer.datum);
            this._shift.setValue(this._pairedDataContainer.shift);
            this._offset.setValue(this._pairedDataContainer.offset);
            if (this._pairedDataContainer.transformType == 1) {
                this._transformComboBox.setSelectedItem(this.types[0]);
            } else {
                this._transformComboBox.setSelectedItem(this.types[1]);
            }
            this.ratingPanel.setVisible(true);
        }
        this._table.setData((DataContainer)this._pairedDataContainer, false, 0);
        this.numberOfCurvesChanged();
        this._table.setMlHeaderRenderer();
        this._table.setEditable(true);
        this._table.setExtendable(true, 2);
    }

    protected void updateContainers() {
        Object typeObj;
        this._path = this.pathnamePanel.getDSSPathname();
        this._pairedDataContainer.fullName = this._path.pathname();
        this._pairedDataContainer.watershed = this._path.aPart();
        this._pairedDataContainer.location = this._path.bPart();
        this._pairedDataContainer.xparameter = this._path.getPairedDataX();
        this._pairedDataContainer.yparameter = this._path.getPairedDataY();
        this._pairedDataContainer.other = this._path.dPart();
        this._pairedDataContainer.date = this._path.ePart();
        this._pairedDataContainer.version = this._path.fPart();
        this._pairedDataContainer.switchXyAxis = this.getSwitchXyAxis();
        this._pairedDataContainer.xunits = this.XunitsTextField.getText();
        this._pairedDataContainer.yunits = this.YunitsTextField.getText();
        String type = this._table.getValueAt(2, 1).toString();
        if (type.length() < 2) {
            this._pairedDataContainer.xtype = this.getType(this.XtypeComboBox.getSelectedIndex());
        }
        if ((type = (typeObj = this._table.getValueAt(2, 2)) != null ? typeObj.toString() : "").length() < 2) {
            this._pairedDataContainer.ytype = this.getType(this.YtypeComboBox.getSelectedIndex());
        }
        if (this._addRatingInfo.isSelected()) {
            this._pairedDataContainer.datum = this._datum.getValue();
            this._pairedDataContainer.shift = this._shift.getValue();
            this._pairedDataContainer.offset = this._offset.getValue();
            this._pairedDataContainer.transformType = this._transformComboBox.getSelectedItem().equals("Linear") ? 1 : 2;
        } else {
            this._pairedDataContainer.datum = -3.4028234663852886E38;
            this._pairedDataContainer.shift = -3.4028234663852886E38;
            this._pairedDataContainer.offset = -3.4028234663852886E38;
            this._pairedDataContainer.transformType = Integer.MIN_VALUE;
        }
        int[] errors = new int[1];
        this._table.updateContainers(errors);
    }

    protected String getType(int typeIndex) {
        if (typeIndex == 0) {
            return "UNT";
        }
        if (typeIndex == 1) {
            return "LOG";
        }
        return "PROB";
    }

    protected boolean getSwitchXyAxis() {
        return this._yHorizontalAxisRadio.isSelected();
    }

    public void setNumOfCurvesChangeAllowed(boolean allowed) {
        this.numberCurvesComboBox.setVisible(allowed);
        this.labelNumberCurves.setVisible(allowed);
        if (!allowed) {
            this.numberCurvesComboBox.setSelectedIndex(0);
        }
    }

    void pasteButton_ActionPerformed(ActionEvent event) {
        this.setCursor(new Cursor(3));
        int colSel = this._table.getSelectedColumn();
        if (colSel < 1) {
            this._table.updateSelection(1, 1, false, false);
        }
        this._table.paste();
        this.setCursor(new Cursor(0));
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == PairedDataEntryPanel.this.numberCurvesComboBox) {
                PairedDataEntryPanel.this.numberOfCurvesChanged();
            } else if (object == PairedDataEntryPanel.this.pasteButton) {
                PairedDataEntryPanel.this.pasteButton_ActionPerformed(event);
            }
        }
    }
}

