/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.dataentry;

import hec.dataTable.HecDataTable;
import hec.dataTable.TimeSeriesColumnBase;
import hec.dataTable.TimeSeriesDataModel;
import hec.dataui.dataentry.TimeSeriesPathnameEditor;
import hec.heclib.dss.DSSPathname;
import hec.heclib.dss.HecTimeSeriesBase;
import hec.heclib.util.HecDouble;
import hec.heclib.util.HecTime;
import hec.hecmath.HecMath;
import hec.hecmath.HecMathException;
import hec.hecmath.TimeSeriesMath;
import hec.io.DataContainer;
import hec.io.TimeSeriesContainer;
import hec.lang.Const;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import rma.swing.RmaJDecimalField;
import rma.util.RMAIO;

public class TimeSeriesDataEntryPanel
extends JPanel
implements FocusListener {
    protected HecDataTable _table;
    protected JScrollPane _tableScrollPane;
    protected TimeSeriesPathnameEditor _pathnamePanel;
    protected JPanel _specsPanel;
    protected JPanel _timePanel;
    protected JPanel _typePanel;
    protected JLabel _labelStartDate;
    protected JTextField _startDateTextField;
    protected JLabel _labelStartTime;
    protected JTextField _startTimeTextField;
    protected JLabel _labelUnits;
    protected JTextField _unitsTextField;
    protected JLabel _labelType;
    protected JComboBox _typeComboBox;
    protected JPanel _autoPanel;
    protected JLabel _labelEndDate;
    protected JTextField _endDateTextField;
    protected JLabel _labelEndTime;
    protected JTextField _endTimeTextField;
    protected JLabel _labelInitialAutoValue;
    protected RmaJDecimalField _initialAutoValueTextField;
    protected JButton _generateAutoButton;
    protected JButton _pasteButton;
    protected JTabbedPane _tabbedPane;
    protected JPanel _tablePanel;
    protected TimeSeriesContainer _timeSeriesContainer = null;
    protected DSSPathname _path = new DSSPathname();
    protected String _sdate = "";
    protected String _stime = "";
    protected String _edate = "";
    protected String _etime = "";

    public TimeSeriesDataEntryPanel() {
        this((TimeSeriesContainer)null);
    }

    public TimeSeriesDataEntryPanel(TimeSeriesContainer timeSeriesContainer) {
        super(new GridBagLayout());
        this._timeSeriesContainer = this._timeSeriesContainer != null ? timeSeriesContainer : new TimeSeriesContainer();
    }

    public void setData(TimeSeriesContainer timeSeriesContainer) {
        this._timeSeriesContainer = timeSeriesContainer;
        this.initializeData();
    }

    public void build() {
        this.buildPathnamePanel();
        this.buildSpecsPanel();
        this.buildTable();
        this.buildAutoPanel();
        this.registerListeners();
        if (this._timeSeriesContainer != null) {
            this.initializeData();
        }
    }

    protected void buildPathnamePanel() {
        this._pathnamePanel = new PathnamePanel(this._path);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.insets = new Insets(10, 24, 0, 24);
        gbc.weightx = 1.0;
        gbc.anchor = 11;
        gbc.fill = 2;
        ((GridBagLayout)this.getLayout()).setConstraints(this._pathnamePanel, gbc);
        this.add(this._pathnamePanel);
    }

    protected void buildSpecsPanel() {
        this._specsPanel = new JPanel(new GridLayout(1, 2));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.insets = new Insets(20, 24, 0, 24);
        gbc.weightx = 1.0;
        gbc.anchor = 11;
        gbc.fill = 2;
        this.add((Component)this._specsPanel, gbc);
        this._timePanel = new JPanel(new GridBagLayout());
        this._specsPanel.add(this._timePanel);
        this._labelStartDate = new JLabel("Start Date:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 0;
        gbc.anchor = 18;
        this._timePanel.add((Component)this._labelStartDate, gbc);
        this._startDateTextField = new JTextField();
        this._startDateTextField.setToolTipText("Date of the first data value");
        this._startDateTextField.setMargin(new Insets(0, 2, 0, 0));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 5, 0, 15);
        gbc.ipady = 0;
        this._timePanel.add((Component)this._startDateTextField, gbc);
        this._labelStartTime = new JLabel("Start Time:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 0;
        gbc.insets = new Insets(10, 0, 0, 0);
        gbc.anchor = 18;
        this._timePanel.add((Component)this._labelStartTime, gbc);
        this._startTimeTextField = new JTextField();
        this._startTimeTextField.setToolTipText("Time of the first data value");
        this._startTimeTextField.setMargin(new Insets(0, 2, 0, 0));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 5, 0, 15);
        gbc.ipady = 0;
        this._timePanel.add((Component)this._startTimeTextField, gbc);
        this._typePanel = new JPanel();
        this._typePanel.setLayout(new GridBagLayout());
        this._specsPanel.add(this._typePanel);
        this._labelUnits = new JLabel("Units:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 16, 0, 0);
        this._typePanel.add((Component)this._labelUnits, gbc);
        this._unitsTextField = new JTextField();
        this._unitsTextField.setToolTipText("Data units (e.g., FEET)");
        this._unitsTextField.setMargin(new Insets(0, 2, 0, 0));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 5, 0, 0);
        gbc.ipady = 0;
        this._typePanel.add((Component)this._unitsTextField, gbc);
        this._labelType = new JLabel("Type:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 0;
        gbc.insets = new Insets(10, 16, 0, 0);
        this._typePanel.add((Component)this._labelType, gbc);
        String[] types = new String[]{"PER-AVER", "PER-CUM", "INST-VAL", "INST-CUM"};
        this._typeComboBox = new JComboBox<String>(types);
        this._typeComboBox.setSelectedItem("INST-VAL");
        this._typeComboBox.setBackground(Color.white);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 5, 0, 0);
        gbc.ipadx = 0;
        gbc.ipady = 0;
        this._typePanel.add((Component)this._typeComboBox, gbc);
    }

    protected void plotData() {
        this.updateContainers();
        Window windowAncestor = SwingUtilities.getWindowAncestor(this);
        if (windowAncestor instanceof JFrame) {
            this._table.plot((JFrame)windowAncestor);
        }
    }

    protected void buildTable() {
        this._pasteButton = new JButton("Paste");
        this._pasteButton.setEnabled(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(10, 24, 0, 0);
        this.add((Component)this._pasteButton, gbc);
        this._tabbedPane = new JTabbedPane();
        this._tablePanel = new JPanel(new BorderLayout());
        this._tabbedPane.addTab("Manual Entry", this._tablePanel);
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 11;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(10, 24, 0, 24);
        this.add((Component)this._tabbedPane, gbc);
        this._table = this.createTable();
        this._table.allowSort(false);
        this._tableScrollPane = this._table.getScrollPane();
        this._tableScrollPane.setVerticalScrollBarPolicy(22);
        this._tablePanel.add((Component)this._tableScrollPane, "Center");
        this._table.setData((DataContainer)this._timeSeriesContainer, false, 0);
        this._table.setDateTimeAsTwoColumns(true);
        this._table.setNumberHeaderRows(0);
        this._table.setExtendable(true, 2);
        this._table.setEditable(false);
        this._table.setEditBackground(true);
        this._table.setMlHeaderRenderer();
        this._table.setDateStyle(4);
    }

    protected HecDataTable createTable() {
        return new HecDataTable((Component)this);
    }

    protected void buildAutoPanel() {
        Insets insets5505 = new Insets(5, 5, 0, 5);
        this._autoPanel = new JPanel(new GridBagLayout());
        this._tabbedPane.addTab("Automatic Generation", this._autoPanel);
        this._labelEndDate = new JLabel("End Date:");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(20, 5, 0, 5);
        this._autoPanel.add((Component)this._labelEndDate, gbc);
        this._endDateTextField = new JTextField();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = new Insets(20, 5, 0, 5);
        this._autoPanel.add((Component)this._endDateTextField, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = insets5505;
        this._autoPanel.add(Box.createHorizontalStrut(200), gbc);
        this._labelEndTime = new JLabel("End Time:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = insets5505;
        this._autoPanel.add((Component)this._labelEndTime, gbc);
        this._endTimeTextField = new JTextField();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = insets5505;
        this._autoPanel.add((Component)this._endTimeTextField, gbc);
        this._labelInitialAutoValue = new JLabel("Fill Value:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = insets5505;
        this._autoPanel.add((Component)this._labelInitialAutoValue, gbc);
        this._initialAutoValueTextField = new RmaJDecimalField();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = insets5505;
        this._autoPanel.add((Component)this._initialAutoValueTextField, gbc);
        JPanel btnPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = new Insets(20, 5, 0, 5);
        this._autoPanel.add((Component)btnPanel, gbc);
        this._generateAutoButton = new JButton("Generate");
        this._generateAutoButton.setEnabled(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 10;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 0, 0, 0);
        btnPanel.add((Component)this._generateAutoButton, gbc);
    }

    protected void registerListeners() {
        SymAction lSymAction = new SymAction();
        this._pasteButton.addActionListener(lSymAction);
        this._typeComboBox.addActionListener(lSymAction);
        this._startDateTextField.addFocusListener(this);
        this._startTimeTextField.addFocusListener(this);
        this._unitsTextField.addFocusListener(this);
        this._endDateTextField.addFocusListener(this);
        this._endTimeTextField.addFocusListener(this);
        this._generateAutoButton.addActionListener(lSymAction);
    }

    protected void initializeData() {
        if (this._timeSeriesContainer != null) {
            if (this._timeSeriesContainer.fullName != null && this._timeSeriesContainer.fullName.length() > 9) {
                this._path.setPathname(this._timeSeriesContainer.fullName);
            }
            if (this._path.getEPart().length() <= 3 && this._timeSeriesContainer.interval > 0) {
                String interval = HecTimeSeriesBase.getEPartFromInterval((int)this._timeSeriesContainer.interval);
                this._path.setEPart(interval);
            }
            this._pathnamePanel.setPathname(this._path.pathname());
            this._table.setData((DataContainer)this._timeSeriesContainer, false, 0);
            this._table.setMlHeaderRenderer();
            this._table.setEditable(true);
            this._table.setExtendable(true, 2);
            if (this._timeSeriesContainer.times != null && this._timeSeriesContainer.times.length > 1 && this._timeSeriesContainer.times[0] != 0) {
                HecTime start = new HecTime();
                start.set(this._timeSeriesContainer.times[0]);
                this._sdate = start.date();
                this._stime = start.time();
                this._startDateTextField.setText(this._sdate);
                this._startTimeTextField.setText(this._stime);
                this._table.initializeEntryStartTime();
            }
            if (this._timeSeriesContainer.units != null && this._timeSeriesContainer.units.length() > 0) {
                this.setUnits(this._timeSeriesContainer.units);
            }
            if (this._timeSeriesContainer.type != null && this._timeSeriesContainer.type.length() > 0) {
                this.setType(this._timeSeriesContainer.type);
            }
        } else {
            this._timeSeriesContainer = new TimeSeriesContainer();
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent event) {
        Object object = event.getSource();
        if (object == this._startDateTextField) {
            this.setStartDate();
        } else if (object == this._startTimeTextField) {
            this.setStartTime();
        } else if (object == this._endDateTextField) {
            this.setEndDate();
        } else if (object == this._endTimeTextField) {
            this.setEndTime();
        } else if (object == this._unitsTextField) {
            this.updateUnits();
        }
    }

    protected void setStartDate() {
        String date = this._startDateTextField.getText();
        if (date.equals(this._sdate)) {
            return;
        }
        this._sdate = date;
        HecTime startTime = new HecTime();
        int status = startTime.setDate(date);
        if (status != 0 && date.length() > 0) {
            String message = "Invalid date:  " + date;
            JOptionPane.showMessageDialog(this, message, "Invalid date", 2);
        }
        if (this._stime.length() > 2 && (status = startTime.setTime(this._stime)) == 0) {
            this.initializeTableTime(startTime);
        }
    }

    public void setStartTime(HecTime time) {
        if (time == null || !time.isDefined()) {
            this._startTimeTextField.setText("");
            this._startDateTextField.setText("");
            this.setStartDate();
            this.setStartTime();
            return;
        }
        this._startDateTextField.setText(time.date());
        this._startTimeTextField.setText(time.time());
        this.setStartDate();
        this.setStartTime();
    }

    protected void setStartTime() {
        String time = this._startTimeTextField.getText();
        if (time.equals(this._stime)) {
            return;
        }
        this._stime = time;
        HecTime startTime = new HecTime();
        int status = startTime.setTime(time);
        if (status != 0 && this._stime.length() > 0) {
            String message = "Invalid time:  " + time;
            JOptionPane.showMessageDialog(this, message, "Invalid time", 2);
        }
        if (this._sdate.length() > 2 && (status = startTime.setDate(this._sdate)) == 0) {
            this.initializeTableTime(startTime);
        }
    }

    protected void setEndDate() {
        String date = this._endDateTextField.getText();
        if (date.equals(this._edate)) {
            return;
        }
        this._edate = date;
        HecTime endTime = new HecTime();
        int status = endTime.setDate(date);
        if (status != 0) {
            String message = "Invalid end date:  " + date;
            JOptionPane.showMessageDialog(this, message, "Invalid Date", 2);
        }
        if (this._etime.length() > 2) {
            status = endTime.setTime(this._etime);
        }
        this.checkAutoPanel();
    }

    protected void setEndTime() {
        String time = this._endTimeTextField.getText();
        if (time.equals(this._etime)) {
            return;
        }
        this._etime = time;
        HecTime endTime = new HecTime();
        int status = endTime.setTime(time);
        if (status != 0) {
            String message = "Invalid end time:  " + time;
            JOptionPane.showMessageDialog(this, message, "Invalid time", 2);
        }
        if (this._edate.length() > 2) {
            status = endTime.setDate(this._edate);
        }
        this.checkAutoPanel();
    }

    protected void checkAutoPanel() {
        if (this._edate.length() > 1 && this._etime.length() > 1 && this._sdate.length() > 1 && this._stime.length() > 1) {
            this._generateAutoButton.setEnabled(true);
        } else {
            this._generateAutoButton.setEnabled(false);
        }
    }

    protected void updateTable() {
        this._table.tableChanged(new TableModelEvent(this._table.getModel()));
    }

    protected void updateUnits() {
        if (this._timeSeriesContainer != null) {
            this._timeSeriesContainer.units = this._unitsTextField.getText();
            this.updateTable();
        }
    }

    protected void updateType() {
        if (this._timeSeriesContainer != null) {
            this._timeSeriesContainer.type = this._typeComboBox.getSelectedItem().toString();
            this.updateTable();
        }
    }

    protected void initializeTableTime(HecTime startTime) {
        DSSPathname path = this.getDSSPathname();
        int interval = this.getIntervalFromPath(path);
        if (this._timeSeriesContainer.getStartTime().equals(startTime) && this._timeSeriesContainer.interval == interval) {
            return;
        }
        this._timeSeriesContainer.setStartTime(startTime);
        this._timeSeriesContainer.interval = interval;
        this._table.setMlHeaderRenderer();
        this._table.setEditable(true);
        this._table.initializeEntryStartTime();
        this.updateTable();
        this.setButtonsEnabled();
        ListSelectionModel select = this._table.getSelectionModel();
        if (select.isSelectionEmpty()) {
            if (interval == 0) {
                this._table.updateSelection(0, 1, false, false);
            } else if (this._table.getDateTimeAsTwoColumns()) {
                this._table.updateSelection(0, 3, false, false);
            } else {
                this._table.updateSelection(0, 2, false, false);
            }
        }
    }

    protected int getIntervalFromPath(DSSPathname path) {
        int interval;
        if (path.isCwmsTsId()) {
            String strInterval = path.getDPart().replace("~", "");
            interval = HecTimeSeriesBase.getIntervalFromEPart((String)strInterval);
        } else {
            interval = HecTimeSeriesBase.getIntervalFromEPart((String)path.getEPart());
        }
        return interval;
    }

    protected void setButtonsEnabled() {
        this._pasteButton.setEnabled(true);
    }

    public void updateContainers() {
        DSSPathname path = this._pathnamePanel.getDSSPathname();
        this._timeSeriesContainer.fullName = path.pathname();
        this._timeSeriesContainer.watershed = path.aPart();
        this._timeSeriesContainer.location = path.bPart();
        this._timeSeriesContainer.parameter = path.cPart();
        this._timeSeriesContainer.version = path.fPart();
        this._timeSeriesContainer.units = this._unitsTextField.getText();
        this._timeSeriesContainer.type = (String)this._typeComboBox.getSelectedItem();
        int[] firstError = new int[3];
        this._table.updateContainers(firstError);
    }

    public TimeSeriesContainer getData() {
        this.updateContainers();
        return this._timeSeriesContainer;
    }

    public void setData(List data) {
        double val;
        long millis;
        Date date;
        HecTime time = new HecTime();
        Object obj = data.get(0);
        if (!(obj instanceof List)) {
            return;
        }
        List row = (List)obj;
        TimeZone tz = TimeZone.getDefault();
        long lastTime = 0L;
        long timeDiff = Long.MIN_VALUE;
        if (this._timeSeriesContainer == null) {
            this._timeSeriesContainer = new TimeSeriesContainer();
        }
        int numRows = data.size();
        this._timeSeriesContainer.times = new int[numRows];
        this._timeSeriesContainer.values = new double[numRows];
        for (int c = 0; c < row.size(); ++c) {
            obj = row.get(c);
            if (obj instanceof Date) {
                date = (Date)obj;
                lastTime = date.getTime();
                millis = tz.getOffset(lastTime);
                time.set(date, 0);
                this._timeSeriesContainer.times[0] = time.value();
                continue;
            }
            val = RMAIO.parseDouble(obj);
            if (!Const.isDefined((double)val)) continue;
            this._timeSeriesContainer.values[0] = val;
        }
        boolean irregular = false;
        for (int r = 1; r < data.size(); ++r) {
            obj = data.get(r);
            if (!(obj instanceof List)) continue;
            row = (List)obj;
            for (int c = 0; c < row.size(); ++c) {
                obj = row.get(c);
                if (obj instanceof Date) {
                    date = (Date)obj;
                    long currTime = date.getTime();
                    if (Const.isUndefined((long)timeDiff)) {
                        timeDiff = currTime - lastTime;
                    } else if (currTime - lastTime != timeDiff) {
                        irregular = true;
                    }
                    millis = tz.getOffset(currTime);
                    time.set(date, 0);
                    this._timeSeriesContainer.times[r] = time.value();
                    lastTime = currTime;
                    continue;
                }
                val = RMAIO.parseDouble(obj);
                if (!Const.isDefined((double)val)) continue;
                this._timeSeriesContainer.values[r] = val;
            }
        }
        this._timeSeriesContainer.numberValues = numRows;
        if (irregular) {
            this._pathnamePanel.EPartComboBox.setSelectedIndex(0);
        } else if (Const.isDefined((long)timeDiff)) {
            String epart = HecTimeSeriesBase.getEPartFromInterval((int)((int)timeDiff / 60000));
            this._pathnamePanel.EPartComboBox.setSelectedItem(epart);
        }
        this._table.setData((DataContainer)this._timeSeriesContainer, false, 0);
        time.set(this._timeSeriesContainer.times[0]);
        this.setStartTime(time);
        TimeSeriesDataModel model = (TimeSeriesDataModel)this._table.getModel();
        Vector dataColumns = model.getDataColumns();
        TimeSeriesColumnBase columnBase = (TimeSeriesColumnBase)dataColumns.get(0);
        columnBase.setDataChanged(true);
    }

    void pasteButtonActionPerformed(ActionEvent event) {
        this.setCursor(new Cursor(3));
        this._table.stopEditing();
        int colSel = this._table.getSelectedColumn();
        int rowSel = this._table.getSelectedRow();
        if (!this._table.isCellEditable(rowSel, colSel)) {
            if (rowSel < 0) {
                rowSel = 0;
            }
            if (colSel < 1) {
                colSel = 1;
            }
            if (this._timeSeriesContainer.interval > 0) {
                colSel = !this._table.getDateTimeAsTwoColumns() ? 2 : 3;
            }
            this._table.updateSelection(rowSel, colSel, false, false);
        }
        this._table.paste();
        this.setCursor(new Cursor(0));
    }

    public void generateAutoActionPerformed(ActionEvent event) {
        this.setStartDate();
        this.setEndDate();
        try {
            if (this._timeSeriesContainer == null) {
                this._timeSeriesContainer = new TimeSeriesContainer();
            }
            HecMath mathGuy = TimeSeriesMath.generateRegularIntervalTimeSeries((String)(this._sdate + " " + this._stime), (String)(this._edate + " " + this._etime), (String)((String)this._pathnamePanel.EPartComboBox.getSelectedItem()), (double)this._initialAutoValueTextField.getValueUndefined(-3.4028234663852886E38));
            mathGuy.getData((DataContainer)this._timeSeriesContainer);
            HecDouble d = new HecDouble(this._initialAutoValueTextField.getText());
            if (d.isDefined() && d.precision() > -1) {
                this._timeSeriesContainer.precision = d.precision();
            }
            this._table.setData((DataContainer)this._timeSeriesContainer, false, 0);
            this._table.setMlHeaderRenderer();
            this._table.setEditable(true);
            this._tabbedPane.setSelectedIndex(0);
        }
        catch (HecMathException hme) {
            System.out.println("error generating timeseries " + hme);
            JOptionPane.showMessageDialog(this, hme.toString(), "Error", 0);
        }
    }

    public boolean hasDataChanged() {
        return this._table.hasDataChanged();
    }

    public DSSPathname getDSSPathname() {
        return this._pathnamePanel.getDSSPathname();
    }

    public void setDSSPathname(String path) {
        this._pathnamePanel.setDSSPathname(path);
    }

    public void setUnits(String units) {
        this._unitsTextField.setText(units);
    }

    public void setType(String type) {
        this._typeComboBox.setSelectedItem(type);
    }

    private final class PathnamePanel
    extends TimeSeriesPathnameEditor {
        private PathnamePanel(DSSPathname pathname) {
            super(pathname);
        }

        @Override
        protected void setInterval(String ePart) {
            HecTime startTime;
            int status;
            super.setInterval(ePart);
            if (TimeSeriesDataEntryPanel.this._sdate.length() > 2 && TimeSeriesDataEntryPanel.this._stime.length() > 3 && (status = (startTime = new HecTime()).set(TimeSeriesDataEntryPanel.this._sdate, TimeSeriesDataEntryPanel.this._stime)) == 0) {
                TimeSeriesDataEntryPanel.this.initializeTableTime(startTime);
            }
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == TimeSeriesDataEntryPanel.this._generateAutoButton) {
                TimeSeriesDataEntryPanel.this.generateAutoActionPerformed(event);
            } else if (object == TimeSeriesDataEntryPanel.this._pasteButton) {
                TimeSeriesDataEntryPanel.this.pasteButtonActionPerformed(event);
            } else if (object == TimeSeriesDataEntryPanel.this._typeComboBox) {
                TimeSeriesDataEntryPanel.this.updateType();
            }
        }
    }
}

