/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.dataentry;

import hec.heclib.dss.DSSPathname;
import hec.heclib.dss.HecTimeSeriesBase;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TimeSeriesPathnameEditor
extends JPanel
implements FocusListener {
    protected JPanel pathnamePanel;
    protected JLabel pathnameLabel;
    protected JTextField pathnameTextField;
    protected JPanel partsPanel;
    protected JPanel aPanel;
    protected JPanel bPanel;
    protected JPanel cPanel;
    protected JPanel dPanel;
    protected JPanel ePanel;
    protected JPanel fPanel;
    protected JLabel labelA;
    protected JTextField APartTextField;
    protected JLabel labelB;
    protected JTextField BPartTextField;
    protected JLabel labelC;
    protected JTextField CPartTextField;
    protected JLabel labelD;
    protected JTextField DPartTextField;
    protected JLabel labelE;
    protected JComboBox EPartComboBox;
    protected JLabel labelF;
    protected JTextField FPartTextField;
    protected DSSPathname _dssPathname = new DSSPathname();

    public TimeSeriesPathnameEditor(DSSPathname pathname) {
        this.setup();
        this.setPathname(pathname.getPathname());
    }

    public TimeSeriesPathnameEditor() {
        this.setup();
        String ePart = (String)this.EPartComboBox.getSelectedItem();
        this.setInterval(ePart);
    }

    public void setup() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.buildPartsPanel();
        this.buildPathnamePanel();
        this.registerListeners();
    }

    public void setPathname(String pathname) {
        String ePart = "";
        this._dssPathname.setPathname(pathname);
        if (this._dssPathname != null && this._dssPathname.getPathname().length() > 9) {
            ePart = this._dssPathname.getEPart();
            this.pathnameTextField.setText(this._dssPathname.getPathname());
            this.pathnameTextField_ActionPerformed();
        }
        if (ePart.length() < 2) {
            ePart = (String)this.EPartComboBox.getSelectedItem();
        }
        this.setInterval(ePart);
    }

    protected void buildPartsPanel() {
        this.partsPanel = new JPanel();
        this.partsPanel.setLayout(new GridBagLayout());
        this.setPartsPanelBorder("Pathname Parts");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 11;
        gbc.fill = 2;
        ((GridBagLayout)this.getLayout()).setConstraints(this.partsPanel, gbc);
        this.add(this.partsPanel);
        this.aPanel = new JPanel();
        this.aPanel.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        this.partsPanel.add((Component)this.aPanel, gbc);
        this.labelA = new JLabel();
        this.labelA.setText("A:");
        this.labelA.setForeground(new Color(0));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 12, 0, 0);
        ((GridBagLayout)this.aPanel.getLayout()).setConstraints(this.labelA, gbc);
        this.aPanel.add(this.labelA);
        this.APartTextField = new JTextField();
        this.APartTextField.setToolTipText("Group name");
        this.APartTextField.setForeground(new Color(0));
        this.APartTextField.setMargin(new Insets(0, 2, 0, 0));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 5, 0, 0);
        gbc.ipadx = 50;
        gbc.ipady = 0;
        ((GridBagLayout)this.aPanel.getLayout()).setConstraints(this.APartTextField, gbc);
        this.aPanel.add(this.APartTextField);
        this.bPanel = new JPanel();
        this.bPanel.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        this.partsPanel.add((Component)this.bPanel, gbc);
        this.labelB = new JLabel();
        this.labelB.setText("B:");
        this.labelB.setForeground(new Color(0));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 12, 0, 0);
        ((GridBagLayout)this.bPanel.getLayout()).setConstraints(this.labelB, gbc);
        this.bPanel.add(this.labelB);
        this.BPartTextField = new JTextField();
        this.BPartTextField.setToolTipText("Location");
        this.BPartTextField.setForeground(new Color(0));
        this.BPartTextField.setMargin(new Insets(0, 2, 0, 0));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 5, 0, 0);
        gbc.ipadx = 50;
        gbc.ipady = 0;
        ((GridBagLayout)this.bPanel.getLayout()).setConstraints(this.BPartTextField, gbc);
        this.bPanel.add(this.BPartTextField);
        this.cPanel = new JPanel();
        this.cPanel.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        this.partsPanel.add((Component)this.cPanel, gbc);
        this.labelC = new JLabel();
        this.labelC.setText("C:");
        this.labelC.setForeground(new Color(0));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 12, 0, 0);
        ((GridBagLayout)this.cPanel.getLayout()).setConstraints(this.labelC, gbc);
        this.cPanel.add(this.labelC);
        this.CPartTextField = new JTextField();
        this.CPartTextField.setToolTipText("Parameter");
        this.CPartTextField.setForeground(new Color(0));
        this.CPartTextField.setMargin(new Insets(0, 2, 0, 0));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 5, 0, 0);
        gbc.ipadx = 50;
        gbc.ipady = 0;
        ((GridBagLayout)this.cPanel.getLayout()).setConstraints(this.CPartTextField, gbc);
        this.cPanel.add(this.CPartTextField);
        this.dPanel = new JPanel();
        this.dPanel.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        this.partsPanel.add((Component)this.dPanel, gbc);
        this.labelD = new JLabel();
        this.labelD.setText("D:");
        this.labelD.setForeground(new Color(0));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 0;
        gbc.insets = new Insets(6, 12, 8, 0);
        ((GridBagLayout)this.dPanel.getLayout()).setConstraints(this.labelD, gbc);
        this.dPanel.add(this.labelD);
        this.DPartTextField = new JTextField();
        this.DPartTextField.setToolTipText("Block start date (automatically generated)");
        this.DPartTextField.setForeground(new Color(0));
        this.DPartTextField.setMargin(new Insets(0, 2, 0, 0));
        this.DPartTextField.setEnabled(false);
        this.DPartTextField.setBackground(new Color(230, 230, 230));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(6, 5, 8, 0);
        gbc.ipadx = 50;
        gbc.ipady = 0;
        ((GridBagLayout)this.dPanel.getLayout()).setConstraints(this.DPartTextField, gbc);
        this.dPanel.add(this.DPartTextField);
        this.ePanel = new JPanel();
        this.ePanel.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        this.partsPanel.add((Component)this.ePanel, gbc);
        this.labelE = new JLabel();
        this.labelE.setText("E:");
        this.labelE.setForeground(new Color(0));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 0;
        gbc.insets = new Insets(6, 12, 8, 0);
        ((GridBagLayout)this.ePanel.getLayout()).setConstraints(this.labelE, gbc);
        this.ePanel.add(this.labelE);
        Vector eParts = HecTimeSeriesBase.getListOfEParts();
        this.EPartComboBox = new JComboBox(eParts);
        this.EPartComboBox.setSelectedItem("1HOUR");
        this.EPartComboBox.setToolTipText("Time interval or irregular interval block length");
        this.EPartComboBox.setForeground(Color.black);
        this.EPartComboBox.setBackground(Color.white);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(6, 5, 8, 0);
        gbc.ipadx = 0;
        gbc.ipady = 0;
        ((GridBagLayout)this.ePanel.getLayout()).setConstraints(this.EPartComboBox, gbc);
        this.ePanel.add(this.EPartComboBox);
        this.fPanel = new JPanel();
        this.fPanel.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        this.partsPanel.add((Component)this.fPanel, gbc);
        this.labelF = new JLabel();
        this.labelF.setText("F:");
        this.labelF.setForeground(new Color(0));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 0;
        gbc.insets = new Insets(6, 12, 8, 0);
        ((GridBagLayout)this.fPanel.getLayout()).setConstraints(this.labelF, gbc);
        this.fPanel.add(this.labelF);
        this.FPartTextField = new JTextField();
        this.FPartTextField.setToolTipText("Version");
        this.FPartTextField.setForeground(new Color(0));
        this.FPartTextField.setMargin(new Insets(0, 2, 0, 0));
        this.FPartTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                TimeSeriesPathnameEditor.this.setPathnamePart(6, TimeSeriesPathnameEditor.this.FPartTextField.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                TimeSeriesPathnameEditor.this.setPathnamePart(6, TimeSeriesPathnameEditor.this.FPartTextField.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                TimeSeriesPathnameEditor.this.setPathnamePart(6, TimeSeriesPathnameEditor.this.FPartTextField.getText());
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(6, 5, 8, 0);
        gbc.ipadx = 50;
        gbc.ipady = 0;
        ((GridBagLayout)this.fPanel.getLayout()).setConstraints(this.FPartTextField, gbc);
        this.fPanel.add(this.FPartTextField);
    }

    protected void buildPathnamePanel() {
        this.pathnamePanel = new JPanel();
        this.pathnamePanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.insets = new Insets(2, 0, 0, 0);
        gbc.weightx = 1.0;
        gbc.anchor = 11;
        gbc.fill = 2;
        ((GridBagLayout)this.getLayout()).setConstraints(this.pathnamePanel, gbc);
        this.add(this.pathnamePanel);
        this.pathnameLabel = new JLabel();
        this.pathnameLabel.setText("Pathname: ");
        this.pathnameLabel.setForeground(new Color(0));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 0;
        gbc.insets = new Insets(8, 0, 0, 0);
        gbc.ipadx = 4;
        gbc.ipady = 0;
        ((GridBagLayout)this.pathnamePanel.getLayout()).setConstraints(this.pathnameLabel, gbc);
        this.pathnamePanel.add(this.pathnameLabel);
        this.pathnameTextField = new JTextField();
        this.pathnameTextField.setToolTipText("Full pathname");
        this.pathnameTextField.setForeground(new Color(0));
        this.pathnameTextField.setMargin(new Insets(0, 2, 0, 0));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 7;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 6, 0, 0);
        gbc.ipadx = 0;
        gbc.ipady = 0;
        ((GridBagLayout)this.pathnamePanel.getLayout()).setConstraints(this.pathnameTextField, gbc);
        this.pathnamePanel.add(this.pathnameTextField);
    }

    public void setPartsPanelBorder(String title) {
        TitledBorder border = BorderFactory.createTitledBorder(new EtchedBorder(), title);
        border.setTitleColor(Color.black);
        this.partsPanel.setBorder(border);
    }

    protected void registerListeners() {
        SymAction lSymAction = new SymAction();
        this.EPartComboBox.addActionListener(lSymAction);
        this.APartTextField.addFocusListener(this);
        this.BPartTextField.addFocusListener(this);
        this.CPartTextField.addFocusListener(this);
        this.DPartTextField.addFocusListener(this);
        this.FPartTextField.addFocusListener(this);
        this.pathnameTextField.addFocusListener(this);
    }

    protected void updatePathname() {
        String path = this._dssPathname.pathname();
        if (path.length() > 7) {
            this.pathnameTextField.setText(this._dssPathname.pathname());
        } else {
            this.pathnameTextField.setText("");
        }
    }

    public void setPathnamePart(int partNumber, String part) {
        if (partNumber == 1) {
            if (part.equals(this._dssPathname.aPart())) {
                return;
            }
            String oldAPart = this._dssPathname.aPart();
            this._dssPathname.setAPart(part);
            this.firePropertyChange("apart", oldAPart, part);
            this.APartTextField.setText(this._dssPathname.aPart());
        } else if (partNumber == 2) {
            if (part.equals(this._dssPathname.bPart())) {
                return;
            }
            String oldBPart = this._dssPathname.bPart();
            this._dssPathname.setBPart(part);
            this.firePropertyChange("bpart", oldBPart, part);
            this.BPartTextField.setText(this._dssPathname.bPart());
        } else if (partNumber == 3) {
            if (part.equals(this._dssPathname.cPart())) {
                return;
            }
            String oldCPart = this._dssPathname.cPart();
            this._dssPathname.setCPart(part);
            this.firePropertyChange("cpart", oldCPart, part);
            this.CPartTextField.setText(this._dssPathname.cPart());
        } else if (partNumber == 4) {
            if (part.equals(this._dssPathname.dPart())) {
                return;
            }
            String oldDPart = this._dssPathname.dPart();
            this._dssPathname.setDPart(part);
            this.firePropertyChange("dpart", oldDPart, part);
            this.DPartTextField.setText(this._dssPathname.dPart());
        } else if (partNumber == 5) {
            this.EPartComboBox.setSelectedItem(part);
            this._dssPathname.setEPart(part);
        } else if (partNumber == 6) {
            if (part.equals(this._dssPathname.fPart())) {
                return;
            }
            String oldFPart = this._dssPathname.fPart();
            this._dssPathname.setFPart(part);
            this.firePropertyChange("fpart", oldFPart, part);
            if (!this.FPartTextField.getText().equals(this._dssPathname.fPart())) {
                this.FPartTextField.setText(this._dssPathname.fPart());
            }
        }
        this.updatePathname();
    }

    void pathnameTextField_ActionPerformed() {
        this._dssPathname.setPathname(this.pathnameTextField.getText());
        this.APartTextField.setText(this._dssPathname.aPart());
        this.BPartTextField.setText(this._dssPathname.bPart());
        this.CPartTextField.setText(this._dssPathname.cPart());
        this.DPartTextField.setText(this._dssPathname.dPart());
        if (this._dssPathname.ePart().length() > 2) {
            this.EPartComboBox.setSelectedItem(this._dssPathname.ePart());
        }
        this.FPartTextField.setText(this._dssPathname.fPart());
        this.updatePathname();
    }

    protected void setInterval(String ePart) {
        if (ePart.equals(this._dssPathname.ePart())) {
            return;
        }
        String oldEPart = this._dssPathname.ePart();
        this._dssPathname.setEPart(ePart);
        this.firePropertyChange("epart", oldEPart, ePart);
        this.updatePathname();
    }

    public DSSPathname getDSSPathname() {
        return this._dssPathname;
    }

    public void setDSSPathname(String pathname) {
        DSSPathname dsspathname = new DSSPathname(pathname);
        this.setDSSPathname(dsspathname);
    }

    public void setDSSPathname(DSSPathname pathname) {
        if (pathname == null) {
            this.pathnameTextField.setText("");
            this.pathnameTextField_ActionPerformed();
        } else {
            this.pathnameTextField.setText(pathname.getPathname());
            this.pathnameTextField_ActionPerformed();
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent event) {
        Object object = event.getSource();
        if (object == this.pathnameTextField) {
            this.pathnameTextField_ActionPerformed();
        } else if (object == this.APartTextField) {
            this.setPathnamePart(1, this.APartTextField.getText());
        } else if (object == this.BPartTextField) {
            this.setPathnamePart(2, this.BPartTextField.getText());
        } else if (object == this.CPartTextField) {
            this.setPathnamePart(3, this.CPartTextField.getText());
        } else if (object == this.DPartTextField) {
            this.setPathnamePart(4, this.DPartTextField.getText());
        } else if (object == this.FPartTextField) {
            this.setPathnamePart(6, this.FPartTextField.getText());
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == TimeSeriesPathnameEditor.this.EPartComboBox) {
                String ePart = (String)TimeSeriesPathnameEditor.this.EPartComboBox.getSelectedItem();
                TimeSeriesPathnameEditor.this.setInterval(ePart);
            }
        }
    }
}

