/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.delete;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import rma.swing.RmaJButton;
import rma.swing.RmaJDialog;
import rma.swing.RmaJPanel;
import rma.swing.RmaJTextField;

public class CascadeDeleteOptionPane
extends RmaJPanel {
    private static final String MESSAGE = "To confirm cascade delete, type \"DELETE\"";
    private final RmaJTextField _textField;
    private final RmaJButton _okButton;
    private String _text;

    private CascadeDeleteOptionPane(JDialog dialog) {
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setVgap(10);
        this.setLayout(borderLayout);
        RmaJPanel confirmPanel = new RmaJPanel();
        GridLayout gridLayout = new GridLayout(2, 1);
        gridLayout.setVgap(10);
        gridLayout.setHgap(10);
        confirmPanel.setLayout(gridLayout);
        confirmPanel.add(new JLabel(MESSAGE, UIManager.getIcon("OptionPane.warningIcon"), 2));
        this._textField = new RmaJTextField();
        this._textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                CascadeDeleteOptionPane.this.validateOkButton();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CascadeDeleteOptionPane.this.validateOkButton();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                CascadeDeleteOptionPane.this.validateOkButton();
            }
        });
        confirmPanel.add((Component)this._textField);
        this.add((Component)confirmPanel, "Center");
        RmaJPanel buttonPanel = new RmaJPanel();
        this._okButton = new RmaJButton("OK");
        Dimension dimension = new Dimension(75, 25);
        this._okButton.setPreferredSize(dimension);
        this._okButton.setEnabled(false);
        this._okButton.addActionListener(e -> dialog.dispose());
        RmaJButton cancelButton = new RmaJButton("Cancel");
        cancelButton.addActionListener(e -> dialog.dispose());
        cancelButton.setPreferredSize(dimension);
        buttonPanel.add((Component)this._okButton);
        buttonPanel.add((Component)cancelButton);
        this.add((Component)buttonPanel, "South");
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
    }

    public static int showCascadeDeleteDialog(Component parentComponent, String title) throws HeadlessException {
        RmaJDialog dialog = new RmaJDialog();
        dialog.setTitle(title);
        dialog.setResizable(false);
        CascadeDeleteOptionPane cascadeDeleteOptionPane = new CascadeDeleteOptionPane((JDialog)dialog);
        dialog.add((Component)((Object)cascadeDeleteOptionPane));
        dialog.setModal(true);
        dialog.pack();
        dialog.setLocationRelativeTo(parentComponent);
        Dimension preferredSize = dialog.getPreferredSize();
        preferredSize.setSize(preferredSize.getWidth() * 1.5, preferredSize.getHeight());
        dialog.setSize(preferredSize);
        dialog.setVisible(true);
        dialog.dispose();
        String value = cascadeDeleteOptionPane.getText();
        if (value != null && value.toString().equals("DELETE")) {
            return 0;
        }
        return 2;
    }

    private void validateOkButton() {
        String text = this._textField.getText();
        this._okButton.setEnabled(text != null && text.equals("DELETE"));
    }

    public String getText() {
        return this._textField.getText();
    }
}

