/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.filter;

import hec.data.location.LocationGroup;
import hec.data.tx.TsGroup;
import hec.dataui.filter.CheckBoxFilter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Arrays;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;

public class SearchFilterMenu
extends JMenu
implements ActionListener,
WindowListener {
    private JRadioButtonMenuItem _locGroupCategoryFilter = new JRadioButtonMenuItem("By Location Category/Group");
    private JRadioButtonMenuItem _tsGroupCategoryFilter = new JRadioButtonMenuItem("By Ts Category/Group");
    private JRadioButtonMenuItem _noFilter = new JRadioButtonMenuItem("No Filter");
    private CheckBoxFilter _locGroupCategoryFilterPanel;
    private CheckBoxFilter _tsGroupCategoryFilterPanel;
    private JDialog _filterDialog;

    public SearchFilterMenu(ActionListener actionListener) {
        super("Filter By Groups");
        ButtonGroup filterGroup = new ButtonGroup();
        filterGroup.add(this._locGroupCategoryFilter);
        filterGroup.add(this._tsGroupCategoryFilter);
        filterGroup.add(this._noFilter);
        this.add(this._locGroupCategoryFilter);
        this.add(this._tsGroupCategoryFilter);
        this.add(this._noFilter);
        this._locGroupCategoryFilter.setEnabled(false);
        this._tsGroupCategoryFilter.setEnabled(false);
        this._noFilter.setSelected(true);
        this._locGroupCategoryFilter.addActionListener(this);
        this._tsGroupCategoryFilter.addActionListener(this);
        this._noFilter.addActionListener(actionListener);
        this._filterDialog = new JDialog();
        this._locGroupCategoryFilterPanel = new CheckBoxFilter(actionListener, this._filterDialog);
        this._tsGroupCategoryFilterPanel = new CheckBoxFilter(actionListener, this._filterDialog);
    }

    public void setLocGroupData(Object[] locGroupData) {
        if (locGroupData == null || locGroupData.length == 0) {
            this._locGroupCategoryFilterPanel.setEnabled(false);
            return;
        }
        this._locGroupCategoryFilterPanel.setData(locGroupData);
        this._locGroupCategoryFilter.setEnabled(true);
    }

    public void setTsGroupData(Object[] tsGroupData) {
        if (tsGroupData == null || tsGroupData.length == 0) {
            this._tsGroupCategoryFilterPanel.setEnabled(false);
            return;
        }
        this._tsGroupCategoryFilterPanel.setData(tsGroupData);
        this._tsGroupCategoryFilter.setEnabled(true);
    }

    public LocationGroup[] getSelectedLocGroups() {
        if (this._locGroupCategoryFilter.isSelected()) {
            Object[] objList = this._locGroupCategoryFilterPanel.getSelectedList();
            if (objList != null) {
                return (LocationGroup[])Arrays.copyOf(objList, objList.length, LocationGroup[].class);
            }
            return null;
        }
        return null;
    }

    public TsGroup[] getSelectedTsGroups() {
        if (this._tsGroupCategoryFilter.isSelected()) {
            Object[] objList = this._tsGroupCategoryFilterPanel.getSelectedList();
            if (objList != null) {
                return (TsGroup[])Arrays.copyOf(objList, objList.length, TsGroup[].class);
            }
            return null;
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this._locGroupCategoryFilter) {
            this._filterDialog.setContentPane(this._locGroupCategoryFilterPanel);
        } else if (e.getSource() == this._tsGroupCategoryFilter) {
            this._filterDialog.setContentPane(this._tsGroupCategoryFilterPanel);
        } else {
            return;
        }
        this._filterDialog.pack();
        this._filterDialog.setVisible(true);
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this._filterDialog.dispose();
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }
}

