/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.importExport.general;

import hec.dataui.importExport.general.ImportPathDialog;
import hec.dataui.importExport.general.ImportTable;
import hec.dataui.importExport.general.ImportTableModel;
import hec.heclib.dss.DSSPathname;
import hec.heclib.dss.HecTimeSeries;
import hec.heclib.dss.HecTimeSeriesBase;
import hec.heclib.util.HecTime;
import hec.io.TimeSeriesContainer;
import hec.util.ObservableClass;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JOptionPane;

public class ImportControl
implements Observer {
    protected Vector _timeSeriesContainers;
    protected ObservableClass _observer;
    protected ImportPathDialog _importPathDialog;
    protected int _count = 0;
    protected int[] _times = null;
    protected double[][] _values = null;
    protected int[] _rawTimes = null;
    protected boolean _timesRead = false;
    protected String _importMessage = "";
    protected ImportTableModel _importTableModel;
    protected ImportTable _table;

    public ImportControl(ImportTable table) {
        this._table = table;
        this._importTableModel = (ImportTableModel)((Object)this._table.getModel());
        this._timeSeriesContainers = new Vector();
        this._importPathDialog = new ImportPathDialog();
        this._importPathDialog.setModal(true);
        this._observer = new ObservableClass();
        this._table.addObserver(this);
    }

    public void clearAll() {
        this._timeSeriesContainers.clear();
        this._count = 0;
        this._times = null;
        this._rawTimes = null;
        this._values = null;
        this._timesRead = false;
        this._importMessage = "";
    }

    public Vector getData() {
        return this._timeSeriesContainers;
    }

    public String getMessage() {
        return this._importMessage;
    }

    public boolean isAnySet() {
        return this._importTableModel.isAnySet();
    }

    public boolean isTimeSet() {
        return this._importTableModel.isTimeSet();
    }

    public boolean isDataSet() {
        return this._importTableModel.isDataSet();
    }

    public boolean isPathPartsSet() {
        return this._importTableModel.isPathPartsSet();
    }

    protected void newDataSet(int numb) {
        this.setDialogTime();
        String[] pathnameParts = this._importTableModel.getPathnameParts(numb);
        this._importPathDialog.setPathnameParts(pathnameParts);
        this._importPathDialog.setVisible(true);
        if (this._importPathDialog.isCanceled()) {
            this._table.clearDataColumn(numb);
            return;
        }
        TimeSeriesContainer tsc = new TimeSeriesContainer();
        tsc.fullName = this._importPathDialog.getPathname();
        tsc.type = this._importPathDialog.getRecordType();
        tsc.units = this._importPathDialog.getUnits();
        tsc.startTime = this._importPathDialog.getFirstTime().value();
        this._timeSeriesContainers.add(tsc);
        if (this._importPathDialog.importNow()) {
            this.importData();
        }
    }

    protected void setAllColumns(int numb) {
        int i;
        this.setDialogTime();
        String[] pathnameParts = new String[6];
        for (i = 0; i < 6; ++i) {
            int action = 50 + i;
            if (!this._importTableModel.getActionSet(action)) continue;
            pathnameParts[i] = "*";
        }
        this._importPathDialog.setPathnameParts(pathnameParts);
        if (this._importTableModel.getActionSet(60)) {
            this._importPathDialog.setUnits("*");
        }
        this._importPathDialog.setVisible(true);
        for (i = 0; i < numb; ++i) {
            if (this._importPathDialog.isCanceled()) {
                this._table.clearDataColumn(i);
                return;
            }
            TimeSeriesContainer tsc = new TimeSeriesContainer();
            DSSPathname path = this._importPathDialog.getDSSPathname();
            String[] pathParts = path.getParts();
            String[] parts = this._importTableModel.getPathnameParts(i);
            for (int j = 0; j < 6; ++j) {
                if (!pathParts[j].equals("*") || parts[j] == null) continue;
                pathParts[j] = parts[j];
            }
            path.setParts(pathParts);
            tsc.fullName = path.getPathname();
            tsc.type = this._importPathDialog.getRecordType();
            tsc.units = this._importPathDialog.getUnits();
            if (tsc.units.equals("*")) {
                tsc.units = this._importTableModel.getUnits(i);
            }
            this._timeSeriesContainers.add(tsc);
        }
        if (this._importPathDialog.importNow()) {
            this.importData();
        }
    }

    protected void setDialogTime() {
        HecTime hecTime = this._importPathDialog.getFirstTime();
        if (!hecTime.isDefined() && (hecTime = this._importTableModel.getFirstTime()).isDefined()) {
            this._importPathDialog.setFirstTime(hecTime);
            int[] times = this.getDateTimes();
            String ePart = HecTimeSeriesBase.getAppropriateEPart((int[])times);
            this._importPathDialog.setEPart(ePart);
        }
    }

    public boolean importData() {
        DSSPathname path;
        int interval;
        this._importMessage = "";
        this.runImport();
        int[] timeVals = this.getDateTimes();
        HecTime firstTime = this._importPathDialog.getFirstTime();
        if (!firstTime.isDefined()) {
            JOptionPane.showMessageDialog(null, "No date/time defined, or date/time cannot be determined", "Import", 2);
            return false;
        }
        this._importPathDialog.getFirstTime();
        boolean ascending = true;
        boolean badValues = false;
        boolean haveOne = false;
        for (int j = 0; j < timeVals.length; ++j) {
            if (timeVals[j] == -2147483647) {
                badValues = true;
            } else {
                haveOne = true;
            }
            if (j <= 0 || timeVals[j] > timeVals[j - 1]) continue;
            ascending = false;
        }
        if (!haveOne && (interval = HecTimeSeries.getIntervalFromEPart((String)(path = new DSSPathname(this._importPathDialog.getPathname())).ePart())) > 0) {
            HecTime htime = new HecTime(firstTime);
            for (int i = 0; i < timeVals.length; ++i) {
                htime.set(firstTime);
                htime.increment(i, interval);
                timeVals[i] = htime.value();
            }
            ascending = true;
            badValues = false;
        }
        for (int i = 0; i < this._timeSeriesContainers.size(); ++i) {
            TimeSeriesContainer tsc = (TimeSeriesContainer)this._timeSeriesContainers.elementAt(i);
            double[] values = this.getValues(i);
            int[] times = timeVals;
            if (!ascending) {
                times = Arrays.copyOf(timeVals, timeVals.length);
                Arrays.sort(times);
            }
            if (!ascending || badValues) {
                int badCount = 0;
                for (int time : times) {
                    if (time != -2147483647) continue;
                    ++badCount;
                }
                int newSize = times.length - badCount;
                if (newSize < 1) continue;
                int[] tmpTimes = new int[newSize];
                double[] tmpVals = new double[newSize];
                int count = 0;
                block4: for (int t : times) {
                    for (int k = 0; k < timeVals.length; ++k) {
                        if (timeVals[k] != t) continue;
                        tmpTimes[count] = t;
                        tmpVals[count++] = values[k];
                        continue block4;
                    }
                }
                times = Arrays.copyOf(tmpTimes, count);
                values = Arrays.copyOf(tmpVals, count);
            }
            tsc.values = values;
            tsc.numberValues = values.length;
            if (tsc.numberValues == 0) {
                this._importMessage = "***** No data values for " + tsc.fullName;
                System.out.println(this._importMessage);
                JOptionPane.showMessageDialog(null, this._importMessage);
                return false;
            }
            if (times != null && times.length > 0 && times[0] != 0) {
                tsc.times = times;
                tsc.startTime = times[0];
                continue;
            }
            DSSPathname path2 = new DSSPathname(tsc.fullName);
            int interval2 = HecTimeSeriesBase.getIntervalFromEPart((String)path2.ePart());
            if (interval2 > 0 && tsc.startTime != 0) {
                HecTime hecTime = new HecTime();
                hecTime.set(tsc.startTime);
                tsc.times = new int[tsc.numberValues];
                tsc.times[0] = hecTime.value();
                for (int j = 1; j < tsc.numberValues; ++j) {
                    hecTime.increment(1, interval2);
                    tsc.times[j] = hecTime.value();
                }
            } else {
                this._importMessage = "***** No time interval or time array for " + tsc.fullName;
                System.out.println(this._importMessage);
                return false;
            }
            tsc.endTime = tsc.times[tsc.times.length - 1];
        }
        this.importComplete();
        return true;
    }

    protected boolean readTimes() {
        boolean found = false;
        this._rawTimes = new int[this._table.getRowCount()];
        Arrays.fill(this._rawTimes, -2147483647);
        HecTime hecTime = this._importTableModel.getFirstTime();
        if (hecTime.isDefined()) {
            found = true;
            for (int i = 0; i < this._table.getRowCount(); ++i) {
                if (!this._importTableModel.isDataRow(i)) {
                    this._rawTimes[i] = -2147483647;
                    continue;
                }
                this._importTableModel.getTime(i, hecTime);
                this._rawTimes[i] = hecTime.isDefined() ? hecTime.value() : -2147483647;
            }
        }
        return found;
    }

    protected int runImport() {
        int numbRows = this._table.getRowCount();
        int numberDataSets = this._table.getNumberDataSets();
        if (this._rawTimes == null) {
            this.readTimes();
        }
        this._times = new int[numbRows];
        this._values = new double[numberDataSets][numbRows];
        this._count = -1;
        for (int i = 0; i < numbRows; ++i) {
            if (!this._importTableModel.isDataRow(i)) continue;
            ++this._count;
            this._times[this._count] = this._rawTimes[i];
            for (int j = 1; j < this._table.getColumnCount(); ++j) {
                int action;
                if (this._importTableModel.isSkippedColumn(j) || (action = this._importTableModel.getCellAction(i, j)) < 100) continue;
                String sval = this._table.getValueAt(i, j).toString();
                try {
                    if (sval.trim().length() > 0) {
                        double val;
                        this._values[action - 100][this._count] = val = Double.parseDouble(sval);
                        continue;
                    }
                    this._values[action - 100][this._count] = -3.4028234663852886E38;
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        ++this._count;
        this._times = Arrays.copyOf(this._times, this._count);
        return numberDataSets;
    }

    public int[] getDateTimes() {
        if (this._times == null && this._rawTimes == null) {
            this.readTimes();
            if (this._rawTimes == null) {
                return null;
            }
            this._times = new int[this._rawTimes.length];
            int count = 0;
            for (int _rawTime : this._rawTimes) {
                if (_rawTime == -2147483647) continue;
                this._times[count++] = _rawTime;
            }
            if (count != this._rawTimes.length) {
                this._times = Arrays.copyOf(this._times, count);
            }
        }
        return this._times;
    }

    public int[] getRawTimes() {
        if (this._rawTimes == null) {
            this.readTimes();
        }
        return this._rawTimes;
    }

    protected double[] getValues(int col) {
        return Arrays.copyOf(this._values[col], this._count);
    }

    protected void importComplete() {
        ActionEvent event = new ActionEvent(this, 0, "importComplete");
        if (this._observer != null) {
            this._observer.notifyObservers((Object)event);
        }
    }

    public void addObserver(Observer o) {
        if (this._observer != null) {
            this._observer.addObserver(o);
        }
    }

    public void removeObserver(Observer o) {
        if (this._observer != null) {
            this._observer.deleteObserver(o);
        }
    }

    public void close() {
        this._importPathDialog.dispose();
        if (this._observer != null) {
            this._observer.deleteObservers();
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg instanceof ActionEvent) {
            ActionEvent event = (ActionEvent)arg;
            String eventName = event.getActionCommand();
            if (eventName.compareTo("dataSet") == 0) {
                int numb = event.getID();
                this.newDataSet(numb);
            } else if (eventName.compareTo("setAllColumns") == 0) {
                int numb = event.getID();
                this.setAllColumns(numb);
            }
        }
    }
}

