/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.importExport.general;

import hec.dataui.tx.PathnameDefinitionPanel;
import hec.heclib.dss.DSSPathname;
import hec.heclib.util.HecTime;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import rma.swing.ButtonCmdPanel;
import rma.swing.RmaInsets;

public class ImportPathDialog
extends JDialog {
    protected PathnameDefinitionPanel _pathDialog;
    protected boolean _canceled = false;
    protected boolean _importNow = false;

    public ImportPathDialog() {
        this.build();
    }

    public DSSPathname getDSSPathname() {
        return this._pathDialog.getPathname();
    }

    public String getPathname() {
        return this.getDSSPathname().pathname();
    }

    public String getUnits() {
        return this._pathDialog.getUnits();
    }

    public void setUnits(String units) {
        this._pathDialog.setUnits(units);
    }

    public String getRecordType() {
        return this._pathDialog.getRecordType();
    }

    public HecTime getFirstTime() {
        return this._pathDialog.getFirstTime();
    }

    public void setFirstTime(HecTime hecTime) {
        this._pathDialog.setFirstTime(hecTime);
    }

    public void setEPart(String ePart) {
        this._pathDialog.setEPart(ePart);
    }

    protected void build() {
        this.setLayout(new GridBagLayout());
        this._pathDialog = new PathnameDefinitionPanel();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 16;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.add((Component)this._pathDialog, gbc);
        ButtonCmdPanel _cmdPanel = new ButtonCmdPanel(14);
        _cmdPanel.getButton("OK").setText("Import Now");
        _cmdPanel.getButton("APPLY").setText("OK");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 16;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)20, (int)5, (int)10, (int)5);
        this.add((Component)_cmdPanel, gbc);
        _cmdPanel.addCmdPanelListener(e -> {
            switch (e.getID()) {
                case 8: {
                    this.importNow_ActionPerformed();
                    break;
                }
                case 2: {
                    this.OKButton_ActionPerformed();
                    break;
                }
                case 4: {
                    this.CancelButton_ActionPerformed();
                }
            }
        });
        this.setSize(550, 320);
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    protected void importNow_ActionPerformed() {
        HecTime firstTime = this.getFirstTime();
        if (!firstTime.isDefined()) {
            JOptionPane.showMessageDialog(this, "No date/time defined, or date/time cannot be determined", "Import", 2);
            return;
        }
        this._canceled = false;
        this._importNow = true;
        this.setVisible(false);
    }

    protected void OKButton_ActionPerformed() {
        this._canceled = false;
        this._importNow = false;
        this.setVisible(false);
    }

    protected void CancelButton_ActionPerformed() {
        this._canceled = true;
        this._importNow = false;
        this.setVisible(false);
    }

    public boolean importNow() {
        return this._importNow;
    }

    public void setPathnameParts(String[] pathnameParts) {
        if (pathnameParts.length > 0 && pathnameParts[0] != null) {
            this._pathDialog.setAPart(pathnameParts[0]);
        }
        if (pathnameParts.length > 1 && pathnameParts[1] != null) {
            this._pathDialog.setBPart(pathnameParts[1]);
        }
        if (pathnameParts.length > 2 && pathnameParts[2] != null) {
            this._pathDialog.setCPart(pathnameParts[2]);
        }
        if (pathnameParts.length > 3 && pathnameParts[3] != null) {
            this._pathDialog.setDPart(pathnameParts[3]);
        }
        if (pathnameParts.length > 4 && pathnameParts[4] != null) {
            this._pathDialog.setEPart(pathnameParts[4]);
        }
        if (pathnameParts.length > 5 && pathnameParts[5] != null) {
            this._pathDialog.setFPart(pathnameParts[5]);
        }
    }
}

