/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.importExport.general;

import hec.dataui.importExport.general.ImportControl;
import hec.dataui.importExport.general.ImportTableModel;
import hec.heclib.util.HecTime;
import hec.util.ObservableClass;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import rma.swing.RmaJTable;
import rma.swing.table.MleHeadRenderer;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class ImportTable
extends RmaJTable {
    protected ObservableClass _observer;
    protected ImportControl _importControl = null;
    protected Vector<String> _instructions = new Vector();
    protected int _column = 0;
    protected int _row = 0;
    protected int _numberDataSets = 0;
    JPopupMenu _popup = null;
    JPopupMenu _rowPopup = null;
    JPopupMenu _columnPopup = null;
    JPopupMenu _cellPopup = null;
    JPopupMenu _cornerPopup = null;
    JMenuItem _clearDataCol = null;
    JMenuItem _clearRow = null;
    JMenuItem unskipMenu = null;
    private boolean _popupsEnabled = true;

    public ImportTable(Component parent) {
        super(parent);
        this.buildImportPopup();
        this._observer = new ObservableClass();
        MleHeadRenderer mleheadrend = new MleHeadRenderer();
        TableColumnModel tcm = this.getTableHeader().getColumnModel();
        for (int i = 0; i < tcm.getColumnCount(); ++i) {
            TableColumn tc = tcm.getColumn(i);
            tc.setHeaderRenderer((TableCellRenderer)mleheadrend);
        }
        JTableHeader th = this.getTableHeader();
        th.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImportTable.this.headerClicked(e);
            }
        });
    }

    protected void skip(int row, int column) {
        if (row == -1) {
            if (column > 0) {
                ((ImportTableModel)((Object)this.getModel())).skip(row, column);
                this._instructions.add("skip " + row + " " + column);
                this.setBackground(row, column);
            }
        } else if (column == 0) {
            if (row >= 0) {
                ((ImportTableModel)((Object)this.getModel())).skip(row, column);
                this._instructions.add("skip " + row + " " + column);
                this.setBackground(row, column);
            }
        } else {
            ((ImportTableModel)((Object)this.getModel())).skip(row, column);
            this._instructions.add("skip " + row + " " + column);
            this.setBackground(row, column);
        }
    }

    protected void skip() {
        if (this._column == 0) {
            int[] rows = this.getSelectedRows();
            for (int i = 0; i < rows.length; ++i) {
                this.skip(rows[i], this._column);
            }
        } else {
            this.skip(this._row, this._column);
        }
    }

    protected void unskip(int row, int column) {
        if (row == -1) {
            if (column > 0) {
                ((ImportTableModel)((Object)this.getModel())).unskip(row, column);
                this._instructions.add("unskip " + row + " " + column);
                this.setBackground(row, column);
            }
        } else if (column == 0) {
            if (row >= 0) {
                ((ImportTableModel)((Object)this.getModel())).unskip(row, column);
                this._instructions.add("unskip " + row + " " + column);
                this.setBackground(row, column);
            }
        } else {
            ((ImportTableModel)((Object)this.getModel())).unskip(row, column);
            this._instructions.add("unskip " + row + " " + column);
            this.setBackground(row, column);
        }
    }

    protected void unskip() {
        if (this._column == 0) {
            int[] rows = this.getSelectedRows();
            for (int i = 0; i < rows.length; ++i) {
                this.unskip(rows[i], this._column);
            }
        } else {
            this.unskip(this._row, this._column);
        }
    }

    protected void setColumn(int action) {
        this.setColumn(this._column, action);
        this._instructions.add("setcolumn " + this._column + " " + action);
    }

    public void setColumn(int column, int action) {
        ImportTableModel tm = (ImportTableModel)((Object)this.getModel());
        tm.actionSet(column, action);
        for (int i = 0; i < this.getRowCount(); ++i) {
            tm.setCellAction(i, column, action);
            this.setCellBackground(i, column);
        }
        this.repaint();
    }

    protected void setRow(int action) {
        this.setRow(this._row, action);
        this._instructions.add("setrow " + this._row + " " + action);
    }

    public void setHeaderPopupsEnabled(boolean enabled) {
        this._popupsEnabled = enabled;
    }

    protected void setRow(int row, int action) {
        ImportTableModel tm = (ImportTableModel)((Object)this.getModel());
        tm.actionSet(action);
        for (int i = 1; i < this.getColumnCount(); ++i) {
            tm.setCellAction(row, i, action);
            this.setCellBackground(row, i);
        }
        this.repaint();
    }

    protected void setAllColumns() {
        ImportTableModel tm = (ImportTableModel)((Object)this.getModel());
        for (int col = 1; col < this.getColumnCount(); ++col) {
            if (!tm.colHasAction(col, 0)) continue;
            int action = 100 + this._numberDataSets;
            tm.actionSet(action);
            for (int row = 0; row < this.getRowCount(); ++row) {
                tm.setCellAction(row, col, action);
                this.setCellBackground(row, col);
            }
            ++this._numberDataSets;
        }
        this._instructions.add("setallcolumns");
        this.repaint();
        ActionEvent event = new ActionEvent((Object)this, this._numberDataSets, "setAllColumns");
        if (this._observer != null) {
            this._observer.notifyObservers((Object)event);
        }
    }

    protected void dataColumn() {
        int action = 100 + this._numberDataSets;
        this.setColumn(action);
        ActionEvent event = new ActionEvent((Object)this, this._numberDataSets, "dataSet");
        ++this._numberDataSets;
        if (this._observer != null) {
            this._observer.notifyObservers((Object)event);
        }
    }

    protected void clearColumn() {
        int act = ((ImportTableModel)((Object)this.getModel())).getColumnAction(this._column);
        if (act >= 100) {
            int dataSet = 100 - act;
            this.clearDataColumn(dataSet);
        }
        ((ImportTableModel)((Object)this.getModel())).clearColumn(this._column);
        this.repaintTable();
    }

    public void clearRow() {
        ((ImportTableModel)((Object)this.getModel())).clearRow(this._row);
        this.repaintTable();
    }

    public void repaintTable() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            for (int j = 1; j < this.getColumnCount(); ++j) {
                this.setCellBackground(i, j);
            }
        }
        this.repaint();
    }

    public void clearDataColumn(int dataSet) {
        int action = 100 + dataSet;
        this.clear(action);
        if (dataSet + 1 == this._numberDataSets) {
            --this._numberDataSets;
        }
    }

    public void clear(int action) {
        ImportTableModel tm = (ImportTableModel)((Object)this.getModel());
        for (int i = 0; i < this.getRowCount(); ++i) {
            for (int j = 1; j < this.getColumnCount(); ++j) {
                int act = tm.getCellAction(i, j);
                if (act != action) continue;
                tm.setCellActionOverride(i, j, 0);
            }
        }
        this.repaintTable();
        this._instructions.add("clear " + action);
    }

    public void clearAll() {
        this._instructions.add("clearall");
        this._numberDataSets = 0;
        this.getImportControl().clearAll();
        ImportTableModel tm = (ImportTableModel)((Object)this.getModel());
        tm.clearAll();
        this.repaintTable();
    }

    public String getSelectedRange() {
        StringBuffer buf = new StringBuffer();
        int[] cols = this.getSelectedColumns();
        int[] rows = this.getSelectedRows();
        if (rows.length == 0 || cols.length == 0 || cols.length == 1 && cols[0] == 0) {
            return buf.toString();
        }
        TableColumnModel colModel = this.getColumnModel();
        buf.append(colModel.getColumn(cols[0]).getHeaderValue());
        buf.append(rows[0] + 1);
        buf.append("..");
        buf.append(colModel.getColumn(cols[cols.length - 1]).getHeaderValue());
        buf.append(rows[rows.length - 1] + 1);
        return buf.toString();
    }

    public int getNumberDataSets() {
        return this._numberDataSets;
    }

    public Point getFirstActionCell(int action) {
        ImportTableModel tm = (ImportTableModel)((Object)this.getModel());
        for (int i = 0; i < this.getRowCount(); ++i) {
            int col = tm.getActionCell(i, action);
            if (col < 0) continue;
            return new Point(i, col);
        }
        return null;
    }

    protected void headerClicked(MouseEvent event) {
        this.processMouseClick(event, true);
    }

    public void mouseReleased(MouseEvent event) {
        this.processMouseClick(event, false);
    }

    public void processMouseClick(MouseEvent event, boolean header) {
        if (!event.isMetaDown()) {
            return;
        }
        if (!this._popupsEnabled) {
            return;
        }
        if (!SwingUtilities.isRightMouseButton(event)) {
            if (this._popup != null && this._popup.isVisible()) {
                this._popup.setVisible(false);
                this._popup = null;
            }
            return;
        }
        int x = event.getX();
        int y = event.getY();
        this._column = this.columnAtPoint(event.getPoint());
        this._row = this.rowAtPoint(event.getPoint());
        if (header) {
            if (this._column == 0) {
                this._popup = this._cornerPopup;
            } else {
                this._popup = this._columnPopup;
                if (((ImportTableModel)((Object)this.getModel())).isColumnSet(this._column)) {
                    this._clearDataCol.setVisible(true);
                } else {
                    this._clearDataCol.setVisible(false);
                }
            }
            this._row = -1;
            y -= 20;
        } else if (this._column == 0) {
            ImportTableModel m = (ImportTableModel)((Object)this.getModel());
            if (m.isSkippedRow(this._row)) {
                this.unskipMenu.setVisible(true);
            } else {
                this.unskipMenu.setVisible(false);
            }
            if (m.isRowSet(this._row)) {
                this._clearRow.setVisible(true);
            } else {
                this._clearRow.setVisible(false);
            }
            this._popup = this._rowPopup;
        } else {
            this._popup = this._cellPopup;
        }
        Dimension dim = this._popup.getPreferredSize();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension scrnsiz = toolkit.getScreenSize();
        Point pt0 = this.getLocationOnScreen();
        int windowsToolBarHeight = 50;
        int offset = scrnsiz.height - (pt0.y + y + dim.height + windowsToolBarHeight);
        if (offset < 0) {
            y += offset;
        }
        this._popup.show((Component)((Object)this), x, y);
    }

    protected void buildImportPopup() {
        this._rowPopup = new JPopupMenu();
        Font f = UIManager.getFont("TextField.font");
        JMenuItem mi = new JMenuItem("Skip Row(s)");
        mi.setFont(f);
        this._rowPopup.add(mi);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportTable.this.skip();
            }
        });
        this.unskipMenu = new JMenuItem("Un-skip Row(s)");
        this.unskipMenu.setFont(f);
        this._rowPopup.add(this.unskipMenu);
        this.unskipMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportTable.this.unskip();
            }
        });
        this._rowPopup.addSeparator();
        JMenu menu = new JMenu("Pathname Part Row");
        this._rowPopup.add(menu);
        mi = new JMenuItem("Part A");
        mi.setFont(f);
        menu.add(mi);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportTable.this.setRow(50);
            }
        });
        mi = new JMenuItem("Part B");
        mi.setFont(f);
        menu.add(mi);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportTable.this.setRow(51);
            }
        });
        mi = new JMenuItem("Part C");
        mi.setFont(f);
        menu.add(mi);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportTable.this.setRow(52);
            }
        });
        mi = new JMenuItem("Part F");
        mi.setFont(f);
        menu.add(mi);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportTable.this.setRow(55);
            }
        });
        mi = new JMenuItem("Units Row");
        mi.setFont(f);
        this._rowPopup.add(mi);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportTable.this.setRow(60);
            }
        });
        this._clearRow = new JMenuItem("Clear Row");
        this._clearRow.setFont(f);
        this._clearRow.setVisible(false);
        this._rowPopup.add(this._clearRow);
        this._clearRow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportTable.this.clearRow();
            }
        });
        this._columnPopup = new JPopupMenu();
        mi = new JMenuItem("Skip Column");
        mi.setFont(f);
        this._columnPopup.add(mi);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportTable.this.skip();
            }
        });
        this._columnPopup.addSeparator();
        menu = new JMenu("Date - Time Column");
        this._columnPopup.add(menu);
        mi = new JMenuItem("Date and Time Column");
        mi.setFont(f);
        menu.add(mi);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportTable.this.setColumn(10);
            }
        });
        mi = new JMenuItem("Date Column");
        mi.setFont(f);
        menu.add(mi);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportTable.this.setColumn(11);
            }
        });
        mi = new JMenuItem("Time Column");
        mi.setFont(f);
        menu.add(mi);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportTable.this.setColumn(12);
            }
        });
        mi = new JMenuItem("Hour Column");
        mi.setFont(f);
        menu.add(mi);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportTable.this.setColumn(13);
            }
        });
        mi = new JMenuItem("Minute Column");
        mi.setFont(f);
        menu.add(mi);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportTable.this.setColumn(14);
            }
        });
        mi = new JMenuItem("Day Column");
        mi.setFont(f);
        menu.add(mi);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportTable.this.setColumn(15);
            }
        });
        mi = new JMenuItem("Month Column");
        mi.setFont(f);
        menu.add(mi);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportTable.this.setColumn(16);
            }
        });
        mi = new JMenuItem("Year Column");
        mi.setFont(f);
        menu.add(mi);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportTable.this.setColumn(17);
            }
        });
        mi = new JMenuItem("Julian Day Column");
        mi.setFont(f);
        menu.add(mi);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportTable.this.setColumn(18);
            }
        });
        mi = new JMenuItem("Month-Day Column");
        mi.setFont(f);
        menu.add(mi);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportTable.this.setColumn(20);
            }
        });
        mi = new JMenuItem("Day-Month Column");
        mi.setFont(f);
        menu.add(mi);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportTable.this.setColumn(19);
            }
        });
        mi = new JMenuItem("Month-Year Column");
        mi.setFont(f);
        menu.add(mi);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportTable.this.setColumn(15);
            }
        });
        mi = new JMenuItem("Set Data Column");
        mi.setFont(f);
        this._columnPopup.add(mi);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportTable.this.dataColumn();
            }
        });
        this._clearDataCol = new JMenuItem("Clear Column");
        this._clearDataCol.setFont(f);
        this._clearDataCol.setVisible(false);
        this._columnPopup.add(this._clearDataCol);
        this._clearDataCol.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportTable.this.clearColumn();
            }
        });
        this._cellPopup = new JPopupMenu();
        mi = new JMenuItem("Skip Cell");
        mi.setFont(f);
        this._cellPopup.add(mi);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportTable.this.skip();
            }
        });
        this._cornerPopup = new JPopupMenu();
        mi = new JMenuItem("Select All Data Columns");
        mi.setFont(f);
        this._cornerPopup.add(mi);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportTable.this.setAllColumns();
            }
        });
    }

    public List getSelectedData() {
        int[] rows = this.getSelectedRows();
        int[] cols = this.getSelectedColumns();
        ArrayList data = new ArrayList(rows.length);
        HecTime hecTime = new HecTime();
        for (int row = 0; row < rows.length; ++row) {
            ArrayList<Object> rowData = new ArrayList<Object>(cols.length);
            for (int col = 0; col < cols.length; ++col) {
                double val;
                Object cell = this.getValueAt(rows[row], cols[col]);
                if (cell.toString().length() > 6) {
                    hecTime.set(cell.toString());
                    if (hecTime.isDateDefined()) {
                        rowData.add(new HecTime(hecTime));
                        continue;
                    }
                }
                if (col == 1 && col < cols.length - 1 && hecTime.isDateDefined() && cell.toString().length() > 3) {
                    Object obj;
                    int pos;
                    HecTime newTime = new HecTime(hecTime);
                    newTime.setTime(cell.toString());
                    if (newTime.isTimeDefined() && (pos = rowData.size() - 1) >= 0 && (obj = rowData.get(pos)) instanceof HecTime) {
                        rowData.set(pos, newTime);
                        continue;
                    }
                }
                if (!RMAConst.isValidValue((double)(val = RMAIO.parseDouble((String)cell.toString())))) continue;
                rowData.add(new Double(val));
            }
            data.add(rowData);
        }
        return data;
    }

    public void setBackground(int row, int column) {
        int numberColumns = this.getColumnCount();
        int numberRows = this.getRowCount();
        if (row == -1) {
            if (column > 0) {
                this.setCellBackground(0, numberRows - 1, column, column);
            }
        } else if (column == 0) {
            if (row >= 0) {
                this.setCellBackground(row, row, 0, numberColumns - 1);
            }
        } else {
            this.setCellBackground(row, row, column, column);
        }
    }

    protected void setCellBackground(int startRow, int endRow, int startColumn, int endColumn) {
        for (int j = startColumn; j <= endColumn; ++j) {
            for (int i = startRow; i <= endRow; ++i) {
                this.setCellBackground(i, j);
            }
        }
        this.repaint();
    }

    protected void setCellBackground(int row, int col) {
        if (col == 0) {
            this.setCellBackground(row, col, Color.LIGHT_GRAY);
            return;
        }
        ImportTableModel tm = (ImportTableModel)((Object)this.getModel());
        int action = tm.getCellAction(row, col);
        if (action == 0) {
            this.setCellBackground(row, col, Color.WHITE);
        } else if (action == 1) {
            this.setCellBackground(row, col, Color.LIGHT_GRAY);
        } else if (action == 50) {
            this.setCellBackground(row, col, Color.GREEN);
        } else if (action == 51) {
            this.setCellBackground(row, col, Color.CYAN);
        } else if (action == 52) {
            this.setCellBackground(row, col, Color.MAGENTA);
        } else if (action == 55) {
            this.setCellBackground(row, col, Color.ORANGE);
        } else if (action == 60) {
            this.setCellBackground(row, col, Color.YELLOW);
        } else if (action < 25) {
            float sat = (float)((double)action * 3.0 / 100.0);
            Color color = Color.getHSBColor(0.33f, sat, 1.0f);
            this.setCellBackground(row, col, color);
        } else if (action >= 100) {
            float sat = (float)((16.0 + ((double)action - 100.0) * 5.0) / 100.0);
            if ((double)sat > 1.0) {
                sat = 1.0f;
            }
            Color color = Color.getHSBColor(0.59f, sat, 1.0f);
            this.setCellBackground(row, col, color);
        }
    }

    public ImportControl getImportControl() {
        return this._importControl;
    }

    public void setImportControl(ImportControl importControl) {
        this._importControl = importControl;
        this.addObserver(importControl);
    }

    public Vector<String> getInstructions() {
        return (Vector)this._instructions.clone();
    }

    public void clearInstructions() {
        this._instructions.clear();
    }

    public void runInstructions(Vector<String> instructions) {
        for (int i = 0; i < instructions.size(); ++i) {
            String inst = instructions.elementAt(i);
            String[] parse = inst.split(" ");
            int arg1 = 0;
            if (parse.length > 1) {
                arg1 = Integer.valueOf(parse[1]);
            }
            int arg2 = 0;
            if (parse.length > 2) {
                arg2 = Integer.valueOf(parse[2]);
            }
            if (parse[0].equals("skip")) {
                this.skip(arg1, arg2);
                continue;
            }
            if (parse[0].equals("unskip")) {
                this.unskip(arg1, arg2);
                continue;
            }
            if (parse[0].equals("setcolumn")) {
                this.setColumn(arg1, arg2);
                continue;
            }
            if (parse[0].equals("setrow")) {
                this.setRow(arg1, arg2);
                continue;
            }
            if (parse[0].equals("setallcolumns")) {
                this.setAllColumns();
                continue;
            }
            if (parse[0].equals("clear")) {
                this.clear(arg1);
                continue;
            }
            if (!parse[0].equals("clearall")) continue;
            this.clearAll();
        }
    }

    public void addObserver(Observer o) {
        if (this._observer != null) {
            this._observer.addObserver(o);
        }
    }

    public void removeObserver(Observer o) {
        if (this._observer != null) {
            this._observer.deleteObserver(o);
        }
    }

    public void done() {
        if (this._observer != null) {
            this._observer.deleteObservers();
        }
    }
}

