/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.importExport.general;

import hec.dataui.importExport.general.ImportControl;
import hec.dataui.importExport.general.ImportTable;
import hec.dataui.importExport.general.ImportTableModel;
import hec.heclib.util.HecTime;
import hec.io.TimeSeriesContainer;
import hec.lang.Const;
import hec.util.GeneralTableEditor;
import hec.util.ObservableClass;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import rma.util.RMAIO;

public class ImportTableEditor
extends GeneralTableEditor {
    protected ImportControl _importControl;
    protected ObservableClass _observableClass;

    public ImportTableEditor(String filename) {
        this.setTitle("Alpha Version.  Time Series Columnar import.  File: " + filename);
        this._observableClass = new ObservableClass();
    }

    protected void init() {
        this.setDefaultCloseOperation(0);
    }

    public void initialize(int maxCols, Vector rows) {
        String[] colHeaders = new String[++maxCols];
        colHeaders[0] = "Row \\ Col";
        for (int i = 1; i < maxCols; ++i) {
            colHeaders[i] = Integer.toString(i);
        }
        this._tableModel = new ImportTableModel(colHeaders);
        ImportTableModel _importTableModel = (ImportTableModel)this._tableModel;
        this._table = new ImportTable((Component)((Object)this));
        this._table.setModel((TableModel)((Object)_importTableModel));
        this._table.setEditable(true);
        _importTableModel.setEditable(true);
        this.setRows(rows);
        this._table.setHorizontalAlignment(0, 0);
        this._table.setAddRemoveEnabled(false);
        this._table.setAutoResizeMode(0);
        this.build();
        this._cmdPanel.getButton("Save to Disk").setText("Import");
        if (maxCols > 10) {
            for (int i = 0; i < maxCols; ++i) {
                TableColumn column = this._table.getColumnModel().getColumn(i);
                column.setMinWidth(50);
            }
            this._table.setAutoResizeMode(0);
        }
        JButton selectAll = new JButton("Select All Data Columns");
        selectAll.addActionListener(e -> ((ImportTable)this._table).setAllColumns());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().add((Component)selectAll, gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        this.getContentPane().add((Component)new JLabel("  "), gbc);
        this._importControl = new ImportControl((ImportTable)this._table);
    }

    public Vector getData() {
        return this._importControl.getData();
    }

    public Vector<TimeSeriesContainer> getSelectedData() {
        double val;
        TimeSeriesContainer timeSeriesContainer;
        List _data = ((ImportTable)this._table).getSelectedData();
        Vector<TimeSeriesContainer> containers = new Vector<TimeSeriesContainer>();
        HecTime time = new HecTime();
        Object obj = _data.get(0);
        if (!(obj instanceof List)) {
            return containers;
        }
        List row = (List)obj;
        int timeDiff = Integer.MIN_VALUE;
        int numRows = _data.size();
        for (Object aRow1 : row) {
            obj = aRow1;
            if (obj instanceof HecTime) {
                time = (HecTime)obj;
                continue;
            }
            if (obj instanceof Double) {
                timeSeriesContainer = new TimeSeriesContainer();
                timeSeriesContainer.times = new int[numRows];
                timeSeriesContainer.values = new double[numRows];
                timeSeriesContainer.values[0] = val = ((Double)obj).doubleValue();
                containers.add(timeSeriesContainer);
                continue;
            }
            if (!(obj instanceof String)) continue;
            val = RMAIO.parseDouble(obj);
            if (Const.isDefined((double)val)) {
                timeSeriesContainer = new TimeSeriesContainer();
                timeSeriesContainer.times = new int[numRows];
                timeSeriesContainer.values = new double[numRows];
                timeSeriesContainer.values[0] = val;
                containers.add(timeSeriesContainer);
                continue;
            }
            if (time.isDefined()) continue;
            String objStr = (String)obj;
            time.set(objStr);
        }
        if (containers.size() == 0) {
            return containers;
        }
        if (!time.isDefined() && time.isDateDefined()) {
            time.setTime("2400");
        }
        if (time.isDefined()) {
            for (int i = 0; i < containers.size(); ++i) {
                timeSeriesContainer = containers.elementAt(i);
                timeSeriesContainer.times[0] = time.value();
            }
        }
        boolean irregular = false;
        for (int r = 1; r < _data.size(); ++r) {
            obj = _data.get(r);
            if (!(obj instanceof List)) continue;
            time.setUndefined();
            int count = 0;
            row = (List)obj;
            for (Object aRow : row) {
                obj = aRow;
                if (obj instanceof HecTime) {
                    time = (HecTime)obj;
                    continue;
                }
                if (obj instanceof Double) {
                    timeSeriesContainer = containers.elementAt(count++);
                    timeSeriesContainer.values[r] = val = ((Double)obj).doubleValue();
                    continue;
                }
                if (!(obj instanceof String)) continue;
                val = RMAIO.parseDouble(obj);
                if (Const.isDefined((double)val)) {
                    timeSeriesContainer = containers.elementAt(count++);
                    timeSeriesContainer.values[r] = val;
                    continue;
                }
                if (time.isDefined()) continue;
                String objStr = (String)obj;
                time.set(objStr);
            }
            if (!time.isDefined() && time.isDateDefined()) {
                time.setTime("2400");
            }
            if (!time.isDefined()) continue;
            for (int i = 0; i < containers.size(); ++i) {
                timeSeriesContainer = containers.elementAt(i);
                timeSeriesContainer.times[r] = time.value();
            }
            timeSeriesContainer = containers.elementAt(0);
            if (r == 1) {
                timeDiff = timeSeriesContainer.times[1] - timeSeriesContainer.times[0];
            }
            if (irregular || r <= 1 || timeSeriesContainer.times[r] - timeSeriesContainer.times[r - 1] == timeDiff) continue;
            irregular = true;
        }
        for (int i = 0; i < containers.size(); ++i) {
            timeSeriesContainer = containers.elementAt(i);
            timeSeriesContainer.numberValues = numRows;
            if (!irregular && timeDiff > 0) {
                timeSeriesContainer.interval = timeDiff;
            }
            if (numRows <= 0 || timeSeriesContainer.times[0] <= 0) continue;
            timeSeriesContainer.startTime = timeSeriesContainer.times[0];
            timeSeriesContainer.endTime = timeSeriesContainer.times[numRows - 1];
        }
        return containers;
    }

    public String getMessage() {
        return this._importControl.getMessage();
    }

    protected void buildMenu() {
        this._menuBar = new JMenuBar();
        this._fileMenu = new JMenu("File");
        this._editMenu = new JMenu("Edit");
        this.buildFileMenu();
        this._menuBar.add(this._fileMenu);
        this.buildEditMenu();
        this.setJMenuBar(this._menuBar);
    }

    protected void buildFileMenu() {
        this._fileMenu = new JMenu("File");
        this._fileMenu.setMnemonic('f');
        JMenuItem menuItem = new JMenuItem("Close", 97);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportTableEditor.this.close();
            }
        });
        this._fileMenu.add(menuItem);
        this._fileMenu.addSeparator();
        menuItem = new JMenuItem("Save", 97);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportTableEditor.this.save(false);
            }
        });
        this._fileMenu.add(menuItem);
        this._menuBar.add(this._fileMenu);
    }

    protected void cancelButton() {
        if (!this.checkForChangedData()) {
            return;
        }
        this.close();
    }

    protected void okayButton() {
        boolean useImportControl = this._importControl.isAnySet();
        String selected = ((ImportTable)this._table).getSelectedRange();
        if (selected.length() == 0) {
            if (useImportControl) {
                this._importControl.importData();
            } else {
                JOptionPane.showMessageDialog(null, "No data selected to import.", "Import Data", 2);
            }
        } else if (useImportControl) {
            this._importControl.runImport();
        } else {
            ActionEvent event = new ActionEvent((Object)this, 0, "importDataEntry");
            if (this._observableClass != null) {
                this._observableClass.notifyObservers((Object)event);
            }
        }
    }

    public void addObserver(Observer o) {
        this._observableClass.addObserver(o);
        this._importControl.addObserver(o);
    }

    public void removeObserver(Observer o) {
        this._observableClass.deleteObserver(o);
        this._importControl.removeObserver(o);
    }

    public void close() {
        this._importControl.close();
        if (this._standAlone) {
            System.exit(0);
        }
        this.dispose();
    }
}

